/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.NumericType;

public abstract class PrimitiveTypeElement
extends TypeElement {
    static PrimitiveTypeElement fromDexType(DexType type, boolean asArrayElementType) {
        assert (type.isPrimitiveType());
        return PrimitiveTypeElement.fromTypeDescriptorChar((char)type.descriptor.content[0], asArrayElementType);
    }

    private static PrimitiveTypeElement fromTypeDescriptorChar(char descriptor, boolean asArrayElementType) {
        switch (descriptor) {
            case 'Z': {
                if (asArrayElementType) {
                    return TypeElement.getBoolean();
                }
            }
            case 'B': {
                if (asArrayElementType) {
                    return TypeElement.getByte();
                }
            }
            case 'S': {
                if (asArrayElementType) {
                    return TypeElement.getShort();
                }
            }
            case 'C': {
                if (asArrayElementType) {
                    return TypeElement.getChar();
                }
            }
            case 'I': {
                return TypeElement.getInt();
            }
            case 'F': {
                return TypeElement.getFloat();
            }
            case 'J': {
                return TypeElement.getLong();
            }
            case 'D': {
                return TypeElement.getDouble();
            }
            case 'V': {
                throw new InternalCompilerError("No value type for void type.");
            }
        }
        throw new Unreachable("Invalid descriptor char '" + descriptor + "'");
    }

    public static PrimitiveTypeElement fromNumericType(NumericType numericType) {
        switch (numericType) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return TypeElement.getInt();
            }
            case FLOAT: {
                return TypeElement.getFloat();
            }
            case LONG: {
                return TypeElement.getLong();
            }
            case DOUBLE: {
                return TypeElement.getDouble();
            }
        }
        throw new Unreachable("Invalid numeric type '" + (Object)((Object)numericType) + "'");
    }

    @Override
    public Nullability nullability() {
        return Nullability.definitelyNotNull();
    }

    @Override
    public boolean isPrimitiveType() {
        return true;
    }

    @Override
    public PrimitiveTypeElement asPrimitiveType() {
        return this;
    }

    public DexType toDexType(DexItemFactory factory) {
        if (this.isBoolean()) {
            return factory.booleanType;
        }
        if (this.isByte()) {
            return factory.byteType;
        }
        if (this.isShort()) {
            return factory.shortType;
        }
        if (this.isChar()) {
            return factory.charType;
        }
        if (this.isInt()) {
            return factory.intType;
        }
        if (this.isFloat()) {
            return factory.floatType;
        }
        if (this.isLong()) {
            return factory.longType;
        }
        if (this.isDouble()) {
            return factory.doubleType;
        }
        throw new Unreachable("Imprecise primitive type '" + this.toString() + "'");
    }

    public boolean hasDexType() {
        return this.isBoolean() || this.isByte() || this.isShort() || this.isChar() || this.isInt() || this.isFloat() || this.isLong() || this.isDouble();
    }

    TypeElement join(PrimitiveTypeElement other) {
        if (this == other) {
            return this;
        }
        if (this.isSinglePrimitive()) {
            if (other.isSinglePrimitive()) {
                return TypeElement.getSingle();
            }
            assert (other.isWidePrimitive());
            return TypeElement.getTop();
        }
        assert (this.isWidePrimitive());
        if (other.isWidePrimitive()) {
            return TypeElement.getWide();
        }
        assert (other.isSinglePrimitive());
        return TypeElement.getTop();
    }
}

