/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;

public class TypeAnalysis {
    private final boolean mayHaveImpreciseTypes;
    private Mode mode = Mode.UNSET;
    private final AppView<?> appView;
    private final Deque<Value> worklist = new ArrayDeque<Value>();

    public TypeAnalysis(AppView<?> appView) {
        this(appView, false);
    }

    public TypeAnalysis(AppView<?> appView, boolean mayHaveImpreciseTypes) {
        this.appView = appView;
        this.mayHaveImpreciseTypes = mayHaveImpreciseTypes;
    }

    private void analyze() {
        while (!this.worklist.isEmpty()) {
            this.analyzeValue(this.worklist.poll());
        }
    }

    private void analyzeValues(Iterable<? extends Value> values2, Mode mode) {
        this.mode = mode;
        assert (this.worklist.isEmpty());
        values2.forEach(this::enqueue);
        this.analyze();
    }

    private void enqueue(Value v) {
        assert (v != null);
        if (!this.worklist.contains(v)) {
            this.worklist.add(v);
        }
    }

    private void analyzeBasicBlock(BasicBlock block) {
        for (Instruction instruction : block.getInstructions()) {
            Value outValue = instruction.outValue();
            if (outValue == null || instruction.isArgument()) continue;
            if (instruction.hasInvariantOutType()) {
                TypeElement derived = instruction.evaluate(this.appView);
                this.updateTypeOfValue(outValue, derived);
                continue;
            }
            this.enqueue(outValue);
        }
        for (Phi phi : block.getPhis()) {
            this.enqueue(phi);
        }
    }

    private void analyzeValue(Value value) {
        TypeElement derived;
        TypeElement previous = value.getType();
        TypeElement typeElement = derived = value.isPhi() ? value.asPhi().computePhiType(this.appView) : value.definition.evaluate(this.appView);
        assert (this.mayHaveImpreciseTypes || derived.isPreciseType());
        assert (!previous.isPreciseType() || derived.isPreciseType());
        this.updateTypeOfValue(value, derived);
    }

    private void updateTypeOfValue(Value value, TypeElement type) {
        assert (this.mode != Mode.UNSET);
        TypeElement current = value.getType();
        if (current.equals(type)) {
            return;
        }
        assert (this.mode != Mode.NO_CHANGE);
        if (type.isBottom()) {
            return;
        }
        if (this.mode == Mode.WIDENING) {
            value.widening(this.appView, type);
        } else {
            assert (this.mode == Mode.NARROWING);
            value.narrowing(this.appView, type);
        }
        for (Instruction instruction : value.uniqueUsers()) {
            Value outValue = instruction.outValue();
            if (outValue == null) continue;
            this.enqueue(outValue);
        }
        for (Phi phi : value.uniquePhiUsers()) {
            this.enqueue(phi);
        }
    }

    public static DexType getRefinedReceiverType(AppView<AppInfoWithLiveness> appView, InvokeMethodWithReceiver invoke) {
        return TypeAnalysis.toRefinedReceiverType(invoke.getReceiver().getDynamicType(appView), invoke.getInvokedMethod(), appView);
    }

    public static DexType toRefinedReceiverType(DynamicType dynamicReceiverType, DexMethod method, AppView<? extends AppInfoWithClassHierarchy> appView) {
        DexType staticReceiverType = method.getHolderType();
        TypeElement staticReceiverTypeElement = staticReceiverType.toTypeElement(appView);
        TypeElement dynamicReceiverUpperBoundType = dynamicReceiverType.getDynamicUpperBoundType(staticReceiverTypeElement);
        if (dynamicReceiverUpperBoundType.isClassType()) {
            DexType singleKnownInterface;
            ClassTypeElement dynamicReceiverUpperBoundClassType = dynamicReceiverUpperBoundType.asClassType();
            DexType refinedType = dynamicReceiverUpperBoundClassType.getClassType();
            if (refinedType == appView.dexItemFactory().objectType && (singleKnownInterface = dynamicReceiverUpperBoundClassType.getInterfaces().getSingleKnownInterface()) != null) {
                refinedType = singleKnownInterface;
            }
            if (appView.appInfo().isSubtype(refinedType, staticReceiverType)) {
                return refinedType;
            }
        }
        return staticReceiverType;
    }

    public void widening(IRCode code) {
        this.mode = Mode.WIDENING;
        assert (this.worklist.isEmpty());
        code.topologicallySortedBlocks().forEach(this::analyzeBasicBlock);
        this.analyze();
    }

    public void widening(Iterable<Value> values2) {
        this.analyzeValues(values2, Mode.WIDENING);
    }

    public void narrowing(IRCode code) {
        this.mode = Mode.NARROWING;
        assert (this.worklist.isEmpty());
        code.topologicallySortedBlocks().forEach(this::analyzeBasicBlock);
        this.analyze();
    }

    public void narrowing(Iterable<? extends Value> values2) {
        ArrayList<? extends Value> sortedValues = Lists.newArrayList(values2);
        sortedValues.sort(Comparator.comparingInt(Value::getNumber));
        this.analyzeValues(sortedValues, Mode.NARROWING);
    }

    public boolean verifyValuesUpToDate(Iterable<? extends Value> values2) {
        this.analyzeValues(values2, Mode.NO_CHANGE);
        return true;
    }

    private static enum Mode {
        UNSET,
        WIDENING,
        NARROWING,
        NO_CHANGE;

    }
}

