/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.ir.analysis.type.ArrayTypeElement;
import com.android.tools.r8.ir.analysis.type.BooleanTypeElement;
import com.android.tools.r8.ir.analysis.type.BottomTypeElement;
import com.android.tools.r8.ir.analysis.type.ByteTypeElement;
import com.android.tools.r8.ir.analysis.type.CharTypeElement;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.DoubleTypeElement;
import com.android.tools.r8.ir.analysis.type.FloatTypeElement;
import com.android.tools.r8.ir.analysis.type.IntTypeElement;
import com.android.tools.r8.ir.analysis.type.LongTypeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.PrimitiveTypeElement;
import com.android.tools.r8.ir.analysis.type.ReferenceTypeElement;
import com.android.tools.r8.ir.analysis.type.ShortTypeElement;
import com.android.tools.r8.ir.analysis.type.SinglePrimitiveTypeElement;
import com.android.tools.r8.ir.analysis.type.TopTypeElement;
import com.android.tools.r8.ir.analysis.type.WidePrimitiveTypeElement;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;

public abstract class TypeElement {
    public static BottomTypeElement getBottom() {
        return BottomTypeElement.getInstance();
    }

    public static TopTypeElement getTop() {
        return TopTypeElement.getInstance();
    }

    public static BooleanTypeElement getBoolean() {
        return BooleanTypeElement.getInstance();
    }

    public static ByteTypeElement getByte() {
        return ByteTypeElement.getInstance();
    }

    public static ShortTypeElement getShort() {
        return ShortTypeElement.getInstance();
    }

    public static CharTypeElement getChar() {
        return CharTypeElement.getInstance();
    }

    public static IntTypeElement getInt() {
        return IntTypeElement.getInstance();
    }

    public static FloatTypeElement getFloat() {
        return FloatTypeElement.getInstance();
    }

    public static SinglePrimitiveTypeElement getSingle() {
        return SinglePrimitiveTypeElement.getInstance();
    }

    public static LongTypeElement getLong() {
        return LongTypeElement.getInstance();
    }

    public static DoubleTypeElement getDouble() {
        return DoubleTypeElement.getInstance();
    }

    public static WidePrimitiveTypeElement getWide() {
        return WidePrimitiveTypeElement.getInstance();
    }

    public static ReferenceTypeElement getNull() {
        return ReferenceTypeElement.getNullType();
    }

    public static TypeElement join(Iterable<TypeElement> typeLattices, AppView<?> appView) {
        TypeElement result = TypeElement.getBottom();
        for (TypeElement other : typeLattices) {
            result = result.join(other, appView);
        }
        return result;
    }

    private boolean internalLessThan(TypeElement other, AppView<?> appView) {
        TypeElement lub = this.join(other, appView);
        return !this.equals(lub) && other.equals(lub);
    }

    public static ClassTypeElement objectClassType(AppView<?> appView, Nullability nullability) {
        return TypeElement.fromDexType(appView.dexItemFactory().objectType, nullability, appView).asClassType();
    }

    static ArrayTypeElement objectArrayType(AppView<?> appView, Nullability nullability) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        return TypeElement.fromDexType(dexItemFactory.createArrayType(1, dexItemFactory.objectType), nullability, appView).asArrayType();
    }

    public static ClassTypeElement classClassType(AppView<?> appView, Nullability nullability) {
        return TypeElement.fromDexType(appView.dexItemFactory().classType, nullability, appView).asClassType();
    }

    public static ClassTypeElement stringClassType(AppView<?> appView, Nullability nullability) {
        return TypeElement.fromDexType(appView.dexItemFactory().stringType, nullability, appView).asClassType();
    }

    public static TypeElement fromDexType(DexType type, Nullability nullability, AppView<?> appView) {
        return TypeElement.fromDexType(type, nullability, appView, false);
    }

    public static TypeElement fromDexType(DexType type, Nullability nullability, AppView<?> appView, boolean asArrayElementType) {
        if (type == DexItemFactory.nullValueType) {
            assert (!nullability.isDefinitelyNotNull());
            return TypeElement.getNull();
        }
        if (type.isPrimitiveType()) {
            return PrimitiveTypeElement.fromDexType(type, asArrayElementType);
        }
        return appView.dexItemFactory().createReferenceTypeElement(type, nullability, appView);
    }

    public final TypeElement fixupClassTypeReferences(AppView<? extends AppInfoWithClassHierarchy> appView, Function<DexType, DexType> mapping) {
        return this.fixupClassTypeReferences(appView, mapping, Collections.emptySet());
    }

    public TypeElement fixupClassTypeReferences(AppView<? extends AppInfoWithClassHierarchy> appView, Function<DexType, DexType> mapping, Set<DexType> prunedTypes) {
        return this;
    }

    public final TypeElement rewrittenWithLens(AppView<? extends AppInfoWithClassHierarchy> appView, GraphLens graphLens) {
        return this.rewrittenWithLens(appView, graphLens, null);
    }

    public final TypeElement rewrittenWithLens(AppView<? extends AppInfoWithClassHierarchy> appView, GraphLens graphLens, GraphLens codeLens) {
        return this.rewrittenWithLens(appView, graphLens, codeLens, Collections.emptySet());
    }

    public final TypeElement rewrittenWithLens(AppView<? extends AppInfoWithClassHierarchy> appView, GraphLens graphLens, GraphLens codeLens, Set<DexType> prunedTypes) {
        return this.fixupClassTypeReferences(appView, type -> graphLens.lookupType((DexType)type, codeLens), prunedTypes);
    }

    public boolean isNullable() {
        return this.nullability().isNullable();
    }

    public abstract Nullability nullability();

    public TypeElement join(TypeElement other, AppView<?> appView) {
        if (this == other || other.isBottom()) {
            return this;
        }
        if (this.isBottom()) {
            return other;
        }
        if (this.isTop() || other.isTop() || this.isPrimitiveType() != other.isPrimitiveType()) {
            return TypeElement.getTop();
        }
        if (this.isPrimitiveType()) {
            return this.asPrimitiveType().join(other.asPrimitiveType());
        }
        assert (this.isReferenceType());
        assert (this.isPreciseType());
        assert (other.isReferenceType());
        assert (other.isPreciseType());
        return this.asReferenceType().join(other.asReferenceType(), appView);
    }

    public boolean strictlyLessThan(TypeElement other, AppView<?> appView) {
        return !this.equals(other) && this.internalLessThan(other, appView);
    }

    public boolean lessThanOrEqual(TypeElement other, AppView<?> appView) {
        return this.equals(other) || this.internalLessThan(other, appView);
    }

    public boolean lessThanOrEqualUpToNullability(TypeElement other, AppView<?> appView) {
        if (this == other) {
            return true;
        }
        if (this.isTop()) {
            return other.isTop();
        }
        if (other.isTop()) {
            return true;
        }
        if (this.isBottom()) {
            return true;
        }
        if (other.isBottom()) {
            return false;
        }
        if (this.isPrimitiveType()) {
            return this.lessThanOrEqual(other, appView);
        }
        assert (this.isReferenceType() && other.isReferenceType());
        ReferenceTypeElement otherAsNullable = other.isNullable() ? other.asReferenceType() : other.asReferenceType().getOrCreateVariant(Nullability.maybeNull());
        return this.lessThanOrEqual(otherAsNullable, appView);
    }

    public boolean equalUpToNullability(TypeElement other) {
        if (this == other) {
            return true;
        }
        if (this.isBottom() != other.isBottom()) {
            return false;
        }
        if (this.isPrimitiveType() || other.isPrimitiveType()) {
            return false;
        }
        assert (this.isReferenceType() && other.isReferenceType());
        ReferenceTypeElement thisAsMaybeNull = this.asReferenceType().getOrCreateVariant(Nullability.maybeNull());
        ReferenceTypeElement otherAsMaybeNull = other.asReferenceType().getOrCreateVariant(Nullability.maybeNull());
        return thisAsMaybeNull.equals(otherAsMaybeNull);
    }

    public boolean isBasedOnMissingClass(AppView<? extends AppInfoWithClassHierarchy> appView) {
        return false;
    }

    public boolean isTop() {
        return false;
    }

    public boolean isBottom() {
        return false;
    }

    public boolean isReferenceType() {
        return false;
    }

    public ReferenceTypeElement asReferenceType() {
        return null;
    }

    public boolean isArrayType() {
        return false;
    }

    public boolean isPrimitiveArrayType() {
        return false;
    }

    public ArrayTypeElement asArrayType() {
        return null;
    }

    public boolean isClassType() {
        return false;
    }

    public final boolean isClassType(DexType type) {
        assert (type.isClassType());
        return this.isClassType() && this.asClassType().getClassType() == type;
    }

    public final boolean isStringType(DexItemFactory dexItemFactory) {
        return this.isClassType(dexItemFactory.stringType);
    }

    public ClassTypeElement asClassType() {
        return null;
    }

    public boolean isPrimitiveType() {
        return false;
    }

    public PrimitiveTypeElement asPrimitiveType() {
        return null;
    }

    public boolean isSinglePrimitive() {
        return false;
    }

    public boolean isWidePrimitive() {
        return false;
    }

    boolean isBoolean() {
        return false;
    }

    boolean isByte() {
        return false;
    }

    boolean isShort() {
        return false;
    }

    boolean isChar() {
        return false;
    }

    public boolean isInt() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isPreciseType() {
        return this.isArrayType() || this.isClassType() || this.isNullType() || this.isInt() || this.isFloat() || this.isLong() || this.isDouble() || this.isBottom();
    }

    public boolean isFineGrainedType() {
        return this.isBoolean() || this.isByte() || this.isShort() || this.isChar();
    }

    public boolean isNullType() {
        return false;
    }

    public boolean isDefinitelyNull() {
        return this.nullability().isDefinitelyNull();
    }

    public boolean isDefinitelyNotNull() {
        return this.nullability().isDefinitelyNotNull();
    }

    public int requiredRegisters() {
        assert (!this.isBottom() && !this.isTop());
        return 1;
    }

    public boolean isValueTypeCompatible(TypeElement other) {
        return this.isReferenceType() && other.isReferenceType() || this.isSinglePrimitive() && other.isSinglePrimitive() || this.isWidePrimitive() && other.isWidePrimitive();
    }

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

