/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.value;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.ir.analysis.value.AbstractValueFactory;
import com.android.tools.r8.ir.analysis.value.BottomValue;
import com.android.tools.r8.ir.analysis.value.ConstantOrNonConstantNumberValue;
import com.android.tools.r8.ir.analysis.value.NonConstantNumberValue;
import com.android.tools.r8.ir.analysis.value.NullOrAbstractValue;
import com.android.tools.r8.ir.analysis.value.NumberFromIntervalValue;
import com.android.tools.r8.ir.analysis.value.NumberFromSetValue;
import com.android.tools.r8.ir.analysis.value.SingleConstClassValue;
import com.android.tools.r8.ir.analysis.value.SingleConstValue;
import com.android.tools.r8.ir.analysis.value.SingleDexItemBasedStringValue;
import com.android.tools.r8.ir.analysis.value.SingleFieldValue;
import com.android.tools.r8.ir.analysis.value.SingleNumberValue;
import com.android.tools.r8.ir.analysis.value.SingleStringValue;
import com.android.tools.r8.ir.analysis.value.SingleValue;
import com.android.tools.r8.ir.analysis.value.StatefulObjectValue;
import com.android.tools.r8.ir.analysis.value.UnknownValue;
import com.android.tools.r8.ir.analysis.value.objectstate.ObjectState;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public abstract class AbstractValue {
    public static BottomValue bottom() {
        return BottomValue.getInstance();
    }

    public static UnknownValue unknown() {
        return UnknownValue.getInstance();
    }

    public abstract boolean isNonTrivial();

    public boolean isSingleBoolean() {
        return false;
    }

    public boolean isBottom() {
        return false;
    }

    public boolean isFalse() {
        return false;
    }

    public boolean isTrue() {
        return false;
    }

    public final boolean isNull() {
        return this.isFalse();
    }

    public final boolean isZero() {
        return this.isFalse();
    }

    public boolean isSingleValue() {
        return false;
    }

    public SingleValue asSingleValue() {
        return null;
    }

    public boolean hasObjectState() {
        return false;
    }

    public ObjectState getObjectState() {
        throw new UnsupportedOperationException("Abstract value " + this + " does not have any object state.");
    }

    public boolean isStatefulObjectValue() {
        return false;
    }

    public StatefulObjectValue asStatefulObjectValue() {
        return null;
    }

    public boolean hasKnownArrayLength() {
        return false;
    }

    public int getKnownArrayLength() {
        throw new UnsupportedOperationException("Abstract value " + this + " does not have a known array length.");
    }

    public boolean isSingleConstValue() {
        return false;
    }

    public SingleConstValue asSingleConstValue() {
        return null;
    }

    public boolean isSingleConstClassValue() {
        return false;
    }

    public SingleConstClassValue asSingleConstClassValue() {
        return null;
    }

    public boolean isSingleFieldValue() {
        return false;
    }

    public SingleFieldValue asSingleFieldValue() {
        return null;
    }

    public boolean isSingleNumberValue() {
        return false;
    }

    public SingleNumberValue asSingleNumberValue() {
        return null;
    }

    public boolean isSingleStringValue() {
        return false;
    }

    public SingleStringValue asSingleStringValue() {
        return null;
    }

    public boolean isSingleDexItemBasedStringValue() {
        return false;
    }

    public SingleDexItemBasedStringValue asSingleDexItemBasedStringValue() {
        return null;
    }

    public boolean isUnknown() {
        return false;
    }

    public boolean isNullOrAbstractValue() {
        return false;
    }

    public NullOrAbstractValue asNullOrAbstractValue() {
        return null;
    }

    public boolean isConstantOrNonConstantNumberValue() {
        return false;
    }

    public ConstantOrNonConstantNumberValue asConstantOrNonConstantNumberValue() {
        return null;
    }

    public boolean isNonConstantNumberValue() {
        return false;
    }

    public NonConstantNumberValue asNonConstantNumberValue() {
        return null;
    }

    public boolean isNumberFromIntervalValue() {
        return false;
    }

    public NumberFromIntervalValue asNumberFromIntervalValue() {
        return null;
    }

    public boolean isNumberFromSetValue() {
        return false;
    }

    public NumberFromSetValue asNumberFromSetValue() {
        return null;
    }

    public AbstractValue join(AbstractValue other, AbstractValueFactory factory, DexType type) {
        return this.join(other, factory, type.isReferenceType(), false);
    }

    public AbstractValue joinPrimitive(AbstractValue other, AbstractValueFactory factory) {
        return this.join(other, factory, false, false);
    }

    public AbstractValue joinReference(AbstractValue other, AbstractValueFactory factory) {
        return this.join(other, factory, true, false);
    }

    public AbstractValue join(AbstractValue other, AbstractValueFactory factory, boolean allowNullOrAbstractValue, boolean allowNonConstantNumbers) {
        if (this.isBottom() || other.isUnknown()) {
            return other;
        }
        if (this.isUnknown() || other.isBottom()) {
            return this;
        }
        if (this.equals(other)) {
            return this;
        }
        if (allowNullOrAbstractValue) {
            if (this.isNull()) {
                return NullOrAbstractValue.create(other);
            }
            if (other.isNull()) {
                return NullOrAbstractValue.create(this);
            }
            if (this.isNullOrAbstractValue() && this.asNullOrAbstractValue().getNonNullValue().equals(other)) {
                return this;
            }
            if (other.isNullOrAbstractValue() && other.asNullOrAbstractValue().getNonNullValue().equals(this)) {
                return other;
            }
            return AbstractValue.unknown();
        }
        assert (!this.isNullOrAbstractValue());
        assert (!other.isNullOrAbstractValue());
        if (allowNonConstantNumbers && this.isConstantOrNonConstantNumberValue() && other.isConstantOrNonConstantNumberValue()) {
            NumberFromSetValue.Builder numberFromSetValueBuilder;
            if (this.isSingleNumberValue()) {
                numberFromSetValueBuilder = NumberFromSetValue.builder(this.asSingleNumberValue());
            } else {
                assert (this.isNumberFromSetValue());
                numberFromSetValueBuilder = this.asNumberFromSetValue().instanceBuilder();
            }
            if (other.isSingleNumberValue()) {
                numberFromSetValueBuilder.addInt(other.asSingleNumberValue().getIntValue());
            } else {
                assert (other.isNumberFromSetValue());
                numberFromSetValueBuilder.addInts(other.asNumberFromSetValue());
            }
            return numberFromSetValueBuilder.build(factory);
        }
        return AbstractValue.unknown();
    }

    public abstract AbstractValue rewrittenWithLens(AppView<AppInfoWithLiveness> var1, GraphLens var2, GraphLens var3);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();
}

