/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.value;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.ConstantOrNonConstantNumberValue;
import com.android.tools.r8.ir.analysis.value.NonConstantNumberValue;
import com.android.tools.r8.ir.analysis.value.NumberFromSetValue;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.OptionalBool;
import java.util.Objects;

public class NumberFromIntervalValue
extends NonConstantNumberValue {
    private final long minInclusive;
    private final long maxInclusive;

    public NumberFromIntervalValue(long minInclusive, long maxInclusive) {
        assert (maxInclusive > minInclusive);
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
    }

    @Override
    public boolean containsInt(int value) {
        return this.minInclusive <= (long)value && (long)value <= this.maxInclusive;
    }

    @Override
    public long getAbstractionSize() {
        return this.maxInclusive - this.minInclusive + 1L;
    }

    @Override
    public boolean isNumberFromIntervalValue() {
        return true;
    }

    @Override
    public NumberFromIntervalValue asNumberFromIntervalValue() {
        return this;
    }

    @Override
    public boolean isNonTrivial() {
        return true;
    }

    @Override
    public OptionalBool isSubsetOf(int[] values2) {
        return OptionalBool.unknown();
    }

    @Override
    public boolean mayOverlapWith(ConstantOrNonConstantNumberValue other) {
        if (other.isSingleNumberValue()) {
            return this.containsInt(other.asSingleNumberValue().getIntValue());
        }
        if (other.isNumberFromIntervalValue()) {
            return this.mayOverlapWith(other.asNumberFromIntervalValue());
        }
        assert (other.isNumberFromSetValue());
        return this.mayOverlapWith(other.asNumberFromSetValue());
    }

    public boolean mayOverlapWith(NumberFromIntervalValue other) {
        return this.minInclusive <= other.maxInclusive && this.maxInclusive >= other.minInclusive;
    }

    public boolean mayOverlapWith(NumberFromSetValue other) {
        return other.mayOverlapWith(this);
    }

    @Override
    public AbstractValue rewrittenWithLens(AppView<AppInfoWithLiveness> appView, GraphLens lens, GraphLens codeLens) {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        NumberFromIntervalValue numberFromIntervalValue = (NumberFromIntervalValue)o;
        return this.minInclusive == numberFromIntervalValue.minInclusive && this.maxInclusive == numberFromIntervalValue.maxInclusive;
    }

    @Override
    public int hashCode() {
        int hash = 31 * (31 * (31 + Long.hashCode(this.minInclusive)) + Long.hashCode(this.maxInclusive));
        assert (hash == Objects.hash(this.minInclusive, this.maxInclusive));
        return hash;
    }

    @Override
    public String toString() {
        return "NumberFromIntervalValue([" + this.minInclusive + "; " + this.maxInclusive + "])";
    }
}

