/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.value;

import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.ir.analysis.value.SingleFieldValue;
import com.android.tools.r8.ir.analysis.value.objectstate.ObjectState;
import java.util.Objects;

public class SingleStatefulFieldValue
extends SingleFieldValue {
    private final ObjectState state;

    SingleStatefulFieldValue(DexField field, ObjectState state) {
        super(field);
        assert (!state.isEmpty());
        this.state = state;
    }

    @Override
    public boolean hasKnownArrayLength() {
        return this.getObjectState().hasKnownArrayLength();
    }

    @Override
    public int getKnownArrayLength() {
        return this.getObjectState().getKnownArrayLength();
    }

    @Override
    public boolean hasObjectState() {
        return true;
    }

    @Override
    public ObjectState getObjectState() {
        return this.state;
    }

    @Override
    public String toString() {
        return "SingleStatefulFieldValue(" + this.field.toSourceString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleStatefulFieldValue singleFieldValue = (SingleStatefulFieldValue)o;
        return this.field == singleFieldValue.field && this.state.equals(singleFieldValue.state);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.state);
    }
}

