/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.value.objectstate;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.UnknownValue;
import com.android.tools.r8.ir.analysis.value.objectstate.ObjectState;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;

public class EnumValuesObjectState
extends ObjectState {
    private final ObjectState[] state;

    public EnumValuesObjectState(ObjectState[] state) {
        assert (state.length > 0);
        assert (Arrays.stream(state).noneMatch(Objects::isNull));
        this.state = state;
    }

    @Override
    public void forEachAbstractFieldValue(BiConsumer<DexField, AbstractValue> consumer) {
    }

    @Override
    public AbstractValue getAbstractFieldValue(DexEncodedField field) {
        return UnknownValue.getInstance();
    }

    public ObjectState getObjectStateForOrdinal(int ordinal) {
        if (ordinal < 0 || ordinal >= this.state.length) {
            return ObjectState.empty();
        }
        return this.state[ordinal];
    }

    public int getEnumValuesSize() {
        return this.state.length;
    }

    @Override
    public boolean hasKnownArrayLength() {
        return true;
    }

    @Override
    public int getKnownArrayLength() {
        return this.state.length;
    }

    @Override
    public boolean isEnumValuesObjectState() {
        return true;
    }

    @Override
    public EnumValuesObjectState asEnumValuesObjectState() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public ObjectState rewrittenWithLens(AppView<AppInfoWithLiveness> appView, GraphLens lens, GraphLens codeLens) {
        ObjectState[] newState = new ObjectState[this.state.length];
        for (int i = 0; i < this.state.length; ++i) {
            newState[i] = this.state[i].rewrittenWithLens(appView, lens, codeLens);
        }
        return new EnumValuesObjectState(newState);
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        EnumValuesObjectState other = (EnumValuesObjectState)o;
        if (this.state.length != other.state.length) {
            return false;
        }
        for (int i = 0; i < this.state.length; ++i) {
            if (this.state[i].equals(other.state[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.state);
    }
}

