/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.value.objectstate;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.UnknownValue;
import com.android.tools.r8.ir.analysis.value.objectstate.ObjectState;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class NonEmptyObjectState
extends ObjectState {
    private final Map<DexField, AbstractValue> state;

    NonEmptyObjectState(Map<DexField, AbstractValue> state) {
        assert (!state.isEmpty());
        assert (state.values().stream().noneMatch(AbstractValue::isUnknown));
        this.state = state;
    }

    @Override
    public void forEachAbstractFieldValue(BiConsumer<DexField, AbstractValue> consumer) {
        this.state.forEach(consumer);
    }

    @Override
    public AbstractValue getAbstractFieldValue(DexEncodedField field) {
        return this.state.getOrDefault(field.getReference(), UnknownValue.getInstance());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public ObjectState rewrittenWithLens(AppView<AppInfoWithLiveness> appView, GraphLens lens, GraphLens codeLens) {
        IdentityHashMap<DexField, AbstractValue> rewrittenState = new IdentityHashMap<DexField, AbstractValue>();
        this.state.forEach((field, value) -> rewrittenState.put(lens.lookupField((DexField)field, codeLens), value.rewrittenWithLens(appView, lens, codeLens)));
        return new NonEmptyObjectState(rewrittenState);
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        NonEmptyObjectState other = (NonEmptyObjectState)o;
        if (this.state.size() != other.state.size()) {
            return false;
        }
        for (DexField dexField : this.state.keySet()) {
            AbstractValue otherValue;
            AbstractValue localValue = this.state.get(dexField);
            if (localValue.equals(otherValue = other.state.get(dexField))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.state.hashCode();
    }
}

