/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.value.objectstate;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.objectstate.ObjectState;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldArgumentInitializationInfo;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfoCollection;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public class ObjectStateAnalysis {
    public static ObjectState computeObjectState(Value value, AppView<AppInfoWithLiveness> appView, ProgramMethod context) {
        assert (!value.hasAliasedValue());
        if (value.isDefinedByInstructionSatisfying(i -> i.isNewArrayEmpty() || i.isNewArrayFilledData() || i.isInvokeNewArray())) {
            return ObjectStateAnalysis.computeNewArrayObjectState(value, appView, context);
        }
        if (value.isDefinedByInstructionSatisfying(Instruction::isNewInstance)) {
            return ObjectStateAnalysis.computeNewInstanceObjectState(value, appView, context);
        }
        return ObjectState.empty();
    }

    private static ObjectState computeNewArrayObjectState(Value value, AppView<AppInfoWithLiveness> appView, ProgramMethod context) {
        AbstractValue abstractValue = value.definition.getAbstractValue(appView, context);
        if (abstractValue.isStatefulObjectValue()) {
            return abstractValue.asStatefulObjectValue().getObjectState();
        }
        return ObjectState.empty();
    }

    private static ObjectState computeNewInstanceObjectState(Value value, AppView<AppInfoWithLiveness> appView, ProgramMethod context) {
        NewInstance newInstance = value.definition.asNewInstance();
        InvokeDirect uniqueConstructorInvoke = newInstance.getUniqueConstructorInvoke(appView.dexItemFactory());
        if (uniqueConstructorInvoke == null) {
            return ObjectState.empty();
        }
        DexClassAndMethod singleTarget = uniqueConstructorInvoke.lookupSingleTarget(appView, context);
        if (singleTarget == null) {
            return ObjectState.empty();
        }
        InstanceFieldInitializationInfoCollection initializationInfos = ((DexEncodedMethod)singleTarget.getDefinition()).getOptimizationInfo().getInstanceInitializerInfo(uniqueConstructorInvoke).fieldInitializationInfos();
        if (initializationInfos.isEmpty()) {
            return ObjectState.empty();
        }
        ObjectState.Builder builder = ObjectState.builder();
        initializationInfos.forEach(appView, (field, initializationInfo) -> {
            if (!((AppInfoWithLiveness)appView.appInfo()).isInstanceFieldWrittenOnlyInInstanceInitializers((DexEncodedField)field) && !appView.dexItemFactory().enumMembers.isNameOrOrdinalField((DexField)field.getReference())) {
                return;
            }
            if (initializationInfo.isArgumentInitializationInfo()) {
                InstanceFieldArgumentInitializationInfo argumentInitializationInfo = initializationInfo.asArgumentInitializationInfo();
                Value argument = uniqueConstructorInvoke.getArgument(argumentInitializationInfo.getArgumentIndex());
                builder.recordFieldHasValue((DexEncodedField)field, argument.getAbstractValue(appView, context));
            } else if (initializationInfo.isSingleValue()) {
                builder.recordFieldHasValue((DexEncodedField)field, initializationInfo.asSingleValue());
            }
        });
        return builder.build();
    }
}

