/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.ir.code.ImpreciseMemberTypeInstruction;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Value;
import java.util.List;

public abstract class ArrayAccess
extends Instruction
implements ImpreciseMemberTypeInstruction {
    private static final int ARRAY_INDEX = 0;
    private static final int INDEX_INDEX = 1;

    ArrayAccess(Value outValue, List<? extends Value> inValues) {
        super(outValue, inValues);
    }

    public Value array() {
        return (Value)this.inValues.get(0);
    }

    public Value index() {
        return (Value)this.inValues.get(1);
    }

    public int getIndexOrDefault(int defaultValue) {
        return this.index().isConstant() ? this.index().getConstInstruction().asConstInstruction().asConstNumber().getIntValue() : defaultValue;
    }

    @Override
    public boolean isArrayAccess() {
        return true;
    }

    @Override
    public ArrayAccess asArrayAccess() {
        return this;
    }

    public abstract ArrayAccess withMemberType(MemberType var1);

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean instructionInstanceCanThrow() {
        Value newArraySizeValue;
        if (this.index().isConstant() && !this.array().isPhi() && this.array().definition.isNewArrayEmpty() && (newArraySizeValue = this.array().definition.asNewArrayEmpty().size()).isConstant()) {
            int newArraySize = newArraySizeValue.getConstInstruction().asConstNumber().getIntValue();
            int index = this.index().getConstInstruction().asConstNumber().getIntValue();
            return newArraySize <= 0 || index < 0 || newArraySize <= index;
        }
        return true;
    }
}

