/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.code.CfArrayStore;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.code.Aput;
import com.android.tools.r8.code.AputBoolean;
import com.android.tools.r8.code.AputByte;
import com.android.tools.r8.code.AputChar;
import com.android.tools.r8.code.AputObject;
import com.android.tools.r8.code.AputShort;
import com.android.tools.r8.code.AputWide;
import com.android.tools.r8.code.Format23x;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.ArrayTypeElement;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.ArrayAccess;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.NewArrayEmpty;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.conversion.MethodConversionOptions;
import com.android.tools.r8.ir.conversion.TypeConstraintResolver;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import java.util.Arrays;

public class ArrayPut
extends ArrayAccess {
    private static final int VALUE_INDEX = 2;
    private MemberType type;

    public ArrayPut(MemberType type, Value array, Value index, Value value) {
        super(null, Arrays.asList(array, index, value));
        assert (type != null);
        assert (array.verifyCompatible(ValueType.OBJECT));
        assert (index.verifyCompatible(ValueType.INT));
        this.type = type;
    }

    @Override
    public int opcode() {
        return 8;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Value value() {
        return (Value)this.inValues.get(2);
    }

    @Override
    public MemberType getMemberType() {
        return this.type;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format23x instruction;
        int value = builder.allocatedRegister(this.value(), this.getNumber());
        int array = builder.allocatedRegister(this.array(), this.getNumber());
        int index = builder.allocatedRegister(this.index(), this.getNumber());
        switch (this.type) {
            case INT: 
            case FLOAT: {
                instruction = new Aput(value, array, index);
                break;
            }
            case LONG: 
            case DOUBLE: {
                instruction = new AputWide(value, array, index);
                break;
            }
            case OBJECT: {
                instruction = new AputObject(value, array, index);
                break;
            }
            case BOOLEAN_OR_BYTE: {
                ArrayTypeElement arrayType = this.array().getType().asArrayType();
                if (arrayType != null && arrayType.getMemberType() == TypeElement.getBoolean()) {
                    instruction = new AputBoolean(value, array, index);
                    break;
                }
                assert (this.array().getType().isDefinitelyNull() || arrayType.getMemberType() == TypeElement.getByte());
                instruction = new AputByte(value, array, index);
                break;
            }
            case CHAR: {
                instruction = new AputChar(value, array, index);
                break;
            }
            case SHORT: {
                instruction = new AputShort(value, array, index);
                break;
            }
            case INT_OR_FLOAT: 
            case LONG_OR_DOUBLE: {
                throw new Unreachable("Unexpected imprecise type: " + (Object)((Object)this.type));
            }
            default: {
                throw new Unreachable("Unexpected type: " + (Object)((Object)this.type));
            }
        }
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "ArrayPut instructions define no values.";
        return 0;
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, ProgramMethod context, Instruction.SideEffectAssumption assumption) {
        if (appView.options().debug) {
            return true;
        }
        Value array = this.array().getAliasedValue();
        if (array.isPhi() || !array.definition.isNewArrayEmpty()) {
            return true;
        }
        NewArrayEmpty definition = array.definition.asNewArrayEmpty();
        Value sizeValue = definition.size().getAliasedValue();
        if (sizeValue.isPhi() || !sizeValue.definition.isConstNumber()) {
            return true;
        }
        Value indexValue = this.index().getAliasedValue();
        if (indexValue.isPhi() || !indexValue.definition.isConstNumber()) {
            return true;
        }
        long index = indexValue.definition.asConstNumber().getRawValue();
        long size = sizeValue.definition.asConstNumber().getRawValue();
        if (index < 0L || index >= size) {
            return true;
        }
        TypeElement arrayType = array.getType();
        TypeElement valueType = this.value().getType();
        if (!arrayType.isArrayType()) {
            return true;
        }
        TypeElement memberType = arrayType.asArrayType().getMemberTypeAsValueType();
        if (!valueType.lessThanOrEqualUpToNullability(memberType, appView)) {
            return true;
        }
        for (Instruction user : array.uniqueUsers()) {
            if (user.isArrayPut() && user.asArrayPut().array() == array) continue;
            return true;
        }
        return array.numberOfPhiUsers() > 0;
    }

    @Override
    public boolean identicalAfterRegisterAllocation(Instruction other, RegisterAllocator allocator, MethodConversionOptions conversionOptions) {
        return false;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isArrayPut() && other.asArrayPut().type == this.type;
    }

    @Override
    public boolean isArrayPut() {
        return true;
    }

    @Override
    public ArrayPut asArrayPut() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forArrayPut();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add((CfInstruction)new CfArrayStore(this.type), this);
    }

    @Override
    public boolean throwsNpeIfValueIsNull(Value value, AppView<?> appView, ProgramMethod context) {
        return this.array() == value;
    }

    @Override
    public boolean throwsOnNullInput() {
        return true;
    }

    @Override
    public Value getNonNullInput() {
        return this.array();
    }

    @Override
    public void constrainType(TypeConstraintResolver constraintResolver) {
        constraintResolver.constrainArrayMemberType(this.type, this.value(), this.array(), t -> {
            this.type = t;
        });
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, ProgramMethod context) {
        return false;
    }

    @Override
    public ArrayAccess withMemberType(MemberType newMemberType) {
        return new ArrayPut(newMemberType, this.array(), this.index(), this.value());
    }
}

