/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.VerifyTypesHelper;
import com.android.tools.r8.ir.analysis.type.DynamicTypeWithUpperBound;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import java.util.Objects;
import java.util.Set;

public class Assume
extends Instruction {
    private static final String ERROR_MESSAGE = "Expected Assume instructions to be removed after IR processing.";
    private DynamicTypeAssumption dynamicTypeAssumption;
    private final NonNullAssumption nonNullAssumption;
    private final Instruction origin;

    public Assume(DynamicTypeAssumption dynamicTypeAssumption, NonNullAssumption nonNullAssumption, Value dest, Value src, Instruction origin, AppView<?> appView) {
        super(dest, src);
        assert (dynamicTypeAssumption != null || nonNullAssumption != null);
        assert (dynamicTypeAssumption == null || dynamicTypeAssumption.verifyCorrectnessOfValues(dest, src, appView));
        assert (nonNullAssumption == null || nonNullAssumption.verifyCorrectnessOfValues(dest, src, appView));
        assert (dest != null);
        this.dynamicTypeAssumption = dynamicTypeAssumption;
        this.nonNullAssumption = nonNullAssumption;
        this.origin = origin;
    }

    public static Assume createAssumeNonNullInstruction(Value dest, Value src, Instruction origin, AppView<?> appView) {
        return new Assume(null, NonNullAssumption.get(), dest, src, origin, appView);
    }

    public static Assume createAssumeDynamicTypeInstruction(DynamicTypeWithUpperBound dynamicType, Value dest, Value src, Instruction origin, AppView<?> appView) {
        return new Assume(new DynamicTypeAssumption(dynamicType), null, dest, src, origin, appView);
    }

    @Override
    public int opcode() {
        return 9;
    }

    public boolean verifyInstructionIsNeeded(AppView<?> appView) {
        if (this.hasDynamicTypeAssumption()) assert (this.dynamicTypeAssumption.verifyCorrectnessOfValues(this.outValue(), this.src(), appView));
        return true;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public DynamicTypeAssumption getDynamicTypeAssumption() {
        return this.dynamicTypeAssumption;
    }

    public NonNullAssumption getNonNullAssumption() {
        return this.nonNullAssumption;
    }

    public Value src() {
        return (Value)this.inValues.get(0);
    }

    public Instruction origin() {
        return this.origin;
    }

    @Override
    public boolean outTypeKnownToBeBoolean(Set<Phi> seen) {
        return this.src().knownToBeBoolean(seen);
    }

    @Override
    public String getInstructionName() {
        return "Assume";
    }

    @Override
    public boolean isAssume() {
        return true;
    }

    @Override
    public Assume asAssume() {
        return this;
    }

    public boolean hasDynamicTypeAssumption() {
        return this.dynamicTypeAssumption != null;
    }

    public void unsetDynamicTypeAssumption() {
        this.dynamicTypeAssumption = null;
    }

    public boolean hasNonNullAssumption() {
        return this.nonNullAssumption != null;
    }

    @Override
    public boolean couldIntroduceAnAlias(AppView<?> appView, Value root) {
        assert (root != null && root.getType().isReferenceType());
        assert (this.outValue != null);
        TypeElement outType = this.outValue.getType();
        if (outType.isPrimitiveType()) {
            return false;
        }
        if (this.hasDynamicTypeAssumption()) {
            outType = this.dynamicTypeAssumption.getDynamicType().getDynamicUpperBoundType();
        }
        if (((AppInfo)appView.appInfo()).hasLiveness() && outType.isClassType() && root.getType().isClassType() && ((AppInfo)appView.appInfo()).withLiveness().inDifferentHierarchy(outType.asClassType().getClassType(), root.getType().asClassType().getClassType())) {
            return false;
        }
        return outType.isReferenceType();
    }

    @Override
    public boolean isIntroducingAnAlias() {
        return true;
    }

    @Override
    public Value getAliasForOutValue() {
        return this.src();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public int maxInValueRegister() {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public int maxOutValueRegister() {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public boolean isOutConstant() {
        return false;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isAssume()) {
            return false;
        }
        Assume assumeInstruction = other.asAssume();
        return Objects.equals(this.dynamicTypeAssumption, assumeInstruction.dynamicTypeAssumption) && Objects.equals(this.nonNullAssumption, assumeInstruction.nonNullAssumption);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forAssume();
    }

    @Override
    public TypeElement evaluate(AppView<?> appView) {
        if (this.hasNonNullAssumption()) {
            assert (this.src().getType().isReferenceType());
            return this.src().getType().asReferenceType().asMeetWithNotNull();
        }
        return this.src().getType();
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return helper.getDexType(this.src());
    }

    @Override
    public boolean hasInvariantOutType() {
        return false;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, ProgramMethod context) {
        return false;
    }

    @Override
    public Value getNonNullInput() {
        return this.src();
    }

    @Override
    public boolean throwsOnNullInput() {
        return this.hasNonNullAssumption();
    }

    @Override
    public boolean verifyTypes(AppView<?> appView, VerifyTypesHelper verifyTypesHelper) {
        assert (super.verifyTypes(appView, verifyTypesHelper));
        TypeElement inType = this.src().getType();
        assert (inType.isReferenceType()) : inType;
        TypeElement outType = this.getOutType();
        if (this.hasNonNullAssumption()) {
            assert (inType.isNullType() || outType.equals(inType.asReferenceType().asMeetWithNotNull())) : "At " + this + System.lineSeparator() + outType + " != " + inType;
        } else {
            assert (this.hasDynamicTypeAssumption());
            assert (!this.src().isConstNumber());
            assert (outType.equals(inType)) : "At " + this + System.lineSeparator() + outType + " != " + inType;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        if (this.hasNonNullAssumption()) {
            builder.append("; not null");
        }
        if (this.hasDynamicTypeAssumption()) {
            DynamicTypeWithUpperBound dynamicType = this.dynamicTypeAssumption.getDynamicType();
            if (this.hasOutValue() && !dynamicType.getDynamicUpperBoundType().equalUpToNullability(this.outValue.getType())) {
                builder.append("; upper bound: ").append(dynamicType.getDynamicUpperBoundType());
            }
            if (dynamicType.hasDynamicLowerBoundType()) {
                builder.append("; lower bound: ").append(dynamicType.getDynamicLowerBoundType());
            }
        }
        return builder.toString();
    }

    public static class NonNullAssumption {
        private static final NonNullAssumption instance = new NonNullAssumption();

        private NonNullAssumption() {
        }

        public static NonNullAssumption get() {
            return instance;
        }

        public boolean verifyCorrectnessOfValues(Value dest, Value src, AppView<?> appView) {
            assert (!src.isNeverNull());
            return true;
        }
    }

    public static class DynamicTypeAssumption {
        private final DynamicTypeWithUpperBound dynamicType;

        public DynamicTypeAssumption(DynamicTypeWithUpperBound dynamicType) {
            assert (dynamicType != null);
            this.dynamicType = dynamicType;
        }

        public DynamicTypeWithUpperBound getDynamicType() {
            return this.dynamicType;
        }

        public boolean verifyCorrectnessOfValues(Value dest, Value src, AppView<?> appView) {
            assert (!this.dynamicType.isBottom());
            assert (!this.dynamicType.isUnknown());
            assert (this.dynamicType.getDynamicUpperBoundType().lessThanOrEqualUpToNullability(src.getType(), appView));
            return true;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            DynamicTypeAssumption assumption = (DynamicTypeAssumption)other;
            return this.dynamicType.equals(assumption.dynamicType);
        }

        public int hashCode() {
            return this.dynamicType.hashCode();
        }
    }
}

