/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.ir.analysis.VerifyTypesHelper;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.BasicBlockInstructionIterator;
import com.android.tools.r8.ir.code.BasicBlockInstructionListIterator;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.IRMetadata;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.InitClass;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.IntSwitch;
import com.android.tools.r8.ir.code.JumpInstruction;
import com.android.tools.r8.ir.code.Move;
import com.android.tools.r8.ir.code.MoveException;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Pop;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.StackValues;
import com.android.tools.r8.ir.code.Switch;
import com.android.tools.r8.ir.code.Throw;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntListIterator;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.StringUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;

public class BasicBlock {
    private Int2ReferenceMap<DebugLocalInfo> localsAtEntry;
    private final List<BasicBlock> successors = new ArrayList<BasicBlock>();
    private final List<BasicBlock> predecessors = new ArrayList<BasicBlock>();
    private Set<BasicBlockChangeListener> onControlFlowEdgesMayChangeListeners = null;
    private CatchHandlers<Integer> catchHandlers = CatchHandlers.EMPTY_INDICES;
    private LinkedList<Instruction> instructions = new LinkedList();
    private int number = -1;
    private List<Phi> phis = new ArrayList<Phi>();
    private boolean filled = false;
    private boolean sealed = false;
    private final Map<Integer, Phi> incompletePhis = new HashMap<Integer, Phi>();
    private int estimatedPredecessorsCount = 0;
    private int unfilledPredecessorsCount = 0;
    private int color = 0;
    private Map<Integer, Value> currentDefinitions = new HashMap<Integer, Value>();

    private boolean notifySuccessorsMayChangeListeners() {
        if (this.onControlFlowEdgesMayChangeListeners != null) {
            this.onControlFlowEdgesMayChangeListeners.forEach(l -> l.onSuccessorsMayChange(this));
        }
        return true;
    }

    private boolean notifyPredecessorsMayChangeListeners() {
        if (this.onControlFlowEdgesMayChangeListeners != null) {
            this.onControlFlowEdgesMayChangeListeners.forEach(l -> l.onPredecessorsMayChange(this));
        }
        return true;
    }

    private boolean hasLinearFlow(BasicBlock current, BasicBlock target) {
        while (current != target) {
            if (current.getPredecessors().size() != 1) {
                return false;
            }
            BasicBlock candidate = current.getPredecessors().get(0);
            if (!candidate.exit().isGoto() || candidate.exit().asGoto().getTarget() != current) {
                return false;
            }
            current = candidate;
        }
        return true;
    }

    private static boolean blocksClean(List<BasicBlock> blocks) {
        blocks.forEach(b -> {
            assert (b.predecessors.size() == 0);
            assert (b.successors.size() == 0);
        });
        return true;
    }

    private void removeCatchHandlerWithGuard(DexType guard) {
        int guardIndex = this.catchHandlers.getGuards().indexOf(guard);
        if (guardIndex >= 0) {
            int successorIndex = this.catchHandlers.getAllTargets().get(guardIndex);
            assert (successorIndex >= 0);
            this.catchHandlers = this.catchHandlers.removeGuard(guard);
            if (this.getCatchHandlers().getAllTargets().stream().noneMatch(target -> target == this.successors.get(successorIndex))) {
                this.getMutableSuccessors().remove(successorIndex);
            }
            assert (this.consistentCatchHandlers());
        }
    }

    private boolean isCatchHandlerForSingleGuard() {
        assert (this.predecessors.size() == 1);
        BasicBlock predecessor = this.predecessors.get(0);
        assert (predecessor.getCatchHandlers().getAllTargets().contains(this));
        int count = 0;
        for (BasicBlock target : predecessor.getCatchHandlers().getAllTargets()) {
            if (target != this || ++count <= 1) continue;
            return false;
        }
        return true;
    }

    private static int onThrowValueRegister(int register) {
        return -(register + 1);
    }

    private Value readOnThrowValue(int register, EdgeType readingEdge) {
        if (readingEdge == EdgeType.EXCEPTIONAL) {
            return this.currentDefinitions.get(BasicBlock.onThrowValueRegister(register));
        }
        return null;
    }

    private boolean isOnThrowValue(int register, EdgeType readingEdge) {
        return this.readOnThrowValue(register, readingEdge) != null;
    }

    private static void appendBasicBlockList(StringBuilder builder, List<BasicBlock> list, Function<BasicBlock, String> postfix) {
        if (list.size() > 0) {
            for (BasicBlock block : list) {
                builder.append(block.getNumberAsString());
                builder.append(postfix.apply(block));
                builder.append(' ');
            }
        } else {
            builder.append('-');
        }
    }

    private String predecessorPostfix(BasicBlock block) {
        if (this.hasCatchSuccessor(block)) {
            return new String(new char[this.guardsForCatchSuccessor(block)]).replace("\u0000", "*");
        }
        return "";
    }

    private static int digits(int number) {
        return (int)Math.ceil(Math.log10(number + 1));
    }

    private static void printBlockList(CfgPrinter printer, List<BasicBlock> blocks) {
        for (BasicBlock block : blocks) {
            printer.append(" \"B").append(block.number).append("\"");
        }
    }

    public static BasicBlock createGotoBlock(int blockNumber, Position position, IRMetadata metadata, BasicBlock target) {
        BasicBlock block = BasicBlock.createGotoBlock(blockNumber, position, metadata);
        block.getMutableSuccessors().add(target);
        return block;
    }

    public static BasicBlock createGotoBlock(int blockNumber, Position position, IRMetadata metadata) {
        BasicBlock block = new BasicBlock();
        block.add((Instruction)new Goto(), metadata);
        block.close(null);
        block.setNumber(blockNumber);
        block.entry().setPosition(position);
        return block;
    }

    public static BasicBlock createIfBlock(int blockNumber, If theIf, IRMetadata metadata) {
        BasicBlock block = new BasicBlock();
        block.add((Instruction)theIf, metadata);
        block.close(null);
        block.setNumber(blockNumber);
        return block;
    }

    public static BasicBlock createIfBlock(int blockNumber, If theIf, IRMetadata metadata, Instruction ... instructions) {
        BasicBlock block = new BasicBlock();
        for (Instruction instruction : instructions) {
            block.add(instruction, metadata);
        }
        block.add((Instruction)theIf, metadata);
        block.close(null);
        block.setNumber(blockNumber);
        return block;
    }

    public static BasicBlock createSwitchBlock(int blockNumber, IntSwitch theSwitch, IRMetadata metadata) {
        BasicBlock block = new BasicBlock();
        block.add((Instruction)theSwitch, metadata);
        block.close(null);
        block.setNumber(blockNumber);
        return block;
    }

    public static BasicBlock createRethrowBlock(IRCode code, Position position, DexType guard, AppView<?> appView) {
        TypeElement guardTypeLattice = TypeElement.fromDexType(guard, Nullability.definitelyNotNull(), appView);
        BasicBlock block = new BasicBlock();
        MoveException moveException = new MoveException(new Value(code.valueNumberGenerator.next(), guardTypeLattice, null), guard, appView.options());
        moveException.setPosition(position);
        Throw throwInstruction = new Throw(moveException.outValue);
        throwInstruction.setPosition(position);
        block.add((Instruction)moveException, code);
        block.add((Instruction)throwInstruction, code);
        block.close(null);
        block.setNumber(code.getNextBlockNumber());
        return block;
    }

    private boolean verifyOnThrowWrite(int register) {
        if (register >= 0) {
            return true;
        }
        for (Integer other : this.currentDefinitions.keySet()) {
            assert (other >= 0 || other == register);
        }
        return true;
    }

    private boolean verifyNoValuesAfterThrowingInstruction() {
        if (this.hasCatchHandlers()) {
            InstructionIterator iterator2 = this.iterator(this.instructions.size());
            while (iterator2.hasPrevious()) {
                Instruction instruction = iterator2.previous();
                if (instruction.instructionTypeCanThrow()) {
                    return true;
                }
                assert (instruction.outValue() == null);
            }
        }
        return true;
    }

    private List<BasicBlock> appendCatchHandlers(BasicBlock fromBlock) {
        assert (fromBlock.hasCatchHandlers());
        List<Integer> prevCatchTargets = fromBlock.catchHandlers.getAllTargets();
        List<DexType> prevCatchGuards = fromBlock.catchHandlers.getGuards();
        ArrayList<BasicBlock> catchSuccessors = new ArrayList<BasicBlock>();
        ArrayList<DexType> newCatchGuards = new ArrayList<DexType>();
        ArrayList<Integer> newCatchTargets = new ArrayList<Integer>();
        if (this.hasCatchHandlers()) {
            newCatchGuards.addAll(this.catchHandlers.getGuards());
            newCatchTargets.addAll(this.catchHandlers.getAllTargets());
            Iterator iterator2 = newCatchTargets.iterator();
            while (iterator2.hasNext()) {
                int newCatchTarget = (Integer)iterator2.next();
                BasicBlock catchSuccessor = this.successors.get(newCatchTarget);
                if (!catchSuccessors.contains(catchSuccessor)) {
                    catchSuccessors.add(catchSuccessor);
                }
                int index = catchSuccessors.indexOf(catchSuccessor);
                assert (index == newCatchTarget);
            }
        }
        int formerCatchHandlersCount = catchSuccessors.size();
        for (int i = 0; i < prevCatchTargets.size(); ++i) {
            int prevCatchTarget = prevCatchTargets.get(i);
            DexType prevCatchGuard = prevCatchGuards.get(i);
            if (newCatchGuards.contains(prevCatchGuard)) continue;
            BasicBlock catchSuccessor = fromBlock.successors.get(prevCatchTarget);
            assert (catchSuccessor.getPredecessors().size() == 1);
            assert (catchSuccessor.getPhis().isEmpty());
            int index = catchSuccessors.indexOf(catchSuccessor);
            if (index == -1) {
                catchSuccessors.add(catchSuccessor);
                index = catchSuccessors.size() - 1;
            }
            newCatchGuards.add(prevCatchGuard);
            newCatchTargets.add(index);
        }
        List<BasicBlock> successors = this.getMutableSuccessors();
        ArrayList<BasicBlock> formerSuccessors = new ArrayList<BasicBlock>(successors);
        successors.clear();
        ArrayList<BasicBlock> sharedCatchSuccessors = new ArrayList<BasicBlock>();
        for (int i = 0; i < catchSuccessors.size(); ++i) {
            if (i < formerCatchHandlersCount) {
                assert (((BasicBlock)catchSuccessors.get(i)).getPredecessors().contains(this));
                successors.add((BasicBlock)catchSuccessors.get(i));
                continue;
            }
            assert (!((BasicBlock)catchSuccessors.get(i)).getPredecessors().contains(this));
            this.link((BasicBlock)catchSuccessors.get(i));
            sharedCatchSuccessors.add((BasicBlock)catchSuccessors.get(i));
        }
        this.catchHandlers = new CatchHandlers(newCatchGuards, newCatchTargets);
        int catchSuccessorsCount = successors.size();
        for (BasicBlock formerSuccessor : formerSuccessors) {
            if (successors.contains(formerSuccessor)) continue;
            assert (!this.exit().isThrow());
            successors.add(formerSuccessor);
        }
        assert (successors.size() == catchSuccessorsCount || !this.exit().isThrow());
        return sharedCatchSuccessors;
    }

    public boolean consistentBlockInstructions(boolean argumentsAllowed, boolean debug, boolean ssa) {
        for (Instruction instruction : this.getInstructions()) {
            assert (instruction.verifyValidPositionInfo(debug));
            assert (instruction.getBlock() == this);
            assert (!instruction.isArgument() || argumentsAllowed);
            assert (!instruction.isDebugLocalRead() || !instruction.getDebugValues().isEmpty());
            assert (!instruction.isInitClass() || this.consistentInitClassInstruction(instruction.asInitClass(), ssa));
            if (instruction.isMoveException()) {
                assert (instruction == this.entry());
                for (BasicBlock pred : this.getPredecessors()) {
                    assert (pred.hasCatchSuccessor(this) || pred.isTrivialGoto() && pred.endOfGotoChain() == this);
                }
            }
            if (instruction.isArgument()) continue;
            argumentsAllowed = false;
        }
        return true;
    }

    public boolean consistentInitClassInstruction(InitClass initClass, boolean ssa) {
        if (!ssa) {
            return true;
        }
        assert (initClass.hasOutValue());
        assert (!initClass.outValue().hasDebugUsers());
        assert (!initClass.outValue().hasPhiUsers());
        assert (initClass.outValue().uniqueUsers().stream().allMatch(Instruction::isPop));
        return true;
    }

    public boolean verifyTypes(AppView<?> appView, VerifyTypesHelper verifyTypesHelper) {
        assert (this.instructions.stream().allMatch(instruction -> instruction.verifyTypes(appView, verifyTypesHelper)));
        return true;
    }

    public void setLocalsAtEntry(Int2ReferenceMap<DebugLocalInfo> localsAtEntry) {
        this.localsAtEntry = localsAtEntry;
    }

    public Int2ReferenceMap<DebugLocalInfo> getLocalsAtEntry() {
        return this.localsAtEntry;
    }

    public void replaceLastInstruction(Instruction instruction, IRCode code) {
        InstructionListIterator iterator2 = this.listIterator(code, this.getInstructions().size());
        iterator2.previous();
        iterator2.replaceCurrentInstruction(instruction);
    }

    public void addControlFlowEdgesMayChangeListener(BasicBlockChangeListener listener) {
        if (this.onControlFlowEdgesMayChangeListeners == null) {
            this.onControlFlowEdgesMayChangeListeners = Collections.newSetFromMap(new WeakHashMap());
        }
        this.onControlFlowEdgesMayChangeListeners.add(listener);
    }

    public boolean hasUniqueSuccessor() {
        return this.successors.size() == 1;
    }

    public boolean hasUniqueSuccessorWithUniquePredecessor() {
        return this.hasUniqueSuccessor() && this.getUniqueSuccessor().getPredecessors().size() == 1;
    }

    public boolean hasUniqueNormalSuccessor() {
        return this.numberOfNormalSuccessors() == 1;
    }

    public boolean hasUniqueNormalSuccessorWithUniquePredecessor() {
        return this.hasUniqueNormalSuccessor() && this.getUniqueNormalSuccessor().getPredecessors().size() == 1;
    }

    public BasicBlock getUniqueSuccessor() {
        assert (this.hasUniqueSuccessor());
        return this.successors.get(0);
    }

    public BasicBlock getUniqueNormalSuccessor() {
        assert (this.hasUniqueNormalSuccessor());
        return ListUtils.last(this.successors);
    }

    public List<BasicBlock> getSuccessors() {
        return Collections.unmodifiableList(this.successors);
    }

    public List<BasicBlock> getMutableSuccessors() {
        assert (this.notifySuccessorsMayChangeListeners());
        return this.successors;
    }

    public void forEachNormalSuccessor(Consumer<BasicBlock> consumer) {
        for (int i = this.successors.size() - this.numberOfNormalSuccessors(); i < this.successors.size(); ++i) {
            consumer.accept(this.successors.get(i));
        }
    }

    public boolean hasNormalSuccessor(BasicBlock block) {
        for (int i = this.successors.size() - this.numberOfNormalSuccessors(); i < this.successors.size(); ++i) {
            if (this.successors.get(i) != block) continue;
            return true;
        }
        return false;
    }

    public List<BasicBlock> getNormalSuccessors() {
        if (!this.hasCatchHandlers()) {
            return this.successors;
        }
        ImmutableList.Builder normals = ImmutableList.builder();
        this.forEachNormalSuccessor(normals::add);
        return normals.build();
    }

    public int numberOfNormalSuccessors() {
        if (this.hasCatchHandlers()) {
            return this.successors.size() - this.catchHandlers.getUniqueTargets().size();
        }
        return this.successors.size();
    }

    public int numberOfExceptionalSuccessors() {
        if (this.hasCatchHandlers()) {
            return this.catchHandlers.getUniqueTargets().size();
        }
        return 0;
    }

    public boolean hasUniquePredecessor() {
        return this.predecessors.size() == 1;
    }

    public BasicBlock getUniquePredecessor() {
        assert (this.hasUniquePredecessor());
        return this.predecessors.get(0);
    }

    public List<BasicBlock> getPredecessors() {
        return Collections.unmodifiableList(this.predecessors);
    }

    public List<BasicBlock> getMutablePredecessors() {
        assert (this.notifyPredecessorsMayChangeListeners());
        return this.predecessors;
    }

    public List<BasicBlock> getNormalPredecessors() {
        ImmutableList.Builder normals = ImmutableList.builder();
        for (BasicBlock predecessor : this.predecessors) {
            if (predecessor.hasCatchSuccessor(this)) continue;
            normals.add(predecessor);
        }
        return normals.build();
    }

    public void removeSuccessor(BasicBlock block) {
        int index = this.successors.indexOf(block);
        assert (index >= 0) : "removeSuccessor did not find the successor to remove";
        this.removeSuccessorsByIndex(new IntArrayList(new int[]{index}));
    }

    public void removePredecessor(BasicBlock block, Set<Value> affectedValues) {
        int index = this.predecessors.indexOf(block);
        assert (index >= 0) : "removePredecessor did not find the predecessor to remove";
        this.getMutablePredecessors().remove(index);
        if (this.phis != null) {
            for (Phi phi : this.getPhis()) {
                phi.removeOperand(index);
            }
            ArrayList<Phi> trivials = new ArrayList<Phi>();
            for (Phi phi : this.getPhis()) {
                if (!phi.isTrivialPhi()) continue;
                trivials.add(phi);
                if (affectedValues == null) continue;
                affectedValues.addAll(phi.affectedValues());
            }
            for (Phi phi : trivials) {
                phi.removeTrivialPhi(null, affectedValues);
            }
        }
    }

    public void removeAllNormalSuccessors() {
        if (this.hasCatchHandlers()) {
            IntArrayList successorsToRemove = new IntArrayList();
            Set<Integer> handlers = this.catchHandlers.getUniqueTargets();
            for (int i = 0; i < this.successors.size(); ++i) {
                if (handlers.contains(i)) continue;
                successorsToRemove.add(i);
            }
            this.removeSuccessorsByIndex(successorsToRemove);
        } else {
            this.successors.clear();
        }
    }

    public void swapSuccessors(BasicBlock a, BasicBlock b) {
        assert (a != b);
        int aIndex = this.successors.indexOf(a);
        int bIndex = this.successors.indexOf(b);
        assert (aIndex >= 0 && bIndex >= 0);
        this.swapSuccessorsByIndex(aIndex, bIndex);
    }

    public void swapSuccessorsByIndex(int index1, int index2) {
        assert (index1 != index2);
        if (this.hasCatchHandlers()) {
            ArrayList<Integer> targets = new ArrayList<Integer>(this.catchHandlers.getAllTargets());
            assert (targets.contains(index1) == targets.contains(index2)) : "Swapping normal successor and catch handler";
            for (int i = 0; i < targets.size(); ++i) {
                if ((Integer)targets.get(i) == index1) {
                    targets.set(i, index2);
                    continue;
                }
                if ((Integer)targets.get(i) != index2) continue;
                targets.set(i, index1);
            }
            this.catchHandlers = new CatchHandlers<Integer>(this.catchHandlers.getGuards(), targets);
        }
        List<BasicBlock> successors = this.getMutableSuccessors();
        BasicBlock tmp = successors.get(index1);
        successors.set(index1, successors.get(index2));
        successors.set(index2, tmp);
    }

    public void replaceSuccessor(BasicBlock block, BasicBlock newBlock) {
        assert (this.successors.contains(block)) : "attempt to replace non-existent successor";
        if (this.successors.contains(newBlock)) {
            int i;
            int indexOfOldBlock = this.successors.indexOf(block);
            int indexOfNewBlock = this.successors.indexOf(newBlock);
            if (this.hasCatchHandlers()) {
                ArrayList<Integer> targets = new ArrayList<Integer>(this.catchHandlers.getAllTargets());
                for (i = 0; i < targets.size(); ++i) {
                    if ((Integer)targets.get(i) == indexOfOldBlock) {
                        targets.set(i, indexOfNewBlock);
                    }
                    if ((Integer)targets.get(i) <= indexOfOldBlock) continue;
                    targets.set(i, (Integer)targets.get(i) - 1);
                }
                this.catchHandlers = new CatchHandlers<Integer>(this.catchHandlers.getGuards(), targets);
            }
            if (this.exit().isGoto()) {
                if (indexOfOldBlock == this.successors.size() - 1 && indexOfNewBlock != this.successors.size() - 2) {
                    this.swapSuccessorsByIndex(indexOfOldBlock - 1, indexOfNewBlock);
                }
            } else if (this.exit().isIf()) {
                if (indexOfNewBlock >= this.successors.size() - 2 && indexOfOldBlock >= this.successors.size() - 2) {
                    Instruction instruction = this.getInstructions().removeLast();
                    for (i = instruction.inValues().size() - 1; i >= 0; --i) {
                        Value value = instruction.inValues().get(i);
                        if (value.isValueOnStack()) {
                            if (!value.isPhi() && value.definition.isLoad() && value.definition.getBlock() == this) {
                                assert (this.hasLinearFlow(this, value.definition.getBlock()));
                                value.definition.getBlock().removeInstruction(value.definition);
                            } else {
                                assert (!(value instanceof StackValues));
                                Pop pop = new Pop(value);
                                pop.setBlock(this);
                                pop.setPosition(instruction.getPosition());
                                this.getInstructions().addLast(pop);
                            }
                        }
                        if (!value.hasUsersInfo()) continue;
                        value.removeUser(instruction);
                    }
                    Goto exit = new Goto();
                    exit.setBlock(this);
                    exit.setPosition(instruction.getPosition());
                    this.getInstructions().addLast(exit);
                } else if (indexOfOldBlock >= this.successors.size() - 2) {
                    this.swapSuccessorsByIndex(indexOfOldBlock - 1, indexOfNewBlock);
                }
            } else if (this.exit().isSwitch()) {
                Switch exit = this.exit().asSwitch();
                if (exit.getFallthroughBlockIndex() == indexOfOldBlock) {
                    exit.setFallthroughBlockIndex(indexOfNewBlock);
                }
                if (exit.getFallthroughBlockIndex() > indexOfOldBlock) {
                    exit.setFallthroughBlockIndex(exit.getFallthroughBlockIndex() - 1);
                }
                int[] indices = exit.targetBlockIndices();
                for (int i2 = 0; i2 < indices.length; ++i2) {
                    if (indices[i2] == indexOfOldBlock) {
                        indices[i2] = indexOfNewBlock;
                    }
                    if (indices[i2] <= indexOfOldBlock) continue;
                    indices[i2] = indices[i2] - 1;
                }
            } else assert (this.exit().isReturn() || this.exit().isThrow());
            boolean removed = this.getMutableSuccessors().remove(block);
            assert (removed);
        } else {
            for (int i = 0; i < this.successors.size(); ++i) {
                if (this.successors.get(i) != block) continue;
                this.getMutableSuccessors().set(i, newBlock);
                return;
            }
        }
    }

    public void replacePredecessor(BasicBlock block, BasicBlock newBlock) {
        for (int i = 0; i < this.predecessors.size(); ++i) {
            if (this.predecessors.get(i) != block) continue;
            assert (this.notifyPredecessorsMayChangeListeners());
            this.getMutablePredecessors().set(i, newBlock);
            return;
        }
        assert (false) : "replaceSuccessor did not find the predecessor to replace";
    }

    public void removeSuccessorsByIndex(IntList successorsToRemove) {
        if (successorsToRemove.isEmpty()) {
            return;
        }
        assert (ListUtils.verifyListIsOrdered(successorsToRemove));
        List<BasicBlock> successors = this.getMutableSuccessors();
        ArrayList<BasicBlock> copy = new ArrayList<BasicBlock>(successors);
        successors.clear();
        int current = 0;
        IntListIterator intListIterator = successorsToRemove.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            successors.addAll(copy.subList(current, i));
            current = i + 1;
        }
        successors.addAll(copy.subList(current, copy.size()));
        if (this.hasCatchHandlers()) {
            List<Integer> currentTargets = this.catchHandlers.getAllTargets();
            List<DexType> currentGuards = this.catchHandlers.getGuards();
            int size = this.catchHandlers.size();
            ArrayList<DexType> newGuards = new ArrayList<DexType>(size);
            ArrayList<Integer> newTargets = new ArrayList<Integer>(size);
            block1: for (int i = 0; i < currentTargets.size(); ++i) {
                int index = currentTargets.get(i);
                int decreaseBy = 0;
                IntListIterator intListIterator2 = successorsToRemove.iterator();
                while (intListIterator2.hasNext()) {
                    int removedIndex = (Integer)intListIterator2.next();
                    if (index == removedIndex) continue block1;
                    if (index < removedIndex) break;
                    ++decreaseBy;
                }
                newTargets.add(index - decreaseBy);
                newGuards.add(currentGuards.get(i));
            }
            this.catchHandlers = newTargets.isEmpty() ? CatchHandlers.EMPTY_INDICES : new CatchHandlers(newGuards, newTargets);
        }
    }

    public void removePredecessorsByIndex(List<Integer> predecessorsToRemove) {
        if (predecessorsToRemove.isEmpty()) {
            return;
        }
        List<BasicBlock> predecessors = this.getMutablePredecessors();
        ArrayList<BasicBlock> copy = new ArrayList<BasicBlock>(predecessors);
        predecessors.clear();
        int current = 0;
        for (int i : predecessorsToRemove) {
            predecessors.addAll(copy.subList(current, i));
            current = i + 1;
        }
        predecessors.addAll(copy.subList(current, copy.size()));
    }

    public void removePhisByIndex(List<Integer> predecessorsToRemove) {
        for (Phi phi : this.phis) {
            phi.removeOperandsByIndex(predecessorsToRemove);
        }
    }

    public boolean hasPhis() {
        return !this.phis.isEmpty();
    }

    public boolean hasDeadPhi(AppView<?> appView, IRCode code) {
        for (Phi phi : this.phis) {
            if (!phi.isDead(appView, code)) continue;
            return true;
        }
        return false;
    }

    public List<Phi> getPhis() {
        return this.phis;
    }

    public boolean isEntry() {
        return this.getPredecessors().isEmpty();
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled() {
        this.filled = true;
    }

    public void setFilledForTesting() {
        this.filled = true;
    }

    public boolean hasCatchHandlers() {
        assert (this.catchHandlers != null);
        return !this.catchHandlers.isEmpty();
    }

    public int getNumber() {
        assert (this.number >= 0);
        return this.number;
    }

    public void setNumber(int number) {
        assert (number >= 0);
        this.number = number;
    }

    public String getNumberAsString() {
        return this.number >= 0 ? "" + this.number : "<unknown>";
    }

    public int numberInstructions(int nextInstructionNumber) {
        for (Instruction instruction : this.instructions) {
            instruction.setNumber(nextInstructionNumber);
            nextInstructionNumber += 2;
        }
        return nextInstructionNumber;
    }

    public LinkedList<Instruction> getInstructions() {
        return this.instructions;
    }

    public Iterable<Instruction> instructionsAfter(Instruction instruction) {
        return () -> this.iterator(instruction);
    }

    public Iterable<Instruction> instructionsBefore(final Instruction instruction) {
        return () -> new Iterator<Instruction>(){
            private InstructionIterator iterator;
            private Instruction next;
            {
                this.iterator = BasicBlock.this.iterator();
                this.next = this.advance();
            }

            private Instruction advance() {
                Instruction next;
                if (this.iterator.hasNext() && (next = (Instruction)this.iterator.next()) != instruction) {
                    return next;
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Instruction next() {
                Instruction result = this.next;
                if (result == null) {
                    throw new NoSuchElementException();
                }
                this.next = this.advance();
                return result;
            }
        };
    }

    public boolean isEmpty() {
        return this.instructions.isEmpty();
    }

    public int size() {
        return this.instructions.size();
    }

    public boolean isReturnBlock() {
        return this.exit().isReturn();
    }

    public Instruction entry() {
        return this.instructions.get(0);
    }

    public JumpInstruction exit() {
        assert (this.filled);
        assert (this.instructions.get(this.instructions.size() - 1).isJumpInstruction());
        return this.instructions.get(this.instructions.size() - 1).asJumpInstruction();
    }

    public Instruction exceptionalExit() {
        assert (this.hasCatchHandlers());
        InstructionIterator it = this.iterator(this.instructions.size());
        while (it.hasPrevious()) {
            Instruction instruction = it.previous();
            if (!instruction.instructionTypeCanThrow()) continue;
            return instruction;
        }
        return null;
    }

    public void clearUserInfo() {
        this.phis = null;
        this.instructions.forEach(Instruction::clearUserInfo);
    }

    public void buildDex(DexBuilder builder) {
        for (Instruction instruction : this.instructions) {
            instruction.buildDex(builder);
        }
    }

    public void mark(int color) {
        assert (color != 0);
        assert (!this.isMarked(color));
        this.color |= color;
        assert (this.isMarked(color));
    }

    public void clearMark(int color) {
        assert (color != 0);
        this.color &= ~color;
        assert (!this.isMarked(color));
    }

    public boolean isMarked(int color) {
        assert (color != 0);
        return (this.color & color) != 0;
    }

    public void incrementUnfilledPredecessorCount() {
        ++this.unfilledPredecessorsCount;
        ++this.estimatedPredecessorsCount;
    }

    public void decrementUnfilledPredecessorCount(int n) {
        this.unfilledPredecessorsCount -= n;
        this.estimatedPredecessorsCount -= n;
    }

    public void decrementUnfilledPredecessorCount() {
        --this.unfilledPredecessorsCount;
        --this.estimatedPredecessorsCount;
    }

    public boolean verifyFilledPredecessors() {
        assert (this.estimatedPredecessorsCount == this.predecessors.size());
        assert (this.unfilledPredecessorsCount == 0);
        return true;
    }

    public void addPhi(Phi phi) {
        this.phis.add(phi);
    }

    public void removePhi(Phi phi) {
        this.phis.remove(phi);
        assert (this.currentDefinitions == null || !this.currentDefinitions.containsValue(phi)) : "Attempt to remove Phi " + phi + " which is present in currentDefinitions";
    }

    public void add(Instruction next, IRCode code) {
        this.add(next, code.metadata());
    }

    public void add(Instruction next, IRMetadata metadata) {
        assert (!this.isFilled());
        this.instructions.add(next);
        metadata.record(next);
        next.setBlock(this);
    }

    public void close(IRBuilder builder) {
        assert (!this.isFilled());
        assert (!this.instructions.isEmpty());
        this.filled = true;
        boolean bl = this.sealed = this.unfilledPredecessorsCount == 0;
        assert (this.exit().isJumpInstruction());
        assert (this.verifyNoValuesAfterThrowingInstruction());
        for (BasicBlock successor : this.successors) {
            successor.filledPredecessor(builder);
        }
    }

    public void link(BasicBlock successor) {
        assert (!this.successors.contains(successor));
        assert (!successor.predecessors.contains(this));
        this.getMutableSuccessors().add(successor);
        successor.getMutablePredecessors().add(this);
    }

    public BasicBlock unlinkSinglePredecessor() {
        assert (this.predecessors.size() == 1);
        assert (this.predecessors.get((int)0).successors.size() == 1);
        BasicBlock unlinkedBlock = this.predecessors.get(0);
        unlinkedBlock.getMutableSuccessors().clear();
        this.getMutablePredecessors().clear();
        return unlinkedBlock;
    }

    public void unlinkSinglePredecessorSiblingsAllowed() {
        assert (this.predecessors.size() == 1);
        assert (this.predecessors.get((int)0).successors.contains(this));
        List<BasicBlock> predecessors = this.getMutablePredecessors();
        predecessors.get(0).getMutableSuccessors().remove(this);
        this.getMutablePredecessors().clear();
    }

    public BasicBlock unlinkSingleSuccessor() {
        assert (!this.hasCatchHandlers());
        assert (this.successors.size() == 1);
        assert (this.successors.get((int)0).predecessors.size() == 1);
        BasicBlock unlinkedBlock = this.successors.get(0);
        unlinkedBlock.getMutablePredecessors().clear();
        this.getMutableSuccessors().clear();
        return unlinkedBlock;
    }

    public void unlinkCatchHandler() {
        assert (this.predecessors.size() == 1);
        this.predecessors.get(0).removeSuccessor(this);
        this.getMutablePredecessors().clear();
    }

    public void unlinkCatchHandlerForGuard(DexType guard) {
        assert (this.predecessors.size() == 1);
        if (this.isCatchHandlerForSingleGuard()) {
            this.unlinkCatchHandler();
        } else {
            BasicBlock predecessor = this.predecessors.get(0);
            predecessor.removeCatchHandlerWithGuard(guard);
        }
    }

    public void detachAllSuccessors() {
        for (BasicBlock successor : this.successors) {
            successor.getMutablePredecessors().remove(this);
        }
        this.getMutableSuccessors().clear();
    }

    public List<BasicBlock> unlink(BasicBlock successor, DominatorTree dominator, Set<Value> affectedValues) {
        assert (affectedValues != null);
        assert (this.successors.contains(successor));
        assert (successor.predecessors.size() == 1);
        assert (successor.predecessors.get(0) == this);
        ArrayList<BasicBlock> removedBlocks = new ArrayList<BasicBlock>();
        for (BasicBlock dominated : dominator.dominatedBlocks(successor)) {
            affectedValues.addAll(dominated.cleanForRemoval());
            removedBlocks.add(dominated);
        }
        assert (BasicBlock.blocksClean(removedBlocks));
        return removedBlocks;
    }

    public Set<Value> cleanForRemoval() {
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        for (BasicBlock block : this.successors) {
            affectedValues.addAll(block.getPhis());
            block.removePredecessor(this, affectedValues);
        }
        this.getMutableSuccessors().clear();
        for (BasicBlock block : this.predecessors) {
            block.removeSuccessor(this);
        }
        this.getMutablePredecessors().clear();
        for (Phi phi : this.getPhis()) {
            affectedValues.addAll(phi.affectedValues());
            for (Value operand : phi.getOperands()) {
                operand.removePhiUser(phi);
            }
        }
        this.getPhis().clear();
        for (Instruction instruction : this.getInstructions()) {
            if (instruction.outValue() != null) {
                affectedValues.addAll(instruction.outValue().affectedValues());
                instruction.outValue().clearUsers();
                instruction.setOutValue(null);
            }
            for (Value value : instruction.inValues) {
                value.removeUser(instruction);
            }
            for (Value value : instruction.getDebugValues()) {
                value.removeDebugUser(instruction);
            }
        }
        return affectedValues;
    }

    public void linkCatchSuccessors(List<DexType> guards, List<BasicBlock> targets) {
        ArrayList<Integer> successorIndexes = new ArrayList<Integer>(targets.size());
        for (BasicBlock target : targets) {
            int index = this.successors.indexOf(target);
            if (index < 0) {
                index = this.successors.size();
                this.link(target);
            }
            successorIndexes.add(index);
        }
        this.catchHandlers = new CatchHandlers(guards, successorIndexes);
    }

    public void appendCatchHandler(BasicBlock target, DexType guard) {
        if (!this.canThrow()) {
            return;
        }
        if (this.hasCatchHandlers()) {
            if (this.catchHandlers.getGuards().contains(guard)) {
                return;
            }
            int targetIndex = this.successors.indexOf(target);
            if (targetIndex < 0) {
                List<BasicBlock> successors = this.getMutableSuccessors();
                int numberOfSuccessors = successors.size();
                int numberOfNormalSuccessors = this.numberOfNormalSuccessors();
                if (numberOfNormalSuccessors > 0) {
                    targetIndex = numberOfSuccessors - numberOfNormalSuccessors;
                    successors.add(targetIndex, target);
                } else {
                    targetIndex = successors.size();
                    successors.add(target);
                }
                target.getMutablePredecessors().add(this);
            }
            this.catchHandlers = this.catchHandlers.appendGuard(guard, targetIndex);
        } else {
            assert (this.instructions.stream().filter(Instruction::instructionTypeCanThrow).count() == 1L);
            this.getMutableSuccessors().add(0, target);
            target.getMutablePredecessors().add(this);
            this.catchHandlers = new CatchHandlers<Integer>(ImmutableList.of(guard), ImmutableList.of(Integer.valueOf(0)));
        }
    }

    public boolean renameGuardsInCatchHandlers(GraphLens.NonIdentityGraphLens graphLens, GraphLens codeLens) {
        assert (this.hasCatchHandlers());
        boolean anyGuardsRenamed = false;
        ArrayList<DexType> newGuards = new ArrayList<DexType>(this.catchHandlers.getGuards().size());
        for (DexType guard : this.catchHandlers.getGuards()) {
            DexType renamed = graphLens.lookupType(guard, codeLens);
            newGuards.add(renamed);
            anyGuardsRenamed |= renamed != guard;
        }
        if (anyGuardsRenamed) {
            this.catchHandlers = new CatchHandlers<Integer>(newGuards, this.catchHandlers.getAllTargets());
        }
        return anyGuardsRenamed;
    }

    public boolean consistentCatchHandlers() {
        if (this.hasCatchHandlers()) {
            assert (this.exit().isGoto() || this.exit().isThrow());
            CatchHandlers<Integer> catchHandlers = this.getCatchHandlersWithSuccessorIndexes();
            assert (catchHandlers.getGuards().size() == ImmutableSet.copyOf(catchHandlers.getGuards()).size());
            List<DexType> guards = catchHandlers.getGuards();
            int lastGuardIndex = guards.size() - 1;
            for (int i = 0; i < guards.size(); ++i) {
                assert (!guards.get(i).toDescriptorString().equals("Ljava/lang/Throwable;") || i == lastGuardIndex);
            }
            ArrayList<Integer> sortedHandlerIndices = new ArrayList<Integer>(catchHandlers.getAllTargets());
            sortedHandlerIndices.sort(Comparator.naturalOrder());
            int firstIndex = (Integer)sortedHandlerIndices.get(0);
            int lastIndex = (Integer)sortedHandlerIndices.get(sortedHandlerIndices.size() - 1);
            assert (firstIndex == 0);
            assert (lastIndex < sortedHandlerIndices.size());
            int lastSuccessorIndex = this.getSuccessors().size() - 1;
            assert (lastIndex == lastSuccessorIndex || lastIndex == lastSuccessorIndex - 1);
            assert (lastIndex == lastSuccessorIndex || !this.exit().isThrow());
        }
        return true;
    }

    public void clearCurrentDefinitions() {
        this.currentDefinitions = null;
        for (Phi phi : this.getPhis()) {
            phi.clearDefinitionsUsers();
        }
    }

    public Value readCurrentDefinition(int register, EdgeType readingEdge) {
        Value result = this.readOnThrowValue(register, readingEdge);
        if (result != null) {
            return result == Value.UNDEFINED ? null : result;
        }
        return this.currentDefinitions.get(register);
    }

    public void replaceCurrentDefinitions(Value oldValue, Value newValue) {
        assert (oldValue.definition.getBlock() == this);
        assert (!oldValue.isUsed());
        for (Map.Entry<Integer, Value> entry : this.currentDefinitions.entrySet()) {
            if (entry.getValue() != oldValue) continue;
            if (oldValue.isPhi()) {
                oldValue.asPhi().removeDefinitionsUser(this.currentDefinitions);
            }
            entry.setValue(newValue);
            if (!newValue.isPhi()) continue;
            newValue.asPhi().addDefinitionsUser(this.currentDefinitions);
        }
    }

    public void updateCurrentDefinition(int register, Value value, EdgeType readingEdge) {
        if (this.isOnThrowValue(register, readingEdge)) {
            register = BasicBlock.onThrowValueRegister(register);
        }
        Value previousValue = this.currentDefinitions.get(register);
        if (value.isPhi()) {
            value.asPhi().addDefinitionsUser(this.currentDefinitions);
        }
        assert (this.verifyOnThrowWrite(register));
        this.currentDefinitions.put(register, value);
        if (previousValue != null && previousValue.isPhi() && !this.currentDefinitions.values().contains(previousValue)) {
            previousValue.asPhi().removeDefinitionsUser(this.currentDefinitions);
        }
    }

    public void writeCurrentDefinition(int register, Value value, ThrowingInfo throwing) {
        if (throwing == ThrowingInfo.CAN_THROW) {
            Value previous = this.currentDefinitions.get(register);
            assert (this.verifyOnThrowWrite(register));
            this.currentDefinitions.put(BasicBlock.onThrowValueRegister(register), previous == null ? Value.UNDEFINED : previous);
        }
        this.updateCurrentDefinition(register, value, EdgeType.NON_EDGE);
    }

    public void filledPredecessor(IRBuilder builder) {
        assert (this.unfilledPredecessorsCount > 0);
        if (--this.unfilledPredecessorsCount == 0) {
            assert (this.estimatedPredecessorsCount == this.predecessors.size());
            for (Map.Entry<Integer, Phi> entry : this.incompletePhis.entrySet()) {
                int register = entry.getKey();
                if (register < 0) {
                    register = BasicBlock.onThrowValueRegister(register);
                }
                entry.getValue().addOperands(builder, register);
            }
            this.sealed = true;
            this.incompletePhis.clear();
        }
    }

    public EdgeType getEdgeType(BasicBlock successor) {
        assert (this.successors.indexOf(successor) >= 0);
        return this.hasCatchSuccessor(successor) ? EdgeType.EXCEPTIONAL : EdgeType.NORMAL;
    }

    public boolean hasCatchSuccessor(BasicBlock block) {
        if (!this.hasCatchHandlers()) {
            return false;
        }
        return this.catchHandlers.getUniqueTargets().contains(this.successors.indexOf(block));
    }

    public int guardsForCatchSuccessor(BasicBlock block) {
        assert (this.hasCatchSuccessor(block));
        int index = this.successors.indexOf(block);
        int count = 0;
        for (int handler : this.catchHandlers.getAllTargets()) {
            if (handler != index) continue;
            ++count;
        }
        assert (count > 0);
        return count;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public void addIncompletePhi(int register, Phi phi, EdgeType readingEdge) {
        if (this.isOnThrowValue(register, readingEdge)) {
            register = BasicBlock.onThrowValueRegister(register);
        }
        assert (!this.incompletePhis.containsKey(register));
        this.incompletePhis.put(register, phi);
    }

    public boolean hasIncompletePhis() {
        return !this.incompletePhis.isEmpty();
    }

    public Collection<Integer> getIncompletePhiRegisters() {
        return this.incompletePhis.keySet();
    }

    public String toString() {
        return this.toDetailedString();
    }

    public String toSimpleString() {
        return this.number < 0 ? super.toString() : "block " + this.number;
    }

    public String toDetailedString() {
        StringBuilder builder = new StringBuilder();
        builder.append("block ");
        builder.append(this.number);
        builder.append(", pred-counts: " + this.predecessors.size());
        if (this.unfilledPredecessorsCount > 0) {
            builder.append(" (" + this.unfilledPredecessorsCount + " unfilled)");
        }
        builder.append(", succ-count: " + this.successors.size());
        builder.append(", filled: " + this.isFilled());
        builder.append(", sealed: " + this.isSealed());
        builder.append('\n');
        builder.append("predecessors: ");
        BasicBlock.appendBasicBlockList(builder, this.predecessors, b -> "");
        builder.append('\n');
        builder.append("successors: ");
        BasicBlock.appendBasicBlockList(builder, this.successors, this::predecessorPostfix);
        if (this.successors.size() > 0) {
            builder.append(" (");
            if (this.hasCatchHandlers()) {
                builder.append(this.catchHandlers.size());
            } else {
                builder.append("no");
            }
            builder.append(" try/catch successors)");
        }
        builder.append('\n');
        if (this.phis != null && this.phis.size() > 0) {
            for (Phi phi : this.phis) {
                builder.append(phi.printPhi());
                if (this.incompletePhis.values().contains(phi)) {
                    builder.append(" (incomplete)");
                }
                builder.append('\n');
            }
        } else {
            builder.append("no phis\n");
        }
        if (this.localsAtEntry != null) {
            builder.append("locals: ");
            StringUtils.append(builder, this.localsAtEntry.int2ReferenceEntrySet(), ", ", StringUtils.BraceType.NONE);
            builder.append('\n');
        }
        int lineColumn = 0;
        int numberColumn = 0;
        for (Instruction instruction : this.instructions) {
            lineColumn = Math.max(lineColumn, instruction.getPositionAsString().length());
            numberColumn = Math.max(numberColumn, BasicBlock.digits(instruction.getNumber()));
        }
        String currentPosition = null;
        for (Instruction instruction : this.instructions) {
            if (lineColumn > 0) {
                String line = "";
                if (!instruction.getPositionAsString().equals(currentPosition)) {
                    line = currentPosition = instruction.getPositionAsString();
                }
                StringUtils.appendLeftPadded(builder, line, lineColumn + 1);
                builder.append(": ");
            }
            StringUtils.appendLeftPadded(builder, "" + instruction.getNumber(), numberColumn + 1);
            builder.append(": ");
            builder.append(instruction.toString());
            if (DebugLocalInfo.PRINT_LEVEL != DebugLocalInfo.PrintLevel.NONE && !instruction.getDebugValues().isEmpty()) {
                builder.append(" [end: ");
                StringUtils.append(builder, instruction.getDebugValues(), ", ", StringUtils.BraceType.NONE);
                builder.append("]");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public void print(CfgPrinter printer) {
        printer.begin("block");
        printer.print("name \"B").append(this.number).append("\"\n");
        printer.print("from_bci -1\n");
        printer.print("to_bci -1\n");
        printer.print("predecessors");
        BasicBlock.printBlockList(printer, this.predecessors);
        printer.ln();
        printer.print("successors");
        BasicBlock.printBlockList(printer, this.successors);
        printer.ln();
        printer.print("xhandlers\n");
        printer.print("flags\n");
        printer.print("first_lir_id ").print(this.instructions.get(0).getNumber()).ln();
        printer.print("last_lir_id ").print(this.instructions.get(this.instructions.size() - 1).getNumber()).ln();
        printer.begin("HIR");
        if (this.phis != null) {
            for (Phi phi : this.phis) {
                phi.print(printer);
                printer.append(" <|@\n");
            }
        }
        for (Instruction instruction : this.instructions) {
            instruction.print(printer);
            printer.append(" <|@\n");
        }
        printer.end("HIR");
        printer.begin("LIR");
        for (Instruction instruction : this.instructions) {
            instruction.printLIR(printer);
            printer.append(" <|@\n");
        }
        printer.end("LIR");
        printer.end("block");
    }

    public void addPhiMove(Move move) {
        JumpInstruction branch = this.exit();
        this.instructions.set(this.instructions.size() - 1, move);
        this.instructions.add(branch);
    }

    public void setInstructions(LinkedList<Instruction> instructions) {
        this.instructions = instructions;
    }

    public void removeInstructions(List<Integer> toRemove) {
        if (!toRemove.isEmpty()) {
            LinkedList<Instruction> newInstructions = new LinkedList<Instruction>();
            int nextIndex = 0;
            for (Integer index : toRemove) {
                assert (index >= nextIndex);
                newInstructions.addAll(this.instructions.subList(nextIndex, index));
                this.instructions.get(index).clearBlock();
                nextIndex = index + 1;
            }
            if (nextIndex < this.instructions.size()) {
                newInstructions.addAll(this.instructions.subList(nextIndex, this.instructions.size()));
            }
            assert (this.instructions.size() == newInstructions.size() + toRemove.size());
            this.setInstructions(newInstructions);
        }
    }

    public void removeInstruction(Instruction toRemove) {
        int index = this.instructions.indexOf(toRemove);
        assert (index >= 0);
        this.removeInstructions(Collections.singletonList(index));
    }

    public boolean isInstructionBeforeThrowingInstruction(Instruction instruction) {
        assert (instruction.getBlock() == this);
        for (Instruction candidate : this.getInstructions()) {
            if (candidate == instruction) {
                return true;
            }
            if (!candidate.instructionTypeCanThrow()) continue;
            return false;
        }
        throw new Unreachable();
    }

    public boolean isTrivialGoto() {
        return this.instructions.size() == 1 && this.exit().isGoto();
    }

    public BasicBlock startOfGotoChain() {
        BasicBlock hare = this;
        BasicBlock tortuous = this;
        boolean advance = false;
        while (hare.isTrivialGoto() && hare.hasUniquePredecessor()) {
            hare = hare.getUniquePredecessor();
            tortuous = advance ? tortuous.getUniquePredecessor() : tortuous;
            boolean bl = advance = !advance;
            if (hare != tortuous) continue;
            return null;
        }
        return hare;
    }

    public BasicBlock endOfGotoChain() {
        BasicBlock hare = this;
        BasicBlock tortuous = this;
        boolean advance = false;
        while (hare.isTrivialGoto()) {
            hare = hare.exit().asGoto().getTarget();
            tortuous = advance ? tortuous.exit().asGoto().getTarget() : tortuous;
            boolean bl = advance = !advance;
            if (hare != tortuous) continue;
            return null;
        }
        return hare;
    }

    public boolean isSimpleAlwaysThrowingPath() {
        BasicBlock hare = this;
        BasicBlock tortuous = this;
        boolean advance = false;
        do {
            List<BasicBlock> normalSuccessors;
            if ((normalSuccessors = hare.getNormalSuccessors()).size() > 1) {
                return false;
            }
            if (normalSuccessors.size() == 0) {
                return hare.exit().isThrow();
            }
            hare = normalSuccessors.get(0);
            tortuous = advance ? tortuous.getNormalSuccessors().get(0) : tortuous;
            boolean bl = advance = !advance;
        } while (hare != tortuous);
        return false;
    }

    public Position getPosition() {
        return this.entry().getPosition();
    }

    public boolean hasOneNormalExit() {
        return this.successors.size() == 1 && this.exit().isGoto();
    }

    public CatchHandlers<BasicBlock> getCatchHandlers() {
        if (!this.hasCatchHandlers()) {
            return CatchHandlers.EMPTY_BASIC_BLOCK;
        }
        List<BasicBlock> targets = ListUtils.map(this.catchHandlers.getAllTargets(), this.successors::get);
        return new CatchHandlers<BasicBlock>(this.catchHandlers.getGuards(), targets);
    }

    public CatchHandlers<Integer> getCatchHandlersWithSuccessorIndexes() {
        return this.catchHandlers;
    }

    public void clearCatchHandlers() {
        this.catchHandlers = CatchHandlers.EMPTY_INDICES;
    }

    public void transferCatchHandlers(BasicBlock other) {
        this.catchHandlers = other.catchHandlers;
        other.catchHandlers = CatchHandlers.EMPTY_INDICES;
    }

    public int numberOfCatchHandlers() {
        return this.catchHandlers.size();
    }

    public int numberOfThrowingInstructions() {
        int count = 0;
        for (Instruction instruction : this.getInstructions()) {
            if (!instruction.instructionTypeCanThrow()) continue;
            ++count;
        }
        return count;
    }

    public boolean canThrow() {
        for (Instruction instruction : this.instructions) {
            if (!instruction.instructionTypeCanThrow()) continue;
            return true;
        }
        return false;
    }

    public InstructionIterator iterator() {
        return new BasicBlockInstructionIterator(this);
    }

    public InstructionIterator iterator(int index) {
        return new BasicBlockInstructionIterator(this, index);
    }

    public InstructionIterator iterator(Instruction instruction) {
        return new BasicBlockInstructionIterator(this, instruction);
    }

    public InstructionListIterator listIterator(IRCode code) {
        return this.listIterator(code.metadata());
    }

    public InstructionListIterator listIterator(IRMetadata metadata) {
        return new BasicBlockInstructionListIterator(metadata, this);
    }

    public InstructionListIterator listIterator(IRCode code, int index) {
        return new BasicBlockInstructionListIterator(code.metadata(), this, index);
    }

    public InstructionListIterator listIterator(IRCode code, Instruction instruction) {
        return new BasicBlockInstructionListIterator(code.metadata(), this, instruction);
    }

    BasicBlock createSplitBlock(int blockNumber, boolean keepCatchHandlers) {
        boolean hadCatchHandlers = this.hasCatchHandlers();
        BasicBlock newBlock = new BasicBlock();
        newBlock.setNumber(blockNumber);
        newBlock.getMutableSuccessors().addAll(this.successors);
        for (BasicBlock successor : newBlock.getSuccessors()) {
            successor.replacePredecessor(this, newBlock);
        }
        this.getMutableSuccessors().clear();
        newBlock.catchHandlers = this.catchHandlers;
        this.catchHandlers = CatchHandlers.EMPTY_INDICES;
        if (keepCatchHandlers && hadCatchHandlers) {
            this.moveCatchHandlers(newBlock);
        }
        this.link(newBlock);
        newBlock.filled = true;
        newBlock.sealed = true;
        return newBlock;
    }

    public void moveCatchHandlers(BasicBlock fromBlock) {
        List<BasicBlock> catchSuccessors = this.appendCatchHandlers(fromBlock);
        for (BasicBlock successor : catchSuccessors) {
            fromBlock.getMutableSuccessors().remove(successor);
            successor.removePredecessor(fromBlock, null);
        }
        fromBlock.catchHandlers = CatchHandlers.EMPTY_INDICES;
    }

    public void copyCatchHandlers(IRCode code, ListIterator<BasicBlock> blockIterator, BasicBlock fromBlock, InternalOptions options) {
        if (this.catchHandlers != null && this.catchHandlers.hasCatchAll(options.itemFactory)) {
            return;
        }
        List<BasicBlock> catchSuccessors = this.appendCatchHandlers(fromBlock);
        for (BasicBlock catchSuccessor : catchSuccessors) {
            catchSuccessor.splitCriticalExceptionEdges(code, blockIterator, options);
        }
    }

    public void splitCriticalExceptionEdges(IRCode code, ListIterator<BasicBlock> blockIterator, InternalOptions options) {
        List<BasicBlock> predecessors = this.getMutablePredecessors();
        boolean hasMoveException = this.entry().isMoveException();
        TypeElement exceptionTypeLattice = null;
        DexType exceptionType = null;
        MoveException move = null;
        Position position = this.entry().getPosition();
        if (hasMoveException) {
            move = this.entry().asMoveException();
            exceptionTypeLattice = move.getOutType();
            exceptionType = move.getExceptionType();
            assert (move.getDebugValues().isEmpty());
            this.getInstructions().remove(0);
        }
        ArrayList<BasicBlock> newPredecessors = new ArrayList<BasicBlock>(predecessors.size());
        ArrayList<Value> values2 = new ArrayList<Value>(predecessors.size());
        for (BasicBlock predecessor : predecessors) {
            if (!predecessor.hasCatchSuccessor(this)) {
                throw new CompilationError("Invalid block structure: catch block reachable via non-exceptional flow.");
            }
            BasicBlock newBlock = new BasicBlock();
            newBlock.setNumber(code.getNextBlockNumber());
            newPredecessors.add(newBlock);
            if (hasMoveException) {
                Value value = new Value(code.valueNumberGenerator.next(), exceptionTypeLattice, move.getLocalInfo());
                values2.add(value);
                MoveException newMove = new MoveException(value, exceptionType, options);
                newBlock.add((Instruction)newMove, code);
                newMove.setPosition(position);
            }
            Goto next = new Goto();
            next.setPosition(position);
            newBlock.add((Instruction)next, code);
            newBlock.close(null);
            newBlock.getMutableSuccessors().add(this);
            newBlock.getMutablePredecessors().add(predecessor);
            predecessor.replaceSuccessor(this, newBlock);
            blockIterator.add(newBlock);
            assert (newBlock.getNumber() >= 0) : "Number must be assigned by `onNewBlock`";
        }
        predecessors.clear();
        predecessors.addAll(newPredecessors);
        if (hasMoveException) {
            Phi phi = new Phi(code.valueNumberGenerator.next(), this, exceptionTypeLattice, move.getLocalInfo(), Phi.RegisterReadType.NORMAL);
            phi.addOperands(values2);
            move.outValue().replaceUsers(phi);
        }
    }

    public boolean hasPathTo(BasicBlock target) {
        Set<BasicBlock> visitedBlocks = Sets.newIdentityHashSet();
        ArrayDeque<BasicBlock> blocks = new ArrayDeque<BasicBlock>();
        blocks.push(this);
        while (!blocks.isEmpty()) {
            BasicBlock block = (BasicBlock)blocks.pop();
            if (block == target) {
                return true;
            }
            visitedBlocks.add(block);
            for (BasicBlock blockToVisit : block.getSuccessors()) {
                if (visitedBlocks.contains(blockToVisit)) continue;
                blocks.push(blockToVisit);
            }
        }
        return false;
    }

    public void deduplicatePhis() {
        PhiEquivalence equivalence = new PhiEquivalence();
        HashMap<Equivalence.Wrapper<Phi>, Phi> wrapper2phi = new HashMap<Equivalence.Wrapper<Phi>, Phi>();
        Iterator<Phi> phiIt = this.phis.iterator();
        while (phiIt.hasNext()) {
            Phi phi = phiIt.next();
            Equivalence.Wrapper<Phi> key = equivalence.wrap(phi);
            Phi replacement = (Phi)wrapper2phi.get(key);
            if (replacement == null) {
                wrapper2phi.put(key, phi);
                continue;
            }
            if (phi.getLocalInfo() != replacement.getLocalInfo()) {
                if (replacement.getLocalInfo() == null) {
                    replacement.setLocalInfo(phi.getLocalInfo());
                } else if (phi.getLocalInfo() != null) {
                    assert (phi.hasLocalInfo() && replacement.hasLocalInfo());
                    continue;
                }
            }
            phi.replaceUsers(replacement);
            for (Value operand : phi.getOperands()) {
                operand.removePhiUser(phi);
            }
            phiIt.remove();
        }
    }

    private static class PhiEquivalence
    extends Equivalence<Phi> {
        private PhiEquivalence() {
        }

        @Override
        protected boolean doEquivalent(Phi a, Phi b) {
            assert (a.getBlock() == b.getBlock());
            for (int i = 0; i < a.getOperands().size(); ++i) {
                if (a.getOperand(i) == b.getOperand(i)) continue;
                return false;
            }
            return true;
        }

        @Override
        protected int doHash(Phi phi) {
            int hash = 0;
            for (Value value : phi.getOperands()) {
                hash = hash * 13 + value.hashCode();
            }
            return hash;
        }
    }

    public static class Pair
    implements Comparable<Pair> {
        public BasicBlock first;
        public BasicBlock second;

        public Pair(BasicBlock first, BasicBlock second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.first != o.first) {
                return this.first.getNumber() - o.first.getNumber();
            }
            if (this.second != o.second) {
                return this.second.getNumber() - o.second.getNumber();
            }
            return 0;
        }

        public String toString() {
            return "Edge: " + this.first.getNumber() + " -> " + this.second.getNumber();
        }
    }

    public static enum EdgeType {
        NON_EDGE,
        NORMAL,
        EXCEPTIONAL;

    }

    public static enum ThrowingInfo {
        NO_THROW,
        CAN_THROW;

    }

    public static interface BasicBlockChangeListener {
        public void onSuccessorsMayChange(BasicBlock var1);

        public void onPredecessorsMayChange(BasicBlock var1);
    }
}

