/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.DebugLocalRead;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.IRMetadata;
import com.android.tools.r8.ir.code.InitClass;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.SafeCheckCast;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.Throw;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.NestUtils;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.IteratorUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Consumer;

public class BasicBlockInstructionListIterator
implements InstructionListIterator {
    protected final BasicBlock block;
    protected final ListIterator<Instruction> listIterator;
    protected Instruction current;
    protected Position position = null;
    private final IRMetadata metadata;

    BasicBlockInstructionListIterator(IRMetadata metadata, BasicBlock block) {
        this.block = block;
        this.listIterator = block.getInstructions().listIterator();
        this.metadata = metadata;
    }

    BasicBlockInstructionListIterator(IRMetadata metadata, BasicBlock block, int index) {
        this.block = block;
        this.listIterator = block.getInstructions().listIterator(index);
        this.metadata = metadata;
    }

    BasicBlockInstructionListIterator(IRMetadata metadata, BasicBlock block, Instruction instruction) {
        this(metadata, block);
        this.nextUntil(x -> x == instruction);
    }

    private boolean canThrow(IRCode code) {
        InstructionIterator iterator2 = code.instructionIterator();
        while (iterator2.hasNext()) {
            boolean throwing = ((Instruction)iterator2.next()).instructionTypeCanThrow();
            if (!throwing) continue;
            return true;
        }
        return false;
    }

    private void splitBlockAndCopyCatchHandlers(AppView<?> appView, IRCode code, BasicBlock invokeBlock, BasicBlock inlinedBlock, ListIterator<BasicBlock> blocksIterator) {
        InstructionListIterator instructionsIterator = inlinedBlock.listIterator(code);
        BasicBlock currentBlock = inlinedBlock;
        while (currentBlock != null && instructionsIterator.hasNext()) {
            assert (!currentBlock.hasCatchHandlers());
            Instruction throwingInstruction = (Instruction)instructionsIterator.nextUntil(Instruction::instructionTypeCanThrow);
            if (throwingInstruction != null) {
                BasicBlock b;
                BasicBlock nextBlock;
                if (instructionsIterator.hasNext()) {
                    nextBlock = instructionsIterator.split(code, blocksIterator);
                    assert (nextBlock.getPredecessors().size() == 1);
                    assert (currentBlock == nextBlock.getPredecessors().get(0));
                    b = blocksIterator.previous();
                    assert (b == nextBlock);
                } else {
                    nextBlock = null;
                }
                currentBlock.copyCatchHandlers(code, blocksIterator, invokeBlock, appView.options());
                if (nextBlock != null) {
                    b = blocksIterator.next();
                    assert (b == nextBlock);
                    instructionsIterator = nextBlock.listIterator(code);
                } else {
                    instructionsIterator = null;
                }
                currentBlock = nextBlock;
                continue;
            }
            assert (!instructionsIterator.hasNext());
            instructionsIterator = null;
            currentBlock = null;
        }
    }

    private void appendCatchHandlers(AppView<?> appView, IRCode code, BasicBlock invokeBlock, IRCode inlinee, ListIterator<BasicBlock> blocksIterator) {
        for (int i = 0; i < inlinee.blocks.size(); ++i) {
            blocksIterator.previous();
        }
        assert (IteratorUtils.peekNext(blocksIterator) == inlinee.entryBlock());
        for (BasicBlock inlinedBlock : inlinee.blocks) {
            BasicBlock expected = blocksIterator.next();
            assert (inlinedBlock == expected);
            if (inlinedBlock.hasCatchHandlers()) {
                inlinedBlock.copyCatchHandlers(code, blocksIterator, invokeBlock, appView.options());
                continue;
            }
            this.splitBlockAndCopyCatchHandlers(appView, code, invokeBlock, inlinedBlock, blocksIterator);
        }
    }

    private static void removeArgumentInstruction(InstructionListIterator iterator2, Value expectedArgument) {
        assert (iterator2.hasNext());
        Instruction instruction = (Instruction)iterator2.next();
        assert (instruction.isArgument());
        assert (!instruction.outValue().isUsed());
        assert (instruction.outValue() == expectedArgument);
        iterator2.remove();
    }

    private InstructionListIterator ensureSingleReturnInstruction(AppView<?> appView, IRCode code, List<BasicBlock> normalExits) {
        Return newReturn;
        if (normalExits.size() == 1) {
            InstructionListIterator it = normalExits.get(0).listIterator(code);
            it.nextUntil(Instruction::isReturn);
            it.previous();
            return it;
        }
        BasicBlock newExitBlock = new BasicBlock();
        newExitBlock.setNumber(code.getNextBlockNumber());
        if (normalExits.get(0).exit().asReturn().isReturnVoid()) {
            newReturn = new Return();
        } else {
            Value value;
            boolean same = true;
            ArrayList<Value> operands = new ArrayList<Value>(normalExits.size());
            for (BasicBlock exitBlock : normalExits) {
                Return exit = exitBlock.exit().asReturn();
                Value retValue = exit.returnValue();
                operands.add(retValue);
                same = same && retValue == operands.get(0);
            }
            if (same) {
                value = (Value)operands.get(0);
            } else {
                Phi phi = new Phi(code.valueNumberGenerator.next(), newExitBlock, TypeElement.getBottom(), null, Phi.RegisterReadType.NORMAL);
                phi.addOperands(operands);
                new TypeAnalysis(appView).widening(ImmutableSet.of(phi));
                value = phi;
            }
            newReturn = new Return(value);
        }
        newReturn.setPosition(Position.none());
        newExitBlock.add((Instruction)newReturn, this.metadata);
        for (BasicBlock exitBlock : normalExits) {
            InstructionListIterator it = exitBlock.listIterator(code, exitBlock.getInstructions().size());
            Instruction oldExit = (Instruction)it.previous();
            assert (oldExit.isReturn());
            it.replaceCurrentInstruction(new Goto());
            exitBlock.link(newExitBlock);
        }
        newExitBlock.close(null);
        code.blocks.add(newExitBlock);
        return newExitBlock.listIterator(code);
    }

    @Override
    public boolean hasNext() {
        return this.listIterator.hasNext();
    }

    @Override
    public Instruction next() {
        this.current = this.listIterator.next();
        return this.current;
    }

    @Override
    public int nextIndex() {
        return this.listIterator.nextIndex();
    }

    @Override
    public boolean hasPrevious() {
        return this.listIterator.hasPrevious();
    }

    @Override
    public Instruction previous() {
        this.current = this.listIterator.previous();
        return this.current;
    }

    @Override
    public int previousIndex() {
        return this.listIterator.previousIndex();
    }

    @Override
    public boolean hasInsertionPosition() {
        return this.position != null;
    }

    @Override
    public void setInsertionPosition(Position position) {
        this.position = position;
    }

    @Override
    public void unsetInsertionPosition() {
        this.position = null;
    }

    @Override
    public void add(Instruction instruction) {
        instruction.setBlock(this.block);
        assert (instruction.getBlock() == this.block);
        if (this.position != null && !instruction.hasPosition()) {
            instruction.setPosition(this.position);
        }
        this.listIterator.add(instruction);
        this.metadata.record(instruction);
    }

    @Override
    public void addThrowingInstructionToPossiblyThrowingBlock(IRCode code, ListIterator<BasicBlock> blockIterator, Instruction instruction, InternalOptions options) {
        if (this.block.hasCatchHandlers()) {
            BasicBlock splitBlock = this.split(code, blockIterator, false);
            splitBlock.listIterator(code).add(instruction);
            assert (!this.block.hasCatchHandlers());
            assert (splitBlock.hasCatchHandlers());
            this.block.copyCatchHandlers(code, blockIterator, splitBlock, options);
            while (IteratorUtils.peekPrevious(blockIterator) != splitBlock) {
                blockIterator.previous();
            }
        } else {
            this.add(instruction);
        }
    }

    @Override
    public void set(Instruction instruction) {
        instruction.setBlock(this.block);
        assert (instruction.getBlock() == this.block);
        this.listIterator.set(instruction);
        this.metadata.record(instruction);
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        assert (this.current.outValue() == null || !this.current.outValue().isUsed());
        assert (this.current.getDebugValues().isEmpty());
        for (int i = 0; i < this.current.inValues().size(); ++i) {
            Value value = this.current.inValues().get(i);
            value.removeUser(this.current);
        }
        for (Value value : this.current.getDebugValues()) {
            value.removeDebugUser(this.current);
        }
        if (this.current.getLocalInfo() != null) {
            for (Instruction user : this.current.outValue().debugUsers()) {
                user.removeDebugValue(this.current.outValue());
            }
        }
        this.listIterator.remove();
        this.current = null;
    }

    @Override
    public void removeInstructionIgnoreOutValue() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.listIterator.remove();
        this.current = null;
    }

    @Override
    public void removeOrReplaceByDebugLocalRead() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        if (this.current.getDebugValues().isEmpty()) {
            this.remove();
        } else {
            this.replaceCurrentInstruction(new DebugLocalRead());
        }
    }

    @Override
    public void replaceCurrentInstruction(Instruction newInstruction, Set<Value> affectedValues) {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        for (Value value : this.current.inValues()) {
            value.removeUser(this.current);
        }
        if (this.current.hasUsedOutValue()) {
            assert (newInstruction.outValue() != null);
            if (affectedValues != null && newInstruction.getOutType() != this.current.getOutType()) {
                this.current.outValue().addAffectedValuesTo(affectedValues);
            }
            this.current.outValue().replaceUsers(newInstruction.outValue());
        }
        this.current.moveDebugValues(newInstruction);
        newInstruction.setBlock(this.block);
        if (!newInstruction.hasPosition()) {
            newInstruction.setPosition(this.current.getPosition());
        }
        this.listIterator.remove();
        this.listIterator.add(newInstruction);
        this.current.clearBlock();
        this.metadata.record(newInstruction);
        this.current = newInstruction;
    }

    @Override
    public Value insertConstNumberInstruction(IRCode code, InternalOptions options, long value, TypeElement type) {
        ConstNumber constNumberInstruction = code.createNumberConstant(value, type);
        if (!this.hasInsertionPosition()) {
            Position position = options.debug ? (this.current != null ? this.current.getPosition() : this.block.getPosition()) : Position.none();
            constNumberInstruction.setPosition(position);
        }
        this.add(constNumberInstruction);
        return constNumberInstruction.outValue();
    }

    @Override
    public Value insertConstStringInstruction(AppView<?> appView, IRCode code, DexString value) {
        ConstString constStringInstruction = code.createStringConstant(appView, value);
        constStringInstruction.setPosition(appView.options().debug ? this.current.getPosition() : Position.none());
        this.add(constStringInstruction);
        return constStringInstruction.outValue();
    }

    @Override
    public InvokeMethod insertNullCheckInstruction(AppView<?> appView, IRCode code, BasicBlockIterator blockIterator, Value value, Position position) {
        InternalOptions options = appView.options();
        DexMethod getClassMethod = appView.dexItemFactory().objectMembers.getClass;
        InvokeVirtual invoke = ((InvokeVirtual.Builder)((InvokeVirtual.Builder)((InvokeVirtual.Builder)InvokeVirtual.builder().setMethod(getClassMethod)).setSingleArgument(value)).setPosition(position)).build();
        this.add(invoke);
        if (this.block.hasCatchHandlers()) {
            this.splitCopyCatchHandlers(code, blockIterator, options);
        }
        return invoke;
    }

    @Override
    public boolean replaceCurrentInstructionByNullCheckIfPossible(AppView<?> appView, ProgramMethod context) {
        Value receiver;
        Instruction toBeReplaced = this.current;
        assert (toBeReplaced != null);
        assert (toBeReplaced.isInstanceFieldInstruction() || toBeReplaced.isInvokeMethodWithReceiver());
        if (toBeReplaced.hasUsedOutValue()) {
            return false;
        }
        if (toBeReplaced.isInvokeDirect()) {
            DexItemFactory dexItemFactory = appView.dexItemFactory();
            DexMethod invokedMethod = toBeReplaced.asInvokeDirect().getInvokedMethod();
            if (invokedMethod.isInstanceInitializer(dexItemFactory) || invokedMethod.mustBeInlinedIntoInstanceInitializer(appView)) {
                return false;
            }
        }
        if (toBeReplaced.instructionMayHaveSideEffects(appView, context, Instruction.SideEffectAssumption.RECEIVER_NOT_NULL)) {
            return false;
        }
        Value value = receiver = toBeReplaced.isInstanceFieldInstruction() ? toBeReplaced.asInstanceFieldInstruction().object() : toBeReplaced.asInvokeMethodWithReceiver().getReceiver();
        if (receiver.isNeverNull()) {
            this.removeOrReplaceByDebugLocalRead();
            return true;
        }
        DexMethod getClassMethod = appView.dexItemFactory().objectMembers.getClass;
        this.replaceCurrentInstruction(new InvokeVirtual(getClassMethod, null, ImmutableList.of(receiver)));
        return true;
    }

    @Override
    public boolean removeOrReplaceCurrentInstructionByInitClassIfPossible(AppView<AppInfoWithLiveness> appView, IRCode code, DexType type, Consumer<InitClass> consumer) {
        Instruction toBeReplaced = this.current;
        assert (toBeReplaced != null);
        assert (toBeReplaced.isStaticFieldInstruction() || toBeReplaced.isInvokeStatic());
        if (toBeReplaced.hasUsedOutValue()) {
            return false;
        }
        ProgramMethod context = code.context();
        if (!toBeReplaced.instructionMayHaveSideEffects(appView, context)) {
            this.removeOrReplaceByDebugLocalRead();
            return true;
        }
        if (toBeReplaced.instructionMayHaveSideEffects(appView, context, Instruction.SideEffectAssumption.CLASS_ALREADY_INITIALIZED)) {
            return false;
        }
        if (!type.classInitializationMayHaveSideEffectsInContext(appView, context)) {
            this.removeOrReplaceByDebugLocalRead();
            return true;
        }
        if (!appView.canUseInitClass()) {
            return false;
        }
        DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(appView.definitionFor(type));
        if (clazz != null) {
            Value dest = code.createValue(TypeElement.getInt());
            InitClass initClass = new InitClass(dest, clazz.type);
            this.replaceCurrentInstruction(initClass);
            consumer.accept(initClass);
        }
        return true;
    }

    @Override
    public void replaceCurrentInstructionWithConstClass(AppView<?> appView, IRCode code, DexType type, DebugLocalInfo localInfo) {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        ClassTypeElement typeElement = TypeElement.classClassType(appView, Nullability.definitelyNotNull());
        Value value = code.createValue(typeElement, localInfo);
        ConstClass constClass = new ConstClass(value, type);
        this.replaceCurrentInstruction(constClass);
    }

    @Override
    public void replaceCurrentInstructionWithConstInt(IRCode code, int value) {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        assert (!this.current.hasOutValue() || this.current.getOutType().isInt());
        ConstNumber constNumber = code.createIntConstant(value, this.current.getLocalInfo());
        this.replaceCurrentInstruction(constNumber);
    }

    @Override
    public void replaceCurrentInstructionWithConstString(AppView<?> appView, IRCode code, DexString value) {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        ConstString constString = code.createStringConstant(appView, value, this.current.getLocalInfo());
        this.replaceCurrentInstruction(constString);
    }

    @Override
    public void replaceCurrentInstructionWithStaticGet(AppView<?> appView, IRCode code, DexField field, Set<Value> affectedValues) {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        TypeElement newType = TypeElement.fromDexType(field.type, Nullability.maybeNull(), appView);
        TypeElement oldType = this.current.getOutType();
        Value value = code.createValue(newType, this.current.getLocalInfo());
        StaticGet staticGet = new StaticGet(value, field);
        this.replaceCurrentInstruction(staticGet);
        if (value.hasAnyUsers() && !newType.equals(oldType)) {
            affectedValues.addAll(value.affectedValues());
        }
    }

    @Override
    public void replaceCurrentInstructionWithThrow(AppView<?> appView, IRCode code, ListIterator<BasicBlock> blockIterator, Value exceptionValue, Set<BasicBlock> blocksToRemove, Set<Value> affectedValues) {
        InstructionListIterator throwBlockInstructionIterator;
        BasicBlock throwBlock;
        if (this.current == null) {
            throw new IllegalStateException();
        }
        Instruction toBeReplaced = this.current;
        InternalOptions options = appView.options();
        BasicBlock block = toBeReplaced.getBlock();
        assert (!blocksToRemove.contains(block));
        assert (affectedValues != null);
        this.previous();
        if (block.hasCatchHandlers() && !toBeReplaced.instructionTypeCanThrow()) {
            throwBlock = this.splitCopyCatchHandlers(code, blockIterator, options);
            throwBlock.listIterator(code).split(code, blockIterator, true);
        } else {
            this.splitCopyCatchHandlers(code, blockIterator, options);
            throwBlock = block;
        }
        blocksToRemove.addAll(throwBlock.unlink(throwBlock.getUniqueNormalSuccessor(), new DominatorTree(code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS), affectedValues));
        if (throwBlock == block) {
            throwBlockInstructionIterator = this;
            this.previous();
            this.next();
        } else {
            throwBlockInstructionIterator = throwBlock.listIterator(code, 1);
        }
        assert (!throwBlockInstructionIterator.hasNext());
        Throw throwInstruction = new Throw(exceptionValue);
        if (this.hasInsertionPosition()) {
            throwInstruction.setPosition(this.position);
        } else if (toBeReplaced.getPosition().isSome()) {
            throwInstruction.setPosition(toBeReplaced.getPosition());
        } else {
            assert (!toBeReplaced.instructionTypeCanThrow());
            throwInstruction.setPosition(Position.syntheticNone());
        }
        throwBlockInstructionIterator.replaceCurrentInstruction(throwInstruction);
    }

    @Override
    public void replaceCurrentInstructionWithThrowNull(AppView<? extends AppInfoWithClassHierarchy> appView, IRCode code, ListIterator<BasicBlock> blockIterator, Set<BasicBlock> blocksToRemove, Set<Value> affectedValues) {
        InstructionListIterator throwBlockInstructionIterator;
        BasicBlock throwBlock;
        if (this.current == null) {
            throw new IllegalStateException();
        }
        Instruction toBeReplaced = this.current;
        BasicBlock block = toBeReplaced.getBlock();
        assert (!blocksToRemove.contains(block));
        assert (affectedValues != null);
        this.previous();
        if (block.hasCatchHandlers() && !toBeReplaced.instructionTypeCanThrow()) {
            throwBlock = this.split(code, blockIterator, true);
            throwBlock.listIterator(code).split(code, blockIterator);
        } else {
            this.split(code, blockIterator, true);
            throwBlock = block;
        }
        assert (!this.hasNext());
        this.previous();
        blocksToRemove.addAll(throwBlock.unlink(throwBlock.getUniqueNormalSuccessor(), new DominatorTree(code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS), affectedValues));
        if (throwBlock == block) {
            throwBlockInstructionIterator = this;
        } else {
            throwBlockInstructionIterator = throwBlock.listIterator(code);
            throwBlockInstructionIterator.setInsertionPosition(this.position);
        }
        Value nullValue = throwBlockInstructionIterator.insertConstNullInstruction(code, appView.options());
        throwBlockInstructionIterator.next();
        assert (!throwBlockInstructionIterator.hasNext());
        Throw throwInstruction = new Throw(nullValue);
        if (this.hasInsertionPosition()) {
            throwInstruction.setPosition(this.position);
        } else if (toBeReplaced.getPosition().isSome()) {
            throwInstruction.setPosition(toBeReplaced.getPosition());
        } else {
            assert (!toBeReplaced.instructionTypeCanThrow());
            throwInstruction.setPosition(Position.syntheticNone());
        }
        throwBlockInstructionIterator.replaceCurrentInstruction(throwInstruction);
        if (block.hasCatchHandlers()) {
            if (block == throwBlock) {
                CatchHandlers<BasicBlock> catchHandlers = block.getCatchHandlers();
                catchHandlers.forEach((guard, target) -> {
                    if (blocksToRemove.contains(target)) {
                        return;
                    }
                    if (!((AppInfoWithClassHierarchy)appView.appInfo()).isSubtype(appView.dexItemFactory().npeType, (DexType)guard)) {
                        DominatorTree dominatorTree = new DominatorTree(code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS);
                        blocksToRemove.addAll(block.unlink((BasicBlock)target, dominatorTree, affectedValues));
                    }
                });
            } else {
                throwBlock.copyCatchHandlers(code, blockIterator, block, appView.options());
            }
        }
    }

    @Override
    public BasicBlock split(IRCode code, ListIterator<BasicBlock> blocksIterator, boolean keepCatchHandlers) {
        LinkedList<BasicBlock> blocks = code.blocks;
        assert (blocksIterator == null || IteratorUtils.peekPrevious(blocksIterator) == this.block);
        assert (this.hasNext());
        Position position = this.current != null ? this.current.getPosition() : this.block.getPosition();
        BasicBlock newBlock = this.block.createSplitBlock(code.getNextBlockNumber(), keepCatchHandlers);
        Goto newGoto = new Goto(this.block);
        this.listIterator.add(newGoto);
        newGoto.setPosition(position);
        while (this.listIterator.hasNext()) {
            Instruction instruction = this.listIterator.next();
            newBlock.getInstructions().addLast(instruction);
            instruction.setBlock(newBlock);
            this.listIterator.remove();
        }
        if (blocksIterator == null) {
            blocks.add(blocks.indexOf(this.block) + 1, newBlock);
        } else {
            blocksIterator.add(newBlock);
            blocksIterator.previous();
            blocksIterator.next();
        }
        return newBlock;
    }

    @Override
    public BasicBlock split(IRCode code, int instructions, ListIterator<BasicBlock> blocksIterator) {
        BasicBlock newBlock = this.split(code, blocksIterator);
        assert (blocksIterator == null || IteratorUtils.peekPrevious(blocksIterator) == newBlock);
        InstructionListIterator iterator2 = newBlock.listIterator(code);
        for (int i = 0; i < instructions; ++i) {
            iterator2.next();
        }
        iterator2.split(code, blocksIterator);
        return newBlock;
    }

    @Override
    public BasicBlock splitCopyCatchHandlers(IRCode code, ListIterator<BasicBlock> blockIterator, InternalOptions options) {
        BasicBlock splitBlock = this.split(code, blockIterator, false);
        assert (!this.block.hasCatchHandlers());
        if (splitBlock.hasCatchHandlers()) {
            this.block.copyCatchHandlers(code, blockIterator, splitBlock, options);
        }
        return splitBlock;
    }

    @Override
    public BasicBlock inlineInvoke(AppView<?> appView, IRCode code, IRCode inlinee, ListIterator<BasicBlock> blocksIterator, Set<BasicBlock> blocksToRemove, DexProgramClass downcast) {
        Set<Value> affectedValues;
        InstructionListIterator entryBlockIterator;
        assert (blocksToRemove != null);
        ProgramMethod callerContext = code.context();
        ProgramMethod calleeContext = inlinee.context();
        if (callerContext.getHolder() != calleeContext.getHolder() && ((DexEncodedMethod)calleeContext.getDefinition()).isOnlyInlinedIntoNestMembers()) {
            assert (NestUtils.sameNest(callerContext.getHolderType(), calleeContext.getHolderType(), appView));
            NestUtils.rewriteNestCallsForInlining(inlinee, callerContext, appView);
        }
        boolean inlineeCanThrow = this.canThrow(inlinee);
        BasicBlock invokeBlock = this.split(code, 1, blocksIterator);
        assert (invokeBlock.getInstructions().size() == 2);
        assert (invokeBlock.getInstructions().getFirst().isInvoke());
        Invoke invoke = invokeBlock.getInstructions().getFirst().asInvoke();
        BasicBlock invokePredecessor = invokeBlock.getPredecessors().get(0);
        BasicBlock invokeSuccessor = invokeBlock.getSuccessors().get(0);
        if (!inlinee.doAllThrowingInstructionsHavePositions()) {
            code.setAllThrowingInstructionsHavePositions(false);
        }
        Set<Value> argumentUsers = Sets.newIdentityHashSet();
        List<Value> arguments = inlinee.collectArguments();
        assert (invoke.inValues().size() == arguments.size());
        BasicBlock entryBlock = inlinee.entryBlock();
        int i = 0;
        assert (downcast == null || arguments.get(0).isThis());
        if (downcast != null && arguments.get(0).isUsed()) {
            Value receiver = invoke.inValues().get(0);
            TypeElement castTypeLattice = TypeElement.fromDexType(downcast.getType(), receiver.getType().nullability(), appView);
            SafeCheckCast castInstruction = new SafeCheckCast(code.createValue(castTypeLattice), receiver, downcast.getType());
            castInstruction.setPosition(invoke.getPosition());
            if (entryBlock.canThrow()) {
                BasicBlock inlineEntry = entryBlock;
                entryBlock = entryBlock.listIterator(code).split(inlinee);
                entryBlockIterator = entryBlock.listIterator(code);
                inlineEntry.listIterator(code).add(castInstruction);
                castInstruction.setBlock(inlineEntry);
                assert (castInstruction.getBlock().getInstructions().size() == 2);
            } else {
                castInstruction.setBlock(entryBlock);
                entryBlockIterator = entryBlock.listIterator(code);
                entryBlockIterator.add(castInstruction);
            }
            Value argument = arguments.get(i);
            argumentUsers.addAll(argument.affectedValues());
            argument.replaceUsers(castInstruction.outValue);
            BasicBlockInstructionListIterator.removeArgumentInstruction(entryBlockIterator, argument);
            ++i;
        } else {
            entryBlockIterator = entryBlock.listIterator(code);
        }
        while (i < invoke.inValues().size()) {
            assert (!arguments.get(i).hasLocalInfo());
            Value argument = arguments.get(i);
            argumentUsers.addAll(argument.affectedValues());
            argument.replaceUsers(invoke.inValues().get(i));
            BasicBlockInstructionListIterator.removeArgumentInstruction(entryBlockIterator, argument);
            ++i;
        }
        assert (entryBlock.getInstructions().stream().noneMatch(Instruction::isArgument));
        new TypeAnalysis(appView).narrowing(argumentUsers);
        BasicBlock inlineEntry = inlinee.entryBlock();
        BasicBlock inlineExit = null;
        List<BasicBlock> normalExits = inlinee.computeNormalExitBlocks();
        if (!normalExits.isEmpty()) {
            Iterator<Instruction> inlineeIterator = this.ensureSingleReturnInstruction(appView, inlinee, normalExits);
            assert (inlineeIterator.peekNext().isReturn());
            if (invoke.outValue() != null) {
                affectedValues = invoke.outValue().affectedValues();
                Return returnInstruction = inlineeIterator.peekNext().asReturn();
                invoke.outValue().replaceUsers(returnInstruction.returnValue());
                new TypeAnalysis(appView).narrowing(Iterables.concat(ImmutableList.of(returnInstruction.returnValue()), affectedValues));
            }
            BasicBlock returnBlock = inlineeIterator.split(inlinee);
            inlineExit = returnBlock.unlinkSinglePredecessor();
            InstructionListIterator returnBlockIterator = returnBlock.listIterator(code);
            returnBlockIterator.next();
            returnBlockIterator.remove();
            assert (!returnBlockIterator.hasNext());
            inlinee.blocks.remove(returnBlock);
            invokeBlock.unlinkSinglePredecessor();
            InstructionListIterator invokeBlockIterator = invokeBlock.listIterator(code);
            invokeBlockIterator.next();
            invokeBlockIterator.remove();
            invokeSuccessor = invokeBlock;
            assert (invokeBlock.getInstructions().getFirst().isGoto());
        }
        invokePredecessor.link(inlineEntry);
        if (inlineExit != null) {
            inlineExit.link(invokeSuccessor);
        }
        if (blocksIterator == null) {
            blocksIterator = code.listIterator(code.blocks.indexOf(invokeBlock));
        } else {
            blocksIterator.previous();
            blocksIterator.previous();
        }
        assert (IteratorUtils.peekNext(blocksIterator) == invokeBlock);
        for (BasicBlock bb : inlinee.blocks) {
            bb.setNumber(code.getNextBlockNumber());
            blocksIterator.add(bb);
        }
        if (invokeBlock.hasCatchHandlers()) {
            this.appendCatchHandlers(appView, code, invokeBlock, inlinee, blocksIterator);
        }
        if (normalExits.isEmpty()) {
            assert (inlineeCanThrow);
            DominatorTree dominatorTree = new DominatorTree(code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS);
            affectedValues = Sets.newIdentityHashSet();
            blocksToRemove.addAll(invokePredecessor.unlink(invokeBlock, dominatorTree, affectedValues));
            new TypeAnalysis(appView).narrowing(affectedValues);
        }
        blocksIterator.next();
        assert (IteratorUtils.peekPrevious(blocksIterator) == invokeBlock);
        BasicBlock finalInvokeSuccessor = invokeSuccessor;
        assert (invokeSuccessor == invokeBlock || IteratorUtils.anyRemainingMatch(blocksIterator, remaining -> remaining == finalInvokeSuccessor));
        code.metadata().merge(inlinee.metadata());
        return invokeSuccessor;
    }
}

