/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;

public class CatchHandlers<T>
implements Iterable<CatchHandler<T>> {
    public static final CatchHandlers<Integer> EMPTY_INDICES = new CatchHandlers();
    public static final CatchHandlers<BasicBlock> EMPTY_BASIC_BLOCK = new CatchHandlers();
    private final List<DexType> guards;
    private final List<T> targets;
    private Set<T> uniqueTargets;

    private CatchHandlers() {
        this.guards = ImmutableList.of();
        this.targets = ImmutableList.of();
    }

    public CatchHandlers(List<DexType> guards, List<T> targets) {
        assert (!guards.isEmpty());
        assert (guards.size() == targets.size());
        this.guards = ImmutableList.copyOf(guards);
        this.targets = ImmutableList.copyOf(targets);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        assert (this.guards.size() == this.targets.size());
        return this.guards.size();
    }

    public List<DexType> getGuards() {
        return this.guards;
    }

    public List<T> getAllTargets() {
        return this.targets;
    }

    public Set<T> getUniqueTargets() {
        if (this.uniqueTargets == null) {
            this.uniqueTargets = ImmutableSet.copyOf(this.targets);
        }
        return this.uniqueTargets;
    }

    public boolean hasCatchAll(DexItemFactory factory) {
        return this.getGuards().size() > 0 && this.getGuards().get(this.getGuards().size() - 1) == factory.throwableType;
    }

    public CatchHandlers<T> appendGuard(DexType guard, T target) {
        assert (!this.guards.contains(guard));
        ImmutableCollection newGuards = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.guards)).add(guard)).build();
        ImmutableCollection newTargets = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.targets)).add(target)).build();
        return new CatchHandlers<T>((List<DexType>)((Object)newGuards), newTargets);
    }

    public CatchHandlers<T> removeGuard(DexType guardToBeRemoved) {
        ArrayList<DexType> newGuards = new ArrayList<DexType>();
        ArrayList newTargets = new ArrayList();
        this.forEach((DexType guard, T target) -> {
            if (guard != guardToBeRemoved) {
                newGuards.add((DexType)guard);
                newTargets.add(target);
            }
        });
        return new CatchHandlers(newGuards, newTargets);
    }

    public void forEach(BiConsumer<DexType, T> consumer) {
        for (int i = 0; i < this.size(); ++i) {
            consumer.accept(this.guards.get(i), (DexType)this.targets.get(i));
        }
    }

    @Override
    public Iterator<CatchHandler<T>> iterator() {
        return new Iterator<CatchHandler<T>>(){
            private int nextIndex = 0;

            @Override
            public boolean hasNext() {
                return this.nextIndex < CatchHandlers.this.size();
            }

            @Override
            public CatchHandler<T> next() {
                DexType guard = (DexType)CatchHandlers.this.guards.get(this.nextIndex);
                Object target = CatchHandlers.this.targets.get(this.nextIndex);
                ++this.nextIndex;
                return new CatchHandler(guard, target);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CatchHandlers)) {
            return false;
        }
        CatchHandlers that = (CatchHandlers)o;
        return this.guards.equals(that.guards) && this.targets.equals(that.targets);
    }

    public int hashCode() {
        return 31 * this.guards.hashCode() + this.targets.hashCode();
    }

    public static class CatchHandler<T> {
        public final DexType guard;
        public final T target;

        public CatchHandler(DexType guard, T target) {
            this.guard = guard;
            this.target = target;
        }

        public T getTarget() {
            return this.target;
        }
    }
}

