/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfConstClass;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.graph.AccessControl;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.UnknownValue;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;

public class ConstClass
extends ConstInstruction {
    private final DexType clazz;
    private final boolean ignoreCompatRules;

    public ConstClass(Value dest, DexType clazz) {
        this(dest, clazz, false);
    }

    public ConstClass(Value dest, DexType clazz, boolean ignoreCompatRules) {
        super(dest);
        this.clazz = clazz;
        this.ignoreCompatRules = ignoreCompatRules;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ConstClass copyOf(IRCode code, ConstClass original) {
        Value newValue = new Value(code.valueNumberGenerator.next(), original.getOutType(), original.getLocalInfo());
        return ConstClass.copyOf(newValue, original);
    }

    public static ConstClass copyOf(Value newValue, ConstClass original) {
        assert (newValue != original.outValue());
        return new ConstClass(newValue, original.getValue());
    }

    public DexType getType() {
        return this.clazz;
    }

    @Override
    public int opcode() {
        return 12;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Value dest() {
        return this.outValue;
    }

    public DexType getValue() {
        return this.clazz;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new com.android.tools.r8.code.ConstClass(dest, this.clazz, this.ignoreCompatRules()));
    }

    @Override
    public boolean ignoreCompatRules() {
        return this.ignoreCompatRules;
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "ConstClass has no register arguments.";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public String toString() {
        return super.toString() + this.clazz.toSourceString();
    }

    @Override
    public boolean instructionTypeCanBeCanonicalized() {
        return true;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean instructionInstanceCanThrow() {
        return true;
    }

    @Override
    public boolean instructionInstanceCanThrow(AppView<?> appView, ProgramMethod context) {
        DexType baseType = this.getValue().toBaseType(appView.dexItemFactory());
        if (baseType.isPrimitiveType()) {
            return false;
        }
        if (!appView.enableWholeProgramOptimizations()) {
            return baseType != context.getHolderType();
        }
        assert (((AppInfo)appView.appInfo()).hasClassHierarchy());
        AppView<AppInfoWithClassHierarchy> appViewWithClassHierarchy = appView.withClassHierarchy();
        DexClass clazz = appView.definitionFor(baseType);
        if (clazz == null || !clazz.isResolvable(appView)) {
            return true;
        }
        return AccessControl.isClassAccessible(clazz, context, appViewWithClassHierarchy).isPossiblyFalse();
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, ProgramMethod context, Instruction.SideEffectAssumption assumption) {
        return this.instructionInstanceCanThrow(appView, context);
    }

    @Override
    public boolean isOutConstant() {
        return true;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isConstClass() && other.asConstClass().clazz == this.clazz;
    }

    @Override
    public boolean isConstClass() {
        return true;
    }

    @Override
    public ConstClass asConstClass() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forConstClass(this.clazz, context);
    }

    @Override
    public TypeElement evaluate(AppView<?> appView) {
        return TypeElement.classClassType(appView, Nullability.definitelyNotNull());
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return appView.dexItemFactory().classType;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add((CfInstruction)new CfConstClass(this.clazz), this);
    }

    @Override
    public AbstractValue getAbstractValue(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod context) {
        if (!this.instructionMayHaveSideEffects(appView, context)) {
            return appView.abstractValueFactory().createSingleConstClassValue(this.clazz);
        }
        return UnknownValue.getInstance();
    }

    public static class Builder
    extends Instruction.BuilderBase<Builder, ConstClass> {
        private DexType type;

        public Builder setType(DexType type) {
            this.type = type;
            return this;
        }

        @Override
        public ConstClass build() {
            return this.amend(new ConstClass(this.outValue, this.type));
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

