/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfConstMethodType;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;

public class ConstMethodType
extends ConstInstruction {
    private final DexProto methodType;

    public ConstMethodType(Value dest, DexProto methodType) {
        super(dest);
        this.methodType = methodType;
    }

    public static ConstMethodType copyOf(IRCode code, ConstMethodType original) {
        Value newValue = new Value(code.valueNumberGenerator.next(), original.getOutType(), original.getLocalInfo());
        return ConstMethodType.copyOf(newValue, original);
    }

    public static ConstMethodType copyOf(Value newValue, ConstMethodType original) {
        return new ConstMethodType(newValue, original.getValue());
    }

    @Override
    public int opcode() {
        return 14;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Value dest() {
        return this.outValue;
    }

    public DexProto getValue() {
        return this.methodType;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new com.android.tools.r8.code.ConstMethodType(dest, this.methodType));
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add((CfInstruction)new CfConstMethodType(this.methodType), this);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isConstMethodType() && other.asConstMethodType().methodType == this.methodType;
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "ConstMethodType has no register arguments.";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public String toString() {
        return super.toString() + " \"" + this.methodType + "\"";
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isOutConstant() {
        return true;
    }

    @Override
    public boolean isConstMethodType() {
        return true;
    }

    @Override
    public ConstMethodType asConstMethodType() {
        return this;
    }

    @Override
    public TypeElement evaluate(AppView<?> appView) {
        return TypeElement.fromDexType(appView.dexItemFactory().methodTypeType, Nullability.definitelyNotNull(), appView);
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return appView.dexItemFactory().methodTypeType;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forConstMethodType();
    }
}

