/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfConstString;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.VerifyTypesHelper;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.UnknownValue;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.DeadCodeRemover;
import java.io.UTFDataFormatException;

public class ConstString
extends ConstInstruction {
    private final DexString value;

    public ConstString(Value dest, DexString value) {
        super(dest);
        this.value = value;
    }

    public static ConstString copyOf(IRCode code, ConstString original) {
        Value newValue = new Value(code.valueNumberGenerator.next(), original.getOutType(), original.getLocalInfo());
        return ConstString.copyOf(newValue, original);
    }

    public static ConstString copyOf(Value newValue, ConstString original) {
        assert (newValue != original.outValue());
        return new ConstString(newValue, original.getValue());
    }

    @Override
    public int opcode() {
        return 16;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Value dest() {
        return this.outValue;
    }

    public DexString getValue() {
        return this.value;
    }

    @Override
    public boolean instructionTypeCanBeCanonicalized() {
        return true;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new com.android.tools.r8.code.ConstString(dest, this.value));
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isConstString() && other.asConstString().value == this.value;
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "ConstString has no register arguments.";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public String toString() {
        return super.toString() + " \"" + this.value + "\"";
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isOutConstant() {
        return true;
    }

    @Override
    public boolean isConstString() {
        return true;
    }

    @Override
    public ConstString asConstString() {
        return this;
    }

    @Override
    public boolean instructionInstanceCanThrow() {
        try {
            this.value.toString();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof UTFDataFormatException) {
                return true;
            }
            throw e;
        }
        return false;
    }

    @Override
    public DeadCodeRemover.DeadInstructionResult canBeDeadCode(AppView<?> appView, IRCode code) {
        if (appView.options().isGeneratingClassFiles() || !this.instructionInstanceCanThrow()) {
            return DeadCodeRemover.DeadInstructionResult.deadIfOutValueIsDead();
        }
        return DeadCodeRemover.DeadInstructionResult.notDead();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add((CfInstruction)new CfConstString(this.value), this);
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return appView.dexItemFactory().stringType;
    }

    @Override
    public TypeElement evaluate(AppView<?> appView) {
        return TypeElement.stringClassType(appView, Nullability.definitelyNotNull());
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, ProgramMethod context) {
        return false;
    }

    @Override
    public AbstractValue getAbstractValue(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod context) {
        if (!this.instructionInstanceCanThrow()) {
            return appView.abstractValueFactory().createSingleStringValue(this.value);
        }
        return UnknownValue.getInstance();
    }

    @Override
    public boolean verifyTypes(AppView<?> appView, VerifyTypesHelper verifyTypesHelper) {
        assert (super.verifyTypes(appView, verifyTypesHelper));
        ClassTypeElement expectedType = TypeElement.stringClassType(appView, Nullability.definitelyNotNull());
        assert (this.getOutType().equals(expectedType));
        return true;
    }
}

