/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfDexItemBasedConstString;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.DeadCodeRemover;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.naming.dexitembasedstring.NameComputationInfo;

public class DexItemBasedConstString
extends ConstInstruction {
    private final DexReference item;
    private final NameComputationInfo<?> nameComputationInfo;

    public DexItemBasedConstString(Value dest, DexReference item, NameComputationInfo<?> nameComputationInfo) {
        super(dest);
        this.item = item;
        this.nameComputationInfo = nameComputationInfo;
    }

    public static DexItemBasedConstString copyOf(IRCode code, DexItemBasedConstString original) {
        Value newValue = new Value(code.valueNumberGenerator.next(), original.getOutType(), original.getLocalInfo());
        return DexItemBasedConstString.copyOf(newValue, original);
    }

    public static DexItemBasedConstString copyOf(Value newValue, DexItemBasedConstString original) {
        assert (newValue != original.outValue());
        return new DexItemBasedConstString(newValue, original.getItem(), original.nameComputationInfo);
    }

    @Override
    public int opcode() {
        return 20;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public DexReference getItem() {
        return this.item;
    }

    public NameComputationInfo<?> getNameComputationInfo() {
        return this.nameComputationInfo;
    }

    @Override
    public boolean instructionTypeCanBeCanonicalized() {
        return true;
    }

    @Override
    public boolean isDexItemBasedConstString() {
        return true;
    }

    @Override
    public DexItemBasedConstString asDexItemBasedConstString() {
        return this;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.outValue(), this.getNumber());
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new com.android.tools.r8.code.DexItemBasedConstString(dest, this.item, this.nameComputationInfo));
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isDexItemBasedConstString() && other.asDexItemBasedConstString().item == this.item && other.asDexItemBasedConstString().nameComputationInfo.equals(this.nameComputationInfo);
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "DexItemBasedConstString has no register arguments.";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public String toString() {
        return super.toString() + " \"" + this.item.toSourceString() + "\"";
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isOutConstant() {
        return true;
    }

    @Override
    public boolean instructionInstanceCanThrow() {
        return false;
    }

    @Override
    public DeadCodeRemover.DeadInstructionResult canBeDeadCode(AppView<?> appView, IRCode code) {
        return DeadCodeRemover.DeadInstructionResult.deadIfOutValueIsDead();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add((CfInstruction)new CfDexItemBasedConstString(this.item, this.nameComputationInfo), this);
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return appView.dexItemFactory().stringType;
    }

    @Override
    public TypeElement evaluate(AppView<?> appView) {
        return TypeElement.stringClassType(appView, Nullability.definitelyNotNull());
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forDexItemBasedConstString(this.item, context);
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, ProgramMethod context) {
        return false;
    }

    @Override
    public AbstractValue getAbstractValue(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod context) {
        return appView.abstractValueFactory().createSingleDexItemBasedStringValue(this.item, this.nameComputationInfo);
    }
}

