/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import java.util.function.Predicate;

public class FixedRegisterValue
extends Value {
    private final int register;

    public FixedRegisterValue(TypeElement moveType, int register) {
        super(-1, moveType, null);
        this.setNeedsRegister(true);
        this.register = register;
    }

    @Override
    public ValueType outType() {
        TypeElement type = this.getType();
        if (type.isPrimitiveType()) {
            if (type.isSinglePrimitive()) {
                if (type.isInt()) {
                    return ValueType.INT;
                }
                if (type.isFloat()) {
                    return ValueType.FLOAT;
                }
            } else {
                assert (type.isWidePrimitive());
                if (type.isDouble()) {
                    return ValueType.DOUBLE;
                }
                if (type.isLong()) {
                    return ValueType.LONG;
                }
            }
        } else {
            assert (type.isReferenceType());
            return ValueType.OBJECT;
        }
        throw new Unreachable("Unexpected imprecise type: " + type);
    }

    public int getRegister() {
        return this.register;
    }

    @Override
    public boolean isDefinedByInstructionSatisfying(Predicate<Instruction> predicate) {
        return false;
    }

    @Override
    public boolean isFixedRegisterValue() {
        return true;
    }

    @Override
    public FixedRegisterValue asFixedRegisterValue() {
        return this;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public String toString() {
        return "r" + this.register;
    }
}

