/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.classmerging.MergedClassesCollection;
import com.android.tools.r8.ir.analysis.TypeChecker;
import com.android.tools.r8.ir.analysis.VerifyTypesHelper;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCodeInstructionIterator;
import com.android.tools.r8.ir.code.IRCodeInstructionListIterator;
import com.android.tools.r8.ir.code.IRMetadata;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.ImpreciseMemberTypeInstruction;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.MoveException;
import com.android.tools.r8.ir.code.NumberGenerator;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.StackValue;
import com.android.tools.r8.ir.code.StackValues;
import com.android.tools.r8.ir.code.Switch;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueFactory;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.MethodConversionOptions;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.BooleanUtils;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.DequeUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.IteratorUtils;
import com.android.tools.r8.utils.LinkedHashSetUtils;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.WorkList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IRCode
implements ValueFactory {
    private static final int MAX_MARKING_COLOR = 0x40000000;
    public static final int INSTRUCTION_NUMBER_DELTA = 2;
    private final ProgramMethod method;
    private final MethodConversionOptions.MutableMethodConversionOptions conversionOptions;
    public LinkedList<BasicBlock> blocks;
    public final NumberGenerator valueNumberGenerator;
    public final NumberGenerator basicBlockNumberGenerator;
    private int usedMarkingColors = 0;
    private boolean numbered = false;
    private int nextInstructionNumber = 0;
    private boolean allThrowingInstructionsHavePositions;
    private final IRMetadata metadata;
    private final InternalOptions options;
    public final Origin origin;

    public IRCode(InternalOptions options, ProgramMethod method, LinkedList<BasicBlock> blocks, NumberGenerator valueNumberGenerator, NumberGenerator basicBlockNumberGenerator, IRMetadata metadata, Origin origin, MethodConversionOptions.MutableMethodConversionOptions conversionOptions) {
        assert (metadata != null);
        assert (options != null);
        assert (blocks.size() == basicBlockNumberGenerator.peek());
        this.options = options;
        this.conversionOptions = conversionOptions;
        this.method = method;
        this.blocks = blocks;
        this.valueNumberGenerator = valueNumberGenerator;
        this.basicBlockNumberGenerator = basicBlockNumberGenerator;
        this.metadata = metadata;
        this.origin = origin;
        this.allThrowingInstructionsHavePositions = this.computeAllThrowingInstructionsHavePositions();
    }

    private void ensureBlockNumbering() {
        if (!this.numbered) {
            this.numbered = true;
            int blockNumber = 0;
            for (BasicBlock block : this.topologicallySortedBlocks()) {
                block.setNumber(blockNumber++);
            }
        }
    }

    private ImmutableList<BasicBlock> depthFirstSorting() {
        ArrayList<BasicBlock> reverseOrdered = new ArrayList<BasicBlock>(this.blocks.size());
        HashSet<BasicBlock> visitedBlocks = new HashSet<BasicBlock>(this.blocks.size());
        ArrayDeque<Object> worklist = new ArrayDeque<Object>(this.blocks.size());
        worklist.addLast(this.entryBlock());
        while (!worklist.isEmpty()) {
            Object item = worklist.removeLast();
            if (item instanceof BlockMarker) {
                reverseOrdered.add(((BlockMarker)item).block);
                continue;
            }
            BasicBlock block = (BasicBlock)item;
            if (visitedBlocks.contains(block)) continue;
            visitedBlocks.add(block);
            worklist.addLast(new BlockMarker(block));
            for (int i = block.getSuccessors().size() - 1; i >= 0; --i) {
                worklist.addLast(block.getSuccessors().get(i));
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = reverseOrdered.size() - 1; i >= 0; --i) {
            builder.add((BasicBlock)reverseOrdered.get(i));
        }
        return builder.build();
    }

    private static ImmutableList<BasicBlock> reorderExceptionalBlocksLastForTesting(ImmutableList<BasicBlock> blocks) {
        ImmutableList.Builder reordered = ImmutableList.builder();
        for (BasicBlock block : blocks) {
            if (block.entry().isMoveException()) continue;
            reordered.add(block);
        }
        for (BasicBlock block : blocks) {
            if (!block.entry().isMoveException()) continue;
            reordered.add(block);
        }
        return reordered.build();
    }

    private boolean validAssumeInstructions(AppView<?> appView) {
        for (BasicBlock block : this.blocks) {
            for (Instruction instruction : block.getInstructions()) {
                if (instruction.isAssume()) assert (instruction.asAssume().verifyInstructionIsNeeded(appView));
            }
        }
        return true;
    }

    private boolean noCriticalEdges() {
        for (BasicBlock block : this.blocks) {
            List<BasicBlock> predecessors = block.getPredecessors();
            if (predecessors.size() <= 1) continue;
            if (block.entry() instanceof MoveException) {
                assert (false);
                return false;
            }
            for (int predIndex = 0; predIndex < predecessors.size(); ++predIndex) {
                if (predecessors.get(predIndex).hasOneNormalExit()) continue;
                assert (false);
                return false;
            }
        }
        return true;
    }

    private boolean consistentDefUseChains() {
        Set<Value> values2 = Sets.newIdentityHashSet();
        for (BasicBlock block : this.blocks) {
            int predecessorCount = block.getPredecessors().size();
            for (Phi phi : block.getPhis()) {
                assert (!phi.isTrivialPhi());
                assert (phi.getOperands().size() == predecessorCount);
                values2.add(phi);
                for (Value value : phi.getOperands()) {
                    values2.add(value);
                    assert (value.uniquePhiUsers().contains(phi));
                    assert (!phi.hasLocalInfo() || phi.getLocalInfo() == value.getLocalInfo());
                    assert (value.isPhi() || value.definition.hasBlock());
                }
            }
            for (Instruction instruction : block.getInstructions()) {
                assert (instruction.getBlock() == block);
                Value outValue = instruction.outValue();
                if (outValue != null) {
                    values2.add(outValue);
                    assert (outValue.definition == instruction);
                }
                for (Value value : instruction.inValues()) {
                    values2.add(value);
                    assert (value.uniqueUsers().contains(instruction));
                }
                for (Value value : instruction.getDebugValues()) {
                    values2.add(value);
                    assert (value.debugUsers().contains(instruction));
                }
            }
        }
        for (Value value : values2) {
            assert (this.verifyValue(value));
            assert (this.consistentValueUses(value));
        }
        return true;
    }

    private boolean verifyValue(Value value) {
        assert (!value.isPhi() ? this.verifyDefinition(value) : this.verifyPhi(value.asPhi()));
        return true;
    }

    private boolean verifyPhi(Phi phi) {
        assert (phi.getBlock().getPhis().contains(phi));
        return true;
    }

    private boolean verifyDefinition(Value value) {
        Value outValue = value.definition.outValue();
        assert (outValue == value || value instanceof StackValue && Arrays.asList(((StackValues)outValue).getStackValues()).contains(value));
        return true;
    }

    private boolean consistentValueUses(Value value) {
        for (Instruction user : value.uniqueUsers()) {
            assert (user.inValues().contains(value));
        }
        for (Phi phiUser : value.uniquePhiUsers()) {
            assert (phiUser.getOperands().contains(value));
            assert (phiUser.getBlock().getPhis().contains(phiUser));
        }
        if (value.hasLocalInfo()) {
            for (Instruction debugUser : value.debugUsers()) {
                assert (debugUser.getDebugValues().contains(value));
            }
        }
        return true;
    }

    private boolean consistentPredecessorSuccessors() {
        Set<BasicBlock> blockSet = SetUtils.newIdentityHashSet(this.blocks);
        IdentityHashMap<BasicBlock, Collection> predecessorCollections = new IdentityHashMap<BasicBlock, Collection>(this.blocks.size());
        IdentityHashMap<BasicBlock, Collection> successorCollections = new IdentityHashMap<BasicBlock, Collection>(this.blocks.size());
        Function<Collection, Collection> optimizeForMembershipQueries = collection -> collection.size() > 5 ? SetUtils.newIdentityHashSet(collection) : collection;
        for (BasicBlock block : this.blocks) {
            Collection predecessors = predecessorCollections.computeIfAbsent(block, key -> (Collection)optimizeForMembershipQueries.apply(key.getPredecessors()));
            Collection successors = successorCollections.computeIfAbsent(block, key -> (Collection)optimizeForMembershipQueries.apply(key.getSuccessors()));
            assert (predecessors.size() == block.getPredecessors().size());
            assert (successors.size() == block.getSuccessors().size());
            assert (blockSet.containsAll(predecessors));
            assert (blockSet.containsAll(successors));
            for (BasicBlock succ : successors) {
                Collection succPredecessors = predecessorCollections.computeIfAbsent(succ, key -> (Collection)optimizeForMembershipQueries.apply(key.getPredecessors()));
                assert (succPredecessors.contains(block));
            }
            for (BasicBlock pred : predecessors) {
                Collection predSuccessors = successorCollections.computeIfAbsent(pred, key -> (Collection)optimizeForMembershipQueries.apply(key.getSuccessors()));
                assert (predSuccessors.contains(block));
            }
        }
        return true;
    }

    private boolean consistentCatchHandlers() {
        for (BasicBlock block : this.blocks) {
            assert (block.consistentCatchHandlers());
        }
        return true;
    }

    private boolean consistentBlockInstructions(AppView<?> appView, boolean ssa) {
        boolean argumentsAllowed = true;
        for (BasicBlock block : this.blocks) {
            assert (block.consistentBlockInstructions(argumentsAllowed, this.options.debug || this.context().getOrComputeReachabilitySensitive(appView), ssa));
            argumentsAllowed = false;
        }
        return true;
    }

    private boolean consistentMetadata() {
        for (Instruction instruction : this.instructions()) {
            if (instruction.isAdd()) {
                assert (this.metadata.mayHaveAdd() && this.metadata.mayHaveArithmeticOrLogicalBinop()) : "IR metadata should indicate that code has an add";
                continue;
            }
            if (instruction.isAnd()) {
                assert (this.metadata.mayHaveAnd() && this.metadata.mayHaveArithmeticOrLogicalBinop()) : "IR metadata should indicate that code has an and";
                continue;
            }
            if (instruction.isCheckCast()) {
                assert (this.metadata.mayHaveCheckCast()) : "IR metadata should indicate that code has a check-cast";
                continue;
            }
            if (instruction.isConstNumber()) {
                assert (this.metadata.mayHaveConstNumber()) : "IR metadata should indicate that code has a const-number";
                continue;
            }
            if (instruction.isConstString()) {
                assert (this.metadata.mayHaveConstString()) : "IR metadata should indicate that code has a const-string";
                continue;
            }
            if (instruction.isDebugPosition()) {
                assert (this.metadata.mayHaveDebugPosition()) : "IR metadata should indicate that code has a debug position";
                continue;
            }
            if (instruction.isDexItemBasedConstString()) {
                assert (this.metadata.mayHaveDexItemBasedConstString()) : "IR metadata should indicate that code has a dex-item-based-const-string";
                continue;
            }
            if (instruction.isDiv()) {
                assert (this.metadata.mayHaveDiv() && this.metadata.mayHaveArithmeticOrLogicalBinop()) : "IR metadata should indicate that code has a div";
                continue;
            }
            if (instruction.isInstanceGet()) {
                assert (this.metadata.mayHaveInstanceGet()) : "IR metadata should indicate that code has an instance-get";
                continue;
            }
            if (instruction.isInstancePut()) {
                assert (this.metadata.mayHaveInstancePut()) : "IR metadata should indicate that code has an instance-put";
                continue;
            }
            if (instruction.isInstanceOf()) {
                assert (this.metadata.mayHaveInstanceOf()) : "IR metadata should indicate that code has an instance-of";
                continue;
            }
            if (instruction.isIntSwitch()) {
                assert (this.metadata.mayHaveIntSwitch()) : "IR metadata should indicate that code has an int-switch";
                continue;
            }
            if (instruction.isInvokeDirect()) {
                assert (this.metadata.mayHaveInvokeDirect()) : "IR metadata should indicate that code has an invoke-direct";
                continue;
            }
            if (instruction.isInvokeInterface()) {
                assert (this.metadata.mayHaveInvokeInterface()) : "IR metadata should indicate that code has an invoke-interface";
                continue;
            }
            if (instruction.isInvokePolymorphic()) {
                assert (this.metadata.mayHaveInvokePolymorphic()) : "IR metadata should indicate that code has an invoke-polymorphic";
                continue;
            }
            if (instruction.isInvokeStatic()) {
                assert (this.metadata.mayHaveInvokeStatic()) : "IR metadata should indicate that code has an invoke-static";
                continue;
            }
            if (instruction.isInvokeSuper()) {
                assert (this.metadata.mayHaveInvokeSuper()) : "IR metadata should indicate that code has an invoke-super";
                continue;
            }
            if (instruction.isInvokeVirtual()) {
                assert (this.metadata.mayHaveInvokeVirtual()) : "IR metadata should indicate that code has an invoke-virtual";
                continue;
            }
            if (instruction.isOr()) {
                assert (this.metadata.mayHaveOr() && this.metadata.mayHaveArithmeticOrLogicalBinop()) : "IR metadata should indicate that code has an or";
                continue;
            }
            if (instruction.isMonitor()) {
                assert (this.metadata.mayHaveMonitorInstruction()) : "IR metadata should indicate that code has a monitor instruction";
                continue;
            }
            if (instruction.isMul()) {
                assert (this.metadata.mayHaveMul() && this.metadata.mayHaveArithmeticOrLogicalBinop()) : "IR metadata should indicate that code has a mul";
                continue;
            }
            if (instruction.isNewInstance()) {
                assert (this.metadata.mayHaveNewInstance()) : "IR metadata should indicate that code has a new-instance";
                continue;
            }
            if (instruction.isRem()) {
                assert (this.metadata.mayHaveRem() && this.metadata.mayHaveArithmeticOrLogicalBinop()) : "IR metadata should indicate that code has a rem";
                continue;
            }
            if (instruction.isShl()) {
                assert (this.metadata.mayHaveShl() && this.metadata.mayHaveArithmeticOrLogicalBinop()) : "IR metadata should indicate that code has a shl";
                continue;
            }
            if (instruction.isShr()) {
                assert (this.metadata.mayHaveShr() && this.metadata.mayHaveArithmeticOrLogicalBinop()) : "IR metadata should indicate that code has a shr";
                continue;
            }
            if (instruction.isStaticGet()) {
                assert (this.metadata.mayHaveStaticGet()) : "IR metadata should indicate that code has a static-get";
                continue;
            }
            if (instruction.isStaticPut()) {
                assert (this.metadata.mayHaveStaticPut()) : "IR metadata should indicate that code has a static-put";
                continue;
            }
            if (instruction.isStringSwitch()) {
                assert (this.metadata.mayHaveStringSwitch()) : "IR metadata should indicate that code has a string-switch";
                continue;
            }
            if (instruction.isSub()) {
                assert (this.metadata.mayHaveSub() && this.metadata.mayHaveArithmeticOrLogicalBinop()) : "IR metadata should indicate that code has a sub";
                continue;
            }
            if (instruction.isUshr()) {
                assert (this.metadata.mayHaveUshr() && this.metadata.mayHaveArithmeticOrLogicalBinop()) : "IR metadata should indicate that code has an ushr";
                continue;
            }
            if (instruction.isXor()) assert (this.metadata.mayHaveXor() && this.metadata.mayHaveArithmeticOrLogicalBinop()) : "IR metadata should indicate that code has an xor";
        }
        return true;
    }

    private boolean validThrowingInstructions() {
        for (BasicBlock block : this.blocks) {
            if (!block.hasCatchHandlers()) continue;
            assert (block != this.entryBlock());
            for (BasicBlock handler : block.getCatchHandlers().getUniqueTargets()) {
                assert (handler.getPredecessors().size() == 1);
            }
            boolean seenThrowing = false;
            for (Instruction instruction : block.getInstructions()) {
                if (instruction.instructionTypeCanThrow()) {
                    assert (!seenThrowing);
                    seenThrowing = true;
                    continue;
                }
                assert (!seenThrowing || instruction.isAllowedAfterThrowingInstruction());
            }
        }
        return true;
    }

    private boolean verifyNoValueWithOnlyAssumeInstructionAsUsers() {
        Predicate<Value> verifyValue = v -> {
            assert (!v.hasUsers() || v.uniqueUsers().stream().anyMatch(i -> !i.isAssume()) || !v.isPhi() && v.definition.isArgument() || !v.hasDebugUsers() || v.debugUsers().stream().anyMatch(i -> !i.isAssume()) || v.numberOfPhiUsers() > 0) : StringUtils.join(System.lineSeparator(), v.uniqueUsers());
            return true;
        };
        return this.verifySSATypeLattice(this.wrapSSAVerifierWithStackValueHandling(verifyValue));
    }

    private Predicate<Value> wrapSSAVerifierWithStackValueHandling(Predicate<Value> tester) {
        return v -> {
            if (v instanceof StackValues) {
                return Stream.of(((StackValues)v).getStackValues()).allMatch(tester);
            }
            return tester.test((Value)v);
        };
    }

    private boolean verifySSATypeLattice(Predicate<Value> tester) {
        for (BasicBlock block : this.blocks) {
            for (Instruction instruction : block.getInstructions()) {
                if (instruction.hasOutValue()) assert (tester.test(instruction.outValue()));
            }
            for (Phi phi : block.getPhis()) {
                assert (tester.test(phi));
            }
        }
        return true;
    }

    private boolean computeAllThrowingInstructionsHavePositions() {
        for (Instruction instruction : this.instructions()) {
            if (!instruction.instructionTypeCanThrow() || instruction.isConstString() || instruction.isDexItemBasedConstString() || !instruction.getPosition().isNone() || instruction.getPosition().isSyntheticNone()) continue;
            return false;
        }
        return true;
    }

    private boolean isDeadPhi(WorkList<Phi> reachablePhis) {
        while (reachablePhis.hasNext()) {
            Phi currentPhi = reachablePhis.next();
            if (currentPhi.hasUsers() || currentPhi.hasDebugUsers()) {
                return false;
            }
            reachablePhis.addIfNotSeen(currentPhi.uniquePhiUsers());
        }
        return true;
    }

    private void markTransitiveSuccessors(BasicBlock subject, int color) {
        this.markTransitiveSuccessors(DequeUtils.newArrayDeque(subject), color);
    }

    private void markTransitiveSuccessors(Deque<BasicBlock> worklist, int color) {
        assert (this.isMarkingColorInUse(color) && !this.anyBlocksMarkedWithColor(color));
        while (!worklist.isEmpty()) {
            BasicBlock block = worklist.poll();
            if (block.isMarked(color)) continue;
            block.mark(color);
            for (BasicBlock successor : block.getSuccessors()) {
                if (successor.isMarked(color)) continue;
                worklist.add(successor);
            }
        }
    }

    public IRMetadata metadata() {
        return this.metadata;
    }

    public ProgramMethod context() {
        return this.method;
    }

    @Deprecated
    public DexEncodedMethod method() {
        return (DexEncodedMethod)this.method.getDefinition();
    }

    public BasicBlock entryBlock() {
        return this.blocks.getFirst();
    }

    public MethodConversionOptions getConversionOptions() {
        return this.conversionOptions;
    }

    public void mutateConversionOptions(Consumer<MethodConversionOptions.MutableMethodConversionOptions> mutator) {
        mutator.accept(this.conversionOptions);
    }

    public Map<BasicBlock, LiveAtEntrySets> computeLiveAtEntrySets() {
        IdentityHashMap<BasicBlock, LiveAtEntrySets> liveAtEntrySets = new IdentityHashMap<BasicBlock, LiveAtEntrySets>();
        ArrayDeque<BasicBlock> worklist = new ArrayDeque<BasicBlock>();
        ImmutableList<BasicBlock> sorted2 = this.topologicallySortedBlocks();
        worklist.addAll(sorted2.reverse());
        while (!worklist.isEmpty()) {
            BasicBlock block = (BasicBlock)worklist.poll();
            LinkedHashSet<Value> live = new LinkedHashSet<Value>();
            Set<Value> liveLocals = Sets.newIdentityHashSet();
            ArrayDeque<Value> liveStack = new ArrayDeque<Value>();
            Set<BasicBlock> exceptionalSuccessors = block.getCatchHandlers().getUniqueTargets();
            for (BasicBlock succ : block.getSuccessors()) {
                LiveAtEntrySets liveAtSucc = (LiveAtEntrySets)liveAtEntrySets.get(succ);
                if (liveAtSucc != null) {
                    LinkedHashSetUtils.addAll(live, liveAtSucc.liveValues);
                    liveLocals.addAll(liveAtSucc.liveLocalValues);
                    if (exceptionalSuccessors.contains(succ)) {
                        assert (liveAtSucc.liveStackValues.size() == 0);
                    } else {
                        assert (liveStack.isEmpty());
                        liveStack = new ArrayDeque<Value>(liveAtSucc.liveStackValues);
                    }
                }
                int predIndex = succ.getPredecessors().indexOf(block);
                for (Phi phi : succ.getPhis()) {
                    Value operand = phi.getOperand(predIndex);
                    if (operand.isValueOnStack()) {
                        liveStack.addLast(operand);
                        continue;
                    }
                    live.add(operand);
                    if (!phi.hasLocalInfo()) continue;
                    assert (phi.getLocalInfo() == operand.getLocalInfo());
                    liveLocals.add(operand);
                }
            }
            assert (liveStack.isEmpty() || block.getSuccessors().size() - exceptionalSuccessors.size() == 1);
            InstructionListIterator iterator2 = block.listIterator(this, block.getInstructions().size());
            while (iterator2.hasPrevious()) {
                Instruction instruction = iterator2.previous();
                Value outValue = instruction.outValue();
                if (outValue != null) {
                    if (outValue instanceof StackValue) {
                        Value pop = (Value)liveStack.removeLast();
                        assert (pop == outValue);
                    } else if (outValue instanceof StackValues) {
                        StackValue[] values2 = ((StackValues)outValue).getStackValues();
                        for (int i = values2.length - 1; i >= 0; --i) {
                            Value pop = (Value)liveStack.removeLast();
                            assert (pop == values2[i]);
                        }
                    } else {
                        live.remove(outValue);
                        assert (outValue.hasLocalInfo() || !liveLocals.contains(outValue));
                        if (outValue.hasLocalInfo()) {
                            liveLocals.remove(outValue);
                        }
                    }
                }
                for (Value use : instruction.inValues()) {
                    if (use.needsRegister()) {
                        live.add(use);
                        continue;
                    }
                    if (!use.isValueOnStack()) continue;
                    liveStack.addLast(use);
                }
                if (instruction.getDebugValues().isEmpty()) continue;
                ArrayList<Value> sortedValues = new ArrayList<Value>(instruction.getDebugValues());
                sortedValues.sort(Value::compareTo);
                assert (sortedValues.stream().allMatch(Value::needsRegister));
                assert (sortedValues.stream().allMatch(Value::hasLocalInfo));
                live.addAll(sortedValues);
                liveLocals.addAll(sortedValues);
            }
            for (Phi phi : block.getPhis()) {
                if (phi.isValueOnStack()) {
                    liveStack.remove(phi);
                } else {
                    live.remove(phi);
                }
                assert (phi.hasLocalInfo() || !liveLocals.contains(phi));
                if (!phi.hasLocalInfo()) continue;
                liveLocals.remove(phi);
            }
            LiveAtEntrySets liveAtEntry = new LiveAtEntrySets(live, liveLocals, liveStack);
            LiveAtEntrySets previousLiveAtEntry = liveAtEntrySets.put(block, liveAtEntry);
            if (previousLiveAtEntry != null && previousLiveAtEntry.equals(liveAtEntry)) continue;
            for (BasicBlock pred : block.getPredecessors()) {
                if (worklist.contains(pred)) continue;
                worklist.add(pred);
            }
        }
        assert (((LiveAtEntrySets)liveAtEntrySets.get(sorted2.get(0))).isEmpty()) : "Unexpected values live at entry to first block: " + ((LiveAtEntrySets)liveAtEntrySets.get(sorted2.get((int)0))).liveValues;
        return liveAtEntrySets;
    }

    public boolean controlFlowMayDependOnEnvironment(Consumer<Value> valueRequiredToBeIndependentOfEnvironmentConsumer) {
        for (BasicBlock block : this.blocks) {
            if (block.hasCatchHandlers()) {
                return true;
            }
            if (block.exit().isIf()) {
                If ifInstruction = block.exit().asIf();
                valueRequiredToBeIndependentOfEnvironmentConsumer.accept(ifInstruction.lhs());
                if (ifInstruction.isZeroTest()) continue;
                valueRequiredToBeIndependentOfEnvironmentConsumer.accept(ifInstruction.rhs());
                continue;
            }
            if (!block.exit().isSwitch()) continue;
            Switch switchInstruction = block.exit().asSwitch();
            valueRequiredToBeIndependentOfEnvironmentConsumer.accept(switchInstruction.value());
        }
        return false;
    }

    public void prepareBlocksForCatchHandlers() {
        BasicBlock entryBlock = this.entryBlock();
        BasicBlockIterator blockIterator = this.listIterator();
        while (blockIterator.hasNext()) {
            List<BasicBlock> successors;
            BasicBlock block2 = (BasicBlock)blockIterator.next();
            InstructionListIterator instructionIterator = block2.listIterator(this);
            boolean hasSeenThrowingInstruction = false;
            while (instructionIterator.hasNext()) {
                Instruction instruction = (Instruction)instructionIterator.next();
                boolean instructionTypeCanThrow = instruction.instructionTypeCanThrow();
                if (hasSeenThrowingInstruction && !instruction.isAllowedAfterThrowingInstruction() || instructionTypeCanThrow && block2 == entryBlock) {
                    instructionIterator.previous();
                    instructionIterator.split(this, blockIterator);
                    blockIterator.previous();
                    break;
                }
                if (!instructionTypeCanThrow) continue;
                hasSeenThrowingInstruction = true;
            }
            if (!hasSeenThrowingInstruction || (successors = block2.getSuccessors()).size() != 1 || ListUtils.first(successors).getPredecessors().size() <= 1) continue;
            BasicBlock splitBlock = block2.createSplitBlock(this.getNextBlockNumber(), true);
            Goto newGoto = new Goto(block2);
            newGoto.setPosition(Position.none());
            splitBlock.listIterator(this).add(newGoto);
            blockIterator.add(splitBlock);
        }
        assert (this.blocks.stream().allMatch(block -> block.numberOfThrowingInstructions() <= 1));
    }

    public void splitCriticalEdges() {
        ArrayList<BasicBlock> newBlocks = new ArrayList<BasicBlock>();
        for (BasicBlock block : this.blocks) {
            List<BasicBlock> predecessors = block.getMutablePredecessors();
            if (predecessors.size() <= 1) continue;
            assert (!block.entry().isMoveException());
            for (int predIndex = 0; predIndex < predecessors.size(); ++predIndex) {
                BasicBlock pred = predecessors.get(predIndex);
                if (pred.hasOneNormalExit()) continue;
                BasicBlock newBlock = BasicBlock.createGotoBlock(this.getNextBlockNumber(), pred.exit().getPosition(), this.metadata, block);
                newBlocks.add(newBlock);
                pred.replaceSuccessor(block, newBlock);
                newBlock.getMutablePredecessors().add(pred);
                predecessors.set(predIndex, newBlock);
            }
        }
        this.blocks.addAll(newBlocks);
    }

    public boolean verifySplitCriticalEdges() {
        for (BasicBlock block : this.blocks) {
            List<BasicBlock> predecessors = block.getPredecessors();
            if (predecessors.size() > 1) {
                for (BasicBlock predecessor : predecessors) {
                    assert (predecessor.hasOneNormalExit());
                    assert (predecessor.getSuccessors().get(0) == block);
                }
            }
            if (!block.hasCatchHandlers()) continue;
            for (BasicBlock handler : block.getCatchHandlers().getUniqueTargets()) {
                assert (handler.getPredecessors().size() == 1);
                assert (handler.getPredecessors().get(0) == block);
            }
        }
        return true;
    }

    public void traceBlocks() {
        ImmutableList<BasicBlock> sorted2 = this.topologicallySortedBlocks();
        int color = this.reserveMarkingColor();
        LinkedList<BasicBlock> tracedBlocks = new LinkedList<BasicBlock>();
        for (BasicBlock block : sorted2) {
            if (block.isMarked(color)) continue;
            block.mark(color);
            tracedBlocks.add(block);
            BasicBlock current = block;
            BasicBlock fallthrough = block.exit().fallthroughBlock();
            while (fallthrough != null && !fallthrough.isMarked(color)) {
                fallthrough.mark(color);
                tracedBlocks.add(fallthrough);
                current = fallthrough;
                fallthrough = fallthrough.exit().fallthroughBlock();
            }
            if (fallthrough == null) continue;
            BasicBlock newFallthrough = BasicBlock.createGotoBlock(this.getNextBlockNumber(), current.exit().getPosition(), this.metadata, fallthrough);
            current.exit().setFallthroughBlock(newFallthrough);
            newFallthrough.getMutablePredecessors().add(current);
            fallthrough.replacePredecessor(current, newFallthrough);
            newFallthrough.mark(color);
            tracedBlocks.add(newFallthrough);
        }
        this.blocks = tracedBlocks;
        this.returnMarkingColor(color);
        assert (this.noColorsInUse());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("blocks:\n");
        for (BasicBlock block : this.blocks) {
            builder.append(block.toDetailedString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public void clearMarks(int color) {
        for (BasicBlock block : this.blocks) {
            block.clearMark(color);
        }
    }

    public void removeMarkedBlocks(int color) {
        BasicBlockIterator blockIterator = this.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = (BasicBlock)blockIterator.next();
            if (!block.isMarked(color)) continue;
            blockIterator.remove();
        }
    }

    public boolean verifyNoBlocksMarked(int color) {
        for (BasicBlock block : this.blocks) {
            assert (!block.isMarked(color));
        }
        return true;
    }

    public void removeBlocks(Collection<BasicBlock> blocksToRemove) {
        this.blocks.removeAll(blocksToRemove);
    }

    public ImmutableList<BasicBlock> topologicallySortedBlocks() {
        ImmutableList<BasicBlock> ordered = this.depthFirstSorting();
        return this.options.testing.placeExceptionalBlocksLast ? IRCode.reorderExceptionalBlocksLastForTesting(ordered) : ordered;
    }

    public void print(CfgPrinter printer) {
        this.ensureBlockNumbering();
        for (BasicBlock block : this.blocks) {
            block.print(printer);
        }
    }

    public boolean isConsistentSSA(AppView<?> appView) {
        this.isConsistentSSABeforeTypesAreCorrect(appView);
        assert (this.verifyNoImpreciseOrBottomTypes());
        return true;
    }

    public boolean isConsistentSSABeforeTypesAreCorrect(AppView<?> appView) {
        assert (this.isConsistentGraph(appView, true));
        assert (this.consistentBlockInstructions(appView, true));
        assert (this.consistentDefUseChains());
        assert (this.validThrowingInstructions());
        assert (this.noCriticalEdges());
        assert (this.verifyNoValueWithOnlyAssumeInstructionAsUsers());
        return true;
    }

    public boolean hasNoMergedClasses(AppView<? extends AppInfoWithClassHierarchy> appView) {
        MergedClassesCollection mergedClasses = appView.allMergedClasses();
        if (mergedClasses == null) {
            return true;
        }
        for (Instruction instruction : this.instructions()) {
            if (instruction.outValue == null || !instruction.outValue.getType().isClassType()) continue;
            ClassTypeElement classTypeLattice = instruction.outValue.getType().asClassType();
            assert (!mergedClasses.hasBeenMergedIntoDifferentType(classTypeLattice.getClassType())) : "Expected reference to " + classTypeLattice.getClassType().getTypeName() + " to be rewritten at instruction " + instruction.toString();
            assert (!classTypeLattice.getInterfaces().anyMatch((itf, isKnown) -> {
                assert (!mergedClasses.hasBeenMergedIntoDifferentType((DexType)itf));
                return false;
            }));
        }
        return true;
    }

    public boolean isConsistentGraph(AppView<?> appView) {
        return this.isConsistentGraph(appView, false);
    }

    public boolean isConsistentGraph(AppView<?> appView, boolean ssa) {
        assert (this.noColorsInUse());
        assert (this.consistentBlockNumbering());
        assert (this.consistentPredecessorSuccessors());
        assert (this.consistentCatchHandlers());
        assert (this.consistentBlockInstructions(appView, ssa));
        assert (this.consistentMetadata());
        assert (!this.allThrowingInstructionsHavePositions || this.computeAllThrowingInstructionsHavePositions());
        return true;
    }

    public boolean verifyTypes(AppView<?> appView) {
        VerifyTypesHelper verifyTypesHelper = VerifyTypesHelper.create(appView);
        if (appView.enableWholeProgramOptimizations()) {
            assert (this.validAssumeInstructions(appView));
            assert (new TypeChecker(appView.withLiveness(), verifyTypesHelper).check(this));
        }
        assert (this.blocks.stream().allMatch(block -> block.verifyTypes(appView, verifyTypesHelper)));
        return true;
    }

    public boolean hasCatchHandlers() {
        for (BasicBlock block : this.blocks) {
            if (!block.hasCatchHandlers()) continue;
            return true;
        }
        return false;
    }

    public boolean consistentBlockNumbering() {
        this.blocks.stream().collect(Collectors.groupingBy(BasicBlock::getNumber, Collectors.counting())).forEach((key, value) -> {
            assert (value == 1L);
            assert (value <= (long)this.basicBlockNumberGenerator.peek());
        });
        return true;
    }

    public boolean verifyNoImpreciseOrBottomTypes() {
        Predicate<Value> verifyValue = v -> {
            assert (v.getType().isPreciseType());
            assert (!v.getType().isFineGrainedType());
            assert (!v.getType().isBottom());
            assert (!(v.definition instanceof ImpreciseMemberTypeInstruction) || ((ImpreciseMemberTypeInstruction)((Object)v.definition)).getMemberType().isPrecise());
            return true;
        };
        return this.verifySSATypeLattice(this.wrapSSAVerifierWithStackValueHandling(verifyValue));
    }

    public boolean verifyNoNullabilityBottomTypes() {
        Predicate<Value> verifyValue = v -> {
            assert (v.getType().isPrimitiveType() || v.getType().asReferenceType().nullability() != Nullability.bottom());
            return true;
        };
        return this.verifySSATypeLattice(this.wrapSSAVerifierWithStackValueHandling(verifyValue));
    }

    public Iterable<BasicBlock> blocks(Predicate<BasicBlock> predicate) {
        return () -> IteratorUtils.filter(this.listIterator(), predicate);
    }

    public Iterable<Instruction> instructions() {
        return this::instructionIterator;
    }

    public Stream<Instruction> streamInstructions() {
        return Streams.stream(this.instructions());
    }

    public <T extends Instruction> Iterable<T> instructions(Predicate<Instruction> predicate) {
        return () -> IteratorUtils.filter(this.instructionIterator(), predicate);
    }

    public InstructionIterator instructionIterator() {
        return new IRCodeInstructionIterator(this);
    }

    public InstructionListIterator instructionListIterator() {
        return new IRCodeInstructionListIterator(this);
    }

    public List<BasicBlock> computeNormalExitBlocks() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BasicBlock block : this.blocks) {
            if (!block.exit().isReturn()) continue;
            builder.add(block);
        }
        return builder.build();
    }

    public BasicBlockIterator listIterator() {
        return new BasicBlockIterator(this);
    }

    public BasicBlockIterator listIterator(int index) {
        return new BasicBlockIterator(this, index);
    }

    public ImmutableList<BasicBlock> numberInstructions() {
        ImmutableList<BasicBlock> blocks = this.topologicallySortedBlocks();
        for (BasicBlock block : blocks) {
            this.nextInstructionNumber = block.numberInstructions(this.nextInstructionNumber);
        }
        return blocks;
    }

    public int numberRemainingInstructions() {
        for (Instruction instruction : this.instructions()) {
            if (instruction.getNumber() != -1) continue;
            instruction.setNumber(this.nextInstructionNumber);
            this.nextInstructionNumber += 2;
        }
        return this.nextInstructionNumber;
    }

    public int getNextInstructionNumber() {
        return this.nextInstructionNumber;
    }

    public int getNumberOfArguments() {
        return ((DexMethod)this.context().getReference()).getArity() + BooleanUtils.intValue(!((DexEncodedMethod)this.context().getDefinition()).isStatic());
    }

    public Iterator<Argument> argumentIterator() {
        return new Iterator<Argument>(){
            private final InstructionIterator instructionIterator;
            private Argument next;
            {
                this.instructionIterator = IRCode.this.entryBlock().iterator();
                this.next = ((Instruction)this.instructionIterator.next()).asArgument();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Argument next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Argument previous = this.next;
                this.next = ((Instruction)this.instructionIterator.next()).asArgument();
                return previous;
            }
        };
    }

    public List<Value> collectArguments() {
        return this.collectArguments(false);
    }

    public List<Value> collectArguments(boolean ignoreReceiver) {
        ArrayList<Value> arguments = new ArrayList<Value>();
        Iterator<Argument> iterator2 = this.argumentIterator();
        while (iterator2.hasNext()) {
            Argument argument = iterator2.next();
            Value out = argument.outValue();
            if (ignoreReceiver && out.isThis()) continue;
            arguments.add(out);
        }
        assert (arguments.size() == ((DexMethod)this.method().getReference()).getArity() + (this.method().accessFlags.isStatic() || ignoreReceiver ? 0 : 1));
        return arguments;
    }

    public Argument getLastArgument() {
        InstructionIterator instructionIterator = this.entryBlock().iterator(this.getNumberOfArguments() - 1);
        Argument lastArgument = ((Instruction)instructionIterator.next()).asArgument();
        assert (lastArgument != null);
        assert (!instructionIterator.peekNext().isArgument());
        return lastArgument;
    }

    public Value getThis() {
        if (this.method().accessFlags.isStatic()) {
            return null;
        }
        Instruction firstArg = (Instruction)this.entryBlock().iterator().nextUntil(Instruction::isArgument);
        assert (firstArg != null);
        Value thisValue = firstArg.asArgument().outValue();
        assert (thisValue.isThis());
        return thisValue;
    }

    @Override
    public Value createValue(TypeElement type, DebugLocalInfo local) {
        return new Value(this.valueNumberGenerator.next(), type, local);
    }

    public ConstNumber createNumberConstant(long value, TypeElement type) {
        return this.createNumberConstant(value, type, null);
    }

    public ConstNumber createNumberConstant(long value, TypeElement type, DebugLocalInfo local) {
        return new ConstNumber(this.createValue(type, local), value);
    }

    public ConstNumber createDoubleConstant(double value, DebugLocalInfo local) {
        return this.createNumberConstant(Double.doubleToLongBits(value), TypeElement.getDouble(), local);
    }

    public ConstNumber createFloatConstant(float value, DebugLocalInfo local) {
        return this.createNumberConstant(Float.floatToIntBits(value), TypeElement.getFloat(), local);
    }

    public ConstNumber createIntConstant(int value) {
        return this.createIntConstant(value, null);
    }

    public ConstNumber createIntConstant(int value, DebugLocalInfo local) {
        return this.createNumberConstant(value, TypeElement.getInt(), local);
    }

    public ConstNumber createLongConstant(long value, DebugLocalInfo local) {
        return this.createNumberConstant(value, TypeElement.getLong(), local);
    }

    public ConstString createStringConstant(AppView<?> appView, DexString value) {
        return this.createStringConstant(appView, value, null);
    }

    public ConstString createStringConstant(AppView<?> appView, DexString value, DebugLocalInfo local) {
        Value out = this.createValue(TypeElement.stringClassType(appView, Nullability.definitelyNotNull()), local);
        return new ConstString(out, value);
    }

    public Phi createPhi(BasicBlock block, TypeElement type) {
        return new Phi(this.valueNumberGenerator.next(), block, type, null, Phi.RegisterReadType.NORMAL);
    }

    public final int getNextBlockNumber() {
        return this.basicBlockNumberGenerator.next();
    }

    public final int getCurrentBlockNumber() {
        return this.basicBlockNumberGenerator.peek();
    }

    public ConstClass createConstClass(AppView<?> appView, DexType type) {
        Value out = this.createValue(TypeElement.fromDexType(type, Nullability.definitelyNotNull(), appView));
        return new ConstClass(out, type);
    }

    public ConstNumber createConstNull() {
        return this.createNumberConstant(0L, TypeElement.getNull());
    }

    public ConstNumber createConstNull(DebugLocalInfo local) {
        return this.createNumberConstant(0L, TypeElement.getNull(), local);
    }

    public boolean doAllThrowingInstructionsHavePositions() {
        return this.allThrowingInstructionsHavePositions;
    }

    public void setAllThrowingInstructionsHavePositions(boolean value) {
        this.allThrowingInstructionsHavePositions = value;
    }

    public boolean removeAllDeadAndTrivialPhis() {
        return this.removeAllDeadAndTrivialPhis(null, null);
    }

    public boolean removeAllDeadAndTrivialPhis(IRBuilder builder) {
        return this.removeAllDeadAndTrivialPhis(builder, null);
    }

    public boolean removeAllDeadAndTrivialPhis(Set<Value> affectedValues) {
        return this.removeAllDeadAndTrivialPhis(null, affectedValues);
    }

    public boolean removeAllDeadAndTrivialPhis(IRBuilder builder, Set<Value> affectedValues) {
        boolean anyPhisRemoved = false;
        for (BasicBlock block : this.blocks) {
            ArrayList<Phi> phis = new ArrayList<Phi>(block.getPhis());
            for (Phi phi : phis) {
                WorkList<Phi> reachablePhis = WorkList.newIdentityWorkList(phi);
                if (this.isDeadPhi(reachablePhis)) {
                    reachablePhis.getSeenSet().forEach(Phi::removeDeadPhi);
                    anyPhisRemoved = true;
                    continue;
                }
                anyPhisRemoved |= phi.removeTrivialPhi(builder, affectedValues);
            }
        }
        return anyPhisRemoved;
    }

    public int reserveMarkingColor() {
        int color;
        assert (this.anyMarkingColorAvailable());
        for (color = 1; (this.usedMarkingColors & color) == color; color <<= 1) {
            assert (color <= 0x40000000);
        }
        this.usedMarkingColors |= color;
        assert (this.isMarkingColorInUse(color));
        assert (this.verifyNoBlocksMarked(color));
        return color;
    }

    public boolean anyMarkingColorAvailable() {
        for (int color = 1; (this.usedMarkingColors & color) == color; color <<= 1) {
            if (color <= 0x40000000) continue;
            return false;
        }
        return true;
    }

    public void returnMarkingColor(int color) {
        assert (this.isMarkingColorInUse(color));
        this.clearMarks(color);
        this.usedMarkingColors &= ~color;
    }

    public boolean isMarkingColorInUse(int color) {
        return (this.usedMarkingColors & color) != 0;
    }

    public boolean anyBlocksMarkedWithColor(int color) {
        for (BasicBlock block : this.blocks) {
            if (!block.isMarked(color)) continue;
            return true;
        }
        return false;
    }

    public boolean noColorsInUse() {
        return this.usedMarkingColors == 0;
    }

    public Iterable<Instruction> getInstructionsReachableFrom(Instruction instruction) {
        BasicBlock source = instruction.getBlock();
        Set<BasicBlock> blocksReachableFromSource = this.getBlocksReachableFromExclusive(source);
        if (blocksReachableFromSource.contains(source)) {
            LinkedList<Instruction> result = null;
            for (BasicBlock block : blocksReachableFromSource) {
                result = result != null ? Iterables.concat(result, block.getInstructions()) : block.getInstructions();
            }
            return result;
        }
        Iterable<Instruction> result = () -> source.iterator(instruction);
        for (BasicBlock block : blocksReachableFromSource) {
            result = Iterables.concat(result, block.getInstructions());
        }
        return result;
    }

    public LinkedList<BasicBlock> getBlocks() {
        return this.blocks;
    }

    public Set<BasicBlock> getBlocksReachableFromExclusive(BasicBlock source) {
        Set<BasicBlock> result = Sets.newIdentityHashSet();
        int color = this.reserveMarkingColor();
        this.markTransitiveSuccessors(new ArrayDeque<BasicBlock>(source.getSuccessors()), color);
        for (BasicBlock block : this.blocks) {
            if (!block.isMarked(color)) continue;
            result.add(block);
        }
        this.returnMarkingColor(color);
        return result;
    }

    public Set<BasicBlock> getUnreachableBlocks() {
        Set<BasicBlock> unreachableBlocks = Sets.newIdentityHashSet();
        int color = this.reserveMarkingColor();
        this.markTransitiveSuccessors(this.entryBlock(), color);
        for (BasicBlock block : this.blocks) {
            if (block.isMarked(color)) continue;
            unreachableBlocks.add(block);
        }
        this.returnMarkingColor(color);
        return unreachableBlocks;
    }

    public Set<Value> removeUnreachableBlocks() {
        ImmutableSet.Builder affectedValueBuilder = ImmutableSet.builder();
        int color = this.reserveMarkingColor();
        this.markTransitiveSuccessors(this.entryBlock(), color);
        BasicBlockIterator blockIterator = this.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock current = (BasicBlock)blockIterator.next();
            if (current.isMarked(color)) continue;
            affectedValueBuilder.addAll(current.cleanForRemoval());
            blockIterator.remove();
        }
        this.returnMarkingColor(color);
        return affectedValueBuilder.build();
    }

    public void markTransitivePredecessors(BasicBlock subject, int color) {
        assert (this.isMarkingColorInUse(color));
        ArrayDeque<BasicBlock> worklist = new ArrayDeque<BasicBlock>();
        worklist.add(subject);
        while (!worklist.isEmpty()) {
            BasicBlock block = (BasicBlock)worklist.poll();
            if (block.isMarked(color)) continue;
            block.mark(color);
            for (BasicBlock predecessor : block.getPredecessors()) {
                if (predecessor.isMarked(color)) continue;
                worklist.add(predecessor);
            }
        }
    }

    public Position findFirstNonNonePosition() {
        return this.findFirstNonNonePosition(Position.none());
    }

    public Position findFirstNonNonePosition(Position orElse) {
        BasicBlock current = this.entryBlock();
        Set<BasicBlock> visitedBlocks = Sets.newIdentityHashSet();
        do {
            boolean changed = visitedBlocks.add(current);
            assert (changed);
            for (Instruction instruction : current.getInstructions()) {
                if (instruction.isArgument() || instruction.isGoto() || !instruction.getPosition().isSome()) continue;
                return instruction.getPosition();
            }
        } while (current.exit().isGoto() && !visitedBlocks.contains(current = current.exit().asGoto().getTarget()));
        return orElse;
    }

    private static class BlockMarker {
        final BasicBlock block;

        BlockMarker(BasicBlock block) {
            this.block = block;
        }
    }

    public static class LiveAtEntrySets {
        public final LinkedHashSet<Value> liveValues;
        public final Set<Value> liveLocalValues;
        public final Deque<Value> liveStackValues;

        public LiveAtEntrySets(LinkedHashSet<Value> liveValues, Set<Value> liveLocalValues, Deque<Value> liveStackValues) {
            assert (liveValues.containsAll(liveLocalValues));
            this.liveValues = liveValues;
            this.liveLocalValues = liveLocalValues;
            this.liveStackValues = liveStackValues;
        }

        public int hashCode() {
            throw new Unreachable();
        }

        public boolean equals(Object o) {
            LiveAtEntrySets other = (LiveAtEntrySets)o;
            return this.liveValues.equals(other.liveValues) && this.liveLocalValues.equals(other.liveLocalValues);
        }

        public boolean isEmpty() {
            return this.liveValues.isEmpty() && this.liveLocalValues.isEmpty();
        }
    }
}

