/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class IRCodeInstructionIterator
implements InstructionIterator {
    private final ListIterator<BasicBlock> blockIterator;
    private InstructionListIterator instructionIterator;
    private final IRCode code;

    public IRCodeInstructionIterator(IRCode code) {
        this.blockIterator = code.listIterator();
        this.code = code;
        this.instructionIterator = this.blockIterator.next().listIterator(code);
    }

    @Override
    public boolean hasNext() {
        return this.instructionIterator.hasNext() || this.blockIterator.hasNext();
    }

    @Override
    public Instruction next() {
        if (this.instructionIterator.hasNext()) {
            return (Instruction)this.instructionIterator.next();
        }
        if (!this.blockIterator.hasNext()) {
            throw new NoSuchElementException();
        }
        this.instructionIterator = this.blockIterator.next().listIterator(this.code);
        assert (this.instructionIterator.hasNext());
        return (Instruction)this.instructionIterator.next();
    }

    @Override
    public boolean hasPrevious() {
        return this.instructionIterator.hasPrevious() || this.blockIterator.hasPrevious();
    }

    @Override
    public Instruction previous() {
        if (this.instructionIterator.hasPrevious()) {
            return (Instruction)this.instructionIterator.previous();
        }
        if (!this.blockIterator.hasPrevious()) {
            throw new NoSuchElementException();
        }
        BasicBlock block = this.blockIterator.previous();
        this.instructionIterator = block.listIterator(this.code, block.getInstructions().size());
        assert (this.instructionIterator.hasPrevious());
        return (Instruction)this.instructionIterator.previous();
    }
}

