/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.analysis.VerifyTypesHelper;
import com.android.tools.r8.ir.analysis.constant.Bottom;
import com.android.tools.r8.ir.analysis.constant.ConstRangeLatticeElement;
import com.android.tools.r8.ir.analysis.constant.LatticeElement;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.AbstractFieldSet;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.EmptyFieldSet;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.UnknownFieldSet;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.UnknownValue;
import com.android.tools.r8.ir.code.Add;
import com.android.tools.r8.ir.code.And;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.ArithmeticBinop;
import com.android.tools.r8.ir.code.ArrayAccess;
import com.android.tools.r8.ir.code.ArrayGet;
import com.android.tools.r8.ir.code.ArrayLength;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.Assume;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.Binop;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.Cmp;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.ConstMethodHandle;
import com.android.tools.r8.ir.code.ConstMethodType;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.DebugLocalRead;
import com.android.tools.r8.ir.code.DebugLocalUninitialized;
import com.android.tools.r8.ir.code.DebugLocalWrite;
import com.android.tools.r8.ir.code.DebugLocalsChange;
import com.android.tools.r8.ir.code.DebugPosition;
import com.android.tools.r8.ir.code.DexItemBasedConstString;
import com.android.tools.r8.ir.code.Div;
import com.android.tools.r8.ir.code.Dup;
import com.android.tools.r8.ir.code.Dup2;
import com.android.tools.r8.ir.code.FieldGet;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.FieldPut;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.InitClass;
import com.android.tools.r8.ir.code.InstanceFieldInstruction;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.InstanceOf;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionOrPhi;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.IntSwitch;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeCustom;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeInterface;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.InvokeMultiNewArray;
import com.android.tools.r8.ir.code.InvokeNewArray;
import com.android.tools.r8.ir.code.InvokePolymorphic;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeSuper;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.JumpInstruction;
import com.android.tools.r8.ir.code.Load;
import com.android.tools.r8.ir.code.LogicalBinop;
import com.android.tools.r8.ir.code.Monitor;
import com.android.tools.r8.ir.code.Move;
import com.android.tools.r8.ir.code.MoveException;
import com.android.tools.r8.ir.code.Mul;
import com.android.tools.r8.ir.code.Neg;
import com.android.tools.r8.ir.code.NewArrayEmpty;
import com.android.tools.r8.ir.code.NewArrayFilledData;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.NewUnboxedEnumInstance;
import com.android.tools.r8.ir.code.Not;
import com.android.tools.r8.ir.code.NumberConversion;
import com.android.tools.r8.ir.code.Or;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Pop;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.RecordFieldValues;
import com.android.tools.r8.ir.code.Rem;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.SafeCheckCast;
import com.android.tools.r8.ir.code.Shl;
import com.android.tools.r8.ir.code.Shr;
import com.android.tools.r8.ir.code.StackValue;
import com.android.tools.r8.ir.code.StackValues;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Store;
import com.android.tools.r8.ir.code.StringSwitch;
import com.android.tools.r8.ir.code.Sub;
import com.android.tools.r8.ir.code.Swap;
import com.android.tools.r8.ir.code.Switch;
import com.android.tools.r8.ir.code.Throw;
import com.android.tools.r8.ir.code.TypeAndLocalInfoSupplier;
import com.android.tools.r8.ir.code.Unop;
import com.android.tools.r8.ir.code.UnusedArgument;
import com.android.tools.r8.ir.code.Ushr;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueFactory;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.code.Xor;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.conversion.MethodConversionOptions;
import com.android.tools.r8.ir.optimize.DeadCodeRemover;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class Instruction
implements InstructionOrPhi,
TypeAndLocalInfoSupplier {
    protected Value outValue = null;
    protected final List<Value> inValues = new ArrayList<Value>();
    private BasicBlock block = null;
    private int number = -1;
    private Set<Value> debugValues = null;
    private Position position = null;

    protected Instruction(Value outValue) {
        this.setOutValue(outValue);
    }

    protected Instruction(Value outValue, Value inValue) {
        this.addInValue(inValue);
        this.setOutValue(outValue);
    }

    protected Instruction(Value outValue, List<? extends Value> inValues) {
        if (inValues != null) {
            for (Value value : inValues) {
                this.addInValue(value);
            }
        }
        this.setOutValue(outValue);
    }

    public static void clearUserInfo(Instruction instruction) {
        if (instruction.outValue != null) {
            instruction.outValue.clearUsersInfo();
        }
        instruction.inValues.forEach(Value::clearUsersInfo);
        if (instruction.debugValues != null) {
            instruction.debugValues.forEach(Value::clearUsersInfo);
            instruction.debugValues = null;
        }
    }

    private boolean identicalInputAfterRegisterAllocation(Value a, int aInstrNumber, Instruction bInstr, Value b, int bInstrNumber, RegisterAllocator allocator) {
        boolean aIsStackValue = a instanceof StackValue;
        boolean aIsStackValues = a instanceof StackValues;
        if (aIsStackValue != b instanceof StackValue || aIsStackValues != b instanceof StackValues) {
            return false;
        }
        if (aIsStackValue) {
            return this.identicalStackValuePair((StackValue)a, (StackValue)b);
        }
        if (aIsStackValues) {
            return this.identicalStackValuesPair((StackValues)a, (StackValues)b);
        }
        if (this.needsValueInRegister(a) != bInstr.needsValueInRegister(b)) {
            return false;
        }
        if (this.needsValueInRegister(a) || this.isTwoAddr(allocator) || bInstr.isTwoAddr(allocator)) {
            if (!a.needsRegister() || !b.needsRegister()) {
                return false;
            }
            if (allocator.getRegisterForValue(a, aInstrNumber) != allocator.getRegisterForValue(b, bInstrNumber)) {
                return false;
            }
        } else {
            ConstNumber bNum;
            ConstNumber aNum = a.getConstInstruction().asConstNumber();
            if (!aNum.identicalNonValueNonPositionParts(bNum = b.getConstInstruction().asConstNumber())) {
                return false;
            }
        }
        return a.outType() == b.outType();
    }

    private boolean identicalOutputAfterRegisterAllocation(Value a, int aInstrNumber, Value b, int bInstrNumber, RegisterAllocator allocator) {
        ConstNumber bNum;
        ConstNumber aNum;
        boolean aIsStackValue = a instanceof StackValue;
        boolean aIsStackValues = a instanceof StackValues;
        if (aIsStackValue != b instanceof StackValue || aIsStackValues != b instanceof StackValues) {
            return false;
        }
        if (aIsStackValue) {
            return this.identicalStackValuePair((StackValue)a, (StackValue)b);
        }
        if (aIsStackValues) {
            return this.identicalStackValuesPair((StackValues)a, (StackValues)b);
        }
        if (a.needsRegister() != b.needsRegister()) {
            return false;
        }
        if (a.needsRegister() ? allocator.getRegisterForValue(a, aInstrNumber) != allocator.getRegisterForValue(b, bInstrNumber) : !(aNum = a.getConstInstruction().asConstNumber()).identicalNonValueNonPositionParts(bNum = b.getConstInstruction().asConstNumber())) {
            return false;
        }
        return a.outType() == b.outType();
    }

    private boolean identicalStackValuePair(StackValue a, StackValue b) {
        return a.getHeight() == b.getHeight() && a.outType() == b.outType();
    }

    private boolean identicalStackValuesPair(StackValues a, StackValues b) {
        StackValue[] bStackValues;
        StackValue[] aStackValues = a.getStackValues();
        if (aStackValues.length != (bStackValues = b.getStackValues()).length) {
            return false;
        }
        for (int i = 0; i < aStackValues.length; ++i) {
            if (this.identicalStackValuePair(aStackValues[i], bStackValues[i])) continue;
            return false;
        }
        return true;
    }

    private boolean definesBlockLocalValue() {
        return !this.definesValueWithNonLocalUsages();
    }

    private boolean definesValueWithNonLocalUsages() {
        if (this.hasOutValue()) {
            Value outValue = this.outValue();
            if (outValue.numberOfPhiUsers() > 0) {
                return true;
            }
            for (Instruction user : outValue.uniqueUsers()) {
                if (user.getBlock() == this.getBlock()) continue;
                return true;
            }
        }
        return false;
    }

    public abstract int opcode();

    public abstract <T> T accept(InstructionVisitor<T> var1);

    final boolean hasPosition() {
        return this.position != null;
    }

    public final Position getPosition() {
        assert (this.position != null);
        return this.position;
    }

    public void setPosition(Position position) {
        assert (this.position == null);
        this.position = position;
    }

    public void forceOverwritePosition(Position position) {
        assert (position != null);
        assert (this.position != null);
        this.position = position;
    }

    public String getPositionAsString() {
        return this.position == null ? "???" : this.position.toString();
    }

    public Value getOperand(int index) {
        return this.inValues().get(index);
    }

    public Value getFirstOperand() {
        return this.getOperand(0);
    }

    public List<Value> inValues() {
        return this.inValues;
    }

    protected void addInValue(Value value) {
        if (value != null) {
            this.inValues.add(value);
            assert (value.hasUsersInfo());
            if (value.hasUsersInfo()) {
                value.addUser(this);
            }
        }
    }

    public boolean ignoreCompatRules() {
        return false;
    }

    public boolean hasInValueWithLocalInfo() {
        return this.hasInValueThatMatches(Value::hasLocalInfo);
    }

    public boolean hasInValueThatMatches(Predicate<Value> predicate) {
        for (Value value : this.inValues()) {
            if (!predicate.test(value)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOutValue() {
        return this.outValue != null;
    }

    public boolean hasUnusedOutValue() {
        return !this.hasUsedOutValue();
    }

    public boolean hasUsedOutValue() {
        return this.hasOutValue() && this.outValue().hasAnyUsers();
    }

    public Value outValue() {
        return this.outValue;
    }

    public Value clearOutValue() {
        return this.setOutValue(null);
    }

    public Value setOutValue(Value newOutValue) {
        Value previousOutValue = this.outValue();
        this.outValue = newOutValue;
        if (newOutValue != null) {
            newOutValue.definition = this;
        }
        return previousOutValue;
    }

    public Value swapOutValue(Value newOutValue) {
        Value oldOutValue = this.outValue;
        this.outValue = null;
        this.setOutValue(newOutValue);
        if (oldOutValue != null) {
            oldOutValue.definition = null;
        }
        return oldOutValue;
    }

    public AbstractValue getAbstractValue(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod context) {
        assert (this.hasOutValue());
        return UnknownValue.getInstance();
    }

    @Override
    public TypeElement getOutType() {
        if (this.hasOutValue()) {
            return this.outValue().getType();
        }
        return null;
    }

    public void addDebugValue(Value value) {
        assert (value.hasLocalInfo());
        if (this.debugValues == null) {
            this.debugValues = Sets.newIdentityHashSet();
        }
        this.debugValues.add(value);
    }

    public final ValueType outType() {
        return this.outValue.outType();
    }

    public abstract void buildDex(DexBuilder var1);

    public abstract void buildCf(CfBuilder var1);

    public void replaceValue(Value oldValue, Value newValue) {
        for (int i = 0; i < this.inValues.size(); ++i) {
            if (oldValue != this.inValues.get(i)) continue;
            this.inValues.set(i, newValue);
            newValue.addUser(this);
        }
        oldValue.removeUser(this);
    }

    public void replaceValue(int index, Value newValue) {
        Value oldValue = this.inValues.get(index);
        this.inValues.set(index, newValue);
        newValue.addUser(this);
        oldValue.removeUser(this);
    }

    public void replaceDebugValue(Value oldValue, Value newValue) {
        assert (oldValue.hasLocalInfo());
        assert (newValue.hasLocalInfo());
        assert (newValue.getLocalInfo() == oldValue.getLocalInfo()) : "Replacing debug values with inconsistent locals " + oldValue.getLocalInfo() + " and " + newValue.getLocalInfo() + ". This is likely a code transformation bug that has not taken local information into account";
        boolean removed = this.debugValues.remove(oldValue);
        assert (removed);
        if (removed && newValue.hasLocalInfo()) {
            newValue.addDebugLocalEnd(this);
        }
    }

    public void moveDebugValues(Instruction target) {
        if (this.debugValues == null) {
            return;
        }
        for (Value value : this.debugValues) {
            value.replaceDebugUser(this, target);
        }
        this.debugValues.clear();
    }

    public void removeDebugValue(Value value) {
        assert (value.hasLocalInfo());
        if (this.debugValues != null) {
            assert (this.debugValues.contains(value));
            if (this.debugValues.remove(value)) {
                value.removeDebugUser(this);
            }
            return;
        }
        assert (false);
    }

    public Value removeDebugValue(DebugLocalInfo localInfo) {
        if (this.debugValues != null) {
            Iterator<Value> it = this.debugValues.iterator();
            while (it.hasNext()) {
                Value value = it.next();
                if (!value.hasLocalInfo() || value.getLocalInfo() != localInfo) continue;
                it.remove();
                value.removeDebugUser(this);
                return value;
            }
        }
        return null;
    }

    public void clearDebugValues() {
        if (this.debugValues != null) {
            for (Value debugValue : this.debugValues) {
                debugValue.removeDebugUser(this);
            }
            this.debugValues.clear();
        }
    }

    @Override
    public BasicBlock getBlock() {
        assert (this.block != null);
        return this.block;
    }

    public void setBlock(BasicBlock block) {
        assert (block != null);
        this.block = block;
    }

    public void clearBlock() {
        assert (this.block != null);
        this.block = null;
    }

    public void removeOrReplaceByDebugLocalRead(IRCode code) {
        this.getBlock().listIterator(code, this).removeOrReplaceByDebugLocalRead();
    }

    public void replace(Instruction newInstruction, IRCode code) {
        this.replace(newInstruction, code, null);
    }

    public void replace(Instruction newInstruction, IRCode code, Set<Value> affectedValues) {
        this.getBlock().listIterator(code, this).replaceCurrentInstruction(newInstruction, affectedValues);
    }

    public boolean hasBlock() {
        return this.block != null;
    }

    public String getInstructionName() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getInstructionName());
        for (int i = builder.length(); i < 20; ++i) {
            builder.append(" ");
        }
        builder.append(" ");
        if (this.outValue != null) {
            builder.append(this.outValue);
            builder.append(" <- ");
        }
        if (!this.inValues.isEmpty()) {
            StringUtils.append(builder, this.inValues, ", ", StringUtils.BraceType.NONE);
        }
        return builder.toString();
    }

    public void print(CfgPrinter printer) {
        String value;
        int uses = 0;
        if (this.outValue == null) {
            value = printer.makeUnusedValue();
        } else {
            if (this.outValue.hasUsersInfo()) {
                uses = this.outValue.uniqueUsers().size() + this.outValue.uniquePhiUsers().size();
            }
            value = "v" + this.outValue.getNumber();
        }
        printer.print(0).sp().append(uses).sp().append(value).sp().append(this.getClass().getSimpleName());
        for (Value in : this.inValues) {
            printer.append(" v").append(in.getNumber());
        }
    }

    public void printLIR(CfgPrinter printer) {
        printer.print(this.number).sp().append(this.toString());
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        assert (number != -1);
        this.number = number;
    }

    public void clearNumber() {
        this.number = -1;
    }

    public abstract boolean identicalNonValueNonPositionParts(Instruction var1);

    public boolean identicalNonValueParts(Instruction other) {
        assert (this.getClass() == other.getClass());
        return this.position.equals(other.position) && this.identicalNonValueNonPositionParts(other);
    }

    public boolean identicalAfterRegisterAllocation(Instruction other, RegisterAllocator allocator, MethodConversionOptions conversionOptions) {
        if (other.getClass() != this.getClass()) {
            return false;
        }
        if (this.instructionTypeCanThrow() || allocator.options().debug ? !this.identicalNonValueParts(other) : !this.identicalNonValueNonPositionParts(other)) {
            return false;
        }
        if (this.isInvokeDirect() && !this.asInvokeDirect().sameConstructorReceiverValue(other.asInvoke())) {
            return false;
        }
        if (this.outValue != null) {
            if (other.outValue == null) {
                return false;
            }
            if (!this.identicalOutputAfterRegisterAllocation(this.outValue, this.getNumber(), other.outValue, other.getNumber(), allocator)) {
                return false;
            }
        } else if (other.outValue != null) {
            return false;
        }
        if (this.inValues.size() != other.inValues.size()) {
            return false;
        }
        for (int j = 0; j < this.inValues.size(); ++j) {
            Value in0 = this.inValues.get(j);
            Value in1 = other.inValues.get(j);
            if (this.identicalInputAfterRegisterAllocation(in0, this.getNumber(), other, in1, other.getNumber(), allocator)) continue;
            return false;
        }
        InternalOptions options = allocator.options();
        return !conversionOptions.isGeneratingDex() || DexBuilder.identicalInstructionsAfterBuildingDexCode(this, other, allocator, conversionOptions);
    }

    public boolean isAllowedAfterThrowingInstruction() {
        return false;
    }

    public boolean isBlockLocalInstructionWithoutSideEffects(AppView<?> appView, ProgramMethod context) {
        return this.definesBlockLocalValue() && !this.instructionMayHaveSideEffects(appView, context);
    }

    public boolean instructionTypeCanBeCanonicalized() {
        return false;
    }

    public boolean instructionTypeCanThrow() {
        return false;
    }

    public boolean instructionInstanceCanThrow() {
        return this.instructionTypeCanThrow();
    }

    public boolean instructionMayHaveSideEffects(AppView<?> appView, ProgramMethod context) {
        return this.instructionMayHaveSideEffects(appView, context, SideEffectAssumption.NONE);
    }

    public boolean instructionMayHaveSideEffects(AppView<?> appView, ProgramMethod context, SideEffectAssumption assumption) {
        return this.instructionInstanceCanThrow();
    }

    public abstract boolean instructionMayTriggerMethodInvocation(AppView<?> var1, ProgramMethod var2);

    public boolean instructionInstanceCanThrow(AppView<?> appView, ProgramMethod context) {
        return this.instructionInstanceCanThrow();
    }

    public DeadCodeRemover.DeadInstructionResult canBeDeadCode(AppView<?> appView, IRCode code) {
        return this.instructionMayHaveSideEffects(appView, code.context()) ? DeadCodeRemover.DeadInstructionResult.notDead() : DeadCodeRemover.DeadInstructionResult.deadIfOutValueIsDead();
    }

    public AbstractFieldSet readSet(AppView<AppInfoWithLiveness> appView, ProgramMethod context) {
        if (this.instructionMayTriggerMethodInvocation(appView, context) && this.instructionMayHaveSideEffects(appView, context)) {
            return UnknownFieldSet.getInstance();
        }
        return EmptyFieldSet.getInstance();
    }

    public boolean needsValueInRegister(Value value) {
        return true;
    }

    public boolean isTwoAddr(RegisterAllocator allocator) {
        return false;
    }

    public boolean isOutConstant() {
        return false;
    }

    public ConstInstruction getOutConstantConstInstruction() {
        return null;
    }

    public abstract int maxInValueRegister();

    public abstract int maxOutValueRegister();

    @Override
    public DebugLocalInfo getLocalInfo() {
        return this.outValue == null ? null : this.outValue.getLocalInfo();
    }

    public Set<Value> getDebugValues() {
        return this.debugValues != null ? this.debugValues : ImmutableSet.of();
    }

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public Instruction asInstruction() {
        return this;
    }

    public boolean isRecordFieldValues() {
        return false;
    }

    public RecordFieldValues asRecordFieldValues() {
        return null;
    }

    public boolean isArrayAccess() {
        return false;
    }

    public ArrayAccess asArrayAccess() {
        return null;
    }

    public boolean isArrayGet() {
        return false;
    }

    public ArrayGet asArrayGet() {
        return null;
    }

    public boolean isArrayLength() {
        return false;
    }

    public ArrayLength asArrayLength() {
        return null;
    }

    public boolean isArrayPut() {
        return false;
    }

    public ArrayPut asArrayPut() {
        return null;
    }

    public boolean isArgument() {
        return false;
    }

    public Argument asArgument() {
        return null;
    }

    public boolean isUnusedArgument() {
        return false;
    }

    public UnusedArgument asUnusedArgument() {
        return null;
    }

    public boolean isArithmeticBinop() {
        return false;
    }

    public ArithmeticBinop asArithmeticBinop() {
        return null;
    }

    public boolean isAssume() {
        return false;
    }

    public Assume asAssume() {
        return null;
    }

    public final boolean isAssumeWithDynamicTypeAssumption() {
        return this.isAssume() && this.asAssume().hasDynamicTypeAssumption();
    }

    public final boolean isAssumeWithNonNullAssumption() {
        return this.isAssume() && this.asAssume().hasNonNullAssumption();
    }

    public boolean isBinop() {
        return false;
    }

    public Binop asBinop() {
        return null;
    }

    public boolean isUnop() {
        return false;
    }

    public Unop asUnop() {
        return null;
    }

    public boolean isCheckCast() {
        return false;
    }

    public CheckCast asCheckCast() {
        return null;
    }

    public boolean isSafeCheckCast() {
        return false;
    }

    public SafeCheckCast asSafeCheckCast() {
        return null;
    }

    public boolean isConstNumber() {
        return false;
    }

    public ConstNumber asConstNumber() {
        return null;
    }

    public boolean isConstInstruction() {
        return false;
    }

    public ConstInstruction asConstInstruction() {
        return null;
    }

    public boolean isConstClass() {
        return false;
    }

    public ConstClass asConstClass() {
        return null;
    }

    public boolean isConstMethodHandle() {
        return false;
    }

    public ConstMethodHandle asConstMethodHandle() {
        return null;
    }

    public boolean isConstMethodType() {
        return false;
    }

    public ConstMethodType asConstMethodType() {
        return null;
    }

    public boolean isConstString() {
        return false;
    }

    public ConstString asConstString() {
        return null;
    }

    public boolean isDexItemBasedConstString() {
        return false;
    }

    public DexItemBasedConstString asDexItemBasedConstString() {
        return null;
    }

    public boolean isCmp() {
        return false;
    }

    public Cmp asCmp() {
        return null;
    }

    public boolean isDup() {
        return false;
    }

    public Dup asDup() {
        return null;
    }

    public boolean isDup2() {
        return false;
    }

    public Dup2 asDup2() {
        return null;
    }

    public boolean isJumpInstruction() {
        return false;
    }

    public JumpInstruction asJumpInstruction() {
        return null;
    }

    public boolean isFieldInstruction() {
        return false;
    }

    public FieldInstruction asFieldInstruction() {
        return null;
    }

    public boolean isGoto() {
        return false;
    }

    public Goto asGoto() {
        return null;
    }

    public boolean isIf() {
        return false;
    }

    public If asIf() {
        return null;
    }

    public boolean isSwitch() {
        return false;
    }

    public Switch asSwitch() {
        return null;
    }

    public boolean isIntSwitch() {
        return false;
    }

    public IntSwitch asIntSwitch() {
        return null;
    }

    public boolean isStringSwitch() {
        return false;
    }

    public StringSwitch asStringSwitch() {
        return null;
    }

    public boolean isInstanceFieldInstruction() {
        return false;
    }

    public InstanceFieldInstruction asInstanceFieldInstruction() {
        return null;
    }

    public boolean isInstanceGet() {
        return false;
    }

    public InstanceGet asInstanceGet() {
        return null;
    }

    public boolean isInstanceOf() {
        return false;
    }

    public InstanceOf asInstanceOf() {
        return null;
    }

    public boolean isFieldGet() {
        return false;
    }

    public FieldGet asFieldGet() {
        return null;
    }

    public boolean isFieldPut() {
        return false;
    }

    public FieldPut asFieldPut() {
        return null;
    }

    public boolean isInstancePut() {
        return false;
    }

    public InstancePut asInstancePut() {
        return null;
    }

    public boolean isInvoke() {
        return false;
    }

    public Invoke asInvoke() {
        return null;
    }

    public boolean isMonitor() {
        return false;
    }

    public boolean isMonitorEnter() {
        return false;
    }

    public Monitor asMonitor() {
        return null;
    }

    public boolean isMove() {
        return false;
    }

    public Move asMove() {
        return null;
    }

    public boolean isNewArrayEmpty() {
        return false;
    }

    public NewArrayEmpty asNewArrayEmpty() {
        return null;
    }

    public boolean isNewArrayFilledData() {
        return false;
    }

    public NewArrayFilledData asNewArrayFilledData() {
        return null;
    }

    public boolean isNeg() {
        return false;
    }

    public Neg asNeg() {
        return null;
    }

    public boolean isNewInstance() {
        return false;
    }

    public NewInstance asNewInstance() {
        return null;
    }

    public boolean isNewUnboxedEnumInstance() {
        return false;
    }

    public NewUnboxedEnumInstance asNewUnboxedEnumInstance() {
        return null;
    }

    public boolean isNot() {
        return false;
    }

    public Not asNot() {
        return null;
    }

    public boolean isNumberConversion() {
        return false;
    }

    public NumberConversion asNumberConversion() {
        return null;
    }

    public boolean isReturn() {
        return false;
    }

    public Return asReturn() {
        return null;
    }

    public boolean isThrow() {
        return false;
    }

    public Throw asThrow() {
        return null;
    }

    public boolean isStaticFieldInstruction() {
        return false;
    }

    public boolean isStaticGet() {
        return false;
    }

    public StaticGet asStaticGet() {
        return null;
    }

    public boolean isStaticPut() {
        return false;
    }

    public StaticPut asStaticPut() {
        return null;
    }

    public boolean isInitClass() {
        return false;
    }

    public InitClass asInitClass() {
        return null;
    }

    public boolean isAdd() {
        return false;
    }

    public Add asAdd() {
        return null;
    }

    public boolean isSub() {
        return false;
    }

    public Sub asSub() {
        return null;
    }

    public boolean isMul() {
        return false;
    }

    public Mul asMul() {
        return null;
    }

    public boolean isDiv() {
        return false;
    }

    public Div asDiv() {
        return null;
    }

    public boolean isRem() {
        return false;
    }

    public Rem asRem() {
        return null;
    }

    public boolean isLogicalBinop() {
        return false;
    }

    public LogicalBinop asLogicalBinop() {
        return null;
    }

    public boolean isShl() {
        return false;
    }

    public Shl asShl() {
        return null;
    }

    public boolean isShr() {
        return false;
    }

    public Shr asShr() {
        return null;
    }

    public boolean isUshr() {
        return false;
    }

    public Ushr asUshr() {
        return null;
    }

    public boolean isAnd() {
        return false;
    }

    public And asAnd() {
        return null;
    }

    public boolean isOr() {
        return false;
    }

    public Or asOr() {
        return null;
    }

    public boolean isXor() {
        return false;
    }

    public Xor asXor() {
        return null;
    }

    public boolean isMoveException() {
        return false;
    }

    public MoveException asMoveException() {
        return null;
    }

    public boolean isDebugInstruction() {
        return this.isDebugPosition() || this.isDebugLocalsChange() || this.isDebugLocalRead() || this.isDebugLocalWrite() || this.isDebugLocalUninitialized();
    }

    public boolean isDebugPosition() {
        return false;
    }

    public DebugPosition asDebugPosition() {
        return null;
    }

    public boolean isDebugLocalsChange() {
        return false;
    }

    public DebugLocalsChange asDebugLocalsChange() {
        return null;
    }

    public boolean isDebugLocalUninitialized() {
        return false;
    }

    public DebugLocalUninitialized asDebugLocalUninitialized() {
        return null;
    }

    public boolean isDebugLocalWrite() {
        return false;
    }

    public DebugLocalWrite asDebugLocalWrite() {
        return null;
    }

    public boolean isInvokeMethodWithDynamicDispatch() {
        return this.isInvokeInterface() || this.isInvokeVirtual();
    }

    public boolean isInvokeMethod() {
        return false;
    }

    public InvokeMethod asInvokeMethod() {
        return null;
    }

    public boolean isInvokeMethodWithReceiver() {
        return false;
    }

    public InvokeMethodWithReceiver asInvokeMethodWithReceiver() {
        return null;
    }

    public boolean isInvokeNewArray() {
        return false;
    }

    public InvokeNewArray asInvokeNewArray() {
        return null;
    }

    public boolean isInvokeMultiNewArray() {
        return false;
    }

    public InvokeMultiNewArray asInvokeMultiNewArray() {
        return null;
    }

    public boolean isInvokeCustom() {
        return false;
    }

    public InvokeCustom asInvokeCustom() {
        return null;
    }

    public boolean isInvokeConstructor(DexItemFactory dexItemFactory) {
        return false;
    }

    public boolean isInvokeDirect() {
        return false;
    }

    public InvokeDirect asInvokeDirect() {
        return null;
    }

    public boolean isInvokeInterface() {
        return false;
    }

    public InvokeInterface asInvokeInterface() {
        return null;
    }

    public boolean isInvokeStatic() {
        return false;
    }

    public InvokeStatic asInvokeStatic() {
        return null;
    }

    public boolean isInvokeSuper() {
        return false;
    }

    public InvokeSuper asInvokeSuper() {
        return null;
    }

    public boolean isInvokeVirtual() {
        return false;
    }

    public InvokeVirtual asInvokeVirtual() {
        return null;
    }

    public boolean isInvokePolymorphic() {
        return false;
    }

    public InvokePolymorphic asInvokePolymorphic() {
        return null;
    }

    public boolean isDebugLocalRead() {
        return false;
    }

    public DebugLocalRead asDebugLocalRead() {
        return null;
    }

    public boolean isPop() {
        return false;
    }

    public Pop asPop() {
        return null;
    }

    public boolean isStore() {
        return false;
    }

    public Store asStore() {
        return null;
    }

    public boolean isSwap() {
        return false;
    }

    public Swap asSwap() {
        return null;
    }

    public boolean isLoad() {
        return false;
    }

    public Load asLoad() {
        return null;
    }

    public boolean canBeFolded() {
        return false;
    }

    public boolean couldIntroduceAnAlias(AppView<?> appView, Value root) {
        return false;
    }

    public boolean isIntroducingAnAlias() {
        return false;
    }

    public Value getAliasForOutValue() {
        assert (this.isIntroducingAnAlias());
        return null;
    }

    public boolean isCreatingArray() {
        return this.isNewArrayEmpty() || this.isNewArrayFilledData() || this.isInvokeNewArray() || this.isInvokeMultiNewArray() || this.isRecordFieldValues();
    }

    public boolean isCreatingInstanceOrArray() {
        return this.isNewInstance() || this.isCreatingArray();
    }

    public abstract Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints var1, ProgramMethod var2);

    public abstract void insertLoadAndStores(InstructionListIterator var1, LoadStoreHelper var2);

    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        assert (this.outValue == null || !this.outValue.getType().isReferenceType());
        throw new Unreachable("Instruction without object outValue cannot compute verification type");
    }

    public abstract boolean hasInvariantOutType();

    public LatticeElement evaluate(IRCode code, Function<Value, LatticeElement> getLatticeElement) {
        if (this.outValue.hasValueRange()) {
            return new ConstRangeLatticeElement(this.outValue);
        }
        return Bottom.getInstance();
    }

    public TypeElement evaluate(AppView<?> appView) {
        assert (this.outValue == null);
        throw new Unimplemented("Implement type lattice evaluation for: " + this.getInstructionName());
    }

    public boolean verifyTypes(AppView<?> appView, VerifyTypesHelper verifyTypesHelper) {
        if (this.outValue != null) {
            TypeElement outTypeElement = this.outValue.getType();
            if (outTypeElement.isArrayType()) {
                DexType outBaseType = outTypeElement.asArrayType().toDexType(appView.dexItemFactory()).toBaseType(appView.dexItemFactory());
                assert (appView.graphLens().lookupType(outBaseType) == outBaseType);
            } else if (outTypeElement.isClassType()) {
                DexType outType = outTypeElement.asClassType().getClassType();
                assert (appView.graphLens().lookupType(outType) == outType);
            }
        }
        return true;
    }

    public boolean throwsNpeIfValueIsNull(Value value, AppView<?> appView, ProgramMethod context) {
        return false;
    }

    public boolean throwsOnNullInput() {
        return false;
    }

    public Value getNonNullInput() {
        throw new Unreachable("Should conform to throwsOnNullInput.");
    }

    public boolean definitelyTriggersClassInitialization(DexType clazz, ProgramMethod context, AppView<AppInfoWithLiveness> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return false;
    }

    public boolean verifyValidPositionInfo(boolean debug) {
        assert (this.position != null);
        assert (!debug || this.getPosition().isSome());
        assert (!this.instructionTypeCanThrow() || this.isConstString() || this.isDexItemBasedConstString() || this.getPosition().isSome() || this.getPosition().isSyntheticNone());
        return true;
    }

    public boolean outTypeKnownToBeBoolean(Set<Phi> seen) {
        return false;
    }

    public static abstract class BuilderBase<B extends BuilderBase<B, I>, I extends Instruction> {
        protected Value outValue;
        protected Position position;

        public abstract I build();

        public abstract B self();

        final I amend(I instruction) {
            if (this.position != null) {
                ((Instruction)instruction).setPosition(this.position);
            }
            return instruction;
        }

        public B setOutValue(Value outValue) {
            this.outValue = outValue;
            return this.self();
        }

        public B setFreshOutValue(ValueFactory factory, TypeElement type) {
            return this.setFreshOutValue(factory, type, null);
        }

        public B setFreshOutValue(ValueFactory factory, TypeElement type, DebugLocalInfo localInfo) {
            return this.setOutValue(factory.createValue(type, localInfo));
        }

        public B setPosition(Position position) {
            this.position = position;
            return this.self();
        }

        public B setPosition(Instruction other) {
            return this.setPosition(other.getPosition());
        }
    }

    public static class SideEffectAssumption {
        public static final SideEffectAssumption NONE = new SideEffectAssumption();
        public static final SideEffectAssumption CLASS_ALREADY_INITIALIZED = new SideEffectAssumption(){

            @Override
            public boolean canAssumeClassIsAlreadyInitialized() {
                return true;
            }
        };
        public static final SideEffectAssumption IGNORE_RECEIVER_FIELD_ASSIGNMENTS = new SideEffectAssumption(){

            @Override
            public boolean canIgnoreInstanceFieldAssignmentsToReceiver() {
                return true;
            }
        };
        public static final SideEffectAssumption INVOKED_METHOD_DOES_NOT_HAVE_SIDE_EFFECTS = new SideEffectAssumption(){

            @Override
            public boolean canAssumeInvokedMethodDoesNotHaveSideEffects() {
                return true;
            }
        };
        public static final SideEffectAssumption RECEIVER_NOT_NULL = new SideEffectAssumption(){

            @Override
            public boolean canAssumeReceiverIsNotNull() {
                return true;
            }
        };

        public boolean canAssumeClassIsAlreadyInitialized() {
            return false;
        }

        public boolean canAssumeInvokedMethodDoesNotHaveSideEffects() {
            return false;
        }

        public boolean canIgnoreInstanceFieldAssignmentsToReceiver() {
            return false;
        }

        public boolean canAssumeReceiverIsNotNull() {
            return false;
        }

        public SideEffectAssumption join(final SideEffectAssumption other) {
            return new SideEffectAssumption(){

                @Override
                public boolean canAssumeClassIsAlreadyInitialized() {
                    return this.canAssumeClassIsAlreadyInitialized() || other.canAssumeClassIsAlreadyInitialized();
                }

                @Override
                public boolean canAssumeInvokedMethodDoesNotHaveSideEffects() {
                    return this.canAssumeInvokedMethodDoesNotHaveSideEffects() || other.canAssumeInvokedMethodDoesNotHaveSideEffects();
                }

                @Override
                public boolean canAssumeReceiverIsNotNull() {
                    return this.canAssumeInvokedMethodDoesNotHaveSideEffects() || other.canAssumeInvokedMethodDoesNotHaveSideEffects();
                }
            };
        }
    }
}

