/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.Format11x;
import com.android.tools.r8.code.MoveResult;
import com.android.tools.r8.code.MoveResultObject;
import com.android.tools.r8.code.MoveResultWide;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeInterface;
import com.android.tools.r8.ir.code.InvokeMultiNewArray;
import com.android.tools.r8.ir.code.InvokeNewArray;
import com.android.tools.r8.ir.code.InvokePolymorphic;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeSuper;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.utils.BooleanUtils;
import java.util.List;
import java.util.Set;

public abstract class Invoke
extends Instruction {
    private static final int NO_SUCH_DEX_INSTRUCTION = -1;

    protected Invoke(Value result, List<Value> arguments) {
        super(result, arguments);
    }

    @Deprecated
    public static Invoke create(Type type, DexItem target, DexProto proto, Value result, List<Value> arguments) {
        return Invoke.create(type, target, proto, result, arguments, false);
    }

    public static Invoke create(Type type, DexItem target, DexProto proto, Value result, List<Value> arguments, boolean itf) {
        switch (type) {
            case DIRECT: {
                return new InvokeDirect((DexMethod)target, result, arguments, itf);
            }
            case INTERFACE: {
                return new InvokeInterface((DexMethod)target, result, arguments);
            }
            case STATIC: {
                return new InvokeStatic((DexMethod)target, result, arguments, itf);
            }
            case SUPER: {
                return new InvokeSuper((DexMethod)target, result, arguments, itf);
            }
            case VIRTUAL: {
                return new InvokeVirtual((DexMethod)target, result, arguments);
            }
            case NEW_ARRAY: {
                return new InvokeNewArray((DexType)target, result, arguments);
            }
            case MULTI_NEW_ARRAY: {
                return new InvokeMultiNewArray((DexType)target, result, arguments);
            }
            case CUSTOM: {
                throw new Unreachable("Use InvokeCustom constructor instead");
            }
            case POLYMORPHIC: {
                return new InvokePolymorphic((DexMethod)target, proto, result, arguments);
            }
        }
        throw new Unreachable("Unknown invoke type: " + (Object)((Object)type));
    }

    private boolean argumentsAreConsecutiveInputArguments() {
        if (this.arguments().size() == 0) {
            return false;
        }
        Value current = this.arguments().get(0);
        if (!current.isArgument()) {
            return false;
        }
        for (int i = 1; i < this.arguments().size(); ++i) {
            Value next = this.arguments().get(i);
            if (current.getNextConsecutive() != next) {
                return false;
            }
            current = next;
        }
        return true;
    }

    public abstract Type getType();

    public abstract DexType getReturnType();

    public boolean hasArguments() {
        return !this.arguments().isEmpty();
    }

    public boolean hasReturnTypeVoid(DexItemFactory factory) {
        return this.getReturnType() == factory.voidType;
    }

    public List<Value> arguments() {
        return this.inValues;
    }

    public Value getArgument(int index) {
        assert (index < this.arguments().size());
        return this.arguments().get(index);
    }

    public Value getArgumentForParameter(int index) {
        int offset = BooleanUtils.intValue(!this.isInvokeStatic());
        return this.getArgument(index + offset);
    }

    public Value getFirstArgument() {
        return this.getArgument(0);
    }

    public Value getLastArgument() {
        return this.getArgument(this.arguments().size() - 1);
    }

    public int requiredArgumentRegisters() {
        int registers = 0;
        for (Value inValue : this.inValues) {
            registers += inValue.requiredRegisters();
        }
        return registers;
    }

    protected int argumentRegisterValue(int i, DexBuilder builder) {
        assert (this.needsRangedInvoke(builder));
        if (i < this.arguments().size()) {
            return builder.argumentOrAllocateRegister(this.arguments().get(i), this.getNumber());
        }
        return 0;
    }

    protected int fillArgumentRegisters(DexBuilder builder, int[] registers) {
        assert (!this.needsRangedInvoke(builder));
        int i = 0;
        for (Value value : this.arguments()) {
            int register = builder.argumentOrAllocateRegister(value, this.getNumber());
            if (register + value.requiredRegisters() - 1 > 15) {
                register = builder.allocatedRegister(value, this.getNumber());
            }
            assert (register + value.requiredRegisters() - 1 <= 15);
            for (int j = 0; j < value.requiredRegisters(); ++j) {
                assert (i < 5);
                registers[i++] = register++;
            }
        }
        return i;
    }

    protected boolean argumentsConsecutive(DexBuilder builder) {
        Value value = this.arguments().get(0);
        int next = builder.argumentOrAllocateRegister(value, this.getNumber()) + value.requiredRegisters();
        for (int i = 1; i < this.arguments().size(); ++i) {
            value = this.arguments().get(i);
            assert (next == builder.argumentOrAllocateRegister(value, this.getNumber()));
            next += value.requiredRegisters();
        }
        return true;
    }

    protected void addInvokeAndMoveResult(com.android.tools.r8.code.Instruction instruction, DexBuilder builder) {
        if (this.outValue != null && this.outValue.needsRegister()) {
            Format11x moveResult;
            TypeElement moveType = this.outValue.getType();
            int register = builder.allocatedRegister(this.outValue, this.getNumber());
            if (moveType.isSinglePrimitive()) {
                moveResult = new MoveResult(register);
            } else if (moveType.isWidePrimitive()) {
                moveResult = new MoveResultWide(register);
            } else if (moveType.isReferenceType()) {
                moveResult = new MoveResultObject(register);
            } else {
                throw new Unreachable("Unexpected result type " + this.outType());
            }
            builder.add((Instruction)this, instruction, moveResult);
        } else {
            builder.add((Instruction)this, instruction);
        }
    }

    @Override
    public boolean couldIntroduceAnAlias(AppView<?> appView, Value root) {
        assert (root != null && root.getType().isReferenceType());
        if (this.outValue == null) {
            return false;
        }
        TypeElement outType = this.outValue.getType();
        if (outType.isPrimitiveType()) {
            return false;
        }
        if (((AppInfo)appView.appInfo()).hasLiveness() && outType.isClassType() && root.getType().isClassType() && ((AppInfo)appView.appInfo()).withLiveness().inDifferentHierarchy(outType.asClassType().getClassType(), root.getType().asClassType().getClassType())) {
            return false;
        }
        return outType.isReferenceType();
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public int maxInValueRegister() {
        if (this.arguments().size() == 1 || this.requiredArgumentRegisters() > 5 || this.argumentsAreConsecutiveInputArguments()) {
            return 65535;
        }
        return 15;
    }

    protected boolean needsRangedInvoke(DexBuilder builder) {
        boolean registersGuaranteedToBeConsecutive;
        if (this.requiredArgumentRegisters() > 5) {
            return true;
        }
        boolean bl = registersGuaranteedToBeConsecutive = this.arguments().size() == 1 || this.argumentsAreConsecutiveInputArguments();
        if (!registersGuaranteedToBeConsecutive) {
            return false;
        }
        assert (this.argumentsConsecutive(builder));
        int registerStart = builder.argumentOrAllocateRegister(this.arguments().get(0), this.getNumber());
        int registerEnd = registerStart + this.requiredArgumentRegisters() - 1;
        return registerEnd > 15;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    protected abstract String getTypeString();

    @Override
    public String getInstructionName() {
        return "Invoke-" + this.getTypeString();
    }

    @Override
    public boolean isInvoke() {
        return true;
    }

    @Override
    public Invoke asInvoke() {
        return this;
    }

    @Override
    public TypeElement evaluate(AppView<?> appView) {
        DexType returnType = this.getReturnType();
        if (returnType.isVoidType()) {
            throw new Unreachable("void methods have no type.");
        }
        return TypeElement.fromDexType(returnType, Nullability.maybeNull(), appView);
    }

    @Override
    public boolean outTypeKnownToBeBoolean(Set<Phi> seen) {
        return this.getReturnType().isBooleanType();
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type DIRECT = new Type(112, 118);
        public static final /* enum */ Type INTERFACE = new Type(114, 120);
        public static final /* enum */ Type STATIC = new Type(113, 119);
        public static final /* enum */ Type SUPER = new Type(111, 117);
        public static final /* enum */ Type VIRTUAL = new Type(110, 116);
        public static final /* enum */ Type NEW_ARRAY = new Type(35, -1);
        public static final /* enum */ Type MULTI_NEW_ARRAY = new Type(-1, -1);
        public static final /* enum */ Type CUSTOM = new Type(252, 253);
        public static final /* enum */ Type POLYMORPHIC = new Type(250, 251);
        private static final /* synthetic */ Type[] $VALUES;
        private final int dexOpcode;
        private final int dexOpcodeRange;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(int dexOpcode, int dexOpcodeRange) {
            this.dexOpcode = dexOpcode;
            this.dexOpcodeRange = dexOpcodeRange;
        }

        public static Type fromCfOpcode(int opcode, DexMethod invokedMethod, DexClassAndMethod context, AppView<?> appView) {
            return Type.fromCfOpcode(opcode, invokedMethod, context, appView, appView.codeLens());
        }

        public static Type fromCfOpcode(int opcode, DexMethod invokedMethod, DexClassAndMethod context, AppView<?> appView, GraphLens codeLens) {
            switch (opcode) {
                case 185: {
                    return INTERFACE;
                }
                case 183: {
                    return Type.fromInvokeSpecial(invokedMethod, context, appView, codeLens);
                }
                case 184: {
                    return STATIC;
                }
                case 182: {
                    return appView.dexItemFactory().polymorphicMethods.isPolymorphicInvoke(invokedMethod) ? POLYMORPHIC : VIRTUAL;
                }
            }
            throw new Unreachable("unknown CfInvoke opcode " + opcode);
        }

        public static Type fromInvokeSpecial(DexMethod invokedMethod, DexClassAndMethod context, AppView<?> appView) {
            return Type.fromInvokeSpecial(invokedMethod, context, appView, appView.codeLens());
        }

        public static Type fromInvokeSpecial(DexMethod invokedMethod, DexClassAndMethod context, AppView<?> appView, GraphLens codeLens) {
            boolean originalContextIsInterface;
            if (invokedMethod.isInstanceInitializer(appView.dexItemFactory())) {
                return DIRECT;
            }
            GraphLens graphLens = appView.graphLens();
            DexMethod originalContext = graphLens.getOriginalMethodSignature((DexMethod)context.getReference(), codeLens);
            if (invokedMethod.getHolderType() != originalContext.getHolderType()) {
                return SUPER;
            }
            GraphLens.MethodLookupResult lookupResult = graphLens.lookupMethod(invokedMethod, (DexMethod)context.getReference(), DIRECT);
            if (lookupResult.getType().isVirtual()) {
                return DIRECT;
            }
            DexEncodedMethod definition = context.getHolder().lookupMethod((DexMethod)lookupResult.getReference());
            if (definition == null) {
                return SUPER;
            }
            DexType originalHolderOfDefinition = graphLens.getOriginalMethodSignature((DexMethod)definition.getReference(), codeLens).getHolderType();
            if (originalHolderOfDefinition != originalContext.getHolderType()) {
                return SUPER;
            }
            boolean bl = originalContextIsInterface = context.getHolder().isInterface() || appView.hasVerticallyMergedClasses() && appView.verticallyMergedClasses().hasInterfaceBeenMergedIntoSubtype(originalContext.getHolderType());
            if (originalContextIsInterface) {
                if (definition.belongsToVirtualPool()) {
                    return SUPER;
                }
            } else assert (definition.isPrivate() || lookupResult.getType().isVirtual());
            return DIRECT;
        }

        static {
            $VALUES = new Type[]{DIRECT, INTERFACE, STATIC, SUPER, VIRTUAL, NEW_ARRAY, MULTI_NEW_ARRAY, CUSTOM, POLYMORPHIC};
        }

        public int getCfOpcode() {
            switch (this) {
                case DIRECT: {
                    return 183;
                }
                case INTERFACE: {
                    return 185;
                }
                case POLYMORPHIC: {
                    return 182;
                }
                case STATIC: {
                    return 184;
                }
                case SUPER: {
                    return 183;
                }
                case VIRTUAL: {
                    return 182;
                }
            }
            throw new Unreachable();
        }

        public int getDexOpcode() {
            assert (this.dexOpcode >= 0);
            return this.dexOpcode;
        }

        public int getDexOpcodeRange() {
            assert (this.dexOpcodeRange >= 0);
            return this.dexOpcodeRange;
        }

        public boolean isDirect() {
            return this == DIRECT;
        }

        public boolean isInterface() {
            return this == INTERFACE;
        }

        public boolean isStatic() {
            return this == STATIC;
        }

        public boolean isSuper() {
            return this == SUPER;
        }

        public boolean isVirtual() {
            return this == VIRTUAL;
        }

        public DexMethodHandle.MethodHandleType toMethodHandle(DexMethod targetMethod) {
            switch (this) {
                case STATIC: {
                    return DexMethodHandle.MethodHandleType.INVOKE_STATIC;
                }
                case VIRTUAL: {
                    return DexMethodHandle.MethodHandleType.INVOKE_INSTANCE;
                }
                case DIRECT: {
                    if (targetMethod.name.toString().equals("<init>")) {
                        return DexMethodHandle.MethodHandleType.INVOKE_CONSTRUCTOR;
                    }
                    return DexMethodHandle.MethodHandleType.INVOKE_DIRECT;
                }
                case INTERFACE: {
                    return DexMethodHandle.MethodHandleType.INVOKE_INTERFACE;
                }
                case SUPER: {
                    return DexMethodHandle.MethodHandleType.INVOKE_SUPER;
                }
            }
            throw new Unreachable("Conversion to method handle with unexpected invoke type: " + (Object)((Object)this));
        }
    }
}

