/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.code.Base3Format;
import com.android.tools.r8.code.InvokeDirectRange;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.AbstractFieldSet;
import com.android.tools.r8.ir.analysis.modeling.LibraryMethodReadSetModeling;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.DeadCodeRemover;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.List;

public class InvokeDirect
extends InvokeMethodWithReceiver {
    private final boolean isInterface;

    public InvokeDirect(DexMethod target, Value result, List<Value> arguments) {
        this(target, result, arguments, false);
    }

    public InvokeDirect(DexMethod target, Value result, List<Value> arguments, boolean isInterface) {
        super(target, result, arguments);
        this.isInterface = isInterface;
        assert (!target.name.toString().equals("<init>") || result == null);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public int opcode() {
        return 33;
    }

    @Override
    public boolean getInterfaceBit() {
        return this.isInterface;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.DIRECT;
    }

    @Override
    protected String getTypeString() {
        return "Direct";
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Base3Format instruction;
        int argumentRegisters = this.requiredArgumentRegisters();
        builder.requestOutgoingRegisters(argumentRegisters);
        if (this.needsRangedInvoke(builder)) {
            assert (this.argumentsConsecutive(builder));
            int firstRegister = this.argumentRegisterValue(0, builder);
            instruction = new InvokeDirectRange(firstRegister, argumentRegisters, this.getInvokedMethod());
        } else {
            int[] individualArgumentRegisters = new int[5];
            int argumentRegistersCount = this.fillArgumentRegisters(builder, individualArgumentRegisters);
            instruction = new com.android.tools.r8.code.InvokeDirect(argumentRegistersCount, this.getInvokedMethod(), individualArgumentRegisters[0], individualArgumentRegisters[1], individualArgumentRegisters[2], individualArgumentRegisters[3], individualArgumentRegisters[4]);
        }
        this.addInvokeAndMoveResult(instruction, builder);
    }

    public boolean sameConstructorReceiverValue(Invoke other) {
        if (!this.getInvokedMethod().name.toString().equals("<init>")) {
            return true;
        }
        return this.inValues.get(0) == other.inValues.get(0);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInvokeDirect() && super.identicalNonValueNonPositionParts(other);
    }

    @Override
    public boolean isInvokeConstructor(DexItemFactory dexItemFactory) {
        return this.getInvokedMethod().isInstanceInitializer(dexItemFactory);
    }

    @Override
    public boolean isInvokeDirect() {
        return true;
    }

    @Override
    public InvokeDirect asInvokeDirect() {
        return this;
    }

    @Override
    public DexClassAndMethod lookupSingleTarget(AppView<?> appView, ProgramMethod context, DynamicType dynamicReceiverType) {
        DexEncodedMethod result;
        DexMethod invokedMethod = this.getInvokedMethod();
        if (((AppInfo)appView.appInfo()).hasLiveness()) {
            AppInfoWithLiveness appInfo = ((AppInfo)appView.appInfo()).withLiveness();
            result = appInfo.lookupDirectTarget(invokedMethod, context);
            assert (this.verifyD8LookupResult(result, ((AppInfo)appView.appInfo()).lookupDirectTargetOnItself(invokedMethod, context)));
        } else {
            result = ((AppInfo)appView.appInfo()).lookupDirectTargetOnItself(invokedMethod, context);
        }
        return DexEncodedMethod.asDexClassAndMethodOrNull(result, appView);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forInvokeDirect(this.getInvokedMethod(), context);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add((CfInstruction)new CfInvoke(183, this.getInvokedMethod(), this.isInterface), this);
    }

    @Override
    public boolean definitelyTriggersClassInitialization(DexType clazz, ProgramMethod context, AppView<AppInfoWithLiveness> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return ClassInitializationAnalysis.InstructionUtils.forInvokeDirect(this, clazz, appView, mode, assumption);
    }

    @Override
    public DeadCodeRemover.DeadInstructionResult canBeDeadCode(AppView<?> appView, IRCode code) {
        ProgramMethod context = code.context();
        if (this.instructionMayHaveSideEffects(appView, context, Instruction.SideEffectAssumption.IGNORE_RECEIVER_FIELD_ASSIGNMENTS)) {
            return DeadCodeRemover.DeadInstructionResult.notDead();
        }
        if (!this.getInvokedMethod().isInstanceInitializer(appView.dexItemFactory())) {
            return DeadCodeRemover.DeadInstructionResult.deadIfOutValueIsDead();
        }
        if (this.getReceiver().getAliasedValue() == code.getThis()) {
            return DeadCodeRemover.DeadInstructionResult.notDead();
        }
        return DeadCodeRemover.DeadInstructionResult.deadIfInValueIsDead(this.getReceiver());
    }

    @Override
    public AbstractFieldSet readSet(AppView<AppInfoWithLiveness> appView, ProgramMethod context) {
        DexClassAndMethod singleTarget;
        DexMethod invokedMethod = this.getInvokedMethod();
        if (appView.dexItemFactory().isConstructor(invokedMethod) && (singleTarget = this.lookupSingleTarget(appView, context)) != null && singleTarget.isProgramMethod()) {
            return ((DexEncodedMethod)singleTarget.getDefinition()).getOptimizationInfo().getInstanceInitializerInfo(this).readSet();
        }
        return LibraryMethodReadSetModeling.getModeledReadSetOrUnknown(appView, this);
    }

    public static class Builder
    extends InvokeMethod.Builder<Builder, InvokeDirect> {
        @Override
        public InvokeDirect build() {
            return this.amend(new InvokeDirect(this.method, this.outValue, this.arguments));
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

