/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.LookupResult;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.AbstractFieldSet;
import com.android.tools.r8.ir.analysis.modeling.LibraryMethodReadSetModeling;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.UnknownValue;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeInterface;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeSuper;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueFactory;
import com.android.tools.r8.ir.conversion.MethodConversionOptions;
import com.android.tools.r8.ir.optimize.DefaultInliningOracle;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.inliner.WhyAreYouNotInliningReporter;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.BooleanUtils;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;

public abstract class InvokeMethod
extends Invoke {
    private final DexMethod method;

    public InvokeMethod(DexMethod target, Value result, List<Value> arguments) {
        super(result, arguments);
        this.method = target;
    }

    public static InvokeMethod create(Invoke.Type type, DexMethod target, Value result, List<Value> arguments, boolean itf) {
        switch (type) {
            case DIRECT: {
                return new InvokeDirect(target, result, arguments, itf);
            }
            case INTERFACE: {
                return new InvokeInterface(target, result, arguments);
            }
            case STATIC: {
                return new InvokeStatic(target, result, arguments, itf);
            }
            case SUPER: {
                return new InvokeSuper(target, result, arguments, itf);
            }
            case VIRTUAL: {
                assert (!itf);
                return new InvokeVirtual(target, result, arguments);
            }
        }
        throw new Unreachable("Unexpected invoke type: " + (Object)((Object)type));
    }

    public Value getFirstNonReceiverArgument() {
        return this.getArgument(this.getFirstNonReceiverArgumentIndex());
    }

    public int getFirstNonReceiverArgumentIndex() {
        return BooleanUtils.intValue(this.isInvokeMethodWithReceiver());
    }

    public abstract boolean getInterfaceBit();

    @Override
    public DexType getReturnType() {
        return this.method.proto.returnType;
    }

    public DexMethod getInvokedMethod() {
        return this.method;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInvokeMethod() && this.method == other.asInvokeMethod().getInvokedMethod();
    }

    @Override
    public String toString() {
        return super.toString() + "; method: " + this.method.toSourceString();
    }

    @Override
    public boolean isInvokeMethod() {
        return true;
    }

    @Override
    public InvokeMethod asInvokeMethod() {
        return this;
    }

    public abstract DexClassAndMethod lookupSingleTarget(AppView<?> var1, ProgramMethod var2);

    public final ProgramMethod lookupSingleProgramTarget(AppView<?> appView, ProgramMethod context) {
        return DexClassAndMethod.asProgramMethodOrNull(this.lookupSingleTarget(appView, context));
    }

    public ProgramMethodSet lookupProgramDispatchTargets(AppView<AppInfoWithLiveness> appView, ProgramMethod context) {
        if (!this.getInvokedMethod().holder.isClassType()) {
            return null;
        }
        if (!this.isInvokeMethodWithDynamicDispatch()) {
            ProgramMethod singleTarget = this.lookupSingleProgramTarget(appView, context);
            return singleTarget != null ? ProgramMethodSet.create(singleTarget) : null;
        }
        DexProgramClass refinedReceiverUpperBound = DexProgramClass.asProgramClassOrNull(appView.definitionFor(TypeAnalysis.getRefinedReceiverType(appView, this.asInvokeMethodWithReceiver())));
        DexProgramClass refinedReceiverLowerBound = null;
        ClassTypeElement refinedReceiverLowerBoundType = this.asInvokeMethodWithReceiver().getReceiver().getDynamicLowerBoundType(appView);
        if (refinedReceiverLowerBoundType != null) {
            refinedReceiverLowerBound = DexProgramClass.asProgramClassOrNull(appView.definitionFor(refinedReceiverLowerBoundType.getClassType()));
            if (refinedReceiverUpperBound != null && refinedReceiverLowerBound != null && !appView.appInfo().isSubtype(refinedReceiverLowerBound.type, refinedReceiverUpperBound.type)) {
                refinedReceiverLowerBound = null;
            }
        }
        MethodResolutionResult resolutionResult = appView.appInfo().resolveMethod(this.method, this.getInterfaceBit());
        LookupResult lookupResult = refinedReceiverUpperBound != null ? resolutionResult.lookupVirtualDispatchTargets(context.getHolder(), appView.withLiveness().appInfo(), refinedReceiverUpperBound, refinedReceiverLowerBound) : resolutionResult.lookupVirtualDispatchTargets(context.getHolder(), appView.withLiveness().appInfo());
        if (lookupResult.isLookupResultFailure()) {
            return null;
        }
        ProgramMethodSet result = ProgramMethodSet.create();
        lookupResult.forEach(methodTarget -> {
            if (methodTarget.isProgramMethod()) {
                result.add(methodTarget.asProgramMethod());
            }
        }, lambda -> {});
        return result;
    }

    public abstract Inliner.InlineAction computeInlining(ProgramMethod var1, Inliner.Reason var2, DefaultInliningOracle var3, ClassInitializationAnalysis var4, WhyAreYouNotInliningReporter var5);

    @Override
    public boolean identicalAfterRegisterAllocation(Instruction other, RegisterAllocator allocator, MethodConversionOptions conversionOptions) {
        if (!super.identicalAfterRegisterAllocation(other, allocator, conversionOptions)) {
            return false;
        }
        if (allocator.options().canHaveIncorrectJoinForArrayOfInterfacesBug()) {
            InvokeMethod invoke = other.asInvokeMethod();
            for (int i = 0; i < this.arguments().size(); ++i) {
                Value argument = this.arguments().get(i);
                if (!argument.getType().isArrayType() || argument == invoke.arguments().get(i)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        if (this.getReturnType().isVoidType()) {
            return;
        }
        if (this.outValue == null) {
            helper.popOutType(this.getReturnType(), this, it);
        } else {
            assert (this.outValue.isUsed());
            helper.storeOutValue(this, it);
        }
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return this.getReturnType();
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, ProgramMethod context) {
        return true;
    }

    @Override
    public AbstractFieldSet readSet(AppView<AppInfoWithLiveness> appView, ProgramMethod context) {
        return LibraryMethodReadSetModeling.getModeledReadSetOrUnknown(appView, this);
    }

    @Override
    public AbstractValue getAbstractValue(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod context) {
        assert (this.hasOutValue());
        DexClassAndMethod method = this.lookupSingleTarget(appView, context);
        if (method != null) {
            return ((DexEncodedMethod)method.getDefinition()).getOptimizationInfo().getAbstractReturnValue();
        }
        return UnknownValue.getInstance();
    }

    boolean verifyD8LookupResult(DexEncodedMethod hierarchyResult, DexEncodedMethod lookupDirectTargetOnItself) {
        if (lookupDirectTargetOnItself == null) {
            return true;
        }
        assert (lookupDirectTargetOnItself == hierarchyResult);
        return true;
    }

    @Override
    public boolean throwsNpeIfValueIsNull(Value value, AppView<?> appView, ProgramMethod context) {
        BitSet nonNullParamOrThrow;
        DexClassAndMethod singleTarget = this.lookupSingleTarget(appView, context);
        if (singleTarget != null && (nonNullParamOrThrow = ((DexEncodedMethod)singleTarget.getDefinition()).getOptimizationInfo().getNonNullParamOrThrow()) != null) {
            int argumentIndex = this.inValues.indexOf(value);
            return argumentIndex >= 0 && nonNullParamOrThrow.get(argumentIndex);
        }
        return false;
    }

    static abstract class Builder<B extends Builder<B, I>, I extends InvokeMethod>
    extends Instruction.BuilderBase<B, I> {
        protected DexMethod method;
        protected List<Value> arguments = Collections.emptyList();

        Builder() {
        }

        public B setArguments(List<Value> arguments) {
            assert (arguments != null);
            this.arguments = arguments;
            return (B)((Builder)this.self());
        }

        public B setFreshOutValue(AppView<?> appView, ValueFactory factory) {
            return (B)((Builder)super.setFreshOutValue(factory, TypeElement.fromDexType(this.method.getReturnType(), Nullability.maybeNull(), appView)));
        }

        public B setSingleArgument(Value argument) {
            return this.setArguments(ImmutableList.of(argument));
        }

        public B setMethod(DexMethod method) {
            this.method = method;
            return (B)((Builder)this.self());
        }

        public B setMethod(DexClassAndMethod method) {
            return this.setMethod((DexMethod)method.getReference());
        }
    }
}

