/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfMultiANewArray;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AccessControl;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.utils.LongInterval;
import java.util.List;

public class InvokeMultiNewArray
extends Invoke {
    private final DexType type;

    public InvokeMultiNewArray(DexType type, Value result, List<Value> arguments) {
        super(result, arguments);
        this.type = type;
    }

    private boolean instructionInstanceCanThrowNegativeArraySizeException() {
        boolean mayHaveNegativeArraySize = false;
        for (Value value : this.arguments()) {
            if (!value.hasValueRange()) {
                mayHaveNegativeArraySize = true;
                break;
            }
            LongInterval valueRange = value.getValueRange();
            if (valueRange.getMin() >= 0L) continue;
            mayHaveNegativeArraySize = true;
            break;
        }
        return mayHaveNegativeArraySize;
    }

    @Override
    public int opcode() {
        return 35;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isInvokeMultiNewArray() {
        return true;
    }

    @Override
    public InvokeMultiNewArray asInvokeMultiNewArray() {
        return this;
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.MULTI_NEW_ARRAY;
    }

    public DexType getArrayType() {
        return this.type;
    }

    @Override
    public DexType getReturnType() {
        return this.getArrayType();
    }

    @Override
    protected String getTypeString() {
        return "MultiNewArray";
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInvokeMultiNewArray() && this.type == other.asInvokeMultiNewArray().type;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forInvokeMultiNewArray(this.type, context);
    }

    @Override
    public TypeElement evaluate(AppView<?> appView) {
        return TypeElement.fromDexType(this.type, Nullability.definitelyNotNull(), appView);
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return this.type;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add((CfInstruction)new CfMultiANewArray(this.type, this.arguments().size()), this);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        throw new Unreachable("InvokeNewArray (non-empty) not supported when compiling to dex files.");
    }

    @Override
    public boolean instructionInstanceCanThrow(AppView<?> appView, ProgramMethod context) {
        DexType baseType;
        DexType dexType = baseType = this.type.isArrayType() ? this.type.toBaseType(appView.dexItemFactory()) : this.type;
        if (baseType.isPrimitiveType()) {
            assert (!this.type.isWideType()) : "The array's contents must be single-word";
            return this.instructionInstanceCanThrowNegativeArraySizeException();
        }
        assert (baseType.isReferenceType());
        if (baseType == context.getHolderType()) {
            return this.instructionInstanceCanThrowNegativeArraySizeException();
        }
        if (!appView.enableWholeProgramOptimizations()) {
            return true;
        }
        assert (((AppInfo)appView.appInfo()).hasClassHierarchy());
        AppView<AppInfoWithClassHierarchy> appViewWithClassHierarchy = appView.withClassHierarchy();
        DexClass clazz = appView.definitionFor(baseType);
        if (clazz == null) {
            return true;
        }
        if (clazz.isLibraryClass() && !appView.dexItemFactory().libraryTypesAssumedToBePresent.contains(baseType)) {
            return true;
        }
        if (AccessControl.isClassAccessible(clazz, context, appViewWithClassHierarchy).isPossiblyFalse()) {
            return true;
        }
        return this.instructionInstanceCanThrowNegativeArraySizeException();
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, ProgramMethod context, Instruction.SideEffectAssumption assumption) {
        if (this.hasOutValue() && this.outValue().hasLocalInfo()) {
            assert (appView.options().debug);
            return true;
        }
        return this.instructionInstanceCanThrow(appView, context);
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, ProgramMethod context) {
        return false;
    }
}

