/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.code.Base3Format;
import com.android.tools.r8.code.FilledNewArray;
import com.android.tools.r8.code.FilledNewArrayRange;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AccessControl;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.StatefulObjectValue;
import com.android.tools.r8.ir.analysis.value.UnknownValue;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import java.util.List;

public class InvokeNewArray
extends Invoke {
    private final DexType type;

    public InvokeNewArray(DexType type, Value result, List<Value> arguments) {
        super(result, arguments);
        this.type = type;
    }

    private static Unreachable cfUnsupported() {
        throw new Unreachable("InvokeNewArray (non-empty) not supported when compiling to classfiles.");
    }

    @Override
    public int opcode() {
        return 36;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public DexType getReturnType() {
        return this.getArrayType();
    }

    public DexType getArrayType() {
        return this.type;
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.NEW_ARRAY;
    }

    @Override
    protected String getTypeString() {
        return "NewArray";
    }

    @Override
    public String toString() {
        return super.toString() + "; type: " + this.type.toSourceString();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Base3Format instruction;
        int argumentRegisters = this.requiredArgumentRegisters();
        builder.requestOutgoingRegisters(argumentRegisters);
        if (this.needsRangedInvoke(builder)) {
            assert (this.argumentsConsecutive(builder));
            int firstRegister = this.argumentRegisterValue(0, builder);
            instruction = new FilledNewArrayRange(firstRegister, argumentRegisters, this.type);
        } else {
            int[] individualArgumentRegisters = new int[5];
            int argumentRegistersCount = this.fillArgumentRegisters(builder, individualArgumentRegisters);
            instruction = new FilledNewArray(argumentRegistersCount, this.type, individualArgumentRegisters[0], individualArgumentRegisters[1], individualArgumentRegisters[2], individualArgumentRegisters[3], individualArgumentRegisters[4]);
        }
        this.addInvokeAndMoveResult(instruction, builder);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInvokeNewArray() && this.type == other.asInvokeNewArray().type;
    }

    @Override
    public boolean isInvokeNewArray() {
        return true;
    }

    @Override
    public InvokeNewArray asInvokeNewArray() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forInvokeNewArray(this.type, context);
    }

    @Override
    public TypeElement evaluate(AppView<?> appView) {
        return TypeElement.fromDexType(this.type, Nullability.definitelyNotNull(), appView);
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        throw InvokeNewArray.cfUnsupported();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        throw InvokeNewArray.cfUnsupported();
    }

    @Override
    public void buildCf(CfBuilder builder) {
        throw InvokeNewArray.cfUnsupported();
    }

    @Override
    public AbstractValue getAbstractValue(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod context) {
        if (!this.instructionMayHaveSideEffects(appView, context)) {
            int size = this.inValues.size();
            return StatefulObjectValue.create(appView.abstractValueFactory().createKnownLengthArrayState(size));
        }
        return UnknownValue.getInstance();
    }

    @Override
    public boolean instructionInstanceCanThrow(AppView<?> appView, ProgramMethod context) {
        DexType baseType;
        DexType dexType = baseType = this.type.isArrayType() ? this.type.toBaseType(appView.dexItemFactory()) : this.type;
        if (baseType.isPrimitiveType()) {
            assert (!this.type.isWideType()) : "The array's contents must be single-word";
            return false;
        }
        assert (baseType.isReferenceType());
        if (baseType == context.getHolderType()) {
            return false;
        }
        if (!appView.enableWholeProgramOptimizations()) {
            return true;
        }
        assert (((AppInfo)appView.appInfo()).hasClassHierarchy());
        AppView<AppInfoWithClassHierarchy> appViewWithClassHierarchy = appView.withClassHierarchy();
        DexClass clazz = appView.definitionFor(baseType);
        if (clazz == null) {
            return true;
        }
        if (clazz.isLibraryClass() && !appView.dexItemFactory().libraryTypesAssumedToBePresent.contains(baseType)) {
            return true;
        }
        return AccessControl.isClassAccessible(clazz, context, appViewWithClassHierarchy).isPossiblyFalse();
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, ProgramMethod context, Instruction.SideEffectAssumption assumption) {
        if (this.hasOutValue() && this.outValue().hasLocalInfo()) {
            assert (appView.options().debug);
            return true;
        }
        return this.instructionInstanceCanThrow(appView, context);
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, ProgramMethod context) {
        return false;
    }
}

