/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.code.Base4Format;
import com.android.tools.r8.code.InvokePolymorphicRange;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.DefaultInliningOracle;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.ir.optimize.inliner.WhyAreYouNotInliningReporter;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.List;

public class InvokePolymorphic
extends InvokeMethod {
    private final DexProto proto;

    public InvokePolymorphic(DexMethod target, DexProto proto, Value result, List<Value> arguments) {
        super(target, result, arguments);
        this.proto = proto;
    }

    @Override
    public boolean getInterfaceBit() {
        return false;
    }

    @Override
    public int opcode() {
        return 37;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public DexType getReturnType() {
        return this.proto.returnType;
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.POLYMORPHIC;
    }

    @Override
    protected String getTypeString() {
        return "Polymorphic";
    }

    public DexProto getProto() {
        return this.proto;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Base4Format instruction;
        int argumentRegisters = this.requiredArgumentRegisters();
        builder.requestOutgoingRegisters(argumentRegisters);
        if (this.needsRangedInvoke(builder)) {
            assert (this.argumentsConsecutive(builder));
            int firstRegister = this.argumentRegisterValue(0, builder);
            instruction = new InvokePolymorphicRange(firstRegister, argumentRegisters, this.getInvokedMethod(), this.getProto());
        } else {
            int[] individualArgumentRegisters = new int[5];
            int argumentRegistersCount = this.fillArgumentRegisters(builder, individualArgumentRegisters);
            instruction = new com.android.tools.r8.code.InvokePolymorphic(argumentRegistersCount, this.getInvokedMethod(), this.getProto(), individualArgumentRegisters[0], individualArgumentRegisters[1], individualArgumentRegisters[2], individualArgumentRegisters[3], individualArgumentRegisters[4]);
        }
        this.addInvokeAndMoveResult(instruction, builder);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        DexMethod dexMethod = this.getInvokedMethod();
        DexItemFactory factory = builder.appView.dexItemFactory();
        DexMethod method = factory.createMethod(dexMethod.holder, this.getProto(), dexMethod.name);
        builder.add((CfInstruction)new CfInvoke(182, method, false), this);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInvokePolymorphic() && this.proto.equals(other.asInvokePolymorphic().proto) && super.identicalNonValueNonPositionParts(other);
    }

    @Override
    public boolean isInvokePolymorphic() {
        return true;
    }

    @Override
    public InvokePolymorphic asInvokePolymorphic() {
        return this;
    }

    @Override
    public DexClassAndMethod lookupSingleTarget(AppView<?> appView, ProgramMethod context) {
        return null;
    }

    @Override
    public ProgramMethodSet lookupProgramDispatchTargets(AppView<AppInfoWithLiveness> appView, ProgramMethod context) {
        return null;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forInvokePolymorphic(this.getInvokedMethod(), context);
    }

    @Override
    public Inliner.InlineAction computeInlining(ProgramMethod singleTarget, Inliner.Reason reason, DefaultInliningOracle decider, ClassInitializationAnalysis classInitializationAnalysis, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        if (singleTarget != null) {
            throw new Unreachable("Unexpected invoke-polymorphic with `" + singleTarget.toSourceString() + "` as single target");
        }
        throw new Unreachable("Unexpected attempt to inline invoke that does not have a single target");
    }
}

