/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.code.Base3Format;
import com.android.tools.r8.code.InvokeStaticRange;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.DefaultInliningOracle;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.ir.optimize.inliner.WhyAreYouNotInliningReporter;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.List;

public class InvokeStatic
extends InvokeMethod {
    private final boolean isInterface;

    public InvokeStatic(DexMethod target, Value result, List<Value> arguments) {
        this(target, result, arguments, false);
        assert (target.proto.parameters.size() == arguments.size());
    }

    public InvokeStatic(DexMethod target, Value result, List<Value> arguments, boolean isInterface) {
        super(target, result, arguments);
        this.isInterface = isInterface;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean getInterfaceBit() {
        return this.isInterface;
    }

    @Override
    public int opcode() {
        return 38;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.STATIC;
    }

    @Override
    protected String getTypeString() {
        return "Static";
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Base3Format instruction;
        int argumentRegisters = this.requiredArgumentRegisters();
        builder.requestOutgoingRegisters(argumentRegisters);
        if (this.needsRangedInvoke(builder)) {
            assert (this.argumentsConsecutive(builder));
            int firstRegister = this.argumentRegisterValue(0, builder);
            instruction = new InvokeStaticRange(firstRegister, argumentRegisters, this.getInvokedMethod());
        } else {
            int[] individualArgumentRegisters = new int[5];
            int argumentRegistersCount = this.fillArgumentRegisters(builder, individualArgumentRegisters);
            instruction = new com.android.tools.r8.code.InvokeStatic(argumentRegistersCount, this.getInvokedMethod(), individualArgumentRegisters[0], individualArgumentRegisters[1], individualArgumentRegisters[2], individualArgumentRegisters[3], individualArgumentRegisters[4]);
        }
        this.addInvokeAndMoveResult(instruction, builder);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInvokeStatic() && super.identicalNonValueNonPositionParts(other);
    }

    @Override
    public boolean isInvokeStatic() {
        return true;
    }

    @Override
    public InvokeStatic asInvokeStatic() {
        return this;
    }

    @Override
    public DexClassAndMethod lookupSingleTarget(AppView<?> appView, ProgramMethod context) {
        DexEncodedMethod result;
        DexMethod invokedMethod = this.getInvokedMethod();
        if (((AppInfo)appView.appInfo()).hasLiveness()) {
            AppInfoWithLiveness appInfo = ((AppInfo)appView.appInfo()).withLiveness();
            result = appInfo.lookupStaticTarget(invokedMethod, context);
            assert (this.verifyD8LookupResult(result, ((AppInfo)appView.appInfo()).lookupStaticTargetOnItself(invokedMethod, context)));
        } else {
            DexClass clazz = appView.definitionForHolder(this.getInvokedMethod());
            result = clazz != null && (clazz.isLibraryClass() || appView.libraryMethodOptimizer().isModeled(clazz.type)) ? clazz.lookupMethod(this.getInvokedMethod()) : ((AppInfo)appView.appInfo()).lookupStaticTargetOnItself(invokedMethod, context);
        }
        return DexEncodedMethod.asDexClassAndMethodOrNull(result, appView);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forInvokeStatic(this.getInvokedMethod(), context);
    }

    @Override
    public Inliner.InlineAction computeInlining(ProgramMethod singleTarget, Inliner.Reason reason, DefaultInliningOracle decider, ClassInitializationAnalysis classInitializationAnalysis, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        return decider.computeForInvokeStatic(this, singleTarget, reason, classInitializationAnalysis, whyAreYouNotInliningReporter);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add((CfInstruction)new CfInvoke(184, this.getInvokedMethod(), this.isInterface), this);
    }

    @Override
    public boolean definitelyTriggersClassInitialization(DexType clazz, ProgramMethod context, AppView<AppInfoWithLiveness> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return ClassInitializationAnalysis.InstructionUtils.forInvokeStatic(this, clazz, context, appView, mode, assumption);
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, ProgramMethod context, Instruction.SideEffectAssumption assumption) {
        if (!appView.enableWholeProgramOptimizations()) {
            return true;
        }
        if (appView.options().debug) {
            return true;
        }
        if (appView.getLibraryMethodSideEffectModelCollection().isCallToSideEffectFreeFinalMethod(this)) {
            return false;
        }
        if (!((AppInfo)appView.appInfo()).hasLiveness()) {
            return true;
        }
        AppView<AppInfoWithLiveness> appViewWithLiveness = appView.withLiveness();
        AppInfoWithLiveness appInfoWithLiveness = appViewWithLiveness.appInfo();
        MethodResolutionResult.SingleResolutionResult resolutionResult = appViewWithLiveness.appInfo().resolveMethod(this.getInvokedMethod(), this.isInterface).asSingleResolution();
        if (resolutionResult == null) {
            return true;
        }
        DexClassAndMethod singleTarget = resolutionResult.getResolutionPair();
        assert (singleTarget != null);
        if (!((DexEncodedMethod)singleTarget.getDefinition()).isStatic() || resolutionResult.isAccessibleFrom((ProgramDefinition)context, appInfoWithLiveness).isPossiblyFalse()) {
            return true;
        }
        if (appViewWithLiveness.appInfo().isAssumeNoSideEffectsMethod(singleTarget)) {
            return false;
        }
        if (singleTarget.getOptimizationInfo().mayHaveSideEffects(this, appView.options())) {
            return true;
        }
        if (assumption.canAssumeClassIsAlreadyInitialized()) {
            return false;
        }
        return singleTarget.getHolder().classInitializationMayHaveSideEffectsInContext(appView, context);
    }

    public static class Builder
    extends InvokeMethod.Builder<Builder, InvokeStatic> {
        @Override
        public InvokeStatic build() {
            assert (this.arguments != null);
            assert (this.method != null);
            assert (this.method.getArity() == this.arguments.size());
            assert (this.outValue == null || !this.method.getReturnType().isVoidType());
            return this.amend(new InvokeStatic(this.method, this.outValue, this.arguments));
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

