/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.ValueTypeConstraint;

public enum MemberType {
    OBJECT,
    BOOLEAN_OR_BYTE,
    CHAR,
    SHORT,
    INT,
    FLOAT,
    LONG,
    DOUBLE,
    INT_OR_FLOAT,
    LONG_OR_DOUBLE;


    public static MemberType constrainedType(MemberType type, ValueTypeConstraint constraint) {
        switch (constraint) {
            case OBJECT: {
                if (type != OBJECT) break;
                return OBJECT;
            }
            case INT: {
                if (type != INT && type != INT_OR_FLOAT) break;
                return INT;
            }
            case FLOAT: {
                if (type != FLOAT && type != INT_OR_FLOAT) break;
                return FLOAT;
            }
            case INT_OR_FLOAT: {
                if (type != INT && type != FLOAT && type != INT_OR_FLOAT) break;
                return type;
            }
            case INT_OR_FLOAT_OR_OBJECT: {
                if (type != INT && type != FLOAT && type != OBJECT && type != INT_OR_FLOAT) break;
                return type;
            }
            case LONG: {
                if (type != LONG && type != LONG_OR_DOUBLE) break;
                return LONG;
            }
            case DOUBLE: {
                if (type != DOUBLE && type != LONG_OR_DOUBLE) break;
                return DOUBLE;
            }
            case LONG_OR_DOUBLE: {
                if (type != LONG && type != DOUBLE && type != LONG_OR_DOUBLE) break;
                return type;
            }
            default: {
                throw new Unreachable("Unexpected type constraint: " + (Object)((Object)constraint));
            }
        }
        return null;
    }

    public static MemberType fromTypeDescriptorChar(char descriptor) {
        switch (descriptor) {
            case 'L': 
            case '[': {
                return OBJECT;
            }
            case 'B': 
            case 'Z': {
                return BOOLEAN_OR_BYTE;
            }
            case 'S': {
                return SHORT;
            }
            case 'C': {
                return CHAR;
            }
            case 'I': {
                return INT;
            }
            case 'F': {
                return FLOAT;
            }
            case 'J': {
                return LONG;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'V': {
                throw new InternalCompilerError("No member type for void type.");
            }
        }
        throw new Unreachable("Invalid descriptor char '" + descriptor + "'");
    }

    public static MemberType fromDexType(DexType type) {
        return MemberType.fromTypeDescriptorChar((char)type.descriptor.content[0]);
    }

    public boolean isPrecise() {
        return this != INT_OR_FLOAT && this != LONG_OR_DOUBLE;
    }
}

