/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.DeadCodeRemover;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.utils.InternalOptions;

public class MoveException
extends Instruction {
    private final DexType exceptionType;
    private final InternalOptions options;

    public MoveException(Value dest, DexType exceptionType, InternalOptions options) {
        super(dest);
        this.exceptionType = exceptionType;
        this.options = options;
    }

    @Override
    public int opcode() {
        return 44;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Value dest() {
        return this.outValue;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new com.android.tools.r8.code.MoveException(dest));
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "MoveException has no register arguments.";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isMoveException()) {
            return false;
        }
        if (this.options.canHaveExceptionTypeBug()) {
            return other.asMoveException().exceptionType == this.exceptionType;
        }
        return true;
    }

    @Override
    public boolean isMoveException() {
        return true;
    }

    @Override
    public MoveException asMoveException() {
        return this;
    }

    @Override
    public DeadCodeRemover.DeadInstructionResult canBeDeadCode(AppView<?> appView, IRCode code) {
        InternalOptions options = appView.options();
        if (options.debug || code.context().getOrComputeReachabilitySensitive(appView) || code.getConversionOptions().isGeneratingClassFiles()) {
            return DeadCodeRemover.DeadInstructionResult.notDead();
        }
        return DeadCodeRemover.DeadInstructionResult.deadIfOutValueIsDead();
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forMoveException();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return this.exceptionType;
    }

    @Override
    public TypeElement evaluate(AppView<?> appView) {
        return TypeElement.fromDexType(this.exceptionType, Nullability.definitelyNotNull(), appView);
    }

    public DexType getExceptionType() {
        return this.exceptionType;
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, ProgramMethod context) {
        return false;
    }
}

