/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.utils.Int2StructuralItemArrayMap;
import com.android.tools.r8.utils.structural.Equatable;
import com.android.tools.r8.utils.structural.HashCodeVisitor;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.function.Predicate;

public abstract class Position
implements StructuralItem<Position> {
    private static final int SOURCE_POSITION_COMPARE_ID = 1;
    private static final int SYNTHETIC_POSITION_COMPARE_ID = 2;
    private static final int OUTLINE_POSITION_COMPARE_ID = 3;
    private static final int OUTLINE_CALLER_POSITION_COMPARE_ID = 4;
    protected final int line;
    protected final DexMethod method;
    protected final Position callerPosition;
    private final boolean removeInnerFramesIfThrowingNpe;

    private Position(int line, DexMethod method, Position callerPosition, boolean removeInnerFramesIfThrowingNpe) {
        this.line = line;
        this.method = method;
        this.callerPosition = callerPosition;
        this.removeInnerFramesIfThrowingNpe = removeInnerFramesIfThrowingNpe;
    }

    public static Position none() {
        return SourcePosition.NO_POSITION;
    }

    private static void specifyBasePosition(StructuralSpecification<Position, ?> spec) {
        ((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)spec.withInt(Position::getCompareToId)).withInt(Position::getLine)).withNullableItem(Position::getMethod)).withNullableItem(Position::getCallerPosition)).withBool(Position::isRemoveInnerFramesIfThrowingNpe);
    }

    public static Position syntheticNone() {
        return SyntheticPosition.NO_POSITION_SYNTHETIC;
    }

    public static Position getPositionForInlining(AppView<?> appView, InvokeMethod invoke, ProgramMethod context) {
        Position position = invoke.getPosition();
        if (position.method == null) {
            assert (position.isNone());
            position = ((SourcePosition.SourcePositionBuilder)SourcePosition.builder().setMethod((DexMethod)context.getReference())).build();
        }
        assert (position.getOutermostCaller().method == appView.graphLens().getOriginalMethodSignature((DexMethod)context.getReference()));
        return position;
    }

    private Position getOutermostCallerMatching(Predicate<Position> predicate, boolean isCallerPosition) {
        Position position;
        if (this.hasCallerPosition() && (position = this.getCallerPosition().getOutermostCallerMatching(predicate, true)) != null) {
            return position;
        }
        if (isCallerPosition && predicate.test(this)) {
            return this;
        }
        return null;
    }

    private String toString(boolean forceMethod) {
        if (this.isNone()) {
            return "--";
        }
        StringBuilder builder = new StringBuilder();
        if (this.hasFile()) {
            builder.append(this.getFile()).append(":");
        }
        builder.append("#").append(this.line);
        if (this.method != null && (forceMethod || this.callerPosition != null)) {
            builder.append(":").append(this.method.name);
        }
        if (this.callerPosition != null) {
            Position caller = this.callerPosition;
            while (caller != null) {
                builder.append(";").append(caller.line).append(":").append(caller.method.name);
                caller = caller.callerPosition;
            }
        }
        return builder.toString();
    }

    public boolean isSyntheticPosition() {
        return false;
    }

    public boolean isAdditionalMappingInfoPosition() {
        return false;
    }

    public boolean isRemoveInnerFramesIfThrowingNpe() {
        return this.removeInnerFramesIfThrowingNpe;
    }

    public boolean isOutline() {
        return false;
    }

    public DexMethod getOutlineCallee() {
        return null;
    }

    public Int2StructuralItemArrayMap<Position> getOutlinePositions() {
        return null;
    }

    public boolean hasCallerPosition() {
        return this.callerPosition != null;
    }

    public Position getCallerPosition() {
        return this.callerPosition;
    }

    public int getLine() {
        return this.line;
    }

    public DexMethod getMethod() {
        return this.method;
    }

    public boolean hasFile() {
        return false;
    }

    public DexString getFile() {
        return null;
    }

    @Override
    public Position self() {
        return this;
    }

    public abstract int getCompareToId();

    @Override
    public abstract StructuralMapping<Position> getStructuralMapping();

    public boolean isNone() {
        return this.line == -1;
    }

    public boolean isSyntheticNone() {
        return this == Position.syntheticNone();
    }

    public boolean isSome() {
        return !this.isNone();
    }

    public Position getOutermostCaller() {
        Position lastPosition = this;
        while (lastPosition.callerPosition != null) {
            lastPosition = lastPosition.callerPosition;
        }
        return lastPosition;
    }

    public Position getOutermostCallerMatchingOrElse(Predicate<Position> predicate, Position defaultValue) {
        Position outerMostMatching = this.getOutermostCallerMatching(predicate, false);
        return outerMostMatching == null ? defaultValue : outerMostMatching;
    }

    public Position withOutermostCallerPosition(Position newOutermostCallerPosition) {
        return ((PositionBuilder)this.builderWithCopy().setCallerPosition(this.hasCallerPosition() ? this.getCallerPosition().withOutermostCallerPosition(newOutermostCallerPosition) : newOutermostCallerPosition)).build();
    }

    public Position replacePosition(Position originalPosition, Position newPosition) {
        if (this == originalPosition) {
            return newPosition;
        }
        return this.hasCallerPosition() ? ((PositionBuilder)this.builderWithCopy().setCallerPosition(this.callerPosition.replacePosition(originalPosition, newPosition))).build() : this;
    }

    @Override
    public final boolean equals(Object other) {
        return Equatable.equalsImpl(this, other);
    }

    @Override
    public final int hashCode() {
        return HashCodeVisitor.run(this);
    }

    public String toString() {
        return this.toString(false);
    }

    public abstract PositionBuilder<?, ?> builderWithCopy();

    public static class OutlineCallerPosition
    extends Position {
        private final Int2StructuralItemArrayMap<Position> outlinePositions;
        private final DexMethod outlineCallee;
        private final boolean isOutline;

        public static void specify(StructuralSpecification<Position, ?> spec) {
            ((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)spec.withSpec(x$0 -> Position.specifyBasePosition(x$0))).withBool(Position::isOutline)).withItem(Position::getOutlineCallee)).withItem(Position::getOutlinePositions);
        }

        private OutlineCallerPosition(int line, DexMethod method, Position callerPosition, boolean removeInnerFramesIfThrowingNpe, Int2StructuralItemArrayMap<Position> outlinePositions, DexMethod outlineCallee, boolean isOutline) {
            super(line, method, callerPosition, removeInnerFramesIfThrowingNpe);
            this.outlinePositions = outlinePositions;
            this.outlineCallee = outlineCallee;
            this.isOutline = isOutline;
        }

        public static OutlineCallerPositionBuilder builder() {
            return new OutlineCallerPositionBuilder();
        }

        @Override
        public boolean isNone() {
            return false;
        }

        @Override
        public int getCompareToId() {
            return 4;
        }

        @Override
        public PositionBuilder<?, ?> builderWithCopy() {
            OutlineCallerPositionBuilder outlineCallerPositionBuilder = (OutlineCallerPositionBuilder)((OutlineCallerPositionBuilder)((OutlineCallerPositionBuilder)((OutlineCallerPositionBuilder)OutlineCallerPosition.builder().setLine(this.line)).setMethod(this.method)).setCallerPosition(this.callerPosition)).setOutlineCallee(this.outlineCallee).setIsOutline(this.isOutline).setRemoveInnerFramesIfThrowingNpe(this.isRemoveInnerFramesIfThrowingNpe());
            this.outlinePositions.forEach(outlineCallerPositionBuilder::addOutlinePosition);
            return outlineCallerPositionBuilder;
        }

        @Override
        public boolean isOutline() {
            return this.isOutline;
        }

        @Override
        public DexMethod getOutlineCallee() {
            return this.outlineCallee;
        }

        @Override
        public Int2StructuralItemArrayMap<Position> getOutlinePositions() {
            return this.outlinePositions;
        }

        @Override
        public StructuralMapping<Position> getStructuralMapping() {
            return OutlineCallerPosition::specify;
        }

        public static class OutlineCallerPositionBuilder
        extends PositionBuilder<OutlineCallerPosition, OutlineCallerPositionBuilder> {
            private final Int2StructuralItemArrayMap.Builder<Position> outlinePositionsBuilder = Int2StructuralItemArrayMap.builder();
            private DexMethod outlineCallee;
            private boolean isOutline;

            private OutlineCallerPositionBuilder() {
            }

            @Override
            OutlineCallerPositionBuilder self() {
                return this;
            }

            public OutlineCallerPositionBuilder setOutlineCallee(DexMethod outlineCallee) {
                this.outlineCallee = outlineCallee;
                return this;
            }

            public OutlineCallerPositionBuilder addOutlinePosition(int line, Position callerPosition) {
                this.outlinePositionsBuilder.put(line, callerPosition);
                return this;
            }

            public OutlineCallerPositionBuilder setIsOutline(boolean isOutline) {
                this.isOutline = isOutline;
                return this;
            }

            public boolean hasOutlinePositions() {
                return !this.outlinePositionsBuilder.isEmpty();
            }

            @Override
            public OutlineCallerPosition build() {
                assert (this.noCheckOfPosition || this.line >= 0);
                assert (this.noCheckOfMethod || this.method != null);
                return new OutlineCallerPosition(this.line, this.method, this.callerPosition, this.removeInnerFramesIfThrowingNpe, this.outlinePositionsBuilder.build(), this.outlineCallee, this.isOutline);
            }
        }
    }

    public static class OutlinePosition
    extends Position {
        private OutlinePosition(int line, DexMethod method, Position callerPosition, boolean removeInnerFramesIfThrowingNpe) {
            super(line, method, callerPosition, removeInnerFramesIfThrowingNpe);
        }

        public static OutlinePositionBuilder builder() {
            return new OutlinePositionBuilder();
        }

        @Override
        public boolean isOutline() {
            return true;
        }

        @Override
        public int getCompareToId() {
            return 3;
        }

        @Override
        public PositionBuilder<?, ?> builderWithCopy() {
            return ((OutlinePositionBuilder)((OutlinePositionBuilder)((OutlinePositionBuilder)OutlinePosition.builder().setLine(this.line)).setMethod(this.method)).setCallerPosition(this.callerPosition)).setRemoveInnerFramesIfThrowingNpe(this.isRemoveInnerFramesIfThrowingNpe());
        }

        @Override
        public StructuralMapping<Position> getStructuralMapping() {
            return x$0 -> Position.specifyBasePosition(x$0);
        }

        public static class OutlinePositionBuilder
        extends PositionBuilder<OutlinePosition, OutlinePositionBuilder> {
            private OutlinePositionBuilder() {
            }

            @Override
            OutlinePositionBuilder self() {
                return this;
            }

            @Override
            public OutlinePosition build() {
                return new OutlinePosition(this.line, this.method, this.callerPosition, this.removeInnerFramesIfThrowingNpe);
            }
        }
    }

    public static class SyntheticPosition
    extends Position {
        private static final Position NO_POSITION_SYNTHETIC = new SyntheticPosition(-1, null, null, false);

        private SyntheticPosition(int line, DexMethod method, Position callerPosition, boolean removeInnerFramesIfThrowingNpe) {
            super(line, method, callerPosition, removeInnerFramesIfThrowingNpe);
        }

        public static SyntheticPositionBuilder builder() {
            return new SyntheticPositionBuilder();
        }

        @Override
        public boolean isSyntheticPosition() {
            return true;
        }

        @Override
        public int getCompareToId() {
            return 2;
        }

        @Override
        public PositionBuilder<?, ?> builderWithCopy() {
            return ((SyntheticPositionBuilder)((SyntheticPositionBuilder)((SyntheticPositionBuilder)SyntheticPosition.builder().setLine(this.line)).setMethod(this.method)).setCallerPosition(this.callerPosition)).setRemoveInnerFramesIfThrowingNpe(this.isRemoveInnerFramesIfThrowingNpe());
        }

        @Override
        public StructuralMapping<Position> getStructuralMapping() {
            return x$0 -> Position.specifyBasePosition(x$0);
        }

        public static class SyntheticPositionBuilder
        extends PositionBuilder<SyntheticPosition, SyntheticPositionBuilder> {
            private SyntheticPositionBuilder() {
            }

            @Override
            SyntheticPositionBuilder self() {
                return this;
            }

            @Override
            public SyntheticPosition build() {
                assert (this.noCheckOfPosition || this.line >= 0);
                assert (this.noCheckOfMethod || this.method != null);
                return new SyntheticPosition(this.line, this.method, this.callerPosition, this.removeInnerFramesIfThrowingNpe);
            }
        }
    }

    public static class SourcePosition
    extends Position {
        private static final SourcePosition NO_POSITION = new SourcePosition(-1, null, null, false, null);
        public final DexString file;

        private static void specify(StructuralSpecification<Position, ?> spec) {
            ((StructuralSpecification)spec.withSpec(x$0 -> Position.specifyBasePosition(x$0))).withNullableItem(Position::getFile);
        }

        private SourcePosition(int line, DexMethod method, Position callerPosition, boolean removeInnerFramesIfThrowingNpe, DexString file) {
            super(line, method, callerPosition, removeInnerFramesIfThrowingNpe);
            this.file = file;
            assert (callerPosition == null || callerPosition.method != null);
        }

        public static SourcePositionBuilder builder() {
            return new SourcePositionBuilder();
        }

        @Override
        public boolean hasFile() {
            return this.file != null;
        }

        @Override
        public DexString getFile() {
            return this.file;
        }

        @Override
        public int getCompareToId() {
            return 1;
        }

        @Override
        public PositionBuilder<?, ?> builderWithCopy() {
            return ((SourcePositionBuilder)((SourcePositionBuilder)((SourcePositionBuilder)SourcePosition.builder().setLine(this.line)).setFile(this.file).setMethod(this.method)).setCallerPosition(this.callerPosition)).setRemoveInnerFramesIfThrowingNpe(this.isRemoveInnerFramesIfThrowingNpe());
        }

        @Override
        public StructuralMapping<Position> getStructuralMapping() {
            return SourcePosition::specify;
        }

        public static class SourcePositionBuilder
        extends PositionBuilder<SourcePosition, SourcePositionBuilder> {
            private DexString file;

            @Override
            SourcePositionBuilder self() {
                return this;
            }

            public SourcePositionBuilder setFile(DexString file) {
                this.file = file;
                return this;
            }

            @Override
            public SourcePosition build() {
                assert (this.noCheckOfPosition || this.line >= 0);
                assert (this.noCheckOfMethod || this.method != null);
                return new SourcePosition(this.line, this.method, this.callerPosition, this.removeInnerFramesIfThrowingNpe, this.file);
            }
        }
    }

    public static abstract class PositionBuilder<P extends Position, B extends PositionBuilder<P, B>> {
        protected int line = -1;
        protected DexMethod method;
        protected Position callerPosition;
        protected boolean removeInnerFramesIfThrowingNpe;
        protected boolean noCheckOfPosition;
        protected boolean noCheckOfMethod;

        abstract B self();

        public B setLine(int line) {
            this.line = line;
            return this.self();
        }

        public boolean hasLine() {
            return this.line > -1;
        }

        public B setMethod(DexMethod method) {
            this.method = method;
            return this.self();
        }

        public B setCallerPosition(Position callerPosition) {
            this.callerPosition = callerPosition;
            return this.self();
        }

        public B setRemoveInnerFramesIfThrowingNpe(boolean removeInnerFramesIfThrowingNpe) {
            this.removeInnerFramesIfThrowingNpe = removeInnerFramesIfThrowingNpe;
            return this.self();
        }

        public B disableLineCheck() {
            this.noCheckOfPosition = true;
            return this.self();
        }

        public B disableMethodCheck() {
            this.noCheckOfMethod = true;
            return this.self();
        }

        public abstract P build();
    }
}

