/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Value;

public class StackValue
extends Value {
    private final int height;
    private final TypeVerificationHelper.TypeInfo typeInfo;

    private StackValue(TypeVerificationHelper.TypeInfo typeInfo, TypeElement type, int height) {
        super(-1, type, null);
        this.height = height;
        this.typeInfo = typeInfo;
        assert (height >= 0);
    }

    public static StackValue create(TypeVerificationHelper.TypeInfo typeInfo, int height, AppView<?> appView) {
        return new StackValue(typeInfo, TypeElement.fromDexType(typeInfo.getDexType(), Nullability.maybeNull(), appView), height);
    }

    public int getHeight() {
        return this.height;
    }

    public TypeVerificationHelper.TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public StackValue duplicate(int height) {
        return new StackValue(this.typeInfo, this.getType(), height);
    }

    @Override
    public boolean isValueOnStack() {
        return true;
    }

    @Override
    public boolean needsRegister() {
        return false;
    }

    @Override
    public void setNeedsRegister(boolean value) {
        assert (!value);
    }

    @Override
    public String toString() {
        return "s" + this.height;
    }
}

