/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfStaticFieldRead;
import com.android.tools.r8.code.Sget;
import com.android.tools.r8.code.SgetBoolean;
import com.android.tools.r8.code.SgetByte;
import com.android.tools.r8.code.SgetChar;
import com.android.tools.r8.code.SgetObject;
import com.android.tools.r8.code.SgetOrSput;
import com.android.tools.r8.code.SgetShort;
import com.android.tools.r8.code.SgetWide;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.FieldGet;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.StaticFieldInstruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Set;

public class StaticGet
extends FieldInstruction
implements FieldGet,
StaticFieldInstruction {
    public StaticGet(Value dest, DexField field) {
        super(field, dest, (Value)null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static StaticGet copyOf(IRCode code, StaticGet original) {
        Value newValue = new Value(code.valueNumberGenerator.next(), original.getOutType(), original.getLocalInfo());
        return StaticGet.copyOf(newValue, original);
    }

    public static StaticGet copyOf(Value newValue, StaticGet original) {
        assert (newValue != original.outValue());
        return new StaticGet(newValue, original.getField());
    }

    @Override
    public int opcode() {
        return 59;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Value dest() {
        return this.outValue;
    }

    @Override
    public Value value() {
        return this.outValue;
    }

    @Override
    public boolean couldIntroduceAnAlias(AppView<?> appView, Value root) {
        assert (root != null && root.getType().isReferenceType());
        assert (this.outValue != null);
        TypeElement outType = this.outValue.getType();
        if (outType.isPrimitiveType()) {
            return false;
        }
        if (((AppInfo)appView.appInfo()).hasLiveness() && outType.isClassType() && root.getType().isClassType() && ((AppInfo)appView.appInfo()).withLiveness().inDifferentHierarchy(outType.asClassType().getClassType(), root.getType().asClassType().getClassType())) {
            return false;
        }
        return outType.isReferenceType();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        SgetOrSput instruction;
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        DexField field = this.getField();
        switch (this.getType()) {
            case INT: 
            case FLOAT: {
                instruction = new Sget(dest, field);
                break;
            }
            case LONG: 
            case DOUBLE: {
                instruction = new SgetWide(dest, field);
                break;
            }
            case OBJECT: {
                instruction = new SgetObject(dest, field);
                break;
            }
            case BOOLEAN: {
                instruction = new SgetBoolean(dest, field);
                break;
            }
            case BYTE: {
                instruction = new SgetByte(dest, field);
                break;
            }
            case CHAR: {
                instruction = new SgetChar(dest, field);
                break;
            }
            case SHORT: {
                instruction = new SgetShort(dest, field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type: " + (Object)((Object)this.getType()));
            }
        }
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean instructionTypeCanBeCanonicalized() {
        return true;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, ProgramMethod context) {
        return this.instructionMayHaveSideEffects(appView, context, Instruction.SideEffectAssumption.NONE);
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, ProgramMethod context, Instruction.SideEffectAssumption assumption) {
        return this.instructionInstanceCanThrow(appView, context, assumption);
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isStaticGet()) {
            return false;
        }
        StaticGet o = other.asStaticGet();
        return o.getField() == this.getField() && o.getType() == this.getType();
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forStaticGet(this.getField(), context);
    }

    @Override
    public String toString() {
        return super.toString() + "; field: " + this.getField().toSourceString();
    }

    @Override
    public boolean isFieldGet() {
        return true;
    }

    @Override
    public FieldGet asFieldGet() {
        return this;
    }

    @Override
    public boolean isStaticFieldInstruction() {
        return true;
    }

    @Override
    public boolean isStaticGet() {
        return true;
    }

    @Override
    public StaticGet asStaticGet() {
        return this;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add((CfInstruction)new CfStaticFieldRead(this.getField(), builder.resolveField(this.getField())), this);
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return this.getField().type;
    }

    @Override
    public TypeElement evaluate(AppView<?> appView) {
        return TypeElement.fromDexType(this.getField().type, Nullability.maybeNull(), appView);
    }

    @Override
    public boolean definitelyTriggersClassInitialization(DexType clazz, ProgramMethod context, AppView<AppInfoWithLiveness> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return ClassInitializationAnalysis.InstructionUtils.forStaticGet(this, clazz, appView, mode, assumption);
    }

    @Override
    public boolean outTypeKnownToBeBoolean(Set<Phi> seen) {
        return this.getField().type.isBooleanType();
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, ProgramMethod context) {
        DexType holder = this.getField().holder;
        if (appView.enableWholeProgramOptimizations()) {
            return holder.classInitializationMayHaveSideEffectsInContext(appView, context);
        }
        return holder != context.getHolderType();
    }

    public static class Builder
    extends Instruction.BuilderBase<Builder, StaticGet> {
        private DexField field;

        public Builder setField(DexClassAndField field) {
            return this.setField((DexField)field.getReference());
        }

        public Builder setField(DexField field) {
            this.field = field;
            return this;
        }

        @Override
        public StaticGet build() {
            return this.amend(new StaticGet(this.outValue, this.field));
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

