/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfStaticFieldWrite;
import com.android.tools.r8.code.SgetOrSput;
import com.android.tools.r8.code.Sput;
import com.android.tools.r8.code.SputBoolean;
import com.android.tools.r8.code.SputByte;
import com.android.tools.r8.code.SputChar;
import com.android.tools.r8.code.SputObject;
import com.android.tools.r8.code.SputShort;
import com.android.tools.r8.code.SputWide;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.FieldPut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.StaticFieldInstruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.conversion.MethodConversionOptions;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public class StaticPut
extends FieldInstruction
implements FieldPut,
StaticFieldInstruction {
    public StaticPut(Value source, DexField field) {
        super(field, null, source);
    }

    @Override
    public int opcode() {
        return 60;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public int getValueIndex() {
        return 0;
    }

    @Override
    public Value value() {
        assert (this.inValues.size() == 1);
        return (Value)this.inValues.get(this.getValueIndex());
    }

    @Override
    public void setValue(Value value) {
        this.replaceValue(0, value);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        SgetOrSput instruction;
        int src = builder.allocatedRegister(this.value(), this.getNumber());
        DexField field = this.getField();
        switch (this.getType()) {
            case INT: 
            case FLOAT: {
                instruction = new Sput(src, field);
                break;
            }
            case LONG: 
            case DOUBLE: {
                instruction = new SputWide(src, field);
                break;
            }
            case OBJECT: {
                instruction = new SputObject(src, field);
                break;
            }
            case BOOLEAN: {
                instruction = new SputBoolean(src, field);
                break;
            }
            case BYTE: {
                instruction = new SputByte(src, field);
                break;
            }
            case CHAR: {
                instruction = new SputChar(src, field);
                break;
            }
            case SHORT: {
                instruction = new SputShort(src, field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type: " + (Object)((Object)this.getType()));
            }
        }
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, ProgramMethod context, Instruction.SideEffectAssumption assumption) {
        if (((AppInfo)appView.appInfo()).hasLiveness()) {
            AppView<AppInfoWithLiveness> appViewWithLiveness = appView.withLiveness();
            AppInfoWithLiveness appInfoWithLiveness = appViewWithLiveness.appInfo();
            FieldResolutionResult resolutionResult = appInfoWithLiveness.resolveField(this.getField());
            if (this.internalInstructionInstanceCanThrow(appView, context, assumption, resolutionResult)) {
                return true;
            }
            DexEncodedField encodedField = resolutionResult.getResolvedField();
            assert (encodedField != null) : "NoSuchFieldError (resolution failure) should be caught.";
            boolean isDeadProtoExtensionField = appView.withGeneratedExtensionRegistryShrinker(shrinker -> shrinker.isDeadProtoExtensionField((DexField)encodedField.getReference()), false);
            if (isDeadProtoExtensionField) {
                return false;
            }
            if (encodedField.type().isAlwaysNull(appViewWithLiveness)) {
                return false;
            }
            return appInfoWithLiveness.isFieldRead(encodedField) || this.isStoringObjectWithFinalizer(appViewWithLiveness, encodedField);
        }
        return true;
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "StaticPut instructions define no values.";
        return 0;
    }

    @Override
    public boolean identicalAfterRegisterAllocation(Instruction other, RegisterAllocator allocator, MethodConversionOptions conversionOptions) {
        if (!super.identicalAfterRegisterAllocation(other, allocator, conversionOptions)) {
            return false;
        }
        if (allocator.options().canHaveIncorrectJoinForArrayOfInterfacesBug()) {
            StaticPut staticPut = other.asStaticPut();
            if (this.value().getType().isArrayType() && this.value() != staticPut.value()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isStaticPut()) {
            return false;
        }
        StaticPut o = other.asStaticPut();
        return o.getField() == this.getField() && o.getType() == this.getType();
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forStaticPut(this.getField(), context);
    }

    @Override
    public String toString() {
        return super.toString() + "; field: " + this.getField().toSourceString();
    }

    @Override
    public boolean isFieldPut() {
        return true;
    }

    @Override
    public FieldPut asFieldPut() {
        return this;
    }

    @Override
    public boolean isStaticFieldInstruction() {
        return true;
    }

    @Override
    public boolean isStaticPut() {
        return true;
    }

    @Override
    public StaticPut asStaticPut() {
        return this;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add((CfInstruction)new CfStaticFieldWrite(this.getField(), builder.resolveField(this.getField())), this);
    }

    @Override
    public boolean definitelyTriggersClassInitialization(DexType clazz, ProgramMethod context, AppView<AppInfoWithLiveness> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return ClassInitializationAnalysis.InstructionUtils.forStaticPut(this, clazz, appView, mode, assumption);
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, ProgramMethod context) {
        DexType holder = this.getField().holder;
        if (appView.enableWholeProgramOptimizations()) {
            return holder.classInitializationMayHaveSideEffectsInContext(appView, context);
        }
        return holder != context.getHolderType();
    }
}

