/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.DynamicTypeWithUpperBound;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.UnknownValue;
import com.android.tools.r8.ir.code.AliasedValueConfiguration;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.DefaultAliasedValueConfiguration;
import com.android.tools.r8.ir.code.FixedRegisterValue;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.code.ValueTypeConstraint;
import com.android.tools.r8.ir.optimize.DeadCodeRemover;
import com.android.tools.r8.ir.regalloc.LiveIntervals;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntListIterator;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.MethodPosition;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.BooleanUtils;
import com.android.tools.r8.utils.LongInterval;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class Value
implements Comparable<Value> {
    public static final int UNDEFINED_NUMBER = -1;
    public static final Value UNDEFINED = new Value(-1, TypeElement.getBottom(), null);
    protected final int number;
    public Instruction definition = null;
    private LinkedList<Instruction> users = new LinkedList();
    private Set<Instruction> uniqueUsers = null;
    private LinkedList<Phi> phiUsers = new LinkedList();
    private Set<Phi> uniquePhiUsers = null;
    private Value nextConsecutive = null;
    private Value previousConsecutive = null;
    private LiveIntervals liveIntervals;
    private int needsRegister = -1;
    private boolean isThis = false;
    private LongInterval valueRange;
    private DebugData debugData;
    protected TypeElement type;

    public Value(int number, TypeElement type, DebugLocalInfo local) {
        assert (type != null);
        this.number = number;
        this.debugData = local == null ? null : new DebugData(local);
        this.type = type;
    }

    private static void collectAliasedUsersViaAssume(AliasedValueConfiguration configuration, Set<Instruction> visited, Set<Instruction> usersToTest, Set<Instruction> collectedUsers) {
        for (Instruction user : usersToTest) {
            if (!visited.add(user) || !configuration.isIntroducingAnAlias(user)) continue;
            collectedUsers.addAll(user.outValue().uniqueUsers());
            Value.collectAliasedUsersViaAssume(configuration, visited, user.outValue().uniqueUsers(), collectedUsers);
        }
    }

    private void fullyRemoveUser(Instruction user) {
        this.users.removeIf(u -> u == user);
        this.uniqueUsers = null;
    }

    private void fullyRemovePhiUser(Phi user) {
        this.phiUsers.removeIf(u -> u == user);
        this.uniquePhiUsers = null;
    }

    private void replaceUserInDebugData(Instruction user, Value newValue) {
        user.replaceDebugValue(this, newValue);
    }

    private boolean skipWideningOrNarrowingCheck(AppView<?> appView) {
        return !appView.options().testing.enableNarrowAndWideningingChecksInD8 && !appView.enableWholeProgramOptimizations();
    }

    public void constrainType(ValueTypeConstraint constraint, DexMethod method, Origin origin, Reporter reporter) {
        TypeElement constrainedType = this.constrainedType(constraint);
        if (constrainedType == null) {
            throw reporter.fatalError(new StringDiagnostic("Cannot constrain type: " + this.type + " for value: " + this + " by constraint: " + (Object)((Object)constraint), origin, new MethodPosition(method.asMethodReference())));
        }
        if (constrainedType != this.type) {
            this.setType(constrainedType);
        }
    }

    public TypeElement constrainedType(ValueTypeConstraint constraint) {
        if (constraint == ValueTypeConstraint.INT_OR_FLOAT_OR_OBJECT && !this.type.isWidePrimitive()) {
            return this.type;
        }
        switch (constraint) {
            case OBJECT: {
                if (this.type.isTop()) {
                    if (this.definition != null && this.definition.isConstNumber()) {
                        assert (this.definition.asConstNumber().isZero());
                        return TypeElement.getNull();
                    }
                    return TypeElement.getBottom();
                }
                if (this.type.isReferenceType()) {
                    return this.type;
                }
                if (!this.type.isBottom()) break;
                assert (this.isPhi() || this.definition.isDebugLocalWrite() || this.definition.isArrayGet() && this.definition.asArrayGet().getMemberType() == MemberType.OBJECT);
                return this.type;
            }
            case INT: {
                if (!this.type.isTop() && (!this.type.isSinglePrimitive() || this.type.isFloat())) break;
                return TypeElement.getInt();
            }
            case FLOAT: {
                if (!this.type.isTop() && (!this.type.isSinglePrimitive() || this.type.isInt())) break;
                return TypeElement.getFloat();
            }
            case INT_OR_FLOAT: {
                if (this.type.isTop()) {
                    return TypeElement.getSingle();
                }
                if (!this.type.isSinglePrimitive()) break;
                return this.type;
            }
            case LONG: {
                if (!this.type.isWidePrimitive() || this.type.isDouble()) break;
                return TypeElement.getLong();
            }
            case DOUBLE: {
                if (!this.type.isWidePrimitive() || this.type.isLong()) break;
                return TypeElement.getDouble();
            }
            case LONG_OR_DOUBLE: {
                if (!this.type.isWidePrimitive()) break;
                return this.type;
            }
            default: {
                throw new Unreachable("Unexpected constraint: " + (Object)((Object)constraint));
            }
        }
        return null;
    }

    public boolean verifyCompatible(ValueType valueType) {
        return this.verifyCompatible(ValueTypeConstraint.fromValueType(valueType));
    }

    public boolean verifyCompatible(ValueTypeConstraint constraint) {
        assert (this.constrainedType(constraint) != null);
        return true;
    }

    public void markNonDebugLocalRead() {
        assert (!this.isPhi());
    }

    public boolean isFixedRegisterValue() {
        return false;
    }

    public FixedRegisterValue asFixedRegisterValue() {
        return null;
    }

    public Instruction getDefinition() {
        assert (!this.isPhi());
        return this.definition;
    }

    public boolean hasAliasedValue() {
        return this.getAliasedValue() != this;
    }

    public Value getAliasedValue() {
        return this.getAliasedValue(DefaultAliasedValueConfiguration.getInstance(), Predicates.alwaysFalse());
    }

    public Value getAliasedValue(AliasedValueConfiguration configuration) {
        return this.getAliasedValue(configuration, Predicates.alwaysFalse());
    }

    public Value getAliasedValue(AliasedValueConfiguration configuration, Predicate<Value> stoppingCriterion) {
        Value lastAliasedValue;
        assert (stoppingCriterion != null);
        Set<Value> visited = Sets.newIdentityHashSet();
        Value aliasedValue = this;
        do {
            lastAliasedValue = aliasedValue;
            if (aliasedValue.isPhi()) {
                return aliasedValue;
            }
            if (stoppingCriterion.test(aliasedValue)) {
                return aliasedValue;
            }
            Instruction definitionOfAliasedValue = aliasedValue.definition;
            if (!configuration.isIntroducingAnAlias(definitionOfAliasedValue)) continue;
            aliasedValue = configuration.getAliasForOutValue(definitionOfAliasedValue);
            assert (visited.add(aliasedValue));
        } while (aliasedValue != lastAliasedValue);
        assert (aliasedValue.isPhi() || !aliasedValue.definition.isAssume());
        return aliasedValue;
    }

    public Value getSpecificAliasedValue(Predicate<Value> stoppingCriterion) {
        Value aliasedValue = this.getAliasedValue(DefaultAliasedValueConfiguration.getInstance(), stoppingCriterion);
        return stoppingCriterion.test(aliasedValue) ? aliasedValue : null;
    }

    public int getNumber() {
        return this.number;
    }

    public int requiredRegisters() {
        return this.type.requiredRegisters();
    }

    public DebugLocalInfo getLocalInfo() {
        return this.debugData == null ? null : this.debugData.local;
    }

    public boolean hasLocalInfo() {
        return this.getLocalInfo() != null;
    }

    public void setLocalInfo(DebugLocalInfo local) {
        assert (local != null);
        assert (this.debugData == null);
        this.debugData = new DebugData(local);
    }

    public Set<Instruction> getDebugLocalEnds() {
        return this.debugData == null ? Collections.emptySet() : Collections.unmodifiableSet(this.debugData.users);
    }

    public void addDebugLocalEnd(Instruction end) {
        assert (end != null);
        this.debugData.users.add(end);
        end.addDebugValue(this);
    }

    public void linkTo(Value other) {
        assert (this.nextConsecutive == null || this.nextConsecutive == other);
        assert (other.previousConsecutive == null || other.previousConsecutive == this);
        other.previousConsecutive = this;
        this.nextConsecutive = other;
    }

    public void replaceLink(Value newArgument) {
        assert (this.isLinked());
        if (this.previousConsecutive != null) {
            this.previousConsecutive.nextConsecutive = newArgument;
            newArgument.previousConsecutive = this.previousConsecutive;
            this.previousConsecutive = null;
        }
        if (this.nextConsecutive != null) {
            this.nextConsecutive.previousConsecutive = newArgument;
            newArgument.nextConsecutive = this.nextConsecutive;
            this.nextConsecutive = null;
        }
    }

    public boolean isLinked() {
        return this.nextConsecutive != null || this.previousConsecutive != null;
    }

    public Value getStartOfConsecutive() {
        Value current = this;
        while (current.getPreviousConsecutive() != null) {
            current = current.getPreviousConsecutive();
        }
        return current;
    }

    public Value getNextConsecutive() {
        return this.nextConsecutive;
    }

    public Value getPreviousConsecutive() {
        return this.previousConsecutive;
    }

    public boolean onlyUsedInBlock(BasicBlock block) {
        if (this.hasPhiUsers() || this.hasDebugUsers()) {
            return false;
        }
        for (Instruction user : this.uniqueUsers()) {
            if (user.getBlock() == block) continue;
            return false;
        }
        return true;
    }

    public Set<Instruction> uniqueUsers() {
        if (this.uniqueUsers != null) {
            return this.uniqueUsers;
        }
        this.uniqueUsers = ImmutableSet.copyOf(this.users);
        return this.uniqueUsers;
    }

    public boolean hasSingleUniqueUser() {
        return this.uniqueUsers().size() == 1;
    }

    public Instruction singleUniqueUser() {
        assert (ImmutableSet.copyOf(this.users).size() == 1);
        return this.users.getFirst();
    }

    public Set<Instruction> aliasedUsers() {
        return this.aliasedUsers(DefaultAliasedValueConfiguration.getInstance());
    }

    public Set<Instruction> aliasedUsers(AliasedValueConfiguration configuration) {
        Set<Instruction> users = SetUtils.newIdentityHashSet(this.uniqueUsers());
        Set<Instruction> visited = Sets.newIdentityHashSet();
        Value.collectAliasedUsersViaAssume(configuration, visited, this.uniqueUsers(), users);
        return users;
    }

    public Phi firstPhiUser() {
        assert (!this.phiUsers.isEmpty());
        return this.phiUsers.getFirst();
    }

    public Set<Phi> uniquePhiUsers() {
        if (this.uniquePhiUsers != null) {
            return this.uniquePhiUsers;
        }
        this.uniquePhiUsers = ImmutableSet.copyOf(this.phiUsers);
        return this.uniquePhiUsers;
    }

    public Set<Instruction> debugUsers() {
        return this.debugData == null ? null : Collections.unmodifiableSet(this.debugData.users);
    }

    public boolean hasAnyUsers() {
        return this.hasUsers() || this.hasPhiUsers() || this.hasDebugUsers();
    }

    public boolean hasDebugUsers() {
        return this.debugData != null && !this.debugData.users.isEmpty();
    }

    public boolean hasNonDebugUsers() {
        return this.hasUsers() || this.hasPhiUsers();
    }

    public boolean hasPhiUsers() {
        return !this.phiUsers.isEmpty();
    }

    public boolean hasUsers() {
        return !this.users.isEmpty();
    }

    public boolean hasUserThatMatches(Predicate<Instruction> predicate) {
        for (Instruction user : this.uniqueUsers()) {
            if (!predicate.test(user)) continue;
            return true;
        }
        return false;
    }

    public int numberOfUsers() {
        int size = this.users.size();
        if (size <= 1) {
            return size;
        }
        return this.uniqueUsers().size();
    }

    public int numberOfPhiUsers() {
        int size = this.phiUsers.size();
        if (size <= 1) {
            return size;
        }
        return this.uniquePhiUsers().size();
    }

    public int numberOfAllNonDebugUsers() {
        return this.numberOfUsers() + this.numberOfPhiUsers();
    }

    public int numberOfDebugUsers() {
        return this.debugData == null ? 0 : this.debugData.users.size();
    }

    public int numberOfAllUsers() {
        return this.numberOfAllNonDebugUsers() + this.numberOfDebugUsers();
    }

    public boolean isUsed() {
        return !this.users.isEmpty() || !this.phiUsers.isEmpty() || this.numberOfDebugUsers() > 0;
    }

    public boolean isAlwaysNull(AppView<?> appView) {
        if (this.hasLocalInfo()) {
            return false;
        }
        if (this.type.isDefinitelyNull()) {
            return true;
        }
        if (this.type.isClassType() && ((AppInfo)appView.appInfo()).hasLiveness()) {
            return this.type.asClassType().getClassType().isAlwaysNull(appView.withLiveness());
        }
        return false;
    }

    public boolean isMaybeNull() {
        return !this.isNeverNull();
    }

    public boolean usedInMonitorOperation() {
        for (Instruction instruction : this.uniqueUsers()) {
            if (!instruction.isMonitor()) continue;
            return true;
        }
        return false;
    }

    public void addUser(Instruction user) {
        this.users.add(user);
        this.uniqueUsers = null;
    }

    public void removeUser(Instruction user) {
        this.users.remove(user);
        this.uniqueUsers = null;
    }

    public void clearUsers() {
        this.users.clear();
        this.uniqueUsers = null;
        this.clearPhiUsers();
        if (this.debugData != null) {
            this.debugData.users.clear();
        }
    }

    public void clearPhiUsers() {
        this.phiUsers.clear();
        this.uniquePhiUsers = null;
    }

    public void addPhiUser(Phi user) {
        this.phiUsers.add(user);
        this.uniquePhiUsers = null;
    }

    public void removePhiUser(Phi user) {
        this.phiUsers.remove(user);
        this.uniquePhiUsers = null;
    }

    public boolean isUninitializedLocal() {
        return this.definition != null && this.definition.isDebugLocalUninitialized();
    }

    public boolean isInitializedLocal() {
        return !this.isUninitializedLocal();
    }

    public void removeDebugUser(Instruction user) {
        if (this.debugData != null && this.debugData.users != null) {
            this.debugData.users.remove(user);
            return;
        }
        assert (false);
    }

    public boolean hasUsersInfo() {
        return this.users != null;
    }

    public void clearUsersInfo() {
        this.users = null;
        this.uniqueUsers = null;
        this.phiUsers = null;
        this.uniquePhiUsers = null;
        if (this.debugData != null) {
            this.debugData.users = null;
        }
    }

    public Set<Value> affectedValues() {
        ImmutableSet.Builder affectedValues = ImmutableSet.builder();
        this.forEachAffectedValue(affectedValues::add);
        return affectedValues.build();
    }

    public void addAffectedValuesTo(Set<Value> affectedValues) {
        this.forEachAffectedValue(affectedValues::add);
    }

    public void forEachAffectedValue(Consumer<Value> consumer) {
        for (Instruction user : this.uniqueUsers()) {
            if (!user.hasOutValue()) continue;
            consumer.accept(user.outValue());
        }
        this.uniquePhiUsers().forEach(consumer::accept);
    }

    public void replaceUsers(Value newValue) {
        this.replaceUsers(newValue, null);
    }

    public void replaceUsers(Value newValue, Set<Value> affectedValues) {
        if (this == newValue) {
            return;
        }
        for (Instruction instruction : this.uniqueUsers()) {
            instruction.replaceValue(this, newValue);
            if (affectedValues == null || !instruction.hasOutValue()) continue;
            affectedValues.add(instruction.outValue);
        }
        for (Phi phi : this.uniquePhiUsers()) {
            phi.replaceOperand(this, newValue);
            if (affectedValues == null) continue;
            affectedValues.add(phi);
        }
        if (this.debugData != null) {
            for (Instruction instruction : this.debugData.users) {
                this.replaceUserInDebugData(instruction, newValue);
            }
            this.debugData.users.clear();
        }
        this.clearUsers();
    }

    public void replacePhiUsers(Value newValue) {
        if (this == newValue) {
            return;
        }
        for (Phi user : this.uniquePhiUsers()) {
            user.replaceOperand(this, newValue);
        }
        this.clearPhiUsers();
    }

    public void replaceSelectiveInstructionUsers(Value newValue, Predicate<Instruction> predicate) {
        if (this == newValue) {
            return;
        }
        for (Instruction user : this.uniqueUsers()) {
            if (!predicate.test(user)) continue;
            this.fullyRemoveUser(user);
            user.replaceValue(this, newValue);
        }
    }

    public void replaceSelectiveUsers(Value newValue, Set<Instruction> selectedInstructions, Map<Phi, IntList> selectedPhisWithPredecessorIndexes) {
        if (this == newValue) {
            return;
        }
        for (Instruction instruction : this.uniqueUsers()) {
            if (!selectedInstructions.contains(instruction)) continue;
            this.fullyRemoveUser(instruction);
            instruction.replaceValue(this, newValue);
        }
        Set<Phi> selectedPhis = selectedPhisWithPredecessorIndexes.keySet();
        for (Phi phi : this.uniquePhiUsers()) {
            IntList positionsToUpdate;
            if (!selectedPhis.contains(phi)) continue;
            long count = phi.getOperands().stream().filter(operand -> operand == this).count();
            if (count == (long)(positionsToUpdate = selectedPhisWithPredecessorIndexes.get(phi)).size()) {
                this.fullyRemovePhiUser(phi);
            }
            IntListIterator intListIterator = positionsToUpdate.iterator();
            while (intListIterator.hasNext()) {
                int position = (Integer)intListIterator.next();
                assert (phi.getOperand(position) == this);
                phi.replaceOperandAt(position, newValue);
            }
        }
        if (this.debugData != null) {
            Iterator<Instruction> iterator2 = this.debugData.users.iterator();
            while (iterator2.hasNext()) {
                Instruction instruction = iterator2.next();
                if (!selectedInstructions.contains(instruction)) continue;
                this.replaceUserInDebugData(instruction, newValue);
                iterator2.remove();
            }
        }
    }

    public void replaceDebugUser(Instruction oldUser, Instruction newUser) {
        boolean removed = this.debugData.users.remove(oldUser);
        assert (removed);
        if (removed) {
            this.addDebugLocalEnd(newUser);
        }
    }

    public void setLiveIntervals(LiveIntervals intervals) {
        assert (this.liveIntervals == null);
        this.liveIntervals = intervals;
    }

    public LiveIntervals getLiveIntervals() {
        return this.liveIntervals;
    }

    public boolean needsRegister() {
        assert (this.needsRegister >= 0);
        assert (!this.hasUsersInfo() || this.needsRegister > 0 == this.internalComputeNeedsRegister());
        return this.needsRegister > 0;
    }

    public void setNeedsRegister(boolean value) {
        assert (this.needsRegister == -1 || this.needsRegister > 0 == value);
        this.needsRegister = value ? 1 : 0;
    }

    public void computeNeedsRegister() {
        assert (this.needsRegister < 0);
        this.setNeedsRegister(this.internalComputeNeedsRegister());
    }

    public boolean internalComputeNeedsRegister() {
        if (!this.isConstNumber()) {
            return true;
        }
        if (this.numberOfPhiUsers() > 0) {
            return true;
        }
        for (Instruction user : this.uniqueUsers()) {
            if (!user.needsValueInRegister(this)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRegisterConstraint() {
        for (Instruction instruction : this.uniqueUsers()) {
            if (instruction.maxInValueRegister() == 65535) continue;
            return true;
        }
        return false;
    }

    public boolean isValueOnStack() {
        return false;
    }

    @Override
    public int compareTo(Value value) {
        return Integer.compare(this.number, value.number);
    }

    public int hashCode() {
        return this.number;
    }

    public String toString() {
        boolean isConstant;
        StringBuilder builder = new StringBuilder();
        builder.append("v");
        builder.append(this.number);
        boolean bl = isConstant = this.definition != null && this.definition.isConstNumber();
        if (isConstant || this.hasLocalInfo()) {
            builder.append("(");
            if (isConstant && this.definition.asConstNumber().outValue != null) {
                ConstNumber constNumber = this.definition.asConstNumber();
                if (constNumber.getOutType().isSinglePrimitive()) {
                    builder.append((int)constNumber.getRawValue());
                } else {
                    builder.append(constNumber.getRawValue());
                }
            }
            if (isConstant && this.hasLocalInfo()) {
                builder.append(", ");
            }
            if (this.hasLocalInfo()) {
                builder.append(this.getLocalInfo());
            }
            builder.append(")");
        }
        if (this.valueRange != null) {
            builder.append(this.valueRange);
        }
        return builder.toString();
    }

    public ValueType outType() {
        return ValueType.fromType(this.type);
    }

    public ConstInstruction getConstInstruction() {
        assert (this.isConstant());
        return this.definition.getOutConstantConstInstruction();
    }

    public boolean isConstNumber() {
        return this.isConstant() && this.getConstInstruction().isConstNumber();
    }

    public boolean isConstBoolean(boolean value) {
        return this.isConstNumber() && this.definition.asConstNumber().getRawValue() == BooleanUtils.longValue(value);
    }

    public boolean isConstZero() {
        return this.isConstNumber() && this.definition.asConstNumber().isZero();
    }

    public boolean isConstString() {
        return this.isConstant() && this.getConstInstruction().isConstString();
    }

    public boolean isDexItemBasedConstString() {
        return this.isConstant() && this.getConstInstruction().isDexItemBasedConstString();
    }

    public boolean isDexItemBasedConstStringThatNeedsToComputeClassName() {
        return this.isDexItemBasedConstString() && this.getConstInstruction().asDexItemBasedConstString().getNameComputationInfo().needsToComputeName();
    }

    public boolean isConstClass() {
        return this.isConstant() && this.getConstInstruction().isConstClass();
    }

    public boolean isConstant() {
        return this.definition.isOutConstant() && !this.hasLocalInfo();
    }

    public AbstractValue getAbstractValue(AppView<?> appView, ProgramMethod context) {
        if (!appView.enableWholeProgramOptimizations()) {
            return UnknownValue.getInstance();
        }
        if (this.getType().nullability().isDefinitelyNull()) {
            return appView.abstractValueFactory().createNullValue();
        }
        Value root = this.getAliasedValue();
        if (root.isPhi()) {
            return UnknownValue.getInstance();
        }
        return root.definition.getAbstractValue(appView.withClassHierarchy(), context);
    }

    public boolean isDefinedByInstructionSatisfying(Predicate<Instruction> predicate) {
        return predicate.test(this.definition);
    }

    public boolean isPhi() {
        return false;
    }

    public Phi asPhi() {
        return null;
    }

    public boolean isNeverNull() {
        assert (this.type.isReferenceType());
        return this.isDefinedByInstructionSatisfying(Instruction::isAssumeWithNonNullAssumption) || this.type.isDefinitelyNotNull();
    }

    public boolean isArgument() {
        return this.isDefinedByInstructionSatisfying(Instruction::isArgument);
    }

    public boolean onlyDependsOnArgument() {
        if (this.isPhi()) {
            return false;
        }
        switch (this.definition.opcode()) {
            case 5: 
            case 12: 
            case 15: 
            case 16: 
            case 20: {
                return true;
            }
            case 10: {
                return this.definition.asCheckCast().object().onlyDependsOnArgument();
            }
            case 29: {
                return this.definition.asInstanceOf().value().onlyDependsOnArgument();
            }
        }
        return false;
    }

    public boolean knownToBeBoolean() {
        return this.knownToBeBoolean(null);
    }

    public boolean knownToBeBoolean(Set<Phi> seen) {
        if (!this.getType().isInt()) {
            return false;
        }
        if (this.isPhi()) {
            Phi self = this.asPhi();
            if (seen == null) {
                seen = Sets.newIdentityHashSet();
            }
            if (seen.contains(self)) {
                return true;
            }
            seen.add(self);
            for (Value operand : self.getOperands()) {
                if (operand.knownToBeBoolean(seen)) continue;
                operand.knownToBeBoolean(seen);
                return false;
            }
            return true;
        }
        assert (this.definition != null);
        return this.definition.outTypeKnownToBeBoolean(seen);
    }

    public void markAsThis() {
        assert (this.isArgument());
        assert (!this.isThis);
        this.isThis = true;
    }

    public boolean isThis() {
        return this.isThis;
    }

    public void setValueRange(LongInterval range) {
        this.valueRange = range;
    }

    public boolean hasValueRange() {
        return this.valueRange != null || this.isConstNumber();
    }

    public boolean isValueInRange(int value) {
        if (this.isConstNumber()) {
            return value == this.getConstInstruction().asConstNumber().getIntValue();
        }
        return this.valueRange != null && this.valueRange.containsValue(value);
    }

    public LongInterval getValueRange() {
        if (this.isConstNumber()) {
            if (this.type.isSinglePrimitive()) {
                int value = this.getConstInstruction().asConstNumber().getIntValue();
                return new LongInterval(value, value);
            }
            assert (this.type.isWidePrimitive());
            long value = this.getConstInstruction().asConstNumber().getLongValue();
            return new LongInterval(value, value);
        }
        return this.valueRange;
    }

    public boolean isDead(AppView<?> appView, IRCode code) {
        return !this.isUsed() || this.isDead(appView, code, Predicates.alwaysFalse());
    }

    public boolean isDead(AppView<?> appView, IRCode code, Predicate<Instruction> ignoreUser) {
        return !this.isUsed() || this.isDead(appView, code, ignoreUser, Sets.newIdentityHashSet());
    }

    protected boolean isDead(AppView<?> appView, IRCode code, Predicate<Instruction> ignoreUser, Set<Value> active) {
        if (active.size() > 100) {
            return false;
        }
        if (this.hasDebugUsers()) {
            return false;
        }
        active.add(this);
        for (Instruction instruction : this.uniqueUsers()) {
            Value outValue;
            if (ignoreUser.test(instruction)) continue;
            DeadCodeRemover.DeadInstructionResult result = instruction.canBeDeadCode(appView, code);
            if (result.isNotDead()) {
                return false;
            }
            if (result.isMaybeDead()) {
                for (Value valueRequiredToBeDead : result.getValuesRequiredToBeDead()) {
                    if (active.contains(valueRequiredToBeDead) || valueRequiredToBeDead.isDead(appView, code, ignoreUser, active)) continue;
                    return false;
                }
            }
            if ((outValue = instruction.outValue()) == null || active.contains(outValue) || outValue.isDead(appView, code, ignoreUser, active)) continue;
            return false;
        }
        for (Phi phi : this.uniquePhiUsers()) {
            if (active.contains(phi) || phi.isDead(appView, code, ignoreUser, active)) continue;
            return false;
        }
        return true;
    }

    public boolean isZero() {
        return this.isConstant() && this.getConstInstruction().isConstNumber() && this.getConstInstruction().asConstNumber().isZero();
    }

    public void setType(TypeElement newType) {
        assert (newType != null);
        this.type = newType;
    }

    public void widening(AppView<?> appView, TypeElement newType) {
        assert (this.skipWideningOrNarrowingCheck(appView) || this.type.lessThanOrEqual(newType, appView)) : "During WIDENING, " + newType + " < " + this.type + " at " + (this.isPhi() ? this.asPhi().printPhi() : this.definition.toString());
        this.setType(newType);
    }

    public void narrowing(AppView<?> appView, TypeElement newType) {
        assert (this.skipWideningOrNarrowingCheck(appView) || !this.type.strictlyLessThan(newType, appView)) : "During NARROWING, " + this.type + " < " + newType + " at " + (this.isPhi() ? this.asPhi().printPhi() : this.definition.toString());
        this.setType(newType);
    }

    public BasicBlock getBlock() {
        return this.definition.getBlock();
    }

    public TypeElement getType() {
        return this.type;
    }

    public DynamicTypeWithUpperBound getDynamicType(AppView<AppInfoWithLiveness> appView) {
        return DynamicType.create(appView, this);
    }

    public TypeElement getDynamicUpperBoundType(AppView<? extends AppInfoWithClassHierarchy> appView) {
        TypeElement lattice;
        Value root = this.getAliasedValue();
        if (root.isPhi()) {
            assert (this.getSpecificAliasedValue(value -> value.isDefinedByInstructionSatisfying(Instruction::isAssumeWithDynamicTypeAssumption)) == null);
            TypeElement result = root.getDynamicUpperBoundType(appView);
            if (this.getType().isReferenceType() && this.getType().isDefinitelyNotNull()) {
                return result.asReferenceType().asMeetWithNotNull();
            }
            return result;
        }
        Value aliasedValue = this.getSpecificAliasedValue(value -> value.isDefinedByInstructionSatisfying(Instruction::isAssumeWithDynamicTypeAssumption));
        if (aliasedValue != null) {
            lattice = aliasedValue.definition.asAssume().getDynamicTypeAssumption().getDynamicType().getDynamicUpperBoundType();
            assert (lattice.lessThanOrEqualUpToNullability(this.type, appView)) : this.type + " < " + lattice;
        } else {
            lattice = this.type;
        }
        if (this.type.isDefinitelyNotNull() && lattice.isNullable()) {
            assert (lattice.isReferenceType());
            return lattice.asReferenceType().asMeetWithNotNull();
        }
        return lattice;
    }

    public ClassTypeElement getDynamicLowerBoundType(AppView<AppInfoWithLiveness> appView) {
        return this.getDynamicLowerBoundType(appView, null, Nullability.maybeNull());
    }

    public ClassTypeElement getDynamicLowerBoundType(AppView<AppInfoWithLiveness> appView, TypeElement dynamicUpperBoundType, Nullability maxNullability) {
        ClassTypeElement aliasedValueType;
        ClassTypeElement upperBoundClassType;
        DexClass upperBoundClass;
        TypeElement upperBoundType;
        TypeElement typeElement = upperBoundType = dynamicUpperBoundType != null ? dynamicUpperBoundType : this.getType();
        if (upperBoundType.isClassType() && (upperBoundClass = appView.definitionFor((upperBoundClassType = upperBoundType.asClassType()).getClassType())) != null && upperBoundClass.isEffectivelyFinal(appView)) {
            return upperBoundClassType.meetNullability(maxNullability);
        }
        Value root = this.getAliasedValue();
        if (root.isPhi()) {
            return null;
        }
        Instruction definition = root.getDefinition();
        if (definition.isNewInstance()) {
            DexType type = definition.asNewInstance().getType();
            DexClass clazz = appView.definitionFor(type);
            if (clazz != null && !clazz.isInterface()) {
                assert (!maxNullability.isBottom());
                return TypeElement.fromDexType(type, Nullability.definitelyNotNull(), appView).asClassType();
            }
            return null;
        }
        Value aliasedValue = this.getSpecificAliasedValue(value -> value.getDefinition().isAssumeWithDynamicTypeAssumption());
        if (aliasedValue != null && (aliasedValueType = aliasedValue.getDefinition().asAssume().getDynamicTypeAssumption().getDynamicType().getDynamicLowerBoundType()) != null) {
            aliasedValueType = aliasedValueType.meetNullability(this.getType().nullability());
            assert (aliasedValueType.nullability().lessThanOrEqual(maxNullability));
            return aliasedValueType;
        }
        return null;
    }

    private static class DebugData {
        final DebugLocalInfo local;
        Set<Instruction> users = Sets.newIdentityHashSet();

        DebugData(DebugLocalInfo local) {
            this.local = local;
        }
    }
}

