/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.PrimitiveTypeElement;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.ValueType;

public enum ValueTypeConstraint {
    OBJECT,
    INT,
    FLOAT,
    INT_OR_FLOAT,
    INT_OR_FLOAT_OR_OBJECT,
    LONG,
    DOUBLE,
    LONG_OR_DOUBLE;


    public static ValueTypeConstraint fromValueType(ValueType type) {
        switch (type) {
            case OBJECT: {
                return OBJECT;
            }
            case INT: {
                return INT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case LONG: {
                return LONG;
            }
            case DOUBLE: {
                return DOUBLE;
            }
        }
        throw new Unreachable("Unexpected value type: " + type);
    }

    public static ValueTypeConstraint fromMemberType(MemberType type) {
        switch (type) {
            case BOOLEAN_OR_BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return INT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case INT_OR_FLOAT: {
                return INT_OR_FLOAT;
            }
            case LONG: {
                return LONG;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case LONG_OR_DOUBLE: {
                return LONG_OR_DOUBLE;
            }
            case OBJECT: {
                return OBJECT;
            }
        }
        throw new Unreachable("Unexpected member type: " + (Object)((Object)type));
    }

    public static ValueTypeConstraint fromTypeDescriptorChar(char descriptor) {
        switch (descriptor) {
            case 'L': 
            case '[': {
                return OBJECT;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return INT;
            }
            case 'F': {
                return FLOAT;
            }
            case 'J': {
                return LONG;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'V': {
                throw new InternalCompilerError("No value type for void type.");
            }
        }
        throw new Unreachable("Invalid descriptor char '" + descriptor + "'");
    }

    public static ValueTypeConstraint fromDexType(DexType type) {
        return ValueTypeConstraint.fromTypeDescriptorChar((char)type.descriptor.content[0]);
    }

    public static ValueTypeConstraint fromNumericType(NumericType type) {
        switch (type) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return INT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case LONG: {
                return LONG;
            }
            case DOUBLE: {
                return DOUBLE;
            }
        }
        throw new Unreachable("Invalid numeric type '" + (Object)((Object)type) + "'");
    }

    public static ValueTypeConstraint fromTypeLattice(TypeElement typeElement) {
        if (typeElement.isReferenceType()) {
            return OBJECT;
        }
        if (typeElement.isFineGrainedType() || typeElement.isInt()) {
            return INT;
        }
        if (typeElement.isFloat()) {
            return FLOAT;
        }
        if (typeElement.isLong()) {
            return LONG;
        }
        if (typeElement.isDouble()) {
            return DOUBLE;
        }
        if (typeElement.isSinglePrimitive()) {
            return INT_OR_FLOAT;
        }
        if (typeElement.isWidePrimitive()) {
            return LONG_OR_DOUBLE;
        }
        if (typeElement.isTop()) {
            return INT_OR_FLOAT_OR_OBJECT;
        }
        throw new Unreachable("Unexpected conversion of type: " + typeElement);
    }

    public boolean isObject() {
        return this == OBJECT;
    }

    public boolean isSingle() {
        return this == INT || this == FLOAT || this == INT_OR_FLOAT;
    }

    public boolean isWide() {
        return this == LONG || this == DOUBLE || this == LONG_OR_DOUBLE;
    }

    public boolean isPrecise() {
        return this != INT_OR_FLOAT && this != LONG_OR_DOUBLE && this != INT_OR_FLOAT_OR_OBJECT;
    }

    public int requiredRegisters() {
        return this.isWide() ? 2 : 1;
    }

    public PrimitiveTypeElement toPrimitiveType() {
        switch (this) {
            case INT: {
                return TypeElement.getInt();
            }
            case FLOAT: {
                return TypeElement.getFloat();
            }
            case LONG: {
                return TypeElement.getLong();
            }
            case DOUBLE: {
                return TypeElement.getDouble();
            }
        }
        throw new Unreachable("Unexpected type in conversion to primitive: " + (Object)((Object)this));
    }
}

