/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.cf.code.CfFrame;
import com.android.tools.r8.cf.code.CfGoto;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.cf.code.CfNew;
import com.android.tools.r8.cf.code.CfPosition;
import com.android.tools.r8.cf.code.CfSwitch;
import com.android.tools.r8.cf.code.CfThrow;
import com.android.tools.r8.cf.code.CfTryCatch;
import com.android.tools.r8.errors.InvalidDebugInfoException;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfCodeDiagnostics;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.CanonicalPositions;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.Monitor;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.code.ValueTypeConstraint;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.SourceCode;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMaps;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntListIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.InternalOutputMode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CfSourceCode
implements SourceCode {
    private static final int EXCEPTIONAL_SYNC_EXIT_OFFSET = -2;
    private IRBuilder.BlockInfo currentBlockInfo;
    private boolean hasExitingInstruction = false;
    private final boolean needsGeneratedMethodSynchronization;
    private boolean currentlyGeneratingMethodSynchronization = false;
    private Monitor monitorEnter = null;
    private CfState state;
    private final List<CfCode.LocalVariableInfo> localVariables;
    private final CfCode code;
    private final ProgramMethod method;
    private final Origin origin;
    private final AppView<?> appView;
    private final Reference2IntMap<CfLabel> labelOffsets = new Reference2IntOpenHashMap<CfLabel>();
    private TryHandlerList cachedTryHandlerList;
    private LocalVariableList cachedLocalVariableList;
    private int currentInstructionIndex;
    private int currentBlockIndex;
    private boolean inPrelude;
    private Int2ReferenceMap<DebugLocalInfo> incomingLocals;
    private Int2ReferenceMap<DebugLocalInfo> outgoingLocals;
    private Int2ReferenceMap<CfState.Snapshot> incomingState = new Int2ReferenceOpenHashMap<CfState.Snapshot>();
    private final CanonicalPositions canonicalPositions;
    private final InternalOutputMode internalOutputMode;

    public CfSourceCode(CfCode code, List<CfCode.LocalVariableInfo> localVariables, ProgramMethod method, DexMethod originalMethod, Position callerPosition, Origin origin, AppView<?> appView) {
        this.code = code;
        this.localVariables = localVariables;
        this.method = method;
        this.origin = origin;
        this.appView = appView;
        int cfPositionCount = 0;
        for (int i = 0; i < code.getInstructions().size(); ++i) {
            CfInstruction instruction = code.getInstructions().get(i);
            if (instruction instanceof CfLabel) {
                this.labelOffsets.put((CfLabel)instruction, this.instructionOffset(i));
            }
            if (!(instruction instanceof CfPosition)) continue;
            ++cfPositionCount;
        }
        this.state = new CfState(origin);
        this.canonicalPositions = new CanonicalPositions(callerPosition, cfPositionCount, originalMethod, ((DexEncodedMethod)method.getDefinition()).isD8R8Synthesized());
        this.internalOutputMode = appView.options().getInternalOutputMode();
        this.needsGeneratedMethodSynchronization = !this.getMethod().isProcessed() && this.internalOutputMode.isGeneratingDex() && this.getMethod().isSynchronized();
    }

    private DexEncodedMethod getMethod() {
        return (DexEncodedMethod)this.method.getDefinition();
    }

    private TryHandlerList getTryHandlers(int instructionOffset, DexItemFactory factory) {
        if (this.cachedTryHandlerList == null || !this.cachedTryHandlerList.validFor(instructionOffset)) {
            this.cachedTryHandlerList = TryHandlerList.computeTryHandlers(instructionOffset, this.code.getTryCatchRanges(), this.labelOffsets, this.needsGeneratedMethodSynchronization, factory);
        }
        return this.cachedTryHandlerList;
    }

    private LocalVariableList getLocalVariables(int instructionOffset) {
        if (this.cachedLocalVariableList == null || !this.cachedLocalVariableList.validFor(instructionOffset)) {
            this.cachedLocalVariableList = LocalVariableList.compute(instructionOffset, this.localVariables, this.labelOffsets);
        }
        return this.cachedLocalVariableList;
    }

    private int[] getTargets(int instructionIndex) {
        CfInstruction instruction = this.code.getInstructions().get(instructionIndex);
        assert (this.isControlFlow(instruction));
        CfLabel target = instruction.getTarget();
        if (instruction.isReturn() || instruction instanceof CfThrow) {
            assert (target == null);
            return new int[0];
        }
        assert (instruction instanceof CfSwitch || target != null) : "getTargets(): Non-control flow instruction " + instruction.getClass();
        if (instruction instanceof CfSwitch) {
            CfSwitch cfSwitch = (CfSwitch)instruction;
            List<CfLabel> targets = cfSwitch.getSwitchTargets();
            int[] res = new int[targets.size() + 1];
            for (int i = 0; i < targets.size(); ++i) {
                res[i] = this.labelOffsets.getInt(targets.get(i));
            }
            res[targets.size()] = this.labelOffsets.getInt(cfSwitch.getDefaultTarget());
            return res;
        }
        int targetIndex = this.labelOffsets.getInt(target);
        if (instruction instanceof CfGoto) {
            return new int[]{targetIndex};
        }
        assert (instruction.isConditionalJump());
        return new int[]{targetIndex, instructionIndex + 1};
    }

    private boolean isCurrentlyGeneratingMethodSynchronization() {
        return this.currentlyGeneratingMethodSynchronization;
    }

    private boolean isExceptionalExitForMethodSynchronization(int instructionIndex) {
        return instructionIndex == -2;
    }

    private void buildMethodEnterSynchronization(IRBuilder builder) {
        int monitorRegister;
        assert (this.needsGeneratedMethodSynchronization);
        this.currentlyGeneratingMethodSynchronization = true;
        DexType type = this.method.getHolderType();
        if (this.getMethod().isStatic()) {
            monitorRegister = this.state.push((DexType)type).register;
            this.state.pop();
            builder.addConstClass(monitorRegister, type);
        } else {
            monitorRegister = this.state.read((int)0).register;
        }
        this.monitorEnter = builder.addMonitor(Monitor.Type.ENTER, monitorRegister);
        this.currentlyGeneratingMethodSynchronization = false;
    }

    private void buildExceptionalExitMethodSynchronization(IRBuilder builder) {
        assert (this.needsGeneratedMethodSynchronization);
        this.currentlyGeneratingMethodSynchronization = true;
        this.state.setPosition(this.getCanonicalDebugPositionAtOffset(-2));
        builder.add(new Monitor(Monitor.Type.EXIT, this.monitorEnter.inValues().get(0)));
        builder.addThrow(this.getMoveExceptionRegister(0));
        this.currentlyGeneratingMethodSynchronization = false;
    }

    private void build(CfInstruction instruction, IRBuilder builder) {
        instruction.buildIR(builder, this.state, this);
    }

    private void recordStateForTarget(int target, CfState.Snapshot snapshot) {
        CfState.Snapshot existing = (CfState.Snapshot)this.incomingState.get(target);
        CfState.Snapshot merged = CfState.merge(existing, snapshot, this.origin);
        if (merged != existing) {
            this.incomingState.put(target, merged);
        }
    }

    private boolean isFirstFrameInBlock() {
        for (int i = this.currentBlockIndex; i < this.currentInstructionIndex; ++i) {
            CfInstruction cfInstruction = this.code.getInstructions().get(i);
            if (cfInstruction.isPosition() || cfInstruction.isLabel()) continue;
            return false;
        }
        return true;
    }

    private DexType convertUninitialized(CfFrame.FrameType type) {
        if (type.isInitialized()) {
            return type.getInitializedType();
        }
        if (type.isUninitializedNew()) {
            CfInstruction instruction;
            int insnOffset;
            int labelOffset = this.getLabelOffset(type.getUninitializedLabel());
            for (insnOffset = labelOffset + 1; insnOffset < this.code.getInstructions().size(); ++insnOffset) {
                instruction = this.code.getInstructions().get(insnOffset);
                if (instruction instanceof CfLabel || instruction instanceof CfFrame || instruction instanceof CfPosition) continue;
                assert (instruction instanceof CfNew);
                break;
            }
            instruction = this.code.getInstructions().get(insnOffset);
            assert (instruction instanceof CfNew);
            return ((CfNew)instruction).getType();
        }
        if (type.isUninitializedThis()) {
            return this.method.getHolderType();
        }
        assert (type.isTop());
        return null;
    }

    private void setLocalVariableLists() {
        this.incomingLocals = this.getLocalVariables((int)this.currentInstructionIndex).locals;
        if (this.inPrelude) {
            this.outgoingLocals = this.incomingLocals;
            return;
        }
        CfInstruction currentInstruction = this.code.getInstructions().get(this.currentInstructionIndex);
        this.outgoingLocals = !this.isControlFlow(currentInstruction) ? this.getLocalVariables((int)(this.currentInstructionIndex + 1)).locals : Int2ReferenceSortedMaps.emptyMap();
    }

    private boolean localsChanged() {
        return !this.incomingLocals.equals(this.outgoingLocals);
    }

    private void endLocals(IRBuilder builder) {
        assert (this.localsChanged());
        for (Int2ReferenceMap.Entry entry : this.incomingLocals.int2ReferenceEntrySet()) {
            if (((DebugLocalInfo)entry.getValue()).equals(this.outgoingLocals.get(entry.getIntKey()))) continue;
            builder.addDebugLocalEnd(entry.getIntKey(), (DebugLocalInfo)entry.getValue());
        }
    }

    private void startLocals(IRBuilder builder) {
        assert (this.localsChanged());
        for (Int2ReferenceMap.Entry entry : this.outgoingLocals.int2ReferenceEntrySet()) {
            if (((DebugLocalInfo)entry.getValue()).equals(this.incomingLocals.get(entry.getIntKey()))) continue;
            CfState.Slot slot = this.state.read(entry.getIntKey());
            if (slot != null && slot.type != ValueType.fromDexType(((DebugLocalInfo)entry.getValue()).type)) {
                throw new InvalidDebugInfoException("Attempt to define local of type " + this.prettyType(slot.type) + " as " + ((DebugLocalInfo)entry.getValue()).toString(DebugLocalInfo.PrintLevel.FULL));
            }
            builder.addDebugLocalStart(entry.getIntKey(), (DebugLocalInfo)entry.getValue());
        }
    }

    private String prettyType(ValueType type) {
        switch (type) {
            case OBJECT: {
                return "reference";
            }
            case INT: {
                return "int";
            }
            case FLOAT: {
                return "float";
            }
            case LONG: {
                return "long";
            }
            case DOUBLE: {
                return "double";
            }
        }
        throw new Unreachable();
    }

    private boolean isControlFlow(CfInstruction currentInstruction) {
        return currentInstruction.isReturn() || currentInstruction.getTarget() != null || currentInstruction instanceof CfSwitch || currentInstruction instanceof CfThrow;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public DexType getOriginalHolder() {
        return this.code.getOriginalHolder();
    }

    @Override
    public int instructionCount() {
        return this.code.getInstructions().size();
    }

    @Override
    public int instructionIndex(int instructionOffset) {
        return instructionOffset;
    }

    @Override
    public int instructionOffset(int instructionIndex) {
        return instructionIndex;
    }

    @Override
    public boolean verifyRegister(int register) {
        return true;
    }

    @Override
    public void setUp() {
    }

    @Override
    public void clear() {
    }

    @Override
    public int traceInstruction(int instructionIndex, IRBuilder builder) {
        CfInstruction instruction = this.code.getInstructions().get(instructionIndex);
        AppView<?> appView = builder.appView;
        assert (appView.options().isGeneratingClassFiles() == this.internalOutputMode.isGeneratingClassFiles());
        if (instruction.canThrow()) {
            TryHandlerList tryHandlers = this.getTryHandlers(instructionIndex, appView.dexItemFactory());
            if (!tryHandlers.isEmpty()) {
                builder.ensureBlockWithoutEnqueuing(tryHandlers.startOffset);
                IntOpenHashSet seen = new IntOpenHashSet();
                IntListIterator intListIterator = tryHandlers.offsets.iterator();
                while (intListIterator.hasNext()) {
                    int offset = (Integer)intListIterator.next();
                    if (!seen.add(offset)) continue;
                    builder.ensureExceptionalSuccessorBlock(instructionIndex, offset);
                }
                if (!(instruction instanceof CfThrow)) {
                    builder.ensureNormalSuccessorBlock(instructionIndex, instructionIndex + 1);
                }
                return instructionIndex;
            }
            this.hasExitingInstruction |= instruction instanceof CfThrow;
            return instruction instanceof CfThrow ? instructionIndex : -1;
        }
        if (this.isControlFlow(instruction)) {
            for (int target : this.getTargets(instructionIndex)) {
                builder.ensureNormalSuccessorBlock(instructionIndex, target);
            }
            this.hasExitingInstruction |= instruction.isReturn();
            return instructionIndex;
        }
        return -1;
    }

    @Override
    public void buildPrelude(IRBuilder builder) {
        assert (!this.inPrelude);
        this.inPrelude = true;
        this.state.buildPrelude(this.canonicalPositions.getPreamblePosition());
        this.setLocalVariableLists();
        builder.buildArgumentsWithRewrittenPrototypeChanges(0, this.getMethod(), this.state::write);
        Int2ReferenceMap<DebugLocalInfo> locals = this.getLocalVariables((int)0).locals;
        if (!locals.isEmpty()) {
            int firstLocalIndex = 0;
            if (!this.getMethod().isStatic()) {
                ++firstLocalIndex;
            }
            for (DexType value : this.getMethod().getProto().parameters.values) {
                ++firstLocalIndex;
                if (!value.isLongType() && !value.isDoubleType()) continue;
                ++firstLocalIndex;
            }
            for (Int2ReferenceMap.Entry entry : locals.int2ReferenceEntrySet()) {
                if (firstLocalIndex > entry.getIntKey()) continue;
                builder.addDebugLocalStart(entry.getIntKey(), (DebugLocalInfo)entry.getValue());
            }
        }
        if (this.needsGeneratedMethodSynchronization) {
            this.buildMethodEnterSynchronization(builder);
        }
        this.recordStateForTarget(0, this.state.getSnapshot());
        this.inPrelude = false;
    }

    @Override
    public void buildPostlude(IRBuilder builder) {
        if (this.needsGeneratedMethodSynchronization) {
            this.currentlyGeneratingMethodSynchronization = true;
            builder.add(new Monitor(Monitor.Type.EXIT, this.monitorEnter.inValues().get(0)));
            this.currentlyGeneratingMethodSynchronization = false;
        }
    }

    @Override
    public void buildBlockTransfer(IRBuilder builder, int predecessorOffset, int successorOffset, boolean isExceptional) {
        if (predecessorOffset == -1 || this.isExceptionalExitForMethodSynchronization(successorOffset)) {
            return;
        }
        this.state.setPosition(this.getCanonicalDebugPositionAtOffset(isExceptional ? successorOffset : predecessorOffset));
        Int2ReferenceMap<DebugLocalInfo> atSource = this.getLocalVariables((int)predecessorOffset).locals;
        Int2ReferenceMap<DebugLocalInfo> atTarget = this.getLocalVariables((int)successorOffset).locals;
        if (!isExceptional) {
            for (Int2ReferenceMap.Entry entry : atSource.int2ReferenceEntrySet()) {
                if (atTarget.get(entry.getIntKey()) == entry.getValue()) continue;
                builder.addDebugLocalEnd(entry.getIntKey(), (DebugLocalInfo)entry.getValue());
            }
        }
        for (Int2ReferenceMap.Entry entry : atTarget.int2ReferenceEntrySet()) {
            if (atSource.get(entry.getIntKey()) == entry.getValue()) continue;
            builder.addDebugLocalStart(entry.getIntKey(), (DebugLocalInfo)entry.getValue());
        }
        if (!this.hasExitingInstruction && this.code.getInstructions().get(predecessorOffset) instanceof CfGoto) {
            assert (!isExceptional);
            for (Int2ReferenceMap.Entry entry : atSource.int2ReferenceEntrySet()) {
                if (atTarget.get(entry.getIntKey()) != entry.getValue()) continue;
                builder.addDebugLocalEnd(entry.getIntKey(), (DebugLocalInfo)entry.getValue());
            }
        }
    }

    @Override
    public void buildInstruction(IRBuilder builder, int instructionIndex, boolean firstBlockInstruction) {
        boolean hasNextInstructionInCurrentBlock;
        if (this.isExceptionalExitForMethodSynchronization(instructionIndex)) {
            this.buildExceptionalExitMethodSynchronization(builder);
            return;
        }
        CfInstruction instruction = this.code.getInstructions().get(instructionIndex);
        this.currentInstructionIndex = instructionIndex;
        if (firstBlockInstruction) {
            this.currentBlockInfo = (IRBuilder.BlockInfo)builder.getCFG().get(instructionIndex);
            if (instructionIndex == 0 && this.currentBlockInfo == null) {
                this.currentBlockInfo = (IRBuilder.BlockInfo)builder.getCFG().get(-1);
            }
            this.state.reset((CfState.Snapshot)this.incomingState.get(instructionIndex), instructionIndex == 0, this.getCanonicalDebugPositionAtOffset(instructionIndex));
            this.currentBlockIndex = this.currentInstructionIndex;
        }
        assert (this.currentBlockInfo != null);
        this.setLocalVariableLists();
        if (instruction.canThrow()) {
            CfState.Snapshot exceptionTransfer = this.state.getSnapshot().exceptionTransfer(builder.appView.dexItemFactory().throwableType);
            IntIterator intIterator = this.currentBlockInfo.exceptionalSuccessors.iterator();
            while (intIterator.hasNext()) {
                int target = (Integer)intIterator.next();
                this.recordStateForTarget(target, exceptionTransfer);
            }
        }
        boolean localsChanged = this.localsChanged();
        boolean bl = hasNextInstructionInCurrentBlock = instructionIndex + 1 != this.instructionCount() && !builder.getCFG().containsKey(instructionIndex + 1);
        if (instruction.isReturn() || instruction instanceof CfThrow) {
            assert (this.currentBlockInfo.normalSuccessors.isEmpty());
            if (this.currentBlockInfo.exceptionalSuccessors.isEmpty()) {
                this.incomingLocals.forEach(builder::addDebugLocalEnd);
            } else if (!this.incomingLocals.isEmpty()) {
                Int2ReferenceOpenHashMap live = new Int2ReferenceOpenHashMap();
                ObjectIterator<Int2ReferenceMap.Entry<DebugLocalInfo>> objectIterator = this.currentBlockInfo.exceptionalSuccessors.iterator();
                while (objectIterator.hasNext()) {
                    int n = (Integer)objectIterator.next();
                    live.putAll(this.getLocalVariables((int)n).locals);
                }
                for (Int2ReferenceMap.Entry entry : this.incomingLocals.int2ReferenceEntrySet()) {
                    if (live.get(entry.getIntKey()) == entry.getValue()) continue;
                    builder.addDebugLocalEnd(entry.getIntKey(), (DebugLocalInfo)entry.getValue());
                }
            }
        } else if (localsChanged && hasNextInstructionInCurrentBlock) {
            this.endLocals(builder);
        }
        this.build(instruction, builder);
        if (!hasNextInstructionInCurrentBlock) {
            CfState.Snapshot stateSnapshot = this.state.getSnapshot();
            if (this.isControlFlow(instruction)) {
                for (ObjectIterator<Int2ReferenceMap.Entry<DebugLocalInfo>> target : (ObjectIterator<Int2ReferenceMap.Entry<DebugLocalInfo>>)this.getTargets(instructionIndex)) {
                    this.recordStateForTarget((int)target, stateSnapshot);
                }
            } else {
                this.recordStateForTarget(instructionIndex + 1, stateSnapshot);
            }
        } else if (localsChanged) {
            this.startLocals(builder);
        }
    }

    public int getCurrentInstructionIndex() {
        return this.currentInstructionIndex;
    }

    public int getLabelOffset(CfLabel label) {
        assert (this.labelOffsets.containsKey(label));
        return this.labelOffsets.getInt(label);
    }

    public void setStateFromFrame(CfFrame frame) {
        Int2ReferenceSortedMap<CfFrame.FrameType> frameLocals = frame.getLocals();
        DexType[] locals = new DexType[frameLocals.isEmpty() ? 0 : frameLocals.lastIntKey() + 1];
        DexType[] stack = new DexType[frame.getStack().size()];
        for (Int2ReferenceMap.Entry entry : frameLocals.int2ReferenceEntrySet()) {
            locals[entry.getIntKey()] = this.convertUninitialized((CfFrame.FrameType)entry.getValue());
        }
        int index = 0;
        for (CfFrame.FrameType frameType : frame.getStack()) {
            stack[index++] = this.convertUninitialized(frameType);
        }
        CfState.BaseSnapshot baseSnapshot = this.state.setStateFromFrame(locals, stack, this.getCanonicalDebugPositionAtOffset(this.currentInstructionIndex));
        assert (this.incomingState.get(this.currentBlockIndex) != null);
        if (this.isFirstFrameInBlock()) {
            this.incomingState.put(this.currentBlockIndex, (CfState.Snapshot)baseSnapshot);
        }
    }

    @Override
    public void resolveAndBuildSwitch(int value, int fallthroughOffset, int payloadOffset, IRBuilder builder) {
    }

    @Override
    public void resolveAndBuildNewArrayFilledData(int arrayRef, int payloadOffset, IRBuilder builder) {
    }

    @Override
    public DebugLocalInfo getIncomingLocalAtBlock(int register, int blockOffset) {
        return (DebugLocalInfo)this.getLocalVariables((int)blockOffset).locals.get(register);
    }

    @Override
    public DexType getPhiTypeForBlock(int register, int blockOffset, ValueTypeConstraint constraint, Phi.RegisterReadType readType) {
        CfState.Slot slot;
        assert (this.code.getStackMapStatus() != CfCode.StackMapStatus.NOT_VERIFIED);
        if (this.code.getStackMapStatus().isInvalidOrNotPresent()) {
            return null;
        }
        CfState.Snapshot snapshot = (CfState.Snapshot)this.incomingState.get(blockOffset);
        if (snapshot == null) {
            this.appView.options().reporter.warning(new CfCodeDiagnostics(this.origin, (DexMethod)this.method.getReference(), "Could not find stack map for block at offset " + blockOffset + ". This is most likely due to invalid stack maps in input."));
            return null;
        }
        CfState.Slot slot2 = slot = CfState.Slot.isStackSlot(register) ? snapshot.getStack(CfState.Slot.stackPosition(register)) : snapshot.getLocal(register);
        if (slot == null) {
            if (readType == Phi.RegisterReadType.DEBUG) {
                DebugLocalInfo incomingLocalAtBlock = this.getIncomingLocalAtBlock(register, blockOffset);
                if (incomingLocalAtBlock != null) {
                    return incomingLocalAtBlock.type;
                }
                ArrayList<CfCode.LocalVariableInfo> localVariablesWithRegister = new ArrayList<CfCode.LocalVariableInfo>();
                for (CfCode.LocalVariableInfo variable : this.localVariables) {
                    if (variable.getIndex() != register) continue;
                    localVariablesWithRegister.add(variable);
                }
                if (localVariablesWithRegister.size() == 1) {
                    return ((CfCode.LocalVariableInfo)localVariablesWithRegister.get((int)0)).getLocal().type;
                }
            }
            return null;
        }
        if (slot.isPrecise()) {
            return slot.preciseType;
        }
        return slot.type.isObject() ? this.appView.dexItemFactory().objectType : slot.type.toPrimitiveType().toDexType(this.appView.dexItemFactory());
    }

    @Override
    public DebugLocalInfo getIncomingLocal(int register) {
        return this.isCurrentlyGeneratingMethodSynchronization() ? null : (DebugLocalInfo)this.incomingLocals.get(register);
    }

    @Override
    public DebugLocalInfo getOutgoingLocal(int register) {
        if (this.isCurrentlyGeneratingMethodSynchronization()) {
            return null;
        }
        if (this.inPrelude) {
            return this.getIncomingLocal(register);
        }
        assert (!this.isControlFlow(this.code.getInstructions().get(this.currentInstructionIndex))) : "Outgoing local is undefined for control-flow instructions";
        return (DebugLocalInfo)this.outgoingLocals.get(register);
    }

    @Override
    public CatchHandlers<Integer> getCurrentCatchHandlers(IRBuilder builder) {
        if (this.inPrelude) {
            return null;
        }
        if (this.isCurrentlyGeneratingMethodSynchronization()) {
            return null;
        }
        TryHandlerList tryHandlers = this.getTryHandlers(this.instructionOffset(this.currentInstructionIndex), builder.appView.dexItemFactory());
        if (tryHandlers.isEmpty()) {
            return null;
        }
        return new CatchHandlers<Integer>(tryHandlers.guards, tryHandlers.offsets);
    }

    @Override
    public int getMoveExceptionRegister(int instructionIndex) {
        return 100000;
    }

    @Override
    public boolean verifyCurrentInstructionCanThrow() {
        return this.isCurrentlyGeneratingMethodSynchronization() || this.inPrelude || this.code.getInstructions().get(this.currentInstructionIndex).canThrow();
    }

    @Override
    public boolean verifyLocalInScope(DebugLocalInfo local) {
        return false;
    }

    @Override
    public boolean hasValidTypesFromStackMap() {
        return this.code.getStackMapStatus() == CfCode.StackMapStatus.VALID;
    }

    @Override
    public Position getCanonicalDebugPositionAtOffset(int offset) {
        CfInstruction insn;
        if (offset == -2) {
            return this.canonicalPositions.getExceptionalExitPosition(this.appView.options().debug, () -> this.code.getInstructions().stream().filter(insn -> insn instanceof CfPosition).map(insn -> ((CfPosition)insn).getPosition()).collect(Collectors.toList()), (DexMethod)this.method.getReference());
        }
        while (offset + 1 < this.code.getInstructions().size() && ((insn = this.code.getInstructions().get(offset)) instanceof CfLabel || insn instanceof CfFrame)) {
            ++offset;
        }
        while (offset >= 0 && !(this.code.getInstructions().get(offset) instanceof CfPosition)) {
            --offset;
        }
        if (offset < 0) {
            return this.canonicalPositions.getPreamblePosition();
        }
        return this.getCanonicalPosition(((CfPosition)this.code.getInstructions().get(offset)).getPosition());
    }

    @Override
    public Position getCurrentPosition() {
        return this.state.getPosition();
    }

    public Position getCanonicalPosition(Position position) {
        return this.canonicalPositions.getCanonical((Position)((Position.PositionBuilder)position.builderWithCopy().setCallerPosition(this.canonicalPositions.canonicalizeCallerPosition(position.getCallerPosition()))).build());
    }

    private static class LocalVariableList {
        public static final LocalVariableList EMPTY = new LocalVariableList(0, 0, Int2ReferenceSortedMaps.emptyMap());
        public final int startOffset;
        public final int endOffset;
        public final Int2ReferenceMap<DebugLocalInfo> locals;

        private LocalVariableList(int startOffset, int endOffset, Int2ReferenceMap<DebugLocalInfo> locals) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.locals = locals;
        }

        static LocalVariableList compute(int instructionOffset, List<CfCode.LocalVariableInfo> locals, Reference2IntMap<CfLabel> labelOffsets) {
            int startOffset = Integer.MIN_VALUE;
            int endOffset = Integer.MAX_VALUE;
            Int2ReferenceOpenHashMap<DebugLocalInfo> currentLocals = null;
            for (CfCode.LocalVariableInfo local : locals) {
                int start = labelOffsets.getInt(local.getStart());
                int end = labelOffsets.getInt(local.getEnd());
                if (start > instructionOffset) {
                    endOffset = Math.min(endOffset, start);
                    continue;
                }
                if (instructionOffset >= end) {
                    startOffset = Math.max(startOffset, end);
                    continue;
                }
                if (currentLocals == null) {
                    currentLocals = new Int2ReferenceOpenHashMap<DebugLocalInfo>();
                }
                startOffset = Math.max(startOffset, start);
                endOffset = Math.min(endOffset, end);
                currentLocals.put(local.getIndex(), local.getLocal());
            }
            return new LocalVariableList(startOffset, endOffset, currentLocals == null ? Int2ReferenceSortedMaps.emptyMap() : currentLocals);
        }

        private static Int2ReferenceOpenHashMap<DebugLocalInfo> merge(LocalVariableList a, LocalVariableList b) {
            if (a.locals.size() > b.locals.size()) {
                return LocalVariableList.merge(b, a);
            }
            Int2ReferenceOpenHashMap<DebugLocalInfo> result = new Int2ReferenceOpenHashMap<DebugLocalInfo>();
            for (Int2ReferenceMap.Entry entry : a.locals.int2ReferenceEntrySet()) {
                if (!((DebugLocalInfo)entry.getValue()).equals(b.getLocal(entry.getIntKey()))) continue;
                result.put(entry.getIntKey(), (DebugLocalInfo)entry.getValue());
            }
            return result;
        }

        boolean validFor(int instructionOffset) {
            return this.startOffset <= instructionOffset && instructionOffset < this.endOffset;
        }

        public DebugLocalInfo getLocal(int register) {
            return (DebugLocalInfo)this.locals.get(register);
        }

        public Int2ReferenceOpenHashMap<DebugLocalInfo> merge(LocalVariableList other) {
            return LocalVariableList.merge(this, other);
        }
    }

    private static class TryHandlerList {
        public final int startOffset;
        public final int endOffset;
        public final List<DexType> guards;
        public final IntList offsets;

        TryHandlerList(int startOffset, int endOffset, List<DexType> guards, IntList offsets) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.guards = guards;
            this.offsets = offsets;
        }

        static TryHandlerList computeTryHandlers(int instructionOffset, List<CfTryCatch> tryCatchRanges, Reference2IntMap<CfLabel> labelOffsets, boolean needsGeneratedMethodSynchronization, DexItemFactory factory) {
            int startOffset = 0;
            int endOffset = Integer.MAX_VALUE;
            ArrayList<DexType> guards = new ArrayList<DexType>();
            IntArrayList offsets = new IntArrayList();
            ReferenceOpenHashSet seen = new ReferenceOpenHashSet();
            boolean seenCatchAll = false;
            for (CfTryCatch tryCatch : tryCatchRanges) {
                int start = labelOffsets.getInt(tryCatch.start);
                int end = labelOffsets.getInt(tryCatch.end);
                if (start > instructionOffset) {
                    endOffset = Math.min(endOffset, start);
                    continue;
                }
                if (instructionOffset >= end) {
                    startOffset = Math.max(startOffset, end);
                    continue;
                }
                startOffset = Math.max(startOffset, start);
                endOffset = Math.min(endOffset, end);
                for (int i = 0; i < tryCatch.guards.size() && !seenCatchAll; ++i) {
                    DexType guard = tryCatch.guards.get(i);
                    if (!seen.add(guard)) continue;
                    guards.add(guard);
                    offsets.add(labelOffsets.getInt(tryCatch.targets.get(i)));
                    seenCatchAll = guard == factory.throwableType;
                }
                if (!seenCatchAll) continue;
                break;
            }
            if (needsGeneratedMethodSynchronization && !seenCatchAll) {
                guards.add(factory.throwableType);
                offsets.add(-2);
            }
            return new TryHandlerList(startOffset, endOffset, guards, offsets);
        }

        boolean validFor(int instructionOffset) {
            return this.startOffset <= instructionOffset && instructionOffset < this.endOffset;
        }

        boolean isEmpty() {
            assert (this.guards.isEmpty() == this.offsets.isEmpty());
            return this.guards.isEmpty();
        }
    }
}

