/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.origin.Origin;

public class CfState {
    private static final int MAX_UPDATES = 4;
    private final Origin origin;
    private Snapshot current;
    private Position position;

    public CfState(Origin origin) {
        this.origin = origin;
    }

    public static Snapshot merge(Snapshot current, Snapshot update, Origin origin) {
        assert (update != null);
        if (current == null) {
            return update;
        }
        return CfState.merge(current.asBase(), update.asBase(), origin);
    }

    private static Snapshot merge(BaseSnapshot current, BaseSnapshot update, Origin origin) {
        if (current.stack.length != update.stack.length) {
            throw new CompilationError("Different stack heights at jump target: " + current.stack.length + " != " + update.stack.length, origin);
        }
        for (int i = 0; i < current.stack.length; ++i) {
            ValueType updateType;
            ValueType currentType = current.stack[i].getImprecise();
            if (currentType == (updateType = update.stack[i].getImprecise())) continue;
            throw new CompilationError("Incompatible types in stack position " + i + ": " + current.stack[i] + " and " + update.stack[i], origin);
        }
        return current;
    }

    private Slot push(SlotType slotType) {
        Push newSnapshot = new Push(this.current, slotType);
        this.updateState(newSnapshot);
        return this.current.peek();
    }

    private void updateState(Snapshot newSnapshot) {
        this.current = newSnapshot.updates >= 4 ? new BaseSnapshot(newSnapshot) : newSnapshot;
    }

    private Slot write(int localIndex, SlotType slotType) {
        this.updateState(new Write(this.current, localIndex, slotType));
        return this.current.getLocal(localIndex);
    }

    public void buildPrelude(Position preamblePosition) {
        this.current = new BaseSnapshot();
        this.position = preamblePosition;
    }

    public void clear() {
        this.current = null;
    }

    public void reset(Snapshot snapshot, boolean isMethodEntry, Position position) {
        assert (!isMethodEntry || snapshot != null) : "Must have snapshot for method entry.";
        this.current = snapshot;
        this.position = position;
    }

    public BaseSnapshot setStateFromFrame(DexType[] locals, DexType[] stack, Position position) {
        assert (this.current == null || this.stackHeight() == stack.length);
        BaseSnapshot newSnapShot = new BaseSnapshot(locals, stack, position);
        this.current = newSnapShot;
        return newSnapShot;
    }

    public void merge(Snapshot snapshot) {
        this.current = this.current == null ? (snapshot == null ? new BaseSnapshot() : snapshot) : CfState.merge(this.current, snapshot, this.origin);
    }

    public Snapshot getSnapshot() {
        return this.current;
    }

    public int stackHeight() {
        return this.current.stackHeight();
    }

    public Slot push(Slot fromSlot) {
        return this.push(fromSlot.slotType);
    }

    public Slot push(DexType type) {
        return this.push(new SlotType.Precise(type));
    }

    public Slot push(ValueType type) {
        return this.push(new SlotType.Imprecise(type));
    }

    public Slot pop() {
        Slot top = this.current.peek();
        this.updateState(new Pop(this.current));
        return top;
    }

    public int[] popReverse(int count) {
        int[] registers = new int[count];
        for (int i = count - 1; i >= 0; --i) {
            registers[i] = this.pop().register;
        }
        return registers;
    }

    public Slot peek() {
        return this.current.peek();
    }

    public Slot peek(int skip) {
        return this.current.getStack(this.current.stackHeight() - 1 - skip);
    }

    public Slot read(int localIndex) {
        return this.current.getLocal(localIndex);
    }

    public Slot write(int localIndex, DexType type) {
        return this.write(localIndex, new SlotType.Precise(type));
    }

    public Slot write(int localIndex, Slot src) {
        return this.write(localIndex, src.slotType);
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        assert (position != null);
        this.position = position;
    }

    public String toString() {
        return new BaseSnapshot(this.current).toString();
    }

    private static class Write
    extends Snapshot {
        private final Slot slot;

        Write(Snapshot parent, int slotIndex, SlotType type) {
            super(parent, parent.updates + 1);
            this.slot = new Slot(slotIndex, type);
            assert (0 <= slotIndex && slotIndex < 100000);
        }

        @Override
        public int maxLocal() {
            return Math.max(this.slot.register, this.parent.maxLocal());
        }

        @Override
        public Slot getLocal(int i) {
            return i == this.slot.register ? this.slot : this.parent.getLocal(i);
        }

        @Override
        void build(BaseSnapshot base) {
            this.parent.build(base);
            base.locals[this.slot.register] = this.slot.slotType;
        }

        public String toString() {
            return this.parent.toString() + "; write " + this.slot.register + " := " + this.slot.slotType;
        }
    }

    private static class Pop
    extends Snapshot {
        private final int stackHeight;

        Pop(Snapshot parent) {
            super(parent, parent.updates + 1);
            this.stackHeight = parent.stackHeight() - 1;
            assert (this.stackHeight >= 0);
        }

        @Override
        public int stackHeight() {
            return this.stackHeight;
        }

        @Override
        public Slot getStack(int i) {
            assert (i < this.stackHeight);
            return this.parent.getStack(i);
        }

        @Override
        public Slot peek() {
            return this.parent.getStack(this.stackHeight - 1);
        }

        public String toString() {
            return this.parent.toString() + "; pop";
        }
    }

    private static class Push
    extends Snapshot {
        private final Slot slot;

        Push(Snapshot parent, SlotType type) {
            super(parent, parent.updates + 1);
            this.slot = Slot.stackSlot(parent.stackHeight(), type);
            assert (100000 <= this.slot.register && this.slot.register < 200000);
        }

        @Override
        public int stackHeight() {
            return this.slot.stackPosition() + 1;
        }

        @Override
        public Slot getStack(int i) {
            return i == this.slot.stackPosition() ? this.peek() : this.parent.getStack(i);
        }

        @Override
        public Slot peek() {
            return this.slot;
        }

        @Override
        void build(BaseSnapshot base) {
            this.parent.build(base);
            if (this.slot.stackPosition() < base.stack.length) {
                base.stack[((Slot)this.slot).stackPosition()] = this.slot.slotType;
            }
        }

        public String toString() {
            return this.parent.toString() + "; push(" + this.slot.slotType + ")";
        }
    }

    private static class BaseSnapshot
    extends Snapshot {
        final SlotType[] locals;
        final SlotType[] stack;

        BaseSnapshot() {
            this(0, 0);
        }

        BaseSnapshot(int locals, int stack) {
            super(null, 0);
            this.locals = new SlotType[locals];
            this.stack = new SlotType[stack];
        }

        BaseSnapshot(Snapshot newSnapshot) {
            this(newSnapshot.maxLocal() + 1, newSnapshot.stackHeight());
            newSnapshot.build(this);
        }

        BaseSnapshot(DexType[] locals, DexType[] stack, Position position) {
            super(null, 0);
            int i;
            assert (position != null);
            this.locals = new SlotType[locals.length];
            this.stack = new SlotType[stack.length];
            for (i = 0; i < locals.length; ++i) {
                this.locals[i] = locals[i] == null ? null : this.getSlotType(locals[i]);
            }
            for (i = 0; i < stack.length; ++i) {
                assert (stack[i] != null);
                this.stack[i] = this.getSlotType(stack[i]);
            }
        }

        private SlotType getSlotType(DexType local) {
            return local.toDescriptorString().equals("NULL") ? new SlotType.Imprecise(ValueType.OBJECT) : new SlotType.Precise(local);
        }

        @Override
        public int stackHeight() {
            return this.stack.length;
        }

        @Override
        public int maxLocal() {
            return this.locals.length - 1;
        }

        @Override
        public Slot getStack(int i) {
            return Slot.stackSlot(i, this.stack[i]);
        }

        @Override
        public Slot peek() {
            assert (this.stackHeight() > 0);
            return this.getStack(this.stackHeight() - 1);
        }

        @Override
        public Slot getLocal(int i) {
            if (i >= this.locals.length) {
                return null;
            }
            SlotType local = this.locals[i];
            return local == null ? null : new Slot(i, local);
        }

        @Override
        void build(BaseSnapshot dest) {
            int i;
            for (i = 0; i < this.locals.length && i < dest.locals.length; ++i) {
                dest.locals[i] = this.locals[i];
            }
            for (i = 0; i < this.stack.length && i < dest.stack.length; ++i) {
                dest.stack[i] = this.stack[i];
            }
        }

        @Override
        BaseSnapshot asBase() {
            return this;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("stack: [");
            String sep = "";
            for (SlotType type : this.stack) {
                stringBuilder.append(sep).append(type);
                sep = ", ";
            }
            stringBuilder.append("] locals: [");
            sep = "";
            for (int i = 0; i < this.locals.length; ++i) {
                if (this.locals[i] == null) continue;
                stringBuilder.append(sep).append(i).append(':').append(this.locals[i]);
                sep = ", ";
            }
            return stringBuilder.append(']').toString();
        }
    }

    public static abstract class Snapshot {
        final Snapshot parent;
        final int updates;

        private Snapshot(Snapshot parent, int updates) {
            this.parent = parent;
            this.updates = updates;
        }

        public int stackHeight() {
            return this.parent.stackHeight();
        }

        public int maxLocal() {
            return this.parent.maxLocal();
        }

        public Slot getStack(int i) {
            return this.parent.getStack(i);
        }

        public Slot peek() {
            return this.parent.peek();
        }

        public Slot getLocal(int i) {
            return this.parent.getLocal(i);
        }

        void build(BaseSnapshot base) {
            this.parent.build(base);
        }

        BaseSnapshot asBase() {
            return new BaseSnapshot(this);
        }

        public Snapshot exceptionTransfer(DexType throwableType) {
            BaseSnapshot result = new BaseSnapshot(this.maxLocal() + 1, 1);
            this.build(result);
            result.stack[0] = new SlotType.Precise(throwableType);
            return result;
        }
    }

    public static class Slot {
        public static final int STACK_OFFSET = 100000;
        public final int register;
        public final ValueType type;
        public final DexType preciseType;
        private final SlotType slotType;

        private Slot(int register, SlotType type) {
            this.register = register;
            this.slotType = type;
            this.type = type.getImprecise();
            this.preciseType = type.getPrecise();
        }

        private static Slot stackSlot(int stackPosition, SlotType type) {
            return new Slot(stackPosition + 100000, type);
        }

        private int stackPosition() {
            return Slot.stackPosition(this.register);
        }

        public static int stackPosition(int register) {
            assert (Slot.isStackSlot(register));
            assert (register >= 100000);
            return register - 100000;
        }

        public static boolean isStackSlot(int register) {
            return register >= 100000;
        }

        public String toString() {
            return this.register < 100000 ? this.register + "=" + this.slotType : "s" + (this.register - 100000) + "=" + this.slotType;
        }

        public boolean isStackSlot() {
            return Slot.isStackSlot(this.register);
        }

        public boolean isPrecise() {
            return this.slotType.isPrecise();
        }
    }

    private static abstract class SlotType {
        private SlotType() {
        }

        public abstract DexType getPrecise();

        public abstract ValueType getImprecise();

        public boolean isPrecise() {
            return false;
        }

        private static class Imprecise
        extends SlotType {
            private final ValueType type;

            Imprecise(ValueType type) {
                this.type = type;
            }

            @Override
            public DexType getPrecise() {
                return null;
            }

            @Override
            public ValueType getImprecise() {
                return this.type;
            }

            public String toString() {
                return "Imprecise(" + this.type + ")";
            }
        }

        private static class Precise
        extends SlotType {
            private final DexType type;

            Precise(DexType type) {
                this.type = type;
            }

            @Override
            public DexType getPrecise() {
                return this.type;
            }

            @Override
            public ValueType getImprecise() {
                return ValueType.fromDexType(this.type);
            }

            public String toString() {
                return "Precise(" + this.type + ")";
            }

            @Override
            public boolean isPrecise() {
                return true;
            }
        }
    }
}

