/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.ClassConverterResult;
import com.android.tools.r8.ir.conversion.D8MethodProcessor;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.LibraryDesugaredChecker;
import com.android.tools.r8.ir.desugar.CfClassSynthesizerDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.itf.InterfaceProcessor;
import com.android.tools.r8.utils.ThreadUtils;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public abstract class ClassConverter {
    protected final AppView<?> appView;
    private final IRConverter converter;
    private final D8MethodProcessor methodProcessor;
    private final InterfaceProcessor interfaceProcessor;

    ClassConverter(AppView<?> appView, IRConverter converter, D8MethodProcessor methodProcessor, InterfaceProcessor interfaceProcessor) {
        this.appView = appView;
        this.converter = converter;
        this.methodProcessor = methodProcessor;
        this.interfaceProcessor = interfaceProcessor;
    }

    public static ClassConverter create(AppView<?> appView, IRConverter converter, D8MethodProcessor methodProcessor, InterfaceProcessor interfaceProcessor) {
        return appView.options().desugarSpecificOptions().allowAllDesugaredInput ? new LibraryDesugaredClassConverter(appView, converter, methodProcessor, interfaceProcessor) : new DefaultClassConverter(appView, converter, methodProcessor, interfaceProcessor);
    }

    private void internalConvertClasses(ClassConverterResult.Builder resultBuilder, ExecutorService executorService) throws ExecutionException {
        AbstractCollection classes = ((AppInfo)this.appView.appInfo()).classes();
        CfClassSynthesizerDesugaringEventConsumer classSynthesizerEventConsumer = new CfClassSynthesizerDesugaringEventConsumer();
        this.converter.classSynthesisDesugaring(executorService, classSynthesizerEventConsumer);
        if (!classSynthesizerEventConsumer.getSynthesizedClasses().isEmpty()) {
            classes = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)classes)).addAll(classSynthesizerEventConsumer.getSynthesizedClasses())).build();
        }
        this.converter.prepareDesugaringForD8(executorService);
        while (!classes.isEmpty()) {
            Set<DexType> seenNestHosts = Sets.newIdentityHashSet();
            ArrayList<DexProgramClass> deferred = new ArrayList<DexProgramClass>(classes.size() / 2);
            ArrayList<DexProgramClass> wave = new ArrayList<DexProgramClass>(classes.size());
            for (DexProgramClass clazz2 : classes) {
                if (clazz2.isInANest() && !seenNestHosts.add(clazz2.getNestHost())) {
                    deferred.add(clazz2);
                    continue;
                }
                wave.add(clazz2);
                this.methodProcessor.addScheduled(clazz2);
            }
            CfInstructionDesugaringEventConsumer.D8CfInstructionDesugaringEventConsumer instructionDesugaringEventConsumer = CfInstructionDesugaringEventConsumer.createForD8(this.methodProcessor);
            this.methodProcessor.newWave();
            ThreadUtils.processItems(wave, clazz -> this.convertClass((DexProgramClass)clazz, instructionDesugaringEventConsumer), executorService);
            this.methodProcessor.awaitMethodProcessing();
            List<ProgramMethod> needsProcessing = instructionDesugaringEventConsumer.finalizeDesugaring(this.appView, resultBuilder);
            if (!needsProcessing.isEmpty()) {
                this.methodProcessor.newWave();
                ThreadUtils.processItems(needsProcessing, method -> {
                    DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
                    if (definition.isProcessed()) {
                        definition.markNotProcessed();
                    }
                    this.methodProcessor.processMethod((ProgramMethod)method, instructionDesugaringEventConsumer);
                }, executorService);
                this.methodProcessor.awaitMethodProcessing();
                assert (instructionDesugaringEventConsumer.verifyNothingToFinalize());
            }
            classes = deferred;
        }
    }

    public ClassConverterResult convertClasses(ExecutorService executorService) throws ExecutionException {
        ClassConverterResult.Builder resultBuilder = ClassConverterResult.builder();
        this.internalConvertClasses(resultBuilder, executorService);
        this.notifyAllClassesConverted();
        return resultBuilder.build();
    }

    abstract void convertClass(DexProgramClass var1, CfInstructionDesugaringEventConsumer.D8CfInstructionDesugaringEventConsumer var2);

    void convertMethods(DexProgramClass clazz, CfInstructionDesugaringEventConsumer.D8CfInstructionDesugaringEventConsumer desugaringEventConsumer) {
        this.converter.convertMethods(clazz, desugaringEventConsumer, this.methodProcessor, this.interfaceProcessor);
    }

    abstract void notifyAllClassesConverted();

    static class LibraryDesugaredClassConverter
    extends ClassConverter {
        private final Set<DexType> alreadyLibraryDesugared = Sets.newConcurrentHashSet();

        LibraryDesugaredClassConverter(AppView<?> appView, IRConverter converter, D8MethodProcessor methodProcessor, InterfaceProcessor interfaceProcessor) {
            super(appView, converter, methodProcessor, interfaceProcessor);
        }

        @Override
        void convertClass(DexProgramClass clazz, CfInstructionDesugaringEventConsumer.D8CfInstructionDesugaringEventConsumer desugaringEventConsumer) {
            LibraryDesugaredChecker libraryDesugaredChecker = new LibraryDesugaredChecker(this.appView);
            if (libraryDesugaredChecker.isClassLibraryDesugared(clazz)) {
                this.alreadyLibraryDesugared.add(clazz.getType());
            } else {
                this.convertMethods(clazz, desugaringEventConsumer);
            }
        }

        @Override
        void notifyAllClassesConverted() {
            this.appView.setAlreadyLibraryDesugared(this.alreadyLibraryDesugared);
        }
    }

    static class DefaultClassConverter
    extends ClassConverter {
        DefaultClassConverter(AppView<?> appView, IRConverter converter, D8MethodProcessor methodProcessor, InterfaceProcessor interfaceProcessor) {
            super(appView, converter, methodProcessor, interfaceProcessor);
        }

        @Override
        void convertClass(DexProgramClass clazz, CfInstructionDesugaringEventConsumer.D8CfInstructionDesugaringEventConsumer desugaringEventConsumer) {
            this.convertMethods(clazz, desugaringEventConsumer);
        }

        @Override
        void notifyAllClassesConverted() {
        }
    }
}

