/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.conversion.callgraph.CallSiteInformation;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringEventConsumer;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackIgnore;
import com.android.tools.r8.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class D8MethodProcessor
extends MethodProcessor {
    private final IRConverter converter;
    private final ExecutorService executorService;
    private final Set<DexType> scheduled = Sets.newIdentityHashSet();
    private final List<Future<?>> terminalFutures = Collections.synchronizedList(new ArrayList());
    private final List<Future<?>> nonTerminalFutures = Collections.synchronizedList(new ArrayList());
    private CompilationContext.ProcessorContext processorContext;

    public D8MethodProcessor(IRConverter converter, ExecutorService executorService) {
        this.converter = converter;
        this.executorService = executorService;
        this.processorContext = converter.appView.createProcessorContext();
    }

    public void addScheduled(DexProgramClass clazz) {
        boolean added = this.scheduled.add(clazz.getType());
        assert (added);
    }

    public void newWave() {
        this.processorContext = this.converter.appView.createProcessorContext();
    }

    @Override
    public CompilationContext.MethodProcessingContext createMethodProcessingContext(ProgramMethod method) {
        return this.processorContext.createMethodProcessingContext(method);
    }

    @Override
    public boolean isProcessedConcurrently(ProgramMethod method) {
        return true;
    }

    @Override
    public boolean shouldApplyCodeRewritings(ProgramMethod method) {
        return true;
    }

    public void scheduleMethodForProcessing(ProgramMethod method, CfInstructionDesugaringEventConsumer.D8CfInstructionDesugaringEventConsumer eventConsumer) {
        if (!this.scheduled.contains(method.getHolderType()) && !this.converter.appView.getSyntheticItems().isNonLegacySynthetic(method.getHolder())) {
            return;
        }
        this.nonTerminalFutures.add(ThreadUtils.processAsynchronously(() -> this.converter.rewriteNonDesugaredCode(method, eventConsumer, OptimizationFeedbackIgnore.getInstance(), this, this.processorContext.createMethodProcessingContext(method)), this.executorService));
    }

    @Override
    public void scheduleDesugaredMethodForProcessing(ProgramMethod method) {
        if (!this.scheduled.contains(method.getHolderType()) && !this.converter.appView.getSyntheticItems().isNonLegacySynthetic(method.getHolder())) {
            return;
        }
        if (((DexEncodedMethod)method.getDefinition()).isAbstract()) {
            return;
        }
        this.terminalFutures.add(ThreadUtils.processAsynchronously(() -> this.converter.rewriteDesugaredCode(method, OptimizationFeedbackIgnore.getInstance(), this, this.processorContext.createMethodProcessingContext(method)), this.executorService));
    }

    public D8MethodProcessor scheduleDesugaredMethodsForProcessing(Iterable<ProgramMethod> methods) {
        methods.forEach(this::scheduleDesugaredMethodForProcessing);
        return this;
    }

    @Override
    public CallSiteInformation getCallSiteInformation() {
        throw new Unreachable("Invalid attempt to obtain call-site information in D8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitMethodProcessing() throws ExecutionException {
        while (!this.nonTerminalFutures.isEmpty()) {
            ArrayList futuresToAwait;
            List<Future<?>> list = this.nonTerminalFutures;
            synchronized (list) {
                futuresToAwait = new ArrayList(this.nonTerminalFutures);
                this.nonTerminalFutures.clear();
            }
            ThreadUtils.awaitFutures(futuresToAwait);
        }
        int numberOfTerminalFutures = this.terminalFutures.size();
        ThreadUtils.awaitFutures(this.terminalFutures);
        assert (this.terminalFutures.size() == numberOfTerminalFutures);
        this.terminalFutures.clear();
    }

    public void processMethod(ProgramMethod method, CfInstructionDesugaringEventConsumer desugaringEventConsumer) {
        this.converter.convertMethod(method, desugaringEventConsumer, this, this.processorContext.createMethodProcessingContext(method));
    }

    public boolean verifyNoPendingMethodProcessing() {
        assert (this.terminalFutures.isEmpty());
        assert (this.nonTerminalFutures.isEmpty());
        return true;
    }
}

