/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.ApiLevelException;
import com.android.tools.r8.cf.CfVersion;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.InvalidDebugInfoException;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.proto.ArgumentInfo;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.graph.proto.RemovedArgumentInfo;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.graph.proto.RewrittenTypeInfo;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.PrimitiveTypeElement;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Add;
import com.android.tools.r8.ir.code.And;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.ArrayGet;
import com.android.tools.r8.ir.code.ArrayLength;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.Cmp;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.ConstMethodHandle;
import com.android.tools.r8.ir.code.ConstMethodType;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.DebugLocalRead;
import com.android.tools.r8.ir.code.DebugLocalUninitialized;
import com.android.tools.r8.ir.code.DebugLocalWrite;
import com.android.tools.r8.ir.code.DebugPosition;
import com.android.tools.r8.ir.code.DexItemBasedConstString;
import com.android.tools.r8.ir.code.Div;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.IRMetadata;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.ImpreciseMemberTypeInstruction;
import com.android.tools.r8.ir.code.InitClass;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.InstanceOf;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.IntSwitch;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeCustom;
import com.android.tools.r8.ir.code.JumpInstruction;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Monitor;
import com.android.tools.r8.ir.code.MoveException;
import com.android.tools.r8.ir.code.Mul;
import com.android.tools.r8.ir.code.Neg;
import com.android.tools.r8.ir.code.NewArrayEmpty;
import com.android.tools.r8.ir.code.NewArrayFilledData;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.NewUnboxedEnumInstance;
import com.android.tools.r8.ir.code.Not;
import com.android.tools.r8.ir.code.NumberConversion;
import com.android.tools.r8.ir.code.NumberGenerator;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Or;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.RecordFieldValues;
import com.android.tools.r8.ir.code.Rem;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.SafeCheckCast;
import com.android.tools.r8.ir.code.Shl;
import com.android.tools.r8.ir.code.Shr;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Sub;
import com.android.tools.r8.ir.code.Throw;
import com.android.tools.r8.ir.code.Ushr;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.code.ValueTypeConstraint;
import com.android.tools.r8.ir.code.Xor;
import com.android.tools.r8.ir.conversion.DexSourceCode;
import com.android.tools.r8.ir.conversion.ExtraParameter;
import com.android.tools.r8.ir.conversion.ExtraUnusedNullParameter;
import com.android.tools.r8.ir.conversion.MethodConversionOptions;
import com.android.tools.r8.ir.conversion.SourceCode;
import com.android.tools.r8.ir.conversion.StringSwitchConverter;
import com.android.tools.r8.ir.conversion.TypeConstraintResolver;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArraySet;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntListIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import com.android.tools.r8.naming.dexitembasedstring.NameComputationInfo;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;

public class IRBuilder {
    public static final int INITIAL_BLOCK_OFFSET = -1;
    private final Int2ReferenceSortedMap<BlockInfo> targets = new Int2ReferenceAVLTreeMap<BlockInfo>();
    private final Reference2IntMap<BasicBlock> offsets = new Reference2IntOpenHashMap<BasicBlock>();
    private final Queue<Integer> traceBlocksWorklist = new LinkedList<Integer>();
    private boolean[] processedInstructions = null;
    private Set<Integer> processedSubroutineInstructions = null;
    private final Queue<WorklistItem> ssaWorklist = new LinkedList<WorklistItem>();
    private final LinkedList<BasicBlock> blocks = new LinkedList();
    private BasicBlock entryBlock = null;
    private BasicBlock currentBlock = null;
    private int currentInstructionOffset = -1;
    private final NumberGenerator valueNumberGenerator;
    private final NumberGenerator basicBlockNumberGenerator;
    private final ProgramMethod method;
    private ProgramMethod context;
    public final AppView<?> appView;
    private final GraphLens codeLens;
    private final Origin origin;
    private final RewrittenPrototypeDescription prototypeChanges;
    private Value receiverValue;
    private List<Value> argumentValues;
    private SourceCode source;
    private boolean throwingInstructionInCurrentBlock = false;
    private Value previousLocalValue = null;
    private final List<Value> debugLocalEnds = new ArrayList<Value>();
    private Int2ReferenceMap<List<Value>> uninitializedDebugLocalValues = null;
    private List<ImpreciseMemberTypeInstruction> impreciseInstructions = null;
    private boolean hasImpreciseValues = false;
    private boolean hasIncorrectStackMapTypes = false;
    private final IRMetadata metadata = new IRMetadata();

    private static TypeElement fromMemberType(MemberType type) {
        switch (type) {
            case BOOLEAN_OR_BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return TypeElement.getInt();
            }
            case FLOAT: {
                return TypeElement.getFloat();
            }
            case INT_OR_FLOAT: {
                return TypeElement.getSingle();
            }
            case LONG: {
                return TypeElement.getLong();
            }
            case DOUBLE: {
                return TypeElement.getDouble();
            }
            case LONG_OR_DOUBLE: {
                return TypeElement.getWide();
            }
            case OBJECT: {
                return TypeElement.getBottom();
            }
        }
        throw new Unreachable("Unexpected member type: " + (Object)((Object)type));
    }

    public static IRBuilder create(ProgramMethod method, AppView<?> appView, SourceCode source, Origin origin) {
        return new IRBuilder(method, appView, ((DexEncodedMethod)method.getDefinition()).getCode().getCodeLens(appView), source, origin, IRBuilder.lookupPrototypeChanges(appView, method), new NumberGenerator());
    }

    public static IRBuilder createForInlining(ProgramMethod method, AppView<?> appView, GraphLens codeLens, SourceCode source, Origin origin, NumberGenerator valueNumberGenerator, RewrittenPrototypeDescription protoChanges) {
        return new IRBuilder(method, appView, codeLens, source, origin, protoChanges, valueNumberGenerator);
    }

    public static RewrittenPrototypeDescription lookupPrototypeChanges(AppView<?> appView, ProgramMethod method) {
        return appView.graphLens().lookupPrototypeChangesForMethodDefinition((DexMethod)method.getReference());
    }

    private IRBuilder(ProgramMethod method, AppView<?> appView, GraphLens codeLens, SourceCode source, Origin origin, RewrittenPrototypeDescription prototypeChanges, NumberGenerator valueNumberGenerator) {
        assert (source != null);
        assert (valueNumberGenerator != null);
        this.method = method;
        this.appView = appView;
        this.source = source;
        this.origin = origin;
        this.codeLens = codeLens;
        this.prototypeChanges = prototypeChanges;
        this.valueNumberGenerator = valueNumberGenerator;
        this.basicBlockNumberGenerator = new NumberGenerator();
    }

    private void addToWorklist(BasicBlock block, int firstInstructionIndex) {
        if (!block.isFilled()) {
            this.ssaWorklist.add(new WorklistItem(block, firstInstructionIndex));
        }
    }

    private void setCurrentBlock(BasicBlock block) {
        this.currentBlock = block;
    }

    private boolean allPhisAreStackMapPhis(IRCode ir) {
        ir.instructions().forEach(instruction -> {
            assert (!instruction.isPhi() || instruction.isStackMapPhi());
        });
        return true;
    }

    private void addImpreciseInstruction(ImpreciseMemberTypeInstruction instruction) {
        if (this.impreciseInstructions == null) {
            this.impreciseInstructions = new ArrayList<ImpreciseMemberTypeInstruction>();
        }
        this.impreciseInstructions.add(instruction);
    }

    private void insertDebugPositions() {
        if (!this.isDebugMode()) {
            return;
        }
        for (BasicBlock block : this.blocks) {
            InstructionListIterator it = block.listIterator(this.metadata);
            Position current = null;
            while (it.hasNext()) {
                Instruction instruction = (Instruction)it.next();
                Position position = instruction.getPosition();
                if (instruction.isMoveException()) {
                    assert (current == null);
                    current = position;
                    continue;
                }
                if (instruction.isDebugPosition()) {
                    if (position.equals(current)) {
                        it.removeOrReplaceByDebugLocalRead();
                        continue;
                    }
                    current = position;
                    continue;
                }
                if (!position.isSome() || position.isSyntheticPosition() || position.equals(current)) continue;
                DebugPosition positionChange = new DebugPosition();
                positionChange.setPosition(position);
                it.previous();
                it.add(positionChange);
                it.next();
                current = position;
            }
        }
    }

    private boolean verifyFilledPredecessors() {
        for (BasicBlock block : this.blocks) {
            assert (this.verifyFilledPredecessors(block));
        }
        return true;
    }

    private boolean verifyFilledPredecessors(BasicBlock block) {
        assert (block.verifyFilledPredecessors());
        for (BlockInfo info : this.targets.values()) {
            if (info == null || info.block != block) continue;
            assert (info.predecessorCount() == this.nonSplitPredecessorCount(block));
            assert (info.normalSuccessors.size() == block.getNormalSuccessors().size());
            if (!block.hasCatchHandlers()) assert (!block.canThrow() || info.exceptionalSuccessors.isEmpty() || info.exceptionalSuccessors.size() == 1 && info.exceptionalSuccessors.iterator().nextInt() < 0);
            return true;
        }
        return true;
    }

    private int nonSplitPredecessorCount(BasicBlock block) {
        Set<BasicBlock> set = Sets.newIdentityHashSet();
        for (BasicBlock predecessor : block.getPredecessors()) {
            if (this.offsets.containsKey(predecessor)) {
                set.add(predecessor);
                continue;
            }
            assert (predecessor.getSuccessors().size() == 1);
            assert (predecessor.getPredecessors().size() == 1);
            assert (this.trivialGotoBlockPotentiallyWithMoveException(predecessor));
            if (predecessor.getPredecessors().get(0).hasCatchSuccessor(predecessor)) {
                set.add(predecessor.getPredecessors().get(0));
                continue;
            }
            set.add(predecessor);
        }
        return set.size();
    }

    private boolean trivialGotoBlockPotentiallyWithMoveException(BasicBlock block) {
        for (Instruction instruction : block.getInstructions()) {
            assert (instruction.isMoveException() || instruction.isGoto() || instruction.isDebugInstruction());
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void processWorklist() {
        item = this.ssaWorklist.poll();
        while (item != null) {
            block7: {
                block8: {
                    if (WorklistItem.access$100(item).isFilled()) break block7;
                    if (!IRBuilder.$assertionsDisabled && !this.debugLocalEnds.isEmpty()) {
                        throw new AssertionError();
                    }
                    this.setCurrentBlock(WorklistItem.access$100(item));
                    this.blocks.add(this.currentBlock);
                    this.currentBlock.setNumber(this.basicBlockNumberGenerator.next());
                    if (!(item instanceof MoveExceptionWorklistItem)) break block8;
                    this.processMoveExceptionItem((MoveExceptionWorklistItem)item);
                    this.closeCurrentBlockGuaranteedNotToNeedEdgeSplitting();
                    break block7;
                }
                if (!(item instanceof SplitBlockWorklistItem)) ** GOTO lbl24
                splitEdgeItem = (SplitBlockWorklistItem)item;
                this.source.buildBlockTransfer(this, SplitBlockWorklistItem.access$200(splitEdgeItem), SplitBlockWorklistItem.access$300(splitEdgeItem), false);
                if (WorklistItem.access$400(item) == -1) {
                    this.addInstruction(new Goto(), SplitBlockWorklistItem.access$500(splitEdgeItem));
                    this.closeCurrentBlockGuaranteedNotToNeedEdgeSplitting();
                } else {
                    if (!this.debugLocalEnds.isEmpty()) {
                        this.addInstruction(new DebugLocalRead());
                    }
lbl24:
                    // 4 sources

                    instCount = this.source.instructionCount();
                    for (i = WorklistItem.access$400(item); i < instCount && this.currentBlock != null; ++i) {
                        instructionOffset = this.source.instructionOffset(i);
                        info = (BlockInfo)this.targets.get(instructionOffset);
                        if (info != null && info.block != this.currentBlock) {
                            this.addToWorklist(info.block, i);
                            this.closeCurrentBlockWithFallThrough(info.block);
                            break;
                        }
                        this.currentInstructionOffset = instructionOffset;
                        this.source.buildInstruction(this, i, i == WorklistItem.access$400(item));
                    }
                }
            }
            item = this.ssaWorklist.poll();
        }
    }

    private void processMoveExceptionItem(MoveExceptionWorklistItem moveExceptionItem) {
        int targetIndex = this.source.instructionIndex(moveExceptionItem.targetOffset);
        int moveExceptionDest = this.source.getMoveExceptionRegister(targetIndex);
        Position position = this.source.getCanonicalDebugPositionAtOffset(moveExceptionItem.targetOffset);
        if (moveExceptionDest >= 0) {
            TypeElement typeLattice = TypeElement.fromDexType(moveExceptionItem.guard, Nullability.definitelyNotNull(), this.appView);
            Value out = this.writeRegister(moveExceptionDest, typeLattice, BasicBlock.ThrowingInfo.NO_THROW, null);
            MoveException moveException = new MoveException(out, moveExceptionItem.guard, this.appView.options());
            moveException.setPosition(position);
            this.currentBlock.add((Instruction)moveException, this.metadata);
        }
        boolean isExceptionalEdge = true;
        this.source.buildBlockTransfer(this, moveExceptionItem.sourceOffset, moveExceptionItem.targetOffset, isExceptionalEdge);
        BasicBlock targetBlock = this.getTarget(moveExceptionItem.targetOffset);
        this.currentBlock.link(targetBlock);
        this.addInstruction(new Goto(), position);
        this.addToWorklist(targetBlock, targetIndex);
    }

    private void addExtraUnusedArgument(DexType type) {
        Value value = new Value(this.valueNumberGenerator.next(), type.isReferenceType() ? TypeElement.getNull() : type.toTypeElement(this.appView), null);
        this.addNonThisArgument(new Argument(value, this.currentBlock.size(), false));
    }

    private void addNonThisArgument(Argument argument) {
        if (this.argumentValues == null) {
            this.argumentValues = new ArrayList<Value>();
        }
        this.addInstruction(argument);
        this.argumentValues.add(argument.outValue());
    }

    private static boolean isValidFor(Value value, DebugLocalInfo local) {
        return !value.isUninitializedLocal() && value.getLocalInfo() == local;
    }

    private void internalAddCheckCast(int value, DexType type, boolean isSafe) {
        CheckCast instruction;
        Value in = this.readRegister(value, ValueTypeConstraint.OBJECT);
        TypeElement castTypeLattice = TypeElement.fromDexType(type, in.getType().nullability(), this.appView);
        Value out = this.writeRegister(value, castTypeLattice, BasicBlock.ThrowingInfo.CAN_THROW);
        CheckCast checkCast = instruction = isSafe ? new SafeCheckCast(out, in, type) : new CheckCast(out, in, type);
        assert (instruction.instructionTypeCanThrow());
        this.add(instruction);
    }

    private BasicBlock.ThrowingInfo throwingInfoForConstStrings() {
        return BasicBlock.ThrowingInfo.CAN_THROW;
    }

    private void addTrivialIf(int trueTargetOffset, int falseTargetOffset) {
        assert (trueTargetOffset == falseTargetOffset);
        BasicBlock target = this.getTarget(trueTargetOffset);
        target.decrementUnfilledPredecessorCount();
        this.currentBlock.link(target);
        this.addToWorklist(target, this.source.instructionIndex(trueTargetOffset));
        this.closeCurrentBlock(new Goto());
    }

    private void addNonTrivialIf(If instruction, int trueTargetOffset, int falseTargetOffset) {
        BasicBlock trueTarget = this.getTarget(trueTargetOffset);
        BasicBlock falseTarget = this.getTarget(falseTargetOffset);
        this.currentBlock.link(trueTarget);
        this.currentBlock.link(falseTarget);
        this.addToWorklist(falseTarget, this.source.instructionIndex(falseTargetOffset));
        this.addToWorklist(trueTarget, this.source.instructionIndex(trueTargetOffset));
        this.closeCurrentBlock(instruction);
    }

    private void checkInvokeArgumentRegisters(int expected, int actual) {
        if (expected != actual) {
            throw new CompilationError("Invalid invoke instruction. Expected use of " + expected + " argument registers, found actual use of " + actual);
        }
    }

    private static boolean verifyValueIsMoveException(Value value) {
        if (value.isPhi()) {
            for (Value operand : value.asPhi().getOperands()) {
                assert (operand.definition.isMoveException());
            }
        } else assert (value.definition.isMoveException());
        return true;
    }

    private void addReturn(Return ret) {
        this.attachLocalValues(ret);
        this.source.buildPostlude(this);
        this.closeCurrentBlock(ret);
    }

    private IntSwitch createSwitch(Value value, int[] keys2, int fallthroughOffset, int[] targetOffsets) {
        assert (keys2.length == targetOffsets.length);
        int[] targetBlockIndices = new int[targetOffsets.length];
        HashMap<Integer, Integer> offsetToBlockIndex = new HashMap<Integer, Integer>();
        BasicBlock fallthroughBlock = this.getTarget(fallthroughOffset);
        this.currentBlock.link(fallthroughBlock);
        this.addToWorklist(fallthroughBlock, this.source.instructionIndex(fallthroughOffset));
        int fallthroughBlockIndex = this.currentBlock.getSuccessors().size() - 1;
        offsetToBlockIndex.put(fallthroughOffset, fallthroughBlockIndex);
        for (int i = 0; i < targetOffsets.length; ++i) {
            int targetOffset = targetOffsets[i];
            BasicBlock targetBlock = this.getTarget(targetOffset);
            Integer targetBlockIndex = (Integer)offsetToBlockIndex.get(targetOffset);
            if (targetBlockIndex == null) {
                this.currentBlock.link(targetBlock);
                this.addToWorklist(targetBlock, this.source.instructionIndex(targetOffset));
                int successorIndex = this.currentBlock.getSuccessors().size() - 1;
                offsetToBlockIndex.put(targetOffset, successorIndex);
                targetBlockIndices[i] = successorIndex;
                continue;
            }
            targetBlock.decrementUnfilledPredecessorCount();
            targetBlockIndices[i] = targetBlockIndex;
        }
        return new IntSwitch(value, keys2, targetBlockIndices, fallthroughBlockIndex);
    }

    private Value readRegisterForDebugLocal(int register, DebugLocalInfo local) {
        assert (this.isDebugMode());
        ValueTypeConstraint type = ValueTypeConstraint.fromDexType(local.type);
        return this.readRegister(register, type, this.currentBlock, BasicBlock.EdgeType.NON_EDGE, Phi.RegisterReadType.DEBUG);
    }

    private Value readRegisterRecursive(int register, BasicBlock block, BasicBlock.EdgeType readingEdge, ValueTypeConstraint constraint, Phi.RegisterReadType readType) {
        Value value = null;
        ArrayList<Pair<BasicBlock, BasicBlock.EdgeType>> stack = null;
        if (block.isSealed() && block.getPredecessors().size() == 1) {
            stack = new ArrayList<Pair<BasicBlock, BasicBlock.EdgeType>>(this.blocks.size());
            do {
                assert (block.verifyFilledPredecessors());
                BasicBlock pred = block.getPredecessors().get(0);
                BasicBlock.EdgeType edgeType = pred.getEdgeType(block);
                this.checkRegister(register);
                value = pred.readCurrentDefinition(register, edgeType);
                if (value != null) break;
                stack.add(new Pair<BasicBlock, BasicBlock.EdgeType>(block, readingEdge));
                block = pred;
                readingEdge = edgeType;
            } while (block.isSealed() && block.getPredecessors().size() == 1);
        }
        if (value == null) {
            if (block == this.entryBlock && readType == Phi.RegisterReadType.DEBUG) {
                assert (block.getPredecessors().isEmpty());
                value = this.getUninitializedDebugLocalValue(register, constraint);
            } else {
                DebugLocalInfo local = this.getIncomingLocalAtBlock(register, block);
                TypeElement typeElement = TypeConstraintResolver.typeForConstraint(constraint);
                this.hasImpreciseValues |= !typeElement.isPreciseType();
                Phi phi = null;
                if (this.canUseStackMapTypes() && !this.hasIncorrectStackMapTypes) {
                    DexType phiTypeForBlock = this.source.getPhiTypeForBlock(register, this.offsets.getInt(block), constraint, readType);
                    if (phiTypeForBlock != null) {
                        phi = new Phi.StackMapPhi(this.valueNumberGenerator.next(), block, TypeElement.fromDexType(phiTypeForBlock, Nullability.maybeNull(), this.appView), local, readType);
                    } else {
                        if (readType == Phi.RegisterReadType.DEBUG) {
                            throw new InvalidDebugInfoException("Information in locals-table is invalid with respect to the stack map table. Local refers to non-present stack map type for register: " + register + " with constraint " + (Object)((Object)constraint) + ".");
                        }
                        assert (((DexEncodedMethod)this.method.getDefinition()).getClassFileVersion().isLessThan(CfVersion.V1_8));
                        this.hasIncorrectStackMapTypes = true;
                    }
                }
                if (phi == null) {
                    phi = new Phi(this.valueNumberGenerator.next(), block, typeElement, local, readType);
                }
                if (!block.isSealed()) {
                    block.addIncompletePhi(register, phi, readingEdge);
                    value = phi;
                } else {
                    block.updateCurrentDefinition(register, phi, readingEdge);
                    phi.addOperands(this, register);
                    value = block.readCurrentDefinition(register, readingEdge);
                }
            }
        }
        if (stack != null) {
            for (Pair pair : stack) {
                ((BasicBlock)pair.getFirst()).updateCurrentDefinition(register, value, (BasicBlock.EdgeType)((Object)pair.getSecond()));
            }
        }
        block.updateCurrentDefinition(register, value, readingEdge);
        return value;
    }

    private DebugLocalInfo getIncomingLocalAtBlock(int register, BasicBlock block) {
        if (this.isDebugMode()) {
            int blockOffset = this.offsets.getInt(block);
            return this.source.getIncomingLocalAtBlock(register, blockOffset);
        }
        return null;
    }

    private Value getUninitializedDebugLocalValue(int register, ValueTypeConstraint typeConstraint) {
        ArrayList<Value> values2;
        TypeElement type;
        if (this.appView.options().invalidDebugInfoStrict) {
            throw new InvalidDebugInfoException("Information in locals-table is invalid. Local refers to uninitialized register: " + register + " with constraint " + (Object)((Object)typeConstraint) + ".");
        }
        assert (typeConstraint.isPrecise());
        TypeElement typeElement = type = typeConstraint.isObject() ? TypeElement.getNull() : typeConstraint.toPrimitiveType();
        if (this.uninitializedDebugLocalValues == null) {
            this.uninitializedDebugLocalValues = new Int2ReferenceOpenHashMap<List<Value>>();
        }
        if ((values2 = (ArrayList<Value>)this.uninitializedDebugLocalValues.get(register)) != null) {
            for (Value value : values2) {
                if (value.getType() != type) continue;
                return value;
            }
        } else {
            values2 = new ArrayList<Value>(2);
            this.uninitializedDebugLocalValues.put(register, (List<Value>)values2);
        }
        Value value = new Value(this.valueNumberGenerator.next(), type, null);
        values2.add(value);
        return value;
    }

    private Value readNumericRegister(int register, NumericType type) {
        return this.readRegister(register, ValueTypeConstraint.fromNumericType(type));
    }

    private Value readLiteral(ValueTypeConstraint constraint, long constant) {
        if (constraint == ValueTypeConstraint.INT) {
            return this.readIntLiteral(constant);
        }
        assert (constraint == ValueTypeConstraint.LONG);
        return this.readLongLiteral(constant);
    }

    private Value readLongLiteral(long constant) {
        Value value = new Value(this.valueNumberGenerator.next(), TypeElement.getLong(), null);
        ConstNumber number = new ConstNumber(value, constant);
        this.add(number);
        return number.outValue();
    }

    private Value readIntLiteral(long constant) {
        Value value = new Value(this.valueNumberGenerator.next(), TypeElement.getInt(), null);
        ConstNumber number = new ConstNumber(value, constant);
        this.add(number);
        return number.outValue();
    }

    private Value writeRegister(int register, TypeElement typeLattice, BasicBlock.ThrowingInfo throwing, DebugLocalInfo local) {
        return this.writeRegister(register, new Value(this.valueNumberGenerator.next(), typeLattice, local), throwing);
    }

    private Value writeRegister(int register, Value value, BasicBlock.ThrowingInfo throwing) {
        this.checkRegister(register);
        this.currentBlock.writeCurrentDefinition(register, value, throwing);
        return value;
    }

    private DebugLocalInfo getIncomingLocal(int register) {
        return this.isDebugMode() ? this.source.getIncomingLocal(register) : null;
    }

    private DebugLocalInfo getOutgoingLocal(int register) {
        return this.isDebugMode() ? this.source.getOutgoingLocal(register) : null;
    }

    private void checkRegister(int register) {
        if (register < 0) {
            throw new InternalCompilerError("Invalid register");
        }
        if (!this.source.verifyRegister(register)) {
            throw new CompilationError("Invalid use of register " + register);
        }
    }

    private void addInstruction(Instruction ir) {
        this.addInstruction(ir, this.source.getCurrentPosition());
    }

    private void addInstruction(Instruction ir, Position position) {
        assert (this.verifyOutValueType(ir));
        this.hasImpreciseValues |= ir.outValue() != null && !ir.getOutType().isPreciseType();
        ir.setPosition(position);
        this.attachLocalValues(ir);
        this.currentBlock.add(ir, this.metadata);
        if (ir.instructionTypeCanThrow()) {
            assert (this.source.verifyCurrentInstructionCanThrow());
            CatchHandlers<Integer> catchHandlers = this.source.getCurrentCatchHandlers(this);
            if (catchHandlers != null) {
                assert (!this.throwingInstructionInCurrentBlock);
                this.throwingInstructionInCurrentBlock = true;
                ArrayList<BasicBlock> targets = new ArrayList<BasicBlock>(catchHandlers.getAllTargets().size());
                Set moveExceptionTargets = Sets.newIdentityHashSet();
                catchHandlers.forEach((exceptionType, targetOffset) -> {
                    BasicBlock header = new BasicBlock();
                    header.incrementUnfilledPredecessorCount();
                    this.ssaWorklist.add(new MoveExceptionWorklistItem(header, (DexType)exceptionType, this.currentInstructionOffset, (int)targetOffset));
                    targets.add(header);
                    BasicBlock target = this.getTarget((int)targetOffset);
                    if (!moveExceptionTargets.add(target)) {
                        target.incrementUnfilledPredecessorCount();
                    }
                });
                this.currentBlock.linkCatchSuccessors(catchHandlers.getGuards(), targets);
            }
        }
    }

    private boolean verifyOutValueType(Instruction ir) {
        assert (ir.outValue() == null || ir.isArrayGet() || ir.evaluate(this.appView) == ir.getOutType());
        assert (ir.outValue() == null || !ir.isArrayGet() || ir.evaluate(this.appView) == ir.getOutType() || ir.getOutType().isBottom() && ir.evaluate(this.appView).isReferenceType());
        return true;
    }

    private void attachLocalValues(Instruction ir) {
        if (!this.isDebugMode()) {
            assert (this.previousLocalValue == null);
            assert (this.debugLocalEnds.isEmpty());
            return;
        }
        if (this.previousLocalValue != null && this.previousLocalValue.getLocalInfo() == ir.getLocalInfo()) {
            assert (ir.outValue() != null);
            this.previousLocalValue.addDebugLocalEnd(ir);
        }
        for (Value value : this.debugLocalEnds) {
            value.addDebugLocalEnd(ir);
        }
        this.previousLocalValue = null;
        this.debugLocalEnds.clear();
    }

    private int getBlockStartOffset(int offset) {
        if (this.targets.containsKey(offset)) {
            return offset;
        }
        return this.targets.headMap(offset).lastIntKey();
    }

    private BlockInfo ensureBlock(int offset) {
        if (offset >= 0 && !this.isOffsetProcessed(offset)) {
            this.traceBlocksWorklist.add(offset);
        }
        return this.ensureBlockWithoutEnqueuing(offset);
    }

    private boolean isOffsetProcessed(int offset) {
        return this.isIndexProcessed(this.source.instructionIndex(offset));
    }

    private boolean isIndexProcessed(int index) {
        if (index < this.processedInstructions.length) {
            return this.processedInstructions[index];
        }
        this.ensureSubroutineProcessedInstructions();
        return this.processedSubroutineInstructions.contains(index);
    }

    private void markIndexProcessed(int index) {
        assert (!this.isIndexProcessed(index));
        if (index < this.processedInstructions.length) {
            this.processedInstructions[index] = true;
            return;
        }
        this.ensureSubroutineProcessedInstructions();
        this.processedSubroutineInstructions.add(index);
    }

    private void ensureSubroutineProcessedInstructions() {
        if (this.processedSubroutineInstructions == null) {
            this.processedSubroutineInstructions = new HashSet<Integer>();
        }
    }

    private void ensureSuccessorBlock(int sourceOffset, int targetOffset, boolean normal) {
        BlockInfo targetInfo = this.ensureBlock(targetOffset);
        int sourceStartOffset = this.getBlockStartOffset(sourceOffset);
        BlockInfo sourceInfo = (BlockInfo)this.targets.get(sourceStartOffset);
        if (normal) {
            sourceInfo.addNormalSuccessor(targetOffset);
            targetInfo.addNormalPredecessor(sourceStartOffset);
        } else {
            sourceInfo.addExceptionalSuccessor(targetOffset);
            targetInfo.addExceptionalPredecessor(sourceStartOffset);
        }
        targetInfo.block.incrementUnfilledPredecessorCount();
    }

    private BlockInfo getBlockInfo(int offset) {
        return (BlockInfo)this.targets.get(offset);
    }

    private BlockInfo getBlockInfo(BasicBlock block) {
        return this.getBlockInfo(this.getOffset(block));
    }

    private BasicBlock getTarget(int offset) {
        return ((BlockInfo)this.targets.get((int)offset)).block;
    }

    private int getOffset(BasicBlock block) {
        return this.offsets.getInt(block);
    }

    private void closeCurrentBlockGuaranteedNotToNeedEdgeSplitting() {
        assert (this.currentBlock != null);
        this.currentBlock.close(this);
        this.setCurrentBlock(null);
        this.throwingInstructionInCurrentBlock = false;
        this.currentInstructionOffset = -1;
        assert (this.debugLocalEnds.isEmpty());
    }

    private void closeCurrentBlock(JumpInstruction jumpInstruction) {
        assert (!jumpInstruction.instructionTypeCanThrow());
        assert (this.currentBlock != null);
        assert (this.currentBlock.getInstructions().isEmpty() || !this.currentBlock.getInstructions().getLast().isJumpInstruction());
        this.generateSplitEdgeBlocks();
        this.addInstruction(jumpInstruction);
        this.closeCurrentBlockGuaranteedNotToNeedEdgeSplitting();
    }

    private void closeCurrentBlockWithFallThrough(BasicBlock nextBlock) {
        assert (this.currentBlock != null);
        assert (!this.currentBlock.hasCatchSuccessor(nextBlock));
        this.currentBlock.link(nextBlock);
        this.closeCurrentBlock(new Goto());
    }

    private void generateSplitEdgeBlocks() {
        assert (this.currentBlock != null);
        assert (this.currentBlock.isEmpty() || !this.currentBlock.getInstructions().getLast().isJumpInstruction());
        BlockInfo info = this.getBlockInfo(this.currentBlock);
        Position position = this.source.getCurrentPosition();
        if (info.hasMoreThanASingleNormalExit()) {
            IntIterator intIterator = info.normalSuccessors.iterator();
            while (intIterator.hasNext()) {
                int successorOffset = (Integer)intIterator.next();
                BlockInfo successorInfo = this.getBlockInfo(successorOffset);
                if (successorInfo.predecessorCount() == 1) {
                    WorklistItem oldItem = null;
                    for (WorklistItem item : this.ssaWorklist) {
                        if (item.block != successorInfo.block) continue;
                        oldItem = item;
                    }
                    assert (oldItem.firstInstructionIndex == this.source.instructionIndex(successorOffset));
                    this.ssaWorklist.remove(oldItem);
                    this.ssaWorklist.add(new SplitBlockWorklistItem(oldItem.firstInstructionIndex, oldItem.block, position, this.currentInstructionOffset, successorOffset));
                    continue;
                }
                BasicBlock splitBlock = IRBuilder.createSplitEdgeBlock(this.currentBlock, successorInfo.block);
                this.ssaWorklist.add(new SplitBlockWorklistItem(-1, splitBlock, position, this.currentInstructionOffset, successorOffset));
            }
        } else if (info.normalSuccessors.size() == 1) {
            int successorOffset = info.normalSuccessors.iterator().nextInt();
            this.source.buildBlockTransfer(this, this.currentInstructionOffset, successorOffset, false);
        } else assert (info.allSuccessors().isEmpty());
    }

    private static BasicBlock createSplitEdgeBlock(BasicBlock source, BasicBlock target) {
        BasicBlock splitBlock = new BasicBlock();
        splitBlock.incrementUnfilledPredecessorCount();
        splitBlock.getMutablePredecessors().add(source);
        splitBlock.getMutableSuccessors().add(target);
        source.replaceSuccessor(target, splitBlock);
        target.replacePredecessor(source, splitBlock);
        return splitBlock;
    }

    public DexItemFactory dexItemFactory() {
        return this.appView.dexItemFactory();
    }

    public GraphLens getCodeLens() {
        return this.codeLens;
    }

    public DexEncodedMethod getMethod() {
        return (DexEncodedMethod)this.method.getDefinition();
    }

    public ProgramMethod getProgramMethod() {
        return this.method;
    }

    public RewrittenPrototypeDescription getPrototypeChanges() {
        return this.prototypeChanges;
    }

    public boolean isDebugMode() {
        return this.appView.options().debug || this.getProgramMethod().getOrComputeReachabilitySensitive(this.appView);
    }

    public Int2ReferenceSortedMap<BlockInfo> getCFG() {
        return this.targets;
    }

    public List<Value> getArgumentValues() {
        return this.argumentValues;
    }

    public Value getReceiverValue() {
        return this.receiverValue;
    }

    public void buildArgumentsWithRewrittenPrototypeChanges(int register, DexEncodedMethod method, BiConsumer<Integer, DexType> writeCallback) {
        ArgumentInfoCollection argumentsInfo = this.prototypeChanges.getArgumentInfoCollection();
        int argumentIndex = 0;
        if (!method.isStatic()) {
            assert (argumentsInfo.getNewArgumentIndex(0) == 0);
            writeCallback.accept(register, method.getHolderType());
            this.addThisArgument(register);
            ++argumentIndex;
            ++register;
        }
        int originalNumberOfArguments = method.getParameters().size() + argumentsInfo.numberOfRemovedArguments() + method.getFirstNonReceiverArgumentIndex() - this.prototypeChanges.numberOfExtraParameters();
        int numberOfRemovedArguments = 0;
        while (argumentIndex < originalNumberOfArguments) {
            TypeElement type;
            ArgumentInfo argumentInfo = argumentsInfo.getArgumentInfo(argumentIndex);
            if (argumentInfo.isRemovedArgumentInfo()) {
                RemovedArgumentInfo removedArgumentInfo = argumentInfo.asRemovedArgumentInfo();
                writeCallback.accept(register, removedArgumentInfo.getType());
                type = TypeElement.fromDexType(removedArgumentInfo.getType(), Nullability.maybeNull(), this.appView);
                this.addNonThisArgument(register, type);
                ++numberOfRemovedArguments;
            } else {
                DexType argType;
                int newArgumentIndex = argumentsInfo.getNewArgumentIndex(argumentIndex, numberOfRemovedArguments);
                if (argumentInfo.isRewrittenTypeInfo()) {
                    RewrittenTypeInfo argumentRewrittenTypeInfo = argumentInfo.asRewrittenTypeInfo();
                    assert (method.getArgumentType(newArgumentIndex) == argumentRewrittenTypeInfo.getNewType());
                    argType = argumentRewrittenTypeInfo.getOldType();
                } else {
                    argType = method.getArgumentType(newArgumentIndex);
                }
                writeCallback.accept(register, argType);
                type = TypeElement.fromDexType(argType, Nullability.maybeNull(), this.appView);
                if (argType.isBooleanType()) {
                    this.addBooleanNonThisArgument(register);
                } else {
                    this.addNonThisArgument(register, type);
                }
            }
            ++argumentIndex;
            register += type.requiredRegisters();
        }
        for (ExtraParameter extraParameter : this.prototypeChanges.getExtraParameters()) {
            int newArgumentIndex = argumentsInfo.getNewArgumentIndex(argumentIndex, numberOfRemovedArguments);
            DexType extraArgumentType = method.getArgumentType(newArgumentIndex);
            if (extraParameter instanceof ExtraUnusedNullParameter) {
                this.addExtraUnusedArgument(extraArgumentType);
            } else {
                this.addNonThisArgument(register, extraParameter.getTypeElement(this.appView, extraArgumentType));
            }
            ++argumentIndex;
            register += extraArgumentType.getRequiredRegisters();
        }
    }

    public IRCode build(ProgramMethod context, MethodConversionOptions.MutableMethodConversionOptions conversionOptions) {
        assert (this.source != null);
        this.source.setUp();
        this.context = context;
        BlockInfo initialBlockInfo = new BlockInfo();
        this.targets.put(-1, initialBlockInfo);
        this.offsets.put(initialBlockInfo.block, -1);
        int instCount = this.source.instructionCount();
        this.processedInstructions = new boolean[instCount];
        this.traceBlocksWorklist.add(0);
        block0: while (!this.traceBlocksWorklist.isEmpty()) {
            int startOfBlockOffset = this.traceBlocksWorklist.remove();
            int startOfBlockIndex = this.source.instructionIndex(startOfBlockOffset);
            if (this.isIndexProcessed(startOfBlockIndex)) continue;
            for (int index = startOfBlockIndex; index < instCount; ++index) {
                int nextOffset;
                this.markIndexProcessed(index);
                int n = this.source.traceInstruction(index, this);
                if (n != -1) {
                    if (n + 1 >= instCount) continue block0;
                    this.ensureBlockWithoutEnqueuing(this.source.instructionOffset(n + 1));
                    continue block0;
                }
                if (index + 1 >= instCount || this.targets.get(nextOffset = this.source.instructionOffset(index + 1)) == null) continue;
                this.ensureNormalSuccessorBlock(startOfBlockOffset, nextOffset);
                continue block0;
            }
        }
        this.processedInstructions = null;
        this.setCurrentBlock(((BlockInfo)this.targets.get((int)-1)).block);
        this.entryBlock = this.currentBlock;
        this.source.buildPrelude(this);
        this.addToWorklist(this.currentBlock, 0);
        this.processWorklist();
        assert (this.currentBlock == null);
        assert (this.verifyFilledPredecessors());
        this.insertDebugPositions();
        if (this.uninitializedDebugLocalValues != null) {
            Position position = this.entryBlock.getPosition();
            InstructionListIterator it = this.entryBlock.listIterator(this.metadata);
            it.nextUntil(i -> !i.isArgument());
            it.previous();
            for (List list : this.uninitializedDebugLocalValues.values()) {
                for (Value value : list) {
                    if (!value.isUsed()) continue;
                    DebugLocalUninitialized def = new DebugLocalUninitialized(value);
                    def.setBlock(this.entryBlock);
                    def.setPosition(position);
                    it.add(def);
                }
            }
        }
        for (BasicBlock block : this.blocks) {
            block.clearCurrentDefinitions();
        }
        this.joinPredecessorsWithIdenticalPhis();
        IRCode ir = new IRCode(this.appView.options(), this.method, this.blocks, this.valueNumberGenerator, this.basicBlockNumberGenerator, this.metadata, this.origin, conversionOptions);
        assert (ir.verifySplitCriticalEdges());
        for (BasicBlock block : this.blocks) {
            block.deduplicatePhis();
        }
        ir.removeAllDeadAndTrivialPhis(this);
        ir.removeUnreachableBlocks();
        if (this.hasImpreciseValues || this.impreciseInstructions != null) {
            assert (this.source instanceof DexSourceCode);
            new TypeConstraintResolver(this.appView, this).resolve(this.impreciseInstructions, ir);
        } else if (!this.canUseStackMapTypes() || this.hasIncorrectStackMapTypes) {
            new TypeAnalysis(this.appView).widening(ir);
        } else {
            assert (this.canUseStackMapTypes() && !this.hasIncorrectStackMapTypes);
            assert (this.allPhisAreStackMapPhis(ir));
            new TypeAnalysis(this.appView).narrowing(ir);
        }
        if (this.appView.options().isStringSwitchConversionEnabled()) {
            StringSwitchConverter.convertToStringSwitchInstructions(ir, this.appView.dexItemFactory());
        }
        assert (ir.isConsistentSSA(this.appView));
        this.source.clear();
        this.source = null;
        return ir;
    }

    public boolean canUseStackMapTypes() {
        return !this.appView.enableWholeProgramOptimizations() && this.source.hasValidTypesFromStackMap();
    }

    public void constrainType(Value value, ValueTypeConstraint constraint) {
        value.constrainType(constraint, (DexMethod)this.method.getReference(), this.origin, this.appView.options().reporter);
    }

    public void resolveAndBuildSwitch(int value, int fallthroughOffset, int payloadOffset) {
        this.source.resolveAndBuildSwitch(value, fallthroughOffset, payloadOffset, this);
    }

    public void resolveAndBuildNewArrayFilledData(int arrayRef, int payloadOffset) {
        this.source.resolveAndBuildNewArrayFilledData(arrayRef, payloadOffset, this);
    }

    public void add(Instruction ir) {
        assert (!ir.isJumpInstruction());
        this.addInstruction(ir);
    }

    void addThisArgument(int register) {
        boolean receiverCouldBeNull = this.context != null && this.context != this.method;
        Nullability nullability = receiverCouldBeNull ? Nullability.maybeNull() : Nullability.definitelyNotNull();
        TypeElement receiverType = TypeElement.fromDexType(this.method.getHolderType(), nullability, this.appView);
        this.addThisArgument(register, receiverType);
    }

    public void addThisArgument(int register, TypeElement receiverType) {
        DebugLocalInfo local = this.getOutgoingLocal(register);
        Value value = this.writeRegister(register, receiverType, BasicBlock.ThrowingInfo.NO_THROW, local);
        this.addInstruction(new Argument(value, this.currentBlock.size(), false));
        this.receiverValue = value;
        value.markAsThis();
    }

    public void addNonThisArgument(int register, TypeElement typeLattice) {
        DebugLocalInfo local = this.getOutgoingLocal(register);
        Value value = this.writeRegister(register, typeLattice, BasicBlock.ThrowingInfo.NO_THROW, local);
        this.addNonThisArgument(new Argument(value, this.currentBlock.size(), false));
    }

    public void addBooleanNonThisArgument(int register) {
        DebugLocalInfo local = this.getOutgoingLocal(register);
        Value value = this.writeRegister(register, TypeElement.getInt(), BasicBlock.ThrowingInfo.NO_THROW, local);
        this.addNonThisArgument(new Argument(value, this.currentBlock.size(), true));
    }

    public void addDebugLocalStart(int register, DebugLocalInfo local) {
        assert (local != null);
        if (!this.isDebugMode()) {
            return;
        }
        Value incomingValue = this.readRegisterForDebugLocal(register, local);
        if (incomingValue.getLocalInfo() != local || this.currentBlock.isEmpty() || this.currentBlock.getInstructions().getLast().outValue() != incomingValue) {
            Value out = this.writeRegister(register, incomingValue.getType(), BasicBlock.ThrowingInfo.NO_THROW, local);
            DebugLocalWrite write = new DebugLocalWrite(out, incomingValue);
            this.addInstruction(write);
        }
    }

    public void addDebugLocalEnd(int register, DebugLocalInfo local) {
        assert (local != null);
        if (!this.isDebugMode()) {
            return;
        }
        Value value = this.readRegisterForDebugLocal(register, local);
        if (IRBuilder.isValidFor(value, local)) {
            this.debugLocalEnds.add(value);
        }
    }

    public void addDebugPosition(Position position) {
        if (this.isDebugMode()) {
            assert (this.previousLocalValue == null);
            assert (this.source.getCurrentPosition().equals(position));
            if (!this.debugLocalEnds.isEmpty()) {
                if (this.currentBlock.getInstructions().isEmpty()) {
                    this.addInstruction(new DebugLocalRead());
                } else {
                    assert (!this.debugLocalEnds.contains(this.currentBlock.getInstructions().getLast().outValue()));
                    this.attachLocalValues(this.currentBlock.getInstructions().getLast());
                }
            }
            this.addInstruction(new DebugPosition());
        }
    }

    public void addAdd(NumericType type, int dest, int left, int right) {
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Add instruction = new Add(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addAddLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readIntLiteral(constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Add instruction = new Add(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addAnd(NumericType type, int dest, int left, int right) {
        assert (this.isIntegerType(type));
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        And instruction = new And(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addAndLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readIntLiteral(constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        And instruction = new And(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addArrayGet(MemberType type, int dest, int array, int index) {
        TypeElement typeLattice;
        Value in1 = this.readRegister(array, ValueTypeConstraint.OBJECT);
        Value in2 = this.readRegister(index, ValueTypeConstraint.INT);
        if (type == MemberType.OBJECT && this.canUseStackMapTypes()) {
            if (in1.getType().isNullType()) {
                typeLattice = TypeElement.getNull();
            } else if (in1.getType().isArrayType()) {
                typeLattice = in1.getType().asArrayType().getMemberType();
            } else {
                assert (in1.getType().isBottom() && this.hasIncorrectStackMapTypes);
                typeLattice = IRBuilder.fromMemberType(type);
            }
        } else {
            typeLattice = IRBuilder.fromMemberType(type);
        }
        Value out = this.writeRegister(dest, typeLattice, BasicBlock.ThrowingInfo.CAN_THROW);
        ArrayGet instruction = new ArrayGet(type, out, in1, in2);
        assert (instruction.instructionTypeCanThrow());
        if (!type.isPrecise()) {
            this.addImpreciseInstruction(instruction);
        }
        this.add(instruction);
    }

    public void addArrayLength(int dest, int array) {
        Value in = this.readRegister(array, ValueTypeConstraint.OBJECT);
        Value out = this.writeRegister(dest, TypeElement.getInt(), BasicBlock.ThrowingInfo.CAN_THROW);
        ArrayLength instruction = new ArrayLength(out, in);
        assert (instruction.instructionTypeCanThrow());
        this.add(instruction);
    }

    public void addArrayPut(MemberType type, int value, int array, int index) {
        Value inValue = this.readRegister(value, ValueTypeConstraint.fromMemberType(type));
        Value inArray = this.readRegister(array, ValueTypeConstraint.OBJECT);
        Value inIndex = this.readRegister(index, ValueTypeConstraint.INT);
        ArrayPut instruction = new ArrayPut(type, inArray, inIndex, inValue);
        if (!type.isPrecise()) {
            this.addImpreciseInstruction(instruction);
        }
        this.add(instruction);
    }

    public void addCheckCast(int value, DexType type) {
        this.internalAddCheckCast(value, type, false);
    }

    public void addSafeCheckCast(int value, DexType type) {
        this.internalAddCheckCast(value, type, true);
    }

    public void addCmp(NumericType type, Cmp.Bias bias, int dest, int left, int right) {
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeRegister(dest, TypeElement.getInt(), BasicBlock.ThrowingInfo.NO_THROW);
        Cmp instruction = new Cmp(type, bias, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.add(instruction);
    }

    public void addConst(TypeElement typeLattice, int dest, long value) {
        Value out = this.writeRegister(dest, typeLattice, BasicBlock.ThrowingInfo.NO_THROW);
        ConstNumber instruction = new ConstNumber(out, value);
        assert (!instruction.instructionTypeCanThrow());
        this.add(instruction);
    }

    public void addLongConst(int dest, long value) {
        this.add(new ConstNumber(this.writeRegister(dest, TypeElement.getLong(), BasicBlock.ThrowingInfo.NO_THROW), value));
    }

    public void addDoubleConst(int dest, long value) {
        this.add(new ConstNumber(this.writeRegister(dest, TypeElement.getDouble(), BasicBlock.ThrowingInfo.NO_THROW), value));
    }

    public void addIntConst(int dest, long value) {
        this.add(new ConstNumber(this.writeRegister(dest, TypeElement.getInt(), BasicBlock.ThrowingInfo.NO_THROW), value));
    }

    public void addFloatConst(int dest, long value) {
        this.add(new ConstNumber(this.writeRegister(dest, TypeElement.getFloat(), BasicBlock.ThrowingInfo.NO_THROW), value));
    }

    public void addNullConst(int dest) {
        this.add(new ConstNumber(this.writeRegister(dest, TypeElement.getNull(), BasicBlock.ThrowingInfo.NO_THROW), 0L));
    }

    public void addConstClass(int dest, DexType type) {
        ClassTypeElement typeLattice = TypeElement.classClassType(this.appView, Nullability.definitelyNotNull());
        Value out = this.writeRegister(dest, typeLattice, BasicBlock.ThrowingInfo.CAN_THROW);
        ConstClass instruction = new ConstClass(out, type);
        assert (instruction.instructionTypeCanThrow());
        this.add(instruction);
    }

    public void addConstMethodHandle(int dest, DexMethodHandle methodHandle) {
        if (!this.appView.options().canUseConstantMethodHandle()) {
            throw new ApiLevelException(AndroidApiLevel.P, "Const-method-handle", null);
        }
        TypeElement typeLattice = TypeElement.fromDexType(this.appView.dexItemFactory().methodHandleType, Nullability.definitelyNotNull(), this.appView);
        Value out = this.writeRegister(dest, typeLattice, BasicBlock.ThrowingInfo.CAN_THROW);
        ConstMethodHandle instruction = new ConstMethodHandle(out, methodHandle);
        this.add(instruction);
    }

    public void addConstMethodType(int dest, DexProto methodType) {
        if (!this.appView.options().canUseConstantMethodType()) {
            throw new ApiLevelException(AndroidApiLevel.P, "Const-method-type", null);
        }
        TypeElement typeLattice = TypeElement.fromDexType(this.appView.dexItemFactory().methodTypeType, Nullability.definitelyNotNull(), this.appView);
        Value out = this.writeRegister(dest, typeLattice, BasicBlock.ThrowingInfo.CAN_THROW);
        ConstMethodType instruction = new ConstMethodType(out, methodType);
        this.add(instruction);
    }

    public void addConstString(int dest, DexString string) {
        ClassTypeElement typeLattice = TypeElement.stringClassType(this.appView, Nullability.definitelyNotNull());
        BasicBlock.ThrowingInfo throwingInfo = this.throwingInfoForConstStrings();
        this.add(new ConstString(this.writeRegister(dest, typeLattice, throwingInfo), string));
    }

    public void addDexItemBasedConstString(int dest, DexReference item, NameComputationInfo<?> nameComputationInfo) {
        ClassTypeElement typeLattice = TypeElement.stringClassType(this.appView, Nullability.definitelyNotNull());
        BasicBlock.ThrowingInfo throwingInfo = this.throwingInfoForConstStrings();
        Value out = this.writeRegister(dest, typeLattice, throwingInfo);
        this.add(new DexItemBasedConstString(out, item, nameComputationInfo));
    }

    public void addDiv(NumericType type, int dest, int left, int right) {
        boolean canThrow = type != NumericType.DOUBLE && type != NumericType.FLOAT;
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, canThrow ? BasicBlock.ThrowingInfo.CAN_THROW : BasicBlock.ThrowingInfo.NO_THROW);
        Div instruction = new Div(type, out, in1, in2);
        assert (instruction.instructionTypeCanThrow() == canThrow);
        this.add(instruction);
    }

    public void addDivLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        boolean canThrow = type != NumericType.DOUBLE && type != NumericType.FLOAT;
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readIntLiteral(constant);
        Value out = this.writeNumericRegister(dest, type, canThrow ? BasicBlock.ThrowingInfo.CAN_THROW : BasicBlock.ThrowingInfo.NO_THROW);
        Div instruction = new Div(type, out, in1, in2);
        assert (instruction.instructionTypeCanThrow() == canThrow);
        this.add(instruction);
    }

    public Monitor addMonitor(Monitor.Type type, int monitor) {
        Value in = this.readRegister(monitor, ValueTypeConstraint.OBJECT);
        Monitor monitorEnter = new Monitor(type, in);
        this.add(monitorEnter);
        return monitorEnter;
    }

    public void addMove(ValueType valueType, int dest, int src) {
        this.addMove(ValueTypeConstraint.fromValueType(valueType), dest, src);
    }

    public void addMove(ValueTypeConstraint constraint, int dest, int src) {
        Value in = this.readRegister(src, constraint);
        if (this.isDebugMode()) {
            DebugLocalInfo destLocal = this.getOutgoingLocal(dest);
            if (destLocal != null && destLocal != in.getLocalInfo()) {
                Value out = this.writeRegister(dest, in.getType(), BasicBlock.ThrowingInfo.NO_THROW);
                this.addInstruction(new DebugLocalWrite(out, in));
                return;
            }
            if (!this.debugLocalEnds.isEmpty()) {
                this.addInstruction(new DebugLocalRead());
            }
        }
        this.currentBlock.writeCurrentDefinition(dest, in, BasicBlock.ThrowingInfo.NO_THROW);
    }

    public void addMul(NumericType type, int dest, int left, int right) {
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Mul instruction = new Mul(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addMulLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readIntLiteral(constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Mul instruction = new Mul(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addNop() {
        if (!this.debugLocalEnds.isEmpty()) {
            this.addInstruction(new DebugLocalRead());
        }
    }

    public void addRem(NumericType type, int dest, int left, int right) {
        boolean canThrow = type != NumericType.DOUBLE && type != NumericType.FLOAT;
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, canThrow ? BasicBlock.ThrowingInfo.CAN_THROW : BasicBlock.ThrowingInfo.NO_THROW);
        Rem instruction = new Rem(type, out, in1, in2);
        assert (instruction.instructionTypeCanThrow() == canThrow);
        this.addInstruction(instruction);
    }

    public void addRemLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        boolean canThrow = type != NumericType.DOUBLE && type != NumericType.FLOAT;
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readIntLiteral(constant);
        Value out = this.writeNumericRegister(dest, type, canThrow ? BasicBlock.ThrowingInfo.CAN_THROW : BasicBlock.ThrowingInfo.NO_THROW);
        Rem instruction = new Rem(type, out, in1, in2);
        assert (instruction.instructionTypeCanThrow() == canThrow);
        this.addInstruction(instruction);
    }

    public void addGoto(int targetOffset) {
        BasicBlock targetBlock = this.getTarget(targetOffset);
        assert (!this.currentBlock.hasCatchSuccessor(targetBlock));
        this.currentBlock.link(targetBlock);
        this.addToWorklist(targetBlock, this.source.instructionIndex(targetOffset));
        this.closeCurrentBlock(new Goto());
    }

    public void addIf(If.Type type, ValueType operandType, int value1, int value2, int trueTargetOffset, int falseTargetOffset) {
        this.addIf(type, ValueTypeConstraint.fromValueType(operandType), value1, value2, trueTargetOffset, falseTargetOffset);
    }

    public void addIf(If.Type type, ValueTypeConstraint operandConstraint, int value1, int value2, int trueTargetOffset, int falseTargetOffset) {
        if (trueTargetOffset == falseTargetOffset) {
            this.addTrivialIf(trueTargetOffset, falseTargetOffset);
        } else {
            ArrayList<Value> values2 = new ArrayList<Value>(2);
            values2.add(this.readRegister(value1, operandConstraint));
            values2.add(this.readRegister(value2, operandConstraint));
            If instruction = new If(type, values2);
            this.addNonTrivialIf(instruction, trueTargetOffset, falseTargetOffset);
        }
    }

    public void addIfZero(If.Type type, ValueType operandType, int value, int trueTargetOffset, int falseTargetOffset) {
        this.addIfZero(type, ValueTypeConstraint.fromValueType(operandType), value, trueTargetOffset, falseTargetOffset);
    }

    public void addIfZero(If.Type type, ValueTypeConstraint operandConstraint, int value, int trueTargetOffset, int falseTargetOffset) {
        if (trueTargetOffset == falseTargetOffset) {
            this.addTrivialIf(trueTargetOffset, falseTargetOffset);
        } else {
            If instruction = new If(type, this.readRegister(value, operandConstraint));
            this.addNonTrivialIf(instruction, trueTargetOffset, falseTargetOffset);
        }
    }

    public void addInstanceGet(int dest, int object, DexField field) {
        Value in = this.readRegister(object, ValueTypeConstraint.OBJECT);
        Value out = this.writeRegister(dest, TypeElement.fromDexType(field.type, Nullability.maybeNull(), this.appView), BasicBlock.ThrowingInfo.CAN_THROW);
        InstanceGet instruction = new InstanceGet(out, in, field);
        assert (instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addInstanceOf(int dest, int value, DexType type) {
        Value in = this.readRegister(value, ValueTypeConstraint.OBJECT);
        Value out = this.writeRegister(dest, TypeElement.getInt(), BasicBlock.ThrowingInfo.CAN_THROW);
        InstanceOf instruction = new InstanceOf(out, in, type);
        assert (instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addInstancePut(int value, int object, DexField field) {
        Value objectValue = this.readRegister(object, ValueTypeConstraint.OBJECT);
        Value valueValue = this.readRegister(value, ValueTypeConstraint.fromDexType(field.type));
        InstancePut instruction = new InstancePut(field, objectValue, valueValue);
        this.add(instruction);
    }

    public void addRecordFieldValues(DexField[] fields, IntList registers, int outValue) {
        ArrayList<Value> arguments = new ArrayList<Value>();
        IntListIterator intListIterator = registers.iterator();
        while (intListIterator.hasNext()) {
            int register = (Integer)intListIterator.next();
            arguments.add(this.readRegister(register, ValueTypeConstraint.OBJECT));
        }
        Value out = this.writeRegister(outValue, TypeElement.fromDexType(this.appView.dexItemFactory().objectArrayType, Nullability.definitelyNotNull(), this.appView), BasicBlock.ThrowingInfo.CAN_THROW);
        this.add(new RecordFieldValues(fields, out, arguments));
    }

    public void addInvoke(Invoke.Type type, DexItem item, DexProto callSiteProto, List<Value> arguments, boolean itf) {
        if (type == Invoke.Type.POLYMORPHIC) {
            assert (item instanceof DexMethod);
            if (!this.appView.options().canUseInvokePolymorphic()) {
                throw new ApiLevelException(AndroidApiLevel.O, "MethodHandle.invoke and MethodHandle.invokeExact", null);
            }
            if (!this.appView.options().canUseInvokePolymorphicOnVarHandle() && ((DexMethod)item).holder == this.appView.dexItemFactory().varHandleType) {
                throw new ApiLevelException(AndroidApiLevel.P, "Call to polymorphic signature of VarHandle", null);
            }
        }
        this.add(Invoke.create(type, item, callSiteProto, null, arguments, itf));
    }

    public void addInvoke(Invoke.Type type, DexItem item, DexProto callSiteProto, List<ValueType> types, List<Integer> registers, boolean itf) {
        assert (types.size() == registers.size());
        ArrayList<Value> arguments = new ArrayList<Value>(types.size());
        for (int i = 0; i < types.size(); ++i) {
            arguments.add(this.readRegister(registers.get(i), ValueTypeConstraint.fromValueType(types.get(i))));
        }
        this.addInvoke(type, item, callSiteProto, arguments, itf);
    }

    public void addInvokeCustomRegisters(DexCallSite callSite, int argumentRegisterCount, int[] argumentRegisters) {
        int registerIndex = 0;
        DexMethodHandle bootstrapMethod = callSite.bootstrapMethod;
        ArrayList<Value> arguments = new ArrayList<Value>(argumentRegisterCount);
        if (!bootstrapMethod.isStaticHandle()) {
            arguments.add(this.readRegister(argumentRegisters[registerIndex], ValueTypeConstraint.OBJECT));
            registerIndex += ValueTypeConstraint.OBJECT.requiredRegisters();
        }
        String shorty = callSite.methodProto.shorty.toString();
        for (int i = 1; i < shorty.length(); ++i) {
            ValueTypeConstraint constraint = ValueTypeConstraint.fromTypeDescriptorChar(shorty.charAt(i));
            arguments.add(this.readRegister(argumentRegisters[registerIndex], constraint));
            registerIndex += constraint.requiredRegisters();
        }
        this.add(new InvokeCustom(callSite, null, arguments));
    }

    public void addInvokeCustomRange(DexCallSite callSite, int argumentCount, int firstArgumentRegister) {
        DexMethodHandle bootstrapMethod = callSite.bootstrapMethod;
        ArrayList<Value> arguments = new ArrayList<Value>(argumentCount);
        int register = firstArgumentRegister;
        if (!bootstrapMethod.isStaticHandle()) {
            arguments.add(this.readRegister(register, ValueTypeConstraint.OBJECT));
            register += ValueTypeConstraint.OBJECT.requiredRegisters();
        }
        String shorty = callSite.methodProto.shorty.toString();
        for (int i = 1; i < shorty.length(); ++i) {
            ValueTypeConstraint constraint = ValueTypeConstraint.fromTypeDescriptorChar(shorty.charAt(i));
            arguments.add(this.readRegister(register, constraint));
            register += constraint.requiredRegisters();
        }
        this.checkInvokeArgumentRegisters(register, firstArgumentRegister + argumentCount);
        this.add(new InvokeCustom(callSite, null, arguments));
    }

    public void addInvokeCustom(DexCallSite callSite, List<ValueType> types, List<Integer> registers) {
        assert (types.size() == registers.size());
        ArrayList<Value> arguments = new ArrayList<Value>(types.size());
        for (int i = 0; i < types.size(); ++i) {
            arguments.add(this.readRegister(registers.get(i), ValueTypeConstraint.fromValueType(types.get(i))));
        }
        this.add(new InvokeCustom(callSite, null, arguments));
    }

    public void addInvokeRegisters(Invoke.Type type, DexMethod method, DexProto callSiteProto, int argumentRegisterCount, int[] argumentRegisters) {
        ArrayList<Value> arguments = new ArrayList<Value>(argumentRegisterCount);
        int registerIndex = 0;
        if (type != Invoke.Type.STATIC) {
            arguments.add(this.readRegister(argumentRegisters[registerIndex], ValueTypeConstraint.OBJECT));
            registerIndex += ValueTypeConstraint.OBJECT.requiredRegisters();
        }
        DexString methodShorty = type == Invoke.Type.POLYMORPHIC ? callSiteProto.shorty : method.proto.shorty;
        String shorty = methodShorty.toString();
        for (int i = 1; i < methodShorty.size; ++i) {
            ValueTypeConstraint constraint = ValueTypeConstraint.fromTypeDescriptorChar(shorty.charAt(i));
            arguments.add(this.readRegister(argumentRegisters[registerIndex], constraint));
            registerIndex += constraint.requiredRegisters();
        }
        this.checkInvokeArgumentRegisters(registerIndex, argumentRegisterCount);
        assert (this.appView.options().isGeneratingDex());
        this.addInvoke(type, method, callSiteProto, arguments, false);
    }

    public void addInvokeNewArray(DexType type, int argumentCount, int[] argumentRegisters) {
        int registerIndex;
        String descriptor = type.descriptor.toString();
        assert (descriptor.charAt(0) == '[');
        assert (descriptor.length() >= 2);
        ValueTypeConstraint constraint = ValueTypeConstraint.fromTypeDescriptorChar(descriptor.charAt(1));
        ArrayList<Value> arguments = new ArrayList<Value>(argumentCount / constraint.requiredRegisters());
        for (registerIndex = 0; registerIndex < argumentCount; registerIndex += constraint.requiredRegisters()) {
            arguments.add(this.readRegister(argumentRegisters[registerIndex], constraint));
            if (!constraint.isWide()) continue;
            assert (registerIndex < argumentCount - 1);
            assert (argumentRegisters[registerIndex] == argumentRegisters[registerIndex + 1] + 1);
        }
        this.checkInvokeArgumentRegisters(registerIndex, argumentCount);
        this.addInvoke(Invoke.Type.NEW_ARRAY, type, null, arguments, false);
    }

    public void addMultiNewArray(DexType type, int dest, int[] dimensions) {
        assert (this.appView.options().isGeneratingClassFiles());
        ArrayList<Value> arguments = new ArrayList<Value>(dimensions.length);
        for (int dimension : dimensions) {
            arguments.add(this.readRegister(dimension, ValueTypeConstraint.INT));
        }
        this.addInvoke(Invoke.Type.MULTI_NEW_ARRAY, type, null, arguments, false);
        this.addMoveResult(dest);
    }

    public void addInvokeRange(Invoke.Type type, DexMethod method, DexProto callSiteProto, int argumentCount, int firstArgumentRegister) {
        ArrayList<Value> arguments = new ArrayList<Value>(argumentCount);
        int register = firstArgumentRegister;
        if (type != Invoke.Type.STATIC) {
            arguments.add(this.readRegister(register, ValueTypeConstraint.OBJECT));
            register += ValueTypeConstraint.OBJECT.requiredRegisters();
        }
        DexString methodShorty = type == Invoke.Type.POLYMORPHIC ? callSiteProto.shorty : method.proto.shorty;
        String shorty = methodShorty.toString();
        for (int i = 1; i < methodShorty.size; ++i) {
            ValueTypeConstraint valueTypeConstraint = ValueTypeConstraint.fromTypeDescriptorChar(shorty.charAt(i));
            arguments.add(this.readRegister(register, valueTypeConstraint));
            register += valueTypeConstraint.requiredRegisters();
        }
        this.checkInvokeArgumentRegisters(register, firstArgumentRegister + argumentCount);
        assert (this.appView.options().isGeneratingDex());
        this.addInvoke(type, method, callSiteProto, arguments, false);
    }

    public void addInvokeRangeNewArray(DexType type, int argumentCount, int firstArgumentRegister) {
        int register;
        String descriptor = type.descriptor.toString();
        assert (descriptor.charAt(0) == '[');
        assert (descriptor.length() >= 2);
        ValueTypeConstraint constraint = ValueTypeConstraint.fromTypeDescriptorChar(descriptor.charAt(1));
        ArrayList<Value> arguments = new ArrayList<Value>(argumentCount / constraint.requiredRegisters());
        for (register = firstArgumentRegister; register < firstArgumentRegister + argumentCount; register += constraint.requiredRegisters()) {
            arguments.add(this.readRegister(register, constraint));
        }
        this.checkInvokeArgumentRegisters(register, firstArgumentRegister + argumentCount);
        assert (this.appView.options().isGeneratingDex());
        this.addInvoke(Invoke.Type.NEW_ARRAY, type, null, arguments, false);
    }

    public void addMoveException(int dest) {
        assert (!this.currentBlock.getPredecessors().isEmpty());
        assert (this.currentBlock.getPredecessors().stream().allMatch(b -> b.entry().isMoveException()));
        Value value = this.readRegister(dest, ValueTypeConstraint.OBJECT);
        assert (IRBuilder.verifyValueIsMoveException(value));
    }

    public void addMoveResult(int dest) {
        LinkedList<Instruction> instructions = this.currentBlock.getInstructions();
        Invoke invoke = ((Instruction)instructions.get(instructions.size() - 1)).asInvoke();
        assert (invoke.outValue() == null);
        assert (invoke.instructionTypeCanThrow());
        DexType outType = invoke.getReturnType();
        Nullability nullability = invoke.isInvokeNewArray() || invoke.isInvokeMultiNewArray() ? Nullability.definitelyNotNull() : Nullability.maybeNull();
        TypeElement typeElement = invoke.isInvokeCustom() ? invoke.evaluate(this.appView) : TypeElement.fromDexType(outType, nullability, this.appView);
        Value outValue = this.writeRegister(dest, typeElement, BasicBlock.ThrowingInfo.CAN_THROW);
        invoke.setOutValue(outValue);
    }

    public void addNeg(NumericType type, int dest, int value) {
        Value in = this.readNumericRegister(value, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Neg instruction = new Neg(type, out, in);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addNot(NumericType type, int dest, int value) {
        Instruction instruction;
        Value in = this.readNumericRegister(value, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        if (this.appView.options().canUseNotInstruction()) {
            instruction = new Not(type, out, in);
        } else {
            Value minusOne = this.readLiteral(ValueTypeConstraint.fromNumericType(type), -1L);
            instruction = new Xor(type, out, in, minusOne);
        }
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addNewArrayEmpty(int dest, int size, DexType type) {
        assert (type.isArrayType());
        Value in = this.readRegister(size, ValueTypeConstraint.INT);
        TypeElement arrayTypeLattice = TypeElement.fromDexType(type, Nullability.definitelyNotNull(), this.appView);
        Value out = this.writeRegister(dest, arrayTypeLattice, BasicBlock.ThrowingInfo.CAN_THROW);
        NewArrayEmpty instruction = new NewArrayEmpty(out, in, type);
        assert (instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addNewArrayFilledData(int arrayRef, int elementWidth, long size, short[] data2) {
        NewArrayFilledData instruction = new NewArrayFilledData(this.readRegister(arrayRef, ValueTypeConstraint.OBJECT), elementWidth, size, data2);
        assert (instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addNewInstance(int dest, DexType type) {
        TypeElement instanceType = TypeElement.fromDexType(type, Nullability.definitelyNotNull(), this.appView);
        Value out = this.writeRegister(dest, instanceType, BasicBlock.ThrowingInfo.CAN_THROW);
        NewInstance instruction = new NewInstance(type, out);
        assert (instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addNewUnboxedEnumInstance(int dest, DexType type, int ordinal) {
        TypeElement instanceType = TypeElement.fromDexType(type, Nullability.definitelyNotNull(), this.appView);
        Value out = this.writeRegister(dest, instanceType, BasicBlock.ThrowingInfo.CAN_THROW);
        NewUnboxedEnumInstance instruction = new NewUnboxedEnumInstance(type, ordinal, out);
        assert (instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addReturn(int value) {
        DexType returnType = ((DexEncodedMethod)this.method.getDefinition()).returnType();
        if (returnType.isVoidType()) {
            assert (this.prototypeChanges.hasBeenChangedToReturnVoid());
            this.addReturn();
        } else {
            ValueTypeConstraint returnTypeConstraint = this.prototypeChanges.hasRewrittenReturnInfo() ? ValueTypeConstraint.fromDexType(this.prototypeChanges.getRewrittenReturnInfo().getOldType()) : ValueTypeConstraint.fromDexType(returnType);
            Value in = this.readRegister(value, returnTypeConstraint);
            this.addReturn(new Return(in));
        }
    }

    public void addReturn() {
        this.addReturn(new Return());
    }

    public void addInitClass(int dest, DexType clazz) {
        Value out = this.writeRegister(dest, TypeElement.getInt(), BasicBlock.ThrowingInfo.CAN_THROW);
        InitClass instruction = new InitClass(out, clazz);
        assert (instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addStaticGet(int dest, DexField field) {
        Value out = this.writeRegister(dest, TypeElement.fromDexType(field.type, Nullability.maybeNull(), this.appView), BasicBlock.ThrowingInfo.CAN_THROW);
        StaticGet instruction = new StaticGet(out, field);
        assert (instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addStaticPut(int value, DexField field) {
        Value in = this.readRegister(value, ValueTypeConstraint.fromDexType(field.type));
        StaticPut instruction = new StaticPut(in, field);
        assert (instruction.instructionTypeCanThrow());
        this.add(instruction);
    }

    public void addSub(NumericType type, int dest, int left, int right) {
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Sub instruction = new Sub(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addRsubLiteral(NumericType type, int dest, int value, int constant) {
        assert (type != NumericType.DOUBLE);
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readIntLiteral(constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Sub instruction = new Sub(type, out, in2, in1);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addSwitch(int value, int[] keys2, int fallthroughOffset, int[] labelOffsets) {
        int numberOfTargets = labelOffsets.length;
        assert (keys2.length == 1 || keys2.length == numberOfTargets);
        if (numberOfTargets == 0) {
            this.addGoto(fallthroughOffset);
            return;
        }
        Value switchValue = this.readRegister(value, ValueTypeConstraint.INT);
        IntArrayList nonFallthroughKeys = new IntArrayList(numberOfTargets);
        IntArrayList nonFallthroughOffsets = new IntArrayList(numberOfTargets);
        int numberOfFallthroughs = 0;
        if (keys2.length == 1) {
            int key = keys2[0];
            for (int i = 0; i < numberOfTargets; ++i) {
                if (labelOffsets[i] != fallthroughOffset) {
                    nonFallthroughKeys.add(key);
                    nonFallthroughOffsets.add(labelOffsets[i]);
                } else {
                    ++numberOfFallthroughs;
                }
                ++key;
            }
        } else {
            assert (keys2.length == numberOfTargets);
            for (int i = 0; i < numberOfTargets; ++i) {
                if (labelOffsets[i] != fallthroughOffset) {
                    nonFallthroughKeys.add(keys2[i]);
                    nonFallthroughOffsets.add(labelOffsets[i]);
                    continue;
                }
                ++numberOfFallthroughs;
            }
        }
        ((BlockInfo)this.targets.get((int)fallthroughOffset)).block.decrementUnfilledPredecessorCount(numberOfFallthroughs);
        if (numberOfFallthroughs == numberOfTargets) {
            assert (nonFallthroughKeys.size() == 0);
            this.addGoto(fallthroughOffset);
            return;
        }
        keys2 = nonFallthroughKeys.toIntArray();
        labelOffsets = nonFallthroughOffsets.toIntArray();
        IntSwitch aSwitch = this.createSwitch(switchValue, keys2, fallthroughOffset, labelOffsets);
        this.closeCurrentBlock(aSwitch);
    }

    public void addThrow(int value) {
        Value in = this.readRegister(value, ValueTypeConstraint.OBJECT);
        this.addInstruction(new Throw(in));
        this.closeCurrentBlockGuaranteedNotToNeedEdgeSplitting();
    }

    public void addOr(NumericType type, int dest, int left, int right) {
        assert (this.isIntegerType(type));
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Or instruction = new Or(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addOrLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readIntLiteral(constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Or instruction = new Or(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addShl(NumericType type, int dest, int left, int right) {
        assert (this.isIntegerType(type));
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readRegister(right, ValueTypeConstraint.INT);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Shl instruction = new Shl(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addShlLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readIntLiteral(constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Shl instruction = new Shl(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addShr(NumericType type, int dest, int left, int right) {
        assert (this.isIntegerType(type));
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readRegister(right, ValueTypeConstraint.INT);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Shr instruction = new Shr(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addShrLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readIntLiteral(constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Shr instruction = new Shr(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addUshr(NumericType type, int dest, int left, int right) {
        assert (this.isIntegerType(type));
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readRegister(right, ValueTypeConstraint.INT);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Ushr instruction = new Ushr(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addUshrLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readIntLiteral(constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Ushr instruction = new Ushr(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addXor(NumericType type, int dest, int left, int right) {
        assert (this.isIntegerType(type));
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Instruction instruction = this.appView.options().canUseNotInstruction() && in2.isConstNumber() && in2.getConstInstruction().asConstNumber().isIntegerNegativeOne(type) ? new Not(type, out, in1) : new Xor(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addXorLiteral(NumericType type, int dest, int value, int constant) {
        Instruction instruction;
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        if (this.appView.options().canUseNotInstruction() && constant == -1) {
            Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
            instruction = new Not(type, out, in1);
        } else {
            Value in2 = this.readIntLiteral(constant);
            Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
            instruction = new Xor(type, out, in1, in2);
        }
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addConversion(NumericType to, NumericType from, int dest, int source) {
        Value in = this.readNumericRegister(source, from);
        Value out = this.writeNumericRegister(dest, to, BasicBlock.ThrowingInfo.NO_THROW);
        NumberConversion instruction = new NumberConversion(from, to, out, in);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public Value readRegister(int register, ValueTypeConstraint constraint) {
        DebugLocalInfo local = this.getIncomingLocal(register);
        Value value = this.readRegister(register, constraint, this.currentBlock, BasicBlock.EdgeType.NON_EDGE, Phi.RegisterReadType.NORMAL);
        if (local != null && value.getLocalInfo() != local && !value.isUninitializedLocal()) {
            throw new InvalidDebugInfoException("Attempt to read local " + local + " but no local information was associated with the value being read.");
        }
        assert (!value.hasLocalInfo() || value.getDebugLocalEnds() != null || this.source.verifyLocalInScope(value.getLocalInfo()));
        this.constrainType(value, constraint);
        value.markNonDebugLocalRead();
        return value;
    }

    public Value readRegister(int register, ValueTypeConstraint constraint, BasicBlock block, BasicBlock.EdgeType readingEdge, Phi.RegisterReadType readType) {
        this.checkRegister(register);
        Value value = block.readCurrentDefinition(register, readingEdge);
        return value != null ? value : this.readRegisterRecursive(register, block, readingEdge, constraint, readType);
    }

    public Value writeRegister(int register, TypeElement typeLattice, BasicBlock.ThrowingInfo throwing) {
        DebugLocalInfo incomingLocal = this.getIncomingLocal(register);
        DebugLocalInfo outgoingLocal = this.getOutgoingLocal(register);
        this.previousLocalValue = incomingLocal == null || incomingLocal != outgoingLocal ? null : this.readRegisterForDebugLocal(register, incomingLocal);
        return this.writeRegister(register, typeLattice, throwing, outgoingLocal);
    }

    public Value writeNumericRegister(int register, NumericType type, BasicBlock.ThrowingInfo throwing) {
        return this.writeRegister(register, PrimitiveTypeElement.fromNumericType(type), throwing);
    }

    BlockInfo ensureBlockWithoutEnqueuing(int offset) {
        assert (offset != -1);
        BlockInfo info = (BlockInfo)this.targets.get(offset);
        if (info == null) {
            if (offset >= 0 && this.isOffsetProcessed(offset)) {
                int blockStartOffset = this.getBlockStartOffset(offset);
                BlockInfo existing = (BlockInfo)this.targets.get(blockStartOffset);
                info = existing.split(blockStartOffset, offset, this.targets);
            } else {
                info = new BlockInfo();
            }
            this.targets.put(offset, info);
            this.offsets.put(info.block, offset);
        }
        return info;
    }

    public void ensureNormalSuccessorBlock(int sourceOffset, int targetOffset) {
        this.ensureSuccessorBlock(sourceOffset, targetOffset, true);
    }

    void ensureExceptionalSuccessorBlock(int sourceOffset, int targetOffset) {
        this.ensureSuccessorBlock(sourceOffset, targetOffset, false);
    }

    public void joinPredecessorsWithIdenticalPhis() {
        ArrayList<BasicBlock> blocksToAdd = new ArrayList<BasicBlock>();
        for (BasicBlock block : this.blocks) {
            if (block.hasIncompletePhis()) {
                throw new CompilationError("Undefined value encountered during compilation. This is typically caused by invalid dex input that uses a register that is not defined on all control-flow paths leading to the use.");
            }
            if (block.entry() instanceof MoveException) continue;
            ArrayList<Integer> operandsToRemove = new ArrayList<Integer>();
            HashMap<ValueList, Integer> values2 = new HashMap<ValueList, Integer>();
            HashMap<Integer, BasicBlock> joinBlocks = new HashMap<Integer, BasicBlock>();
            if (block.getPhis().size() > 0) {
                Phi phi = block.getPhis().get(0);
                for (int operandIndex = 0; operandIndex < phi.getOperands().size(); ++operandIndex) {
                    ValueList v = ValueList.fromPhis(block.getPhis(), operandIndex);
                    BasicBlock predecessor = block.getPredecessors().get(operandIndex);
                    if (values2.containsKey(v)) {
                        int otherPredecessorIndex = (Integer)values2.get(v);
                        BasicBlock joinBlock = (BasicBlock)joinBlocks.get(otherPredecessorIndex);
                        if (joinBlock == null) {
                            joinBlock = BasicBlock.createGotoBlock(this.basicBlockNumberGenerator.next(), block.getPosition(), this.metadata, block);
                            joinBlocks.put(otherPredecessorIndex, joinBlock);
                            blocksToAdd.add(joinBlock);
                            BasicBlock otherPredecessor = block.getPredecessors().get(otherPredecessorIndex);
                            joinBlock.getMutablePredecessors().add(otherPredecessor);
                            otherPredecessor.replaceSuccessor(block, joinBlock);
                            block.getMutablePredecessors().set(otherPredecessorIndex, joinBlock);
                        }
                        joinBlock.getMutablePredecessors().add(predecessor);
                        predecessor.replaceSuccessor(block, joinBlock);
                        operandsToRemove.add(operandIndex);
                        continue;
                    }
                    values2.put(v, operandIndex);
                }
            }
            block.removePredecessorsByIndex(operandsToRemove);
            block.removePhisByIndex(operandsToRemove);
        }
        this.blocks.addAll(blocksToAdd);
    }

    boolean isIntegerType(NumericType type) {
        return type != NumericType.FLOAT && type != NumericType.DOUBLE;
    }

    boolean isNonLongIntegerType(NumericType type) {
        return type != NumericType.FLOAT && type != NumericType.DOUBLE && type != NumericType.LONG;
    }

    public NumberGenerator getValueNumberGenerator() {
        return this.valueNumberGenerator;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("blocks:\n");
        for (BasicBlock block : this.blocks) {
            builder.append(block.toDetailedString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public static class BlockInfo {
        BasicBlock block = new BasicBlock();
        IntSet normalPredecessors = new IntArraySet();
        IntSet normalSuccessors = new IntArraySet();
        IntSet exceptionalPredecessors = new IntArraySet();
        IntSet exceptionalSuccessors = new IntArraySet();

        void addNormalPredecessor(int offset) {
            this.normalPredecessors.add(offset);
        }

        void addNormalSuccessor(int offset) {
            this.normalSuccessors.add(offset);
        }

        void replaceNormalPredecessor(int existing, int replacement) {
            this.normalPredecessors.remove(existing);
            this.normalPredecessors.add(replacement);
        }

        void addExceptionalPredecessor(int offset) {
            this.exceptionalPredecessors.add(offset);
        }

        void addExceptionalSuccessor(int offset) {
            this.exceptionalSuccessors.add(offset);
        }

        int predecessorCount() {
            return this.normalPredecessors.size() + this.exceptionalPredecessors.size();
        }

        IntSet allSuccessors() {
            IntArraySet all = new IntArraySet(this.normalSuccessors.size() + this.exceptionalSuccessors.size());
            all.addAll(this.normalSuccessors);
            all.addAll(this.exceptionalSuccessors);
            return all;
        }

        boolean hasMoreThanASingleNormalExit() {
            return this.normalSuccessors.size() > 1 || this.normalSuccessors.size() == 1 && !this.exceptionalSuccessors.isEmpty();
        }

        BlockInfo split(int blockStartOffset, int fallthroughOffset, Int2ReferenceMap<BlockInfo> targets) {
            BlockInfo fallthroughInfo = new BlockInfo();
            fallthroughInfo.normalPredecessors = new IntArraySet(Collections.singleton(blockStartOffset));
            fallthroughInfo.block.incrementUnfilledPredecessorCount();
            IntIterator normalSuccessorIterator = this.normalSuccessors.iterator();
            while (normalSuccessorIterator.hasNext()) {
                BlockInfo normalSuccessor = (BlockInfo)targets.get(normalSuccessorIterator.nextInt());
                normalSuccessor.replaceNormalPredecessor(blockStartOffset, fallthroughOffset);
            }
            fallthroughInfo.normalSuccessors = this.normalSuccessors;
            this.normalSuccessors = new IntArraySet(Collections.singleton(fallthroughOffset));
            IntIterator exceptionalSuccessorIterator = fallthroughInfo.exceptionalSuccessors.iterator();
            while (exceptionalSuccessorIterator.hasNext()) {
                BlockInfo exceptionalSuccessor = (BlockInfo)targets.get(exceptionalSuccessorIterator.nextInt());
                exceptionalSuccessor.addExceptionalPredecessor(fallthroughOffset);
            }
            fallthroughInfo.exceptionalSuccessors = new IntArraySet(this.exceptionalSuccessors);
            return fallthroughInfo;
        }

        public String toString() {
            int offset;
            StringBuilder stringBuilder = new StringBuilder().append("block ").append(this.block.getNumberAsString()).append(" predecessors: ");
            String sep = "";
            IntIterator intIterator = this.normalPredecessors.iterator();
            while (intIterator.hasNext()) {
                offset = (Integer)intIterator.next();
                stringBuilder.append(sep).append(offset);
                sep = ", ";
            }
            intIterator = this.exceptionalPredecessors.iterator();
            while (intIterator.hasNext()) {
                offset = (Integer)intIterator.next();
                stringBuilder.append(sep).append('*').append(offset);
                sep = ", ";
            }
            stringBuilder.append(" successors: ");
            sep = "";
            intIterator = this.normalSuccessors.iterator();
            while (intIterator.hasNext()) {
                offset = (Integer)intIterator.next();
                stringBuilder.append(sep).append(offset);
                sep = ", ";
            }
            intIterator = this.exceptionalSuccessors.iterator();
            while (intIterator.hasNext()) {
                offset = (Integer)intIterator.next();
                stringBuilder.append(sep).append('*').append(offset);
                sep = ", ";
            }
            return stringBuilder.toString();
        }
    }

    private static class ValueList {
        private final List<Value> values = new ArrayList<Value>();

        private ValueList() {
        }

        public static ValueList fromPhis(List<Phi> phis, int index) {
            ValueList result = new ValueList();
            for (Phi phi : phis) {
                result.values.add(phi.getOperand(index));
            }
            return result;
        }

        public int hashCode() {
            return this.values.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ValueList)) {
                return false;
            }
            ValueList o = (ValueList)other;
            if (o.values.size() != this.values.size()) {
                return false;
            }
            for (int i = 0; i < this.values.size(); ++i) {
                if (this.values.get(i) == o.values.get(i)) continue;
                return false;
            }
            return true;
        }
    }

    private static class SplitBlockWorklistItem
    extends WorklistItem {
        private final int sourceOffset;
        private final int targetOffset;
        private final Position position;

        public SplitBlockWorklistItem(int firstInstructionIndex, BasicBlock block, Position position, int sourceOffset, int targetOffset) {
            super(block, firstInstructionIndex);
            this.position = position;
            this.sourceOffset = sourceOffset;
            this.targetOffset = targetOffset;
        }

        static /* synthetic */ int access$200(SplitBlockWorklistItem x0) {
            return x0.sourceOffset;
        }

        static /* synthetic */ int access$300(SplitBlockWorklistItem x0) {
            return x0.targetOffset;
        }

        static /* synthetic */ Position access$500(SplitBlockWorklistItem x0) {
            return x0.position;
        }
    }

    private static class MoveExceptionWorklistItem
    extends WorklistItem {
        private final DexType guard;
        private final int sourceOffset;
        private final int targetOffset;

        private MoveExceptionWorklistItem(BasicBlock block, DexType guard, int sourceOffset, int targetOffset) {
            super(block, -1);
            this.guard = guard;
            this.sourceOffset = sourceOffset;
            this.targetOffset = targetOffset;
        }
    }

    private static class WorklistItem {
        private final BasicBlock block;
        private final int firstInstructionIndex;

        private WorklistItem(BasicBlock block, int firstInstructionIndex) {
            assert (block != null);
            this.block = block;
            this.firstInstructionIndex = firstInstructionIndex;
        }
    }
}

