/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.com.google.common.base.Suppliers;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.graph.bytecodemetadata.BytecodeMetadataProvider;
import com.android.tools.r8.ir.analysis.TypeChecker;
import com.android.tools.r8.ir.analysis.VerifyTypesHelper;
import com.android.tools.r8.ir.analysis.constant.SparseConditionalConstantPropagation;
import com.android.tools.r8.ir.analysis.fieldaccess.FieldAccessAnalysis;
import com.android.tools.r8.ir.analysis.fieldaccess.TrivialFieldAccessReprocessor;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.InstanceFieldValueAnalysis;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.StaticFieldValueAnalysis;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.StaticFieldValues;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.conversion.ClassConverter;
import com.android.tools.r8.ir.conversion.ClassConverterResult;
import com.android.tools.r8.ir.conversion.D8MethodProcessor;
import com.android.tools.r8.ir.conversion.IRToCfFinalizer;
import com.android.tools.r8.ir.conversion.IRToDexFinalizer;
import com.android.tools.r8.ir.conversion.LensCodeRewriter;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.conversion.OneTimeMethodProcessor;
import com.android.tools.r8.ir.conversion.PostMethodProcessor;
import com.android.tools.r8.ir.conversion.PrimaryMethodProcessor;
import com.android.tools.r8.ir.conversion.StringSwitchRemover;
import com.android.tools.r8.ir.desugar.CfClassSynthesizerDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfClassSynthesizerDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.CfPostProcessingDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfPostProcessingDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.CovariantReturnTypeAnnotationTransformer;
import com.android.tools.r8.ir.desugar.ProgramAdditions;
import com.android.tools.r8.ir.desugar.desugaredlibrary.apiconversion.DesugaredLibraryAPIConverter;
import com.android.tools.r8.ir.desugar.itf.EmulatedInterfaceApplicationRewriter;
import com.android.tools.r8.ir.desugar.itf.InterfaceMethodProcessorFacade;
import com.android.tools.r8.ir.desugar.itf.InterfaceMethodRewriter;
import com.android.tools.r8.ir.desugar.itf.InterfaceProcessor;
import com.android.tools.r8.ir.desugar.lambda.D8LambdaDesugaring;
import com.android.tools.r8.ir.desugar.lambda.LambdaDeserializationMethodRemover;
import com.android.tools.r8.ir.desugar.nest.D8NestBasedAccessDesugaring;
import com.android.tools.r8.ir.optimize.AssertionsRewriter;
import com.android.tools.r8.ir.optimize.AssumeInserter;
import com.android.tools.r8.ir.optimize.ClassInitializerDefaultsOptimization;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.ir.optimize.ConstantCanonicalizer;
import com.android.tools.r8.ir.optimize.DeadCodeRemover;
import com.android.tools.r8.ir.optimize.Devirtualizer;
import com.android.tools.r8.ir.optimize.DynamicTypeOptimization;
import com.android.tools.r8.ir.optimize.IdempotentFunctionCallCanonicalizer;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.MemberValuePropagation;
import com.android.tools.r8.ir.optimize.NaturalIntLoopRemover;
import com.android.tools.r8.ir.optimize.RedundantFieldLoadAndStoreElimination;
import com.android.tools.r8.ir.optimize.ReflectionOptimizer;
import com.android.tools.r8.ir.optimize.ServiceLoaderRewriter;
import com.android.tools.r8.ir.optimize.classinliner.ClassInliner;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxer;
import com.android.tools.r8.ir.optimize.enums.EnumValueOptimizer;
import com.android.tools.r8.ir.optimize.info.CallSiteOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.MethodOptimizationInfoCollector;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackDelayed;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackIgnore;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackSimple;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfoCollection;
import com.android.tools.r8.ir.optimize.outliner.Outliner;
import com.android.tools.r8.ir.optimize.string.StringBuilderOptimizer;
import com.android.tools.r8.ir.optimize.string.StringOptimizer;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.naming.IdentifierNameStringMarker;
import com.android.tools.r8.optimize.argumentpropagation.ArgumentPropagator;
import com.android.tools.r8.optimize.argumentpropagation.ArgumentPropagatorIROptimizer;
import com.android.tools.r8.optimize.interfaces.analysis.OpenClosedInterfacesAnalysis;
import com.android.tools.r8.optimize.interfaces.analysis.OpenClosedInterfacesAnalysisImpl;
import com.android.tools.r8.position.MethodPosition;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.KeepMethodInfo;
import com.android.tools.r8.shaking.LibraryMethodOverrideAnalysis;
import com.android.tools.r8.utils.Action;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class IRConverter {
    public final AppView<?> appView;
    private final Timing timing;
    public final Outliner outliner;
    private final ClassInitializerDefaultsOptimization classInitializerDefaultsOptimization;
    private final CfInstructionDesugaringCollection instructionDesugaring;
    private final FieldAccessAnalysis fieldAccessAnalysis;
    private final LibraryMethodOverrideAnalysis libraryMethodOverrideAnalysis;
    private final StringOptimizer stringOptimizer;
    private final StringBuilderOptimizer stringBuilderOptimizer;
    private final IdempotentFunctionCallCanonicalizer idempotentFunctionCallCanonicalizer;
    private final ClassInliner classInliner;
    private final InternalOptions options;
    private final CfgPrinter printer;
    public final CodeRewriter codeRewriter;
    private final NaturalIntLoopRemover naturalIntLoopRemover = new NaturalIntLoopRemover();
    private final ConstantCanonicalizer constantCanonicalizer;
    public final MemberValuePropagation memberValuePropagation;
    private final LensCodeRewriter lensCodeRewriter;
    private final Inliner inliner;
    private final IdentifierNameStringMarker identifierNameStringMarker;
    private final Devirtualizer devirtualizer;
    private final CovariantReturnTypeAnnotationTransformer covariantReturnTypeAnnotationTransformer;
    private final StringSwitchRemover stringSwitchRemover;
    private final TypeChecker typeChecker;
    private final ServiceLoaderRewriter serviceLoaderRewriter;
    private final EnumValueOptimizer enumValueOptimizer;
    private final EnumUnboxer enumUnboxer;
    private final OpenClosedInterfacesAnalysis openClosedInterfacesAnalysis;
    public final AssumeInserter assumeInserter;
    private final DynamicTypeOptimization dynamicTypeOptimization;
    final AssertionsRewriter assertionsRewriter;
    public final DeadCodeRemover deadCodeRemover;
    private final MethodOptimizationInfoCollector methodOptimizationInfoCollector;
    private final OptimizationFeedbackDelayed delayedOptimizationFeedback = new OptimizationFeedbackDelayed();
    private final OptimizationFeedback simpleOptimizationFeedback = OptimizationFeedbackSimple.getInstance();
    private DexString highestSortingString;
    private List<Action> onWaveDoneActions = null;
    private final Set<DexMethod> prunedMethodsInWave = Sets.newIdentityHashSet();
    private final List<DexString> neverMergePrefixes;
    AtomicBoolean seenNotNeverMergePrefix = new AtomicBoolean();
    AtomicBoolean seenNeverMergePrefix = new AtomicBoolean();

    public IRConverter(AppView<?> appView, Timing timing, CfgPrinter printer) {
        assert (appView.options() != null);
        assert (appView.options().programConsumer != null);
        assert (timing != null);
        this.timing = timing;
        this.appView = appView;
        this.options = appView.options();
        this.printer = printer;
        this.codeRewriter = new CodeRewriter(appView);
        this.constantCanonicalizer = new ConstantCanonicalizer(this.codeRewriter);
        this.classInitializerDefaultsOptimization = new ClassInitializerDefaultsOptimization(appView, this);
        this.stringOptimizer = new StringOptimizer(appView);
        this.stringBuilderOptimizer = new StringBuilderOptimizer(appView);
        this.deadCodeRemover = new DeadCodeRemover(appView, this.codeRewriter);
        this.assertionsRewriter = new AssertionsRewriter(appView);
        this.idempotentFunctionCallCanonicalizer = new IdempotentFunctionCallCanonicalizer(appView);
        this.neverMergePrefixes = this.options.neverMergePrefixes.stream().map(prefix -> "L" + DescriptorUtils.getPackageBinaryNameFromJavaType(prefix)).map(this.options.itemFactory::createString).collect(Collectors.toList());
        if (this.options.isDesugaredLibraryCompilation()) {
            assert (this.options.desugarState.isOn());
            this.instructionDesugaring = CfInstructionDesugaringCollection.create(appView, appView.apiLevelCompute());
            this.covariantReturnTypeAnnotationTransformer = null;
            this.dynamicTypeOptimization = null;
            this.classInliner = null;
            this.fieldAccessAnalysis = null;
            this.libraryMethodOverrideAnalysis = null;
            this.inliner = null;
            this.outliner = Outliner.empty();
            this.memberValuePropagation = null;
            this.lensCodeRewriter = null;
            this.identifierNameStringMarker = null;
            this.devirtualizer = null;
            this.typeChecker = null;
            this.stringSwitchRemover = null;
            this.serviceLoaderRewriter = null;
            this.methodOptimizationInfoCollector = null;
            this.enumValueOptimizer = null;
            this.enumUnboxer = EnumUnboxer.empty();
            this.openClosedInterfacesAnalysis = OpenClosedInterfacesAnalysis.empty();
            this.assumeInserter = null;
            return;
        }
        this.instructionDesugaring = appView.enableWholeProgramOptimizations() ? CfInstructionDesugaringCollection.empty() : CfInstructionDesugaringCollection.create(appView, appView.apiLevelCompute());
        CovariantReturnTypeAnnotationTransformer covariantReturnTypeAnnotationTransformer = this.covariantReturnTypeAnnotationTransformer = this.options.processCovariantReturnTypeAnnotations ? new CovariantReturnTypeAnnotationTransformer(this, appView.dexItemFactory()) : null;
        if (appView.enableWholeProgramOptimizations()) {
            assert (((AppInfo)appView.appInfo()).hasLiveness());
            assert (appView.rootSet() != null);
            AppView<AppInfoWithLiveness> appViewWithLiveness = appView.withLiveness();
            this.assumeInserter = new AssumeInserter(appViewWithLiveness);
            this.classInliner = this.options.enableClassInlining && this.options.inlinerOptions().enableInlining ? new ClassInliner() : null;
            this.dynamicTypeOptimization = new DynamicTypeOptimization(appViewWithLiveness);
            this.fieldAccessAnalysis = new FieldAccessAnalysis(appViewWithLiveness);
            this.libraryMethodOverrideAnalysis = this.options.enableTreeShakingOfLibraryMethodOverrides ? new LibraryMethodOverrideAnalysis(appViewWithLiveness) : null;
            this.enumUnboxer = EnumUnboxer.create(appViewWithLiveness);
            this.lensCodeRewriter = new LensCodeRewriter(appViewWithLiveness, this.enumUnboxer);
            this.inliner = new Inliner(appViewWithLiveness, this, this.lensCodeRewriter);
            this.outliner = Outliner.create(appViewWithLiveness);
            this.memberValuePropagation = new MemberValuePropagation(appViewWithLiveness);
            this.methodOptimizationInfoCollector = new MethodOptimizationInfoCollector(appViewWithLiveness, this);
            this.openClosedInterfacesAnalysis = new OpenClosedInterfacesAnalysisImpl(appViewWithLiveness);
            this.identifierNameStringMarker = this.options.isMinifying() ? new IdentifierNameStringMarker(appViewWithLiveness) : null;
            this.devirtualizer = this.options.enableDevirtualization ? new Devirtualizer(appViewWithLiveness) : null;
            this.typeChecker = new TypeChecker(appViewWithLiveness, VerifyTypesHelper.create(appView));
            this.serviceLoaderRewriter = this.options.enableServiceLoaderRewriting ? new ServiceLoaderRewriter(appViewWithLiveness, appView.apiLevelCompute()) : null;
            this.enumValueOptimizer = this.options.enableEnumValueOptimization ? new EnumValueOptimizer(appViewWithLiveness) : null;
        } else {
            this.assumeInserter = null;
            this.classInliner = null;
            this.dynamicTypeOptimization = null;
            this.fieldAccessAnalysis = null;
            this.libraryMethodOverrideAnalysis = null;
            this.inliner = null;
            this.outliner = Outliner.empty();
            this.memberValuePropagation = null;
            this.lensCodeRewriter = null;
            this.identifierNameStringMarker = null;
            this.devirtualizer = null;
            this.typeChecker = null;
            this.serviceLoaderRewriter = null;
            this.methodOptimizationInfoCollector = null;
            this.enumValueOptimizer = null;
            this.enumUnboxer = EnumUnboxer.empty();
            this.openClosedInterfacesAnalysis = OpenClosedInterfacesAnalysis.empty();
        }
        this.stringSwitchRemover = this.options.isStringSwitchConversionEnabled() ? new StringSwitchRemover(appView, this.identifierNameStringMarker) : null;
    }

    public IRConverter(AppView<?> appView, Timing timing) {
        this(appView, timing, null);
    }

    public IRConverter(AppInfo appInfo, Timing timing, CfgPrinter printer) {
        this(AppView.createForD8(appInfo), timing, printer);
    }

    private void synthesizeBridgesForNestBasedAccessesOnClasspath(D8MethodProcessor methodProcessor, ExecutorService executorService) throws ExecutionException {
        this.instructionDesugaring.withD8NestBasedAccessDesugaring(d8NestBasedAccessDesugaring -> d8NestBasedAccessDesugaring.synthesizeBridgesForNestBasedAccessesOnClasspath(methodProcessor, executorService));
        methodProcessor.awaitMethodProcessing();
    }

    private void reportNestDesugarDependencies() {
        this.instructionDesugaring.withD8NestBasedAccessDesugaring(D8NestBasedAccessDesugaring::reportDesugarDependencies);
    }

    private void clearNestAttributes() {
        this.instructionDesugaring.withD8NestBasedAccessDesugaring(D8NestBasedAccessDesugaring::clearNestAttributes);
    }

    private void processCovariantReturnTypeAnnotations(DexApplication.Builder<?> builder) {
        if (this.covariantReturnTypeAnnotationTransformer != null) {
            this.covariantReturnTypeAnnotationTransformer.process(builder);
        }
    }

    private DexApplication commitPendingSyntheticItemsD8(AppView<AppInfo> appView, DexApplication application) {
        if (appView.getSyntheticItems().hasPendingSyntheticClasses()) {
            appView.setAppInfo(new AppInfo(appView.appInfo().getSyntheticItems().commit(application), appView.appInfo().getMainDexInfo()));
            application = appView.appInfo().app();
        }
        return application;
    }

    private static void commitPendingSyntheticItemsR8(AppView<AppInfoWithLiveness> appView) {
        if (appView.getSyntheticItems().hasPendingSyntheticClasses()) {
            appView.setAppInfo(appView.appInfo().rebuildWithLiveness(appView.getSyntheticItems().commit(appView.appInfo().app())));
        }
    }

    private void postProcessingDesugaringForD8(D8MethodProcessor methodProcessor, InterfaceProcessor interfaceProcessor, ExecutorService executorService) throws ExecutionException {
        CfPostProcessingDesugaringEventConsumer.D8CfPostProcessingDesugaringEventConsumer eventConsumer = CfPostProcessingDesugaringEventConsumer.createForD8(methodProcessor, this.instructionDesugaring);
        methodProcessor.newWave();
        InterfaceMethodProcessorFacade interfaceDesugaring = this.instructionDesugaring.getInterfaceMethodPostProcessingDesugaringD8(InterfaceMethodRewriter.Flavor.ExcludeDexResources, interfaceProcessor);
        CfPostProcessingDesugaringCollection.create(this.appView, interfaceDesugaring).postProcessingDesugaring(((AppInfo)this.appView.appInfo()).classes(), m3 -> true, eventConsumer, executorService);
        methodProcessor.awaitMethodProcessing();
        eventConsumer.finalizeDesugaring();
    }

    private void convertClasses(D8MethodProcessor methodProcessor, InterfaceProcessor interfaceProcessor, ExecutorService executorService) throws ExecutionException {
        ClassConverterResult classConverterResult = ClassConverter.create(this.appView, this, methodProcessor, interfaceProcessor).convertClasses(executorService);
        this.synthesizeBridgesForNestBasedAccessesOnClasspath(methodProcessor, executorService);
        methodProcessor.verifyNoPendingMethodProcessing();
        D8LambdaDesugaring.rewriteEnclosingLambdaMethodAttributes(this.appView, classConverterResult.getForcefullyMovedLambdaMethods());
        this.instructionDesugaring.withDesugaredLibraryAPIConverter(DesugaredLibraryAPIConverter::generateTrackingWarnings);
    }

    private boolean needsIRConversion(ProgramMethod method) {
        if (((DexEncodedMethod)method.getDefinition()).getCode().isThrowNullCode()) {
            return false;
        }
        if (this.appView.enableWholeProgramOptimizations()) {
            return true;
        }
        if (this.options.testing.forceIRForCfToCfDesugar) {
            return true;
        }
        return !this.options.cfToCfDesugar;
    }

    private void checkPrefixMerging(ProgramMethod method) {
        if (!this.appView.options().enableNeverMergePrefixes) {
            return;
        }
        for (DexString neverMergePrefix : this.neverMergePrefixes) {
            if (method.getHolderType().descriptor.startsWith(neverMergePrefix)) {
                this.seenNeverMergePrefix.getAndSet(true);
            } else {
                this.seenNotNeverMergePrefix.getAndSet(true);
            }
            if (!this.seenNeverMergePrefix.get() || !this.seenNotNeverMergePrefix.get()) continue;
            StringBuilder message = new StringBuilder();
            message.append("Merging dex file containing classes with prefix").append(this.neverMergePrefixes.size() > 1 ? "es " : " ");
            for (int i = 0; i < this.neverMergePrefixes.size(); ++i) {
                message.append("'").append(this.neverMergePrefixes.get(0).toString().substring(1).replace('/', '.')).append("'").append(i < this.neverMergePrefixes.size() - 1 ? ", " : "");
            }
            message.append(" with classes with any other prefixes is not allowed: ");
            boolean first = true;
            int limit = 11;
            for (DexProgramClass clazz : ((AppInfo)this.appView.appInfo()).classesWithDeterministicOrder()) {
                if (clazz.type.descriptor.startsWith(neverMergePrefix)) continue;
                if (limit-- < 0) {
                    message.append("..");
                    break;
                }
                if (first) {
                    first = false;
                } else {
                    message.append(", ");
                }
                message.append(clazz.type);
            }
            message.append(".");
            throw new CompilationError(message.toString());
        }
    }

    private void workaroundAbstractMethodOnNonAbstractClassVerificationBug(ExecutorService executorService) throws ExecutionException {
        if (!this.options.canHaveDalvikAbstractMethodOnNonAbstractClassVerificationBug()) {
            return;
        }
        assert (this.delayedOptimizationFeedback.noUpdatesLeft());
        ThreadUtils.processItems(((AppInfo)this.appView.appInfo()).classes(), clazz -> {
            if (!clazz.isAbstract()) {
                clazz.forEachProgramMethodMatching(DexEncodedMethod::isAbstract, method -> method.convertToThrowNullMethod(this.appView));
            }
        }, executorService);
    }

    private void waveStart(ProgramMethodSet wave) {
        this.onWaveDoneActions = Collections.synchronizedList(new ArrayList());
    }

    private void waveDone(ProgramMethodSet wave, ExecutorService executorService) throws ExecutionException {
        this.delayedOptimizationFeedback.refineAppInfoWithLiveness(((AppInfo)this.appView.appInfo()).withLiveness());
        this.delayedOptimizationFeedback.updateVisibleOptimizationInfo();
        this.fieldAccessAnalysis.fieldAssignmentTracker().waveDone(wave, this.delayedOptimizationFeedback);
        this.appView.withArgumentPropagator(ArgumentPropagator::publishDelayedReprocessingCriteria);
        if (this.appView.options().protoShrinking().enableRemoveProtoEnumSwitchMap()) {
            this.appView.protoShrinker().protoEnumSwitchMapRemover.updateVisibleStaticFieldValues();
        }
        this.enumUnboxer.updateEnumUnboxingCandidatesInfo();
        assert (this.delayedOptimizationFeedback.noUpdatesLeft());
        this.onWaveDoneActions.forEach(Action::execute);
        this.onWaveDoneActions = null;
        if (!this.prunedMethodsInWave.isEmpty()) {
            this.appView.pruneItems(PrunedItems.builder().setRemovedMethods(this.prunedMethodsInWave).setPrunedApp(((AppInfo)this.appView.appInfo()).app()).build(), executorService);
            this.prunedMethodsInWave.clear();
        }
    }

    private void lastWaveDone(PostMethodProcessor.Builder postMethodProcessorBuilder, ExecutorService executorService) throws ExecutionException {
        if (this.inliner != null) {
            this.inliner.onLastWaveDone(postMethodProcessorBuilder, executorService, this.timing);
        }
        this.openClosedInterfacesAnalysis.onPrimaryOptimizationPassComplete();
    }

    private void processSynthesizedServiceLoaderMethods(List<ProgramMethod> serviceLoadMethods, ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(serviceLoadMethods, this::forEachSynthesizedServiceLoaderMethod, executorService);
    }

    private void forEachSynthesizedServiceLoaderMethod(ProgramMethod method) {
        IRCode code = method.buildIR(this.appView);
        assert (code != null);
        this.codeRewriter.rewriteMoveResult(code);
        this.removeDeadCodeAndFinalizeIR(code, OptimizationFeedbackIgnore.getInstance(), Timing.empty());
    }

    private void clearDexMethodCompilationState() {
        ((AppInfo)this.appView.appInfo()).classes().forEach(this::clearDexMethodCompilationState);
    }

    private void clearDexMethodCompilationState(DexProgramClass clazz) {
        clazz.forEachMethod(DexEncodedMethod::markNotProcessed);
    }

    private String logCode(InternalOptions options, DexEncodedMethod method) {
        return options.useSmaliSyntax ? method.toSmaliString(null) : method.codeToString();
    }

    private static void invertConditionalsForTesting(IRCode code) {
        for (BasicBlock block : code.blocks) {
            if (!block.exit().isIf()) continue;
            block.exit().asIf().invert();
        }
    }

    private Timing rewriteNonDesugaredCodeInternal(ProgramMethod method, CfInstructionDesugaringEventConsumer desugaringEventConsumer, OptimizationFeedback feedback, MethodProcessor methodProcessor, CompilationContext.MethodProcessingContext methodProcessingContext) {
        boolean didDesugar = this.desugar(method, desugaringEventConsumer, methodProcessingContext);
        if (Log.ENABLED && didDesugar) {
            Log.debug(this.getClass(), "Desugared code for %s:\n%s", method.toSourceString(), this.logCode(this.options, (DexEncodedMethod)method.getDefinition()));
        }
        return this.rewriteDesugaredCodeInternal(method, feedback, methodProcessor, methodProcessingContext);
    }

    private Timing rewriteDesugaredCodeInternal(ProgramMethod method, OptimizationFeedback feedback, MethodProcessor methodProcessor, CompilationContext.MethodProcessingContext methodProcessingContext) {
        if (this.options.verbose) {
            this.options.reporter.info(new StringDiagnostic("Processing: " + method.toSourceString()));
        }
        if (Log.ENABLED) {
            Log.debug(this.getClass(), "Original code for %s:\n%s", method.toSourceString(), this.logCode(this.options, (DexEncodedMethod)method.getDefinition()));
        }
        if (this.options.testing.hookInIrConversion != null) {
            this.options.testing.hookInIrConversion.run();
        }
        if (!this.needsIRConversion(method) || this.options.skipIR) {
            feedback.markProcessed((DexEncodedMethod)method.getDefinition(), Inliner.ConstraintWithTarget.NEVER);
            return Timing.empty();
        }
        IRCode code = method.buildIR(this.appView);
        if (code == null) {
            feedback.markProcessed((DexEncodedMethod)method.getDefinition(), Inliner.ConstraintWithTarget.NEVER);
            return Timing.empty();
        }
        return this.optimize(code, feedback, methodProcessor, methodProcessingContext);
    }

    private boolean desugar(ProgramMethod method, CfInstructionDesugaringEventConsumer desugaringEventConsumer, CompilationContext.MethodProcessingContext methodProcessingContext) {
        if (!((DexEncodedMethod)method.getDefinition()).getCode().isCfCode()) {
            return false;
        }
        this.instructionDesugaring.scan(method, desugaringEventConsumer);
        if (this.instructionDesugaring.needsDesugaring(method)) {
            this.instructionDesugaring.desugar(method, methodProcessingContext, desugaringEventConsumer);
            return true;
        }
        return false;
    }

    private Timing optimize(IRCode code, OptimizationFeedback feedback, MethodProcessor methodProcessor, CompilationContext.MethodProcessingContext methodProcessingContext) {
        boolean isDebugMode;
        ProgramMethod context = code.context();
        DexEncodedMethod method = (DexEncodedMethod)context.getDefinition();
        DexProgramClass holder = context.getHolder();
        assert (holder != null);
        Timing timing = Timing.create(context.toSourceString(), this.options);
        if (Log.ENABLED) {
            Log.debug(this.getClass(), "Initial (SSA) flow graph for %s:\n%s", method.toSourceString(), code);
        }
        this.printC1VisualizerHeader(method);
        String previous = this.printMethod(code, "Initial IR (SSA)", null);
        if (this.options.testing.irModifier != null) {
            this.options.testing.irModifier.accept(code, this.appView);
        }
        if (this.options.canHaveArtStringNewInitBug()) {
            timing.begin("Check for new-init issue");
            CodeRewriter.ensureDirectStringNewToInit(code, this.appView.dexItemFactory());
            timing.end();
        }
        if (this.options.canHaveInvokeInterfaceToObjectMethodBug()) {
            timing.begin("JDK-8272564 fix rewrite");
            CodeRewriter.rewriteJdk8272564Fix(code, this.appView);
            timing.end();
        }
        boolean bl = isDebugMode = this.options.debug || context.getOrComputeReachabilitySensitive(this.appView);
        if (isDebugMode) {
            this.codeRewriter.simplifyDebugLocals(code);
        }
        if (this.appView.graphLens().hasCodeRewritings()) {
            assert (this.lensCodeRewriter != null);
            timing.begin("Lens rewrite");
            this.lensCodeRewriter.rewrite(code, context, methodProcessor);
            timing.end();
        }
        assert (!method.isProcessed() || !isDebugMode) : "Method already processed: " + context.toSourceString() + System.lineSeparator() + ExceptionUtils.getMainStackTrace();
        assert (!(method.isProcessed() && this.appView.enableWholeProgramOptimizations() && ((AppInfo)this.appView.appInfo()).withLiveness().isNeverReprocessMethod(context))) : "Unexpected reprocessing of method: " + context.toSourceString();
        if (this.typeChecker != null && !this.typeChecker.check(code)) {
            assert (this.appView.enableWholeProgramOptimizations());
            assert (this.options.testing.allowTypeErrors);
            StringDiagnostic warning = new StringDiagnostic("The method `" + method.toSourceString() + "` does not type check and will be assumed to be unreachable.");
            this.options.reporter.warning(warning);
            context.convertToThrowNullMethod(this.appView);
            return timing;
        }
        assert (code.verifyTypes(this.appView));
        assert (code.isConsistentSSA(this.appView));
        this.openClosedInterfacesAnalysis.analyze(context, code);
        if (this.shouldPassThrough(context)) {
            assert (this.appView.enableWholeProgramOptimizations());
            timing.begin("Collect optimization info");
            this.collectOptimizationInfo(context, code, ClassInitializerDefaultsOptimization.ClassInitializerDefaultsResult.empty(), feedback, methodProcessor, BytecodeMetadataProvider.builder(), timing);
            timing.end();
            this.markProcessed(code, feedback);
            return timing;
        }
        this.assertionsRewriter.run(method, code, timing);
        if (this.serviceLoaderRewriter != null) {
            assert (((AppInfo)this.appView.appInfo()).hasLiveness());
            timing.begin("Rewrite service loaders");
            this.serviceLoaderRewriter.rewrite(code, methodProcessingContext);
            timing.end();
        }
        if (this.identifierNameStringMarker != null) {
            timing.begin("Decouple identifier-name strings");
            this.identifierNameStringMarker.decoupleIdentifierNameStringsInMethod(code);
            timing.end();
            assert (code.isConsistentSSA(this.appView));
        }
        if (this.memberValuePropagation != null) {
            timing.begin("Propagate member values");
            this.memberValuePropagation.run(code);
            timing.end();
        }
        if (this.enumValueOptimizer != null) {
            assert (this.appView.enableWholeProgramOptimizations());
            timing.begin("Remove switch maps");
            this.enumValueOptimizer.removeSwitchMaps(code);
            timing.end();
        }
        previous = this.printMethod(code, "IR after disable assertions (SSA)", previous);
        CallSiteOptimizationInfo callSiteOptimizationInfo = context.getOptimizationInfo().getArgumentInfos();
        if (callSiteOptimizationInfo.isConcreteCallSiteOptimizationInfo() && this.appView.hasLiveness()) {
            ArgumentPropagatorIROptimizer.optimize(this.appView.withLiveness(), code, callSiteOptimizationInfo.asConcreteCallSiteOptimizationInfo());
        }
        if (this.assumeInserter != null) {
            this.assumeInserter.insertAssumeInstructions(code, timing);
        }
        previous = this.printMethod(code, "IR after inserting assume instructions (SSA)", previous);
        timing.begin("Run proto shrinking tasks");
        this.appView.withGeneratedExtensionRegistryShrinker(shrinker -> shrinker.rewriteCode(method, code));
        previous = this.printMethod(code, "IR after generated extension registry shrinking (SSA)", previous);
        this.appView.withGeneratedMessageLiteShrinker(shrinker -> shrinker.run(code));
        timing.end();
        previous = this.printMethod(code, "IR after generated message lite shrinking (SSA)", previous);
        if (!isDebugMode && this.options.inlinerOptions().enableInlining && this.inliner != null) {
            timing.begin("Inlining");
            this.inliner.performInlining(code.context(), code, feedback, methodProcessor, timing);
            timing.end();
            assert (code.verifyTypes(this.appView));
        }
        previous = this.printMethod(code, "IR after inlining (SSA)", previous);
        if (((AppInfo)this.appView.appInfo()).hasLiveness()) {
            timing.begin("Rewrite to const class");
            ReflectionOptimizer.rewriteGetClassOrForNameToConstClass(this.appView.withLiveness(), code);
            timing.end();
        }
        if (!isDebugMode) {
            if (this.options.enableNameReflectionOptimization || this.options.testing.forceNameReflectionOptimization) {
                timing.begin("Rewrite Class.getName");
                this.stringOptimizer.rewriteClassGetName(this.appView, code);
                timing.end();
            }
            timing.begin("Optimize const strings");
            this.stringOptimizer.computeTrivialOperationsOnConstString(code);
            this.stringOptimizer.removeTrivialConversions(code);
            timing.end();
            timing.begin("Optimize library methods");
            this.appView.libraryMethodOptimizer().optimize(code, feedback, methodProcessor, methodProcessingContext);
            timing.end();
            previous = this.printMethod(code, "IR after class library method optimizer (SSA)", previous);
            assert (code.isConsistentSSA(this.appView));
        }
        assert (code.verifyTypes(this.appView));
        if (this.devirtualizer != null) {
            assert (code.verifyTypes(this.appView));
            timing.begin("Devirtualize invoke interface");
            this.devirtualizer.devirtualizeInvokeInterface(code);
            timing.end();
            previous = this.printMethod(code, "IR after devirtualizer (SSA)", previous);
        }
        assert (code.verifyTypes(this.appView));
        timing.begin("Remove trivial type checks/casts");
        this.codeRewriter.removeTrivialCheckCastAndInstanceOfInstructions(code, context, methodProcessor, methodProcessingContext);
        timing.end();
        if (this.enumValueOptimizer != null) {
            assert (this.appView.enableWholeProgramOptimizations());
            timing.begin("Rewrite constant enum methods");
            this.enumValueOptimizer.rewriteConstantEnumMethodCalls(code);
            timing.end();
        }
        timing.begin("Rewrite array length");
        this.codeRewriter.rewriteKnownArrayLengthCalls(code);
        timing.end();
        timing.begin("Natural Int Loop Remover");
        this.naturalIntLoopRemover.run(this.appView, code);
        timing.end();
        timing.begin("Rewrite AssertionError");
        this.codeRewriter.rewriteAssertionErrorTwoArgumentConstructor(code, this.options);
        timing.end();
        timing.begin("Run CSE");
        this.codeRewriter.commonSubexpressionElimination(code);
        timing.end();
        timing.begin("Simplify arrays");
        this.codeRewriter.simplifyArrayConstruction(code);
        timing.end();
        timing.begin("Rewrite move result");
        this.codeRewriter.rewriteMoveResult(code);
        timing.end();
        if (this.options.enableStringConcatenationOptimization && !isDebugMode && this.options.isGeneratingDex()) {
            timing.begin("Rewrite string concat");
            this.stringBuilderOptimizer.computeTrivialStringConcatenation(code);
            timing.end();
        }
        timing.begin("Split range invokes");
        this.codeRewriter.splitRangeInvokeConstants(code);
        timing.end();
        timing.begin("Propogate sparse conditionals");
        new SparseConditionalConstantPropagation(this.appView, code).run();
        timing.end();
        timing.begin("Rewrite always throwing instructions");
        this.codeRewriter.optimizeAlwaysThrowingInstructions(code);
        timing.end();
        timing.begin("Simplify control flow");
        if (this.codeRewriter.simplifyControlFlow(code)) {
            timing.begin("Remove trivial type checks/casts");
            this.codeRewriter.removeTrivialCheckCastAndInstanceOfInstructions(code, context, methodProcessor, methodProcessingContext);
            timing.end();
        }
        timing.end();
        if (this.options.enableRedundantConstNumberOptimization) {
            timing.begin("Remove const numbers");
            this.codeRewriter.redundantConstNumberRemoval(code);
            timing.end();
        }
        if (RedundantFieldLoadAndStoreElimination.shouldRun(this.appView, code)) {
            timing.begin("Remove field loads");
            new RedundantFieldLoadAndStoreElimination(this.appView, code).run();
            timing.end();
        }
        if (this.options.testing.invertConditionals) {
            IRConverter.invertConditionalsForTesting(code);
        }
        if (!isDebugMode) {
            timing.begin("Rewrite throw NPE");
            this.codeRewriter.rewriteThrowNullPointerException(code);
            timing.end();
            previous = this.printMethod(code, "IR after rewrite throw null (SSA)", previous);
        }
        timing.begin("Optimize class initializers");
        ClassInitializerDefaultsOptimization.ClassInitializerDefaultsResult classInitializerDefaultsResult = this.classInitializerDefaultsOptimization.optimize(code, feedback);
        timing.end();
        previous = this.printMethod(code, "IR after class initializer optimisation (SSA)", previous);
        if (Log.ENABLED) {
            Log.debug(this.getClass(), "Intermediate (SSA) flow graph for %s:\n%s", method.toSourceString(), code);
        }
        this.deadCodeRemover.run(code, timing);
        assert (code.isConsistentSSA(this.appView));
        previous = this.printMethod(code, "IR after dead code removal (SSA)", previous);
        assert (code.verifyTypes(this.appView));
        previous = this.printMethod(code, "IR before class inlining (SSA)", previous);
        if (this.classInliner != null) {
            timing.begin("Inline classes");
            assert (this.options.inlinerOptions().enableInlining && this.inliner != null);
            this.classInliner.processMethodCode(this.appView.withLiveness(), this.codeRewriter, this.stringOptimizer, this.enumValueOptimizer, code.context(), code, feedback, methodProcessor, methodProcessingContext, this.inliner, Suppliers.memoize(() -> this.inliner.createDefaultOracle(code.context(), methodProcessor, -1)));
            timing.end();
            assert (code.isConsistentSSA(this.appView));
            assert (code.verifyTypes(this.appView));
        }
        previous = this.printMethod(code, "IR after class inlining (SSA)", previous);
        assert (code.verifyTypes(this.appView));
        previous = this.printMethod(code, "IR after interface method rewriting (SSA)", previous);
        this.outliner.collectOutlineSites(code, timing);
        assert (code.verifyTypes(this.appView));
        previous = this.printMethod(code, "IR after outline handler (SSA)", previous);
        if (this.stringSwitchRemover != null) {
            timing.begin("Remove string switch");
            this.stringSwitchRemover.run(code);
            timing.end();
        }
        if (!this.options.isGeneratingClassFiles()) {
            timing.begin("Canonicalize constants");
            this.constantCanonicalizer.canonicalize(this.appView, code);
            timing.end();
            previous = this.printMethod(code, "IR after constant canonicalization (SSA)", previous);
            timing.begin("Create constants for literal instructions");
            this.codeRewriter.useDedicatedConstantForLitInstruction(code);
            timing.end();
            previous = this.printMethod(code, "IR after constant literals (SSA)", previous);
            timing.begin("Shorten live ranges");
            this.codeRewriter.shortenLiveRanges(code);
            timing.end();
            previous = this.printMethod(code, "IR after shorten live ranges (SSA)", previous);
        }
        timing.begin("Canonicalize idempotent calls");
        this.idempotentFunctionCallCanonicalizer.canonicalize(code);
        timing.end();
        previous = this.printMethod(code, "IR after idempotent function call canonicalization (SSA)", previous);
        if (this.options.methodMatchesLogArgumentsFilter(method) && !method.isProcessed()) {
            this.codeRewriter.logArgumentTypes(method, code);
            assert (code.isConsistentSSA(this.appView));
        }
        previous = this.printMethod(code, "IR after argument type logging (SSA)", previous);
        assert (code.verifyTypes(this.appView));
        this.deadCodeRemover.run(code, timing);
        BytecodeMetadataProvider.Builder bytecodeMetadataProviderBuilder = BytecodeMetadataProvider.builder();
        if (this.appView.enableWholeProgramOptimizations()) {
            timing.begin("Collect optimization info");
            this.collectOptimizationInfo(context, code, classInitializerDefaultsResult, feedback, methodProcessor, bytecodeMetadataProviderBuilder, timing);
            timing.end();
        }
        if (this.assumeInserter != null) {
            timing.begin("Remove assume instructions");
            CodeRewriter.removeAssumeInstructions(this.appView, code);
            timing.end();
            assert (code.isConsistentSSA(this.appView));
            this.codeRewriter.rewriteMoveResult(code);
        }
        assert (code.verifyNoNullabilityBottomTypes());
        assert (code.verifyTypes(this.appView));
        previous = this.printMethod(code, "IR after computation of optimization info summary (SSA)", previous);
        this.printMethod(code, "Optimized IR (SSA)", previous);
        timing.begin("Finalize IR");
        this.finalizeIR(code, feedback, bytecodeMetadataProviderBuilder.build(), timing);
        timing.end();
        return timing;
    }

    private boolean shouldPassThrough(ProgramMethod method) {
        if (this.appView.isCfByteCodePassThrough((DexEncodedMethod)method.getDefinition())) {
            return true;
        }
        Code code = ((DexEncodedMethod)method.getDefinition()).getCode();
        assert (!code.isThrowNullCode());
        return code.isDefaultInstanceInitializerCode();
    }

    private void finalizeToCf(IRCode code, OptimizationFeedback feedback, BytecodeMetadataProvider bytecodeMetadataProvider, Timing timing) {
        ProgramMethod method = code.context();
        method.setCode(new IRToCfFinalizer(this.appView, this.deadCodeRemover).finalizeCode(code, bytecodeMetadataProvider, timing), this.appView);
        this.markProcessed(code, feedback);
    }

    private void finalizeToDex(IRCode code, OptimizationFeedback feedback, BytecodeMetadataProvider bytecodeMetadataProvider, Timing timing) {
        ProgramMethod method = code.context();
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        method.setCode(new IRToDexFinalizer(this.appView, this.codeRewriter, this.deadCodeRemover).finalizeCode(code, bytecodeMetadataProvider, timing), this.appView);
        this.markProcessed(code, feedback);
        this.updateHighestSortingStrings(definition);
    }

    private boolean shouldComputeInliningConstraint(ProgramMethod method) {
        if (!this.options.inlinerOptions().enableInlining || this.inliner == null) {
            return false;
        }
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        if (definition.isClassInitializer() || method.getOrComputeReachabilitySensitive(this.appView)) {
            return false;
        }
        KeepMethodInfo keepInfo = this.appView.getKeepInfo(method);
        return keepInfo.isInliningAllowed(this.options) || keepInfo.isClassInliningAllowed(this.options);
    }

    private synchronized void updateHighestSortingStrings(DexEncodedMethod method) {
        Code code = method.getCode();
        assert (code.isDexWritableCode());
        DexString highestSortingReferencedString = code.asDexWritableCode().getHighestSortingString();
        if (highestSortingReferencedString != null && (this.highestSortingString == null || highestSortingReferencedString.compareTo(this.highestSortingString) > 0)) {
            this.highestSortingString = highestSortingReferencedString;
        }
    }

    private void printC1VisualizerHeader(DexEncodedMethod method) {
        if (this.printer != null) {
            this.printer.begin("compilation");
            this.printer.print("name \"").append(method.toSourceString()).append("\"").ln();
            this.printer.print("method \"").append(method.toSourceString()).append("\"").ln();
            this.printer.print("date 0").ln();
            this.printer.end("compilation");
        }
    }

    public Inliner getInliner() {
        return this.inliner;
    }

    public void convert(AppView<AppInfo> appView, ExecutorService executor) throws ExecutionException {
        LambdaDeserializationMethodRemover.run(appView);
        this.workaroundAbstractMethodOnNonAbstractClassVerificationBug(executor);
        DexApplication application = appView.appInfo().app();
        D8MethodProcessor methodProcessor = new D8MethodProcessor(this, executor);
        InterfaceProcessor interfaceProcessor = appView.options().isInterfaceMethodDesugaringEnabled() ? new InterfaceProcessor(appView) : null;
        this.timing.begin("IR conversion");
        this.convertClasses(methodProcessor, interfaceProcessor, executor);
        this.reportNestDesugarDependencies();
        this.clearNestAttributes();
        application = this.commitPendingSyntheticItemsD8(appView, application);
        this.postProcessingDesugaringForD8(methodProcessor, interfaceProcessor, executor);
        application = this.commitPendingSyntheticItemsD8(appView, application);
        Object builder = application.builder().setHighestSortingString(this.highestSortingString);
        if (appView.options().isDesugaredLibraryCompilation()) {
            new EmulatedInterfaceApplicationRewriter(appView).rewriteApplication((DexApplication.Builder<?>)builder);
        }
        this.processCovariantReturnTypeAnnotations((DexApplication.Builder<?>)builder);
        this.timing.end();
        application = ((DexApplication.Builder)builder).build();
        appView.setAppInfo(new AppInfo(appView.appInfo().getSyntheticItems().commit(application), appView.appInfo().getMainDexInfo()));
    }

    public void classSynthesisDesugaring(ExecutorService executorService, CfClassSynthesizerDesugaringEventConsumer classSynthesizerEventConsumer) throws ExecutionException {
        CfClassSynthesizerDesugaringCollection.create(this.appView).synthesizeClasses(executorService, classSynthesizerEventConsumer);
    }

    public void prepareDesugaringForD8(ExecutorService executorService) throws ExecutionException {
        ProgramAdditions programAdditions = new ProgramAdditions();
        ThreadUtils.processItems(((AppInfo)this.appView.appInfo()).classes(), clazz -> clazz.forEachProgramMethodMatching(method -> method.hasCode() && method.getCode().isCfCode(), method -> this.instructionDesugaring.prepare((ProgramMethod)method, programAdditions)), executorService);
        programAdditions.apply(executorService);
    }

    void convertMethods(DexProgramClass clazz, CfInstructionDesugaringEventConsumer.D8CfInstructionDesugaringEventConsumer desugaringEventConsumer, D8MethodProcessor methodProcessor, InterfaceProcessor interfaceProcessor) {
        ProgramMethod classInitializer = clazz.getProgramClassInitializer();
        ArrayList<ProgramMethod> methods = ListUtils.newArrayList(clazz::forEachProgramMethod);
        if (classInitializer != null) {
            methodProcessor.processMethod(classInitializer, desugaringEventConsumer);
        }
        for (ProgramMethod method : methods) {
            if (((DexEncodedMethod)method.getDefinition()).isClassInitializer()) continue;
            DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
            methodProcessor.processMethod(method, desugaringEventConsumer);
            if (interfaceProcessor == null) continue;
            interfaceProcessor.processMethod(method, desugaringEventConsumer);
        }
        if (clazz.hasClassFileVersion()) {
            clazz.downgradeInitialClassFileVersion(this.appView.options().classFileVersionAfterDesugaring(clazz.getInitialClassFileVersion()));
        }
    }

    void convertMethod(ProgramMethod method, CfInstructionDesugaringEventConsumer desugaringEventConsumer, MethodProcessor methodProcessor, CompilationContext.MethodProcessingContext methodProcessingContext) {
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        if (definition.hasClassFileVersion()) {
            definition.downgradeClassFileVersion(this.appView.options().classFileVersionAfterDesugaring(definition.getClassFileVersion()));
        }
        if (definition.getCode() == null) {
            return;
        }
        if (!this.options.methodMatchesFilter(definition)) {
            return;
        }
        this.checkPrefixMerging(method);
        if (this.options.isGeneratingClassFiles() || !this.options.passthroughDexCode || !definition.getCode().isDexCode()) {
            this.rewriteNonDesugaredCode(method, desugaringEventConsumer, this.simpleOptimizationFeedback, methodProcessor, methodProcessingContext);
        } else assert (definition.getCode().isDexCode());
        if (!this.options.isGeneratingClassFiles()) {
            this.updateHighestSortingStrings(definition);
        }
    }

    public DexApplication optimize(AppView<AppInfoWithLiveness> appView, ExecutorService executorService) throws ExecutionException {
        assert (this.instructionDesugaring.isEmpty());
        this.workaroundAbstractMethodOnNonAbstractClassVerificationBug(executorService);
        this.printPhase("Primary optimization pass");
        GraphLens graphLensForPrimaryOptimizationPass = appView.graphLens();
        appView.withArgumentPropagator(argumentPropagator -> argumentPropagator.initializeCodeScanner(executorService, this.timing));
        this.enumUnboxer.prepareForPrimaryOptimizationPass(graphLensForPrimaryOptimizationPass);
        this.openClosedInterfacesAnalysis.prepareForPrimaryOptimizationPass();
        this.outliner.prepareForPrimaryOptimizationPass(graphLensForPrimaryOptimizationPass);
        if (this.fieldAccessAnalysis != null) {
            this.fieldAccessAnalysis.fieldAssignmentTracker().initialize();
        }
        OptimizationFeedbackDelayed feedback = this.delayedOptimizationFeedback;
        PostMethodProcessor.Builder postMethodProcessorBuilder = new PostMethodProcessor.Builder(graphLensForPrimaryOptimizationPass);
        this.timing.begin("Build primary method processor");
        PrimaryMethodProcessor primaryMethodProcessor = PrimaryMethodProcessor.create(appView.withLiveness(), executorService, this.timing);
        this.timing.end();
        this.timing.begin("IR conversion phase 1");
        assert (appView.graphLens() == graphLensForPrimaryOptimizationPass);
        primaryMethodProcessor.forEachMethod((method, methodProcessingContext) -> this.processDesugaredMethod(method, feedback, primaryMethodProcessor, methodProcessingContext), this::waveStart, this::waveDone, this.timing, executorService);
        this.lastWaveDone(postMethodProcessorBuilder, executorService);
        assert (appView.graphLens() == graphLensForPrimaryOptimizationPass);
        this.timing.end();
        appView.appInfo().withLiveness().getFieldAccessInfoCollection().destroyAccessContexts();
        assert (feedback.noUpdatesLeft());
        appView.setAllCodeProcessed();
        appView.clearCodeRewritings();
        IRConverter.commitPendingSyntheticItemsR8(appView);
        this.printPhase("Post optimization pass");
        this.enumUnboxer.rewriteWithLens();
        this.outliner.rewriteWithLens();
        appView.withArgumentPropagator(argumentPropagator -> argumentPropagator.tearDownCodeScanner(this, postMethodProcessorBuilder, executorService, this.timing));
        if (this.libraryMethodOverrideAnalysis != null) {
            this.libraryMethodOverrideAnalysis.finish();
        }
        if (!this.options.debug) {
            new TrivialFieldAccessReprocessor(appView.withLiveness(), postMethodProcessorBuilder).run(executorService, feedback, this.timing);
        }
        this.outliner.rewriteWithLens();
        this.enumUnboxer.unboxEnums(appView, this, postMethodProcessorBuilder, executorService, feedback);
        GraphLens graphLensForSecondaryOptimizationPass = appView.graphLens();
        this.outliner.rewriteWithLens();
        this.timing.begin("IR conversion phase 2");
        this.timing.begin("Build post method processor");
        PostMethodProcessor postMethodProcessor = postMethodProcessorBuilder.build(appView, executorService, this.timing);
        this.timing.end();
        if (postMethodProcessor != null) {
            assert (!this.options.debug);
            assert (appView.graphLens() == graphLensForSecondaryOptimizationPass);
            this.timing.begin("Process code");
            postMethodProcessor.forEachMethod((method, methodProcessingContext) -> this.processDesugaredMethod(method, feedback, postMethodProcessor, methodProcessingContext), feedback, executorService, this.timing);
            this.timing.end();
            this.timing.begin("Update visible optimization info");
            feedback.updateVisibleOptimizationInfo();
            this.timing.end();
            assert (appView.graphLens() == graphLensForSecondaryOptimizationPass);
        }
        this.timing.end();
        this.enumUnboxer.unsetRewriter();
        appView.clearCodeRewritings();
        IRConverter.commitPendingSyntheticItemsR8(appView);
        DexApplication.Builder<?> builder = appView.appInfo().app().builder();
        builder.setHighestSortingString(this.highestSortingString);
        if (this.serviceLoaderRewriter != null) {
            this.processSynthesizedServiceLoaderMethods(this.serviceLoaderRewriter.getServiceLoadMethods(), executorService);
        }
        feedback.updateVisibleOptimizationInfo();
        this.outliner.performOutlining(this, feedback, executorService, this.timing);
        this.clearDexMethodCompilationState();
        if (this.identifierNameStringMarker != null) {
            this.identifierNameStringMarker.decoupleIdentifierNameStringsInFields(executorService);
        }
        if (Log.ENABLED) {
            this.constantCanonicalizer.logResults();
            if (this.idempotentFunctionCallCanonicalizer != null) {
                this.idempotentFunctionCallCanonicalizer.logResults();
            }
            if (this.libraryMethodOverrideAnalysis != null) {
                this.libraryMethodOverrideAnalysis.logResults();
            }
            if (this.stringOptimizer != null) {
                this.stringOptimizer.logResult();
            }
            if (this.stringBuilderOptimizer != null) {
                this.stringBuilderOptimizer.logResults();
            }
        }
        assert (feedback.noUpdatesLeft());
        return builder.build();
    }

    public void addWaveDoneAction(Action action) {
        if (!this.appView.enableWholeProgramOptimizations()) {
            throw new Unreachable("addWaveDoneAction() should never be used in D8.");
        }
        if (!this.isInWave()) {
            throw new Unreachable("Attempt to call addWaveDoneAction() outside of wave.");
        }
        this.onWaveDoneActions.add(action);
    }

    public boolean isInWave() {
        return this.onWaveDoneActions != null;
    }

    public void replaceCodeForTesting(IRCode code) {
        ProgramMethod method = code.context();
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        assert (code.isConsistentSSA(this.appView));
        Timing timing = Timing.empty();
        this.deadCodeRemover.run(code, timing);
        method.setCode(new IRToDexFinalizer(this.appView, this.codeRewriter, this.deadCodeRemover).finalizeCode(code, BytecodeMetadataProvider.empty(), timing), this.appView);
        if (Log.ENABLED) {
            Log.debug(this.getClass(), "Resulting dex code for %s:\n%s", method.toSourceString(), this.logCode(this.options, definition));
        }
    }

    public void optimizeSynthesizedMethods(List<ProgramMethod> programMethods, ExecutorService executorService) throws ExecutionException {
        ProgramMethodSet methods = ProgramMethodSet.create(programMethods::forEach);
        this.processMethodsConcurrently(methods, executorService);
    }

    public void optimizeSynthesizedMethod(ProgramMethod synthesizedMethod) {
        if (!((DexEncodedMethod)synthesizedMethod.getDefinition()).isProcessed()) {
            OneTimeMethodProcessor methodProcessor = OneTimeMethodProcessor.create(synthesizedMethod, this.appView);
            methodProcessor.forEachWaveWithExtension((method, methodProcessingContext) -> this.processDesugaredMethod(method, this.delayedOptimizationFeedback, methodProcessor, methodProcessingContext));
        }
    }

    public void processMethodsConcurrently(ProgramMethodSet wave, ExecutorService executorService) throws ExecutionException {
        if (!wave.isEmpty()) {
            OneTimeMethodProcessor methodProcessor = OneTimeMethodProcessor.create(wave, this.appView);
            methodProcessor.forEachWaveWithExtension((method, methodProcessingContext) -> this.processDesugaredMethod(method, this.delayedOptimizationFeedback, methodProcessor, methodProcessingContext), executorService);
        }
    }

    public Timing processDesugaredMethod(ProgramMethod method, OptimizationFeedback feedback, MethodProcessor methodProcessor, CompilationContext.MethodProcessingContext methodProcessingContext) {
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        Code code = definition.getCode();
        boolean matchesMethodFilter = this.options.methodMatchesFilter(definition);
        if (code != null && matchesMethodFilter) {
            return this.rewriteDesugaredCode(method, feedback, methodProcessor, methodProcessingContext);
        }
        definition.markProcessed(Inliner.ConstraintWithTarget.NEVER);
        return Timing.empty();
    }

    Timing rewriteNonDesugaredCode(ProgramMethod method, CfInstructionDesugaringEventConsumer desugaringEventConsumer, OptimizationFeedback feedback, MethodProcessor methodProcessor, CompilationContext.MethodProcessingContext methodProcessingContext) {
        return ExceptionUtils.withOriginAndPositionAttachmentHandler(method.getOrigin(), (Position)new MethodPosition(((DexMethod)method.getReference()).asMethodReference()), () -> this.rewriteNonDesugaredCodeInternal(method, desugaringEventConsumer, feedback, methodProcessor, methodProcessingContext));
    }

    Timing rewriteDesugaredCode(ProgramMethod method, OptimizationFeedback feedback, MethodProcessor methodProcessor, CompilationContext.MethodProcessingContext methodProcessingContext) {
        return ExceptionUtils.withOriginAndPositionAttachmentHandler(method.getOrigin(), (Position)new MethodPosition(((DexMethod)method.getReference()).asMethodReference()), () -> this.rewriteDesugaredCodeInternal(method, feedback, methodProcessor, methodProcessingContext));
    }

    public void collectOptimizationInfo(ProgramMethod method, IRCode code, ClassInitializerDefaultsOptimization.ClassInitializerDefaultsResult classInitializerDefaultsResult, OptimizationFeedback feedback, MethodProcessor methodProcessor, BytecodeMetadataProvider.Builder bytecodeMetadataProviderBuilder, Timing timing) {
        this.appView.withArgumentPropagator(argumentPropagator -> argumentPropagator.scan(method, code, methodProcessor, timing));
        if (methodProcessor.isPrimaryMethodProcessor()) {
            this.enumUnboxer.analyzeEnums(code, methodProcessor);
        }
        if (this.inliner != null) {
            this.inliner.recordCallEdgesForMultiCallerInlining(method, code, methodProcessor, timing);
        }
        if (this.libraryMethodOverrideAnalysis != null) {
            timing.begin("Analyze library method overrides");
            this.libraryMethodOverrideAnalysis.analyze(code);
            timing.end();
        }
        if (this.fieldAccessAnalysis != null) {
            timing.begin("Analyze field accesses");
            this.fieldAccessAnalysis.recordFieldAccesses(code, bytecodeMetadataProviderBuilder, feedback, methodProcessor);
            if (classInitializerDefaultsResult != null) {
                this.fieldAccessAnalysis.acceptClassInitializerDefaultsResult(classInitializerDefaultsResult);
            }
            timing.end();
        }
        if (this.appView.getKeepInfo(code.context()).isPinned(this.options)) {
            return;
        }
        InstanceFieldInitializationInfoCollection instanceFieldInitializationInfos = null;
        StaticFieldValues staticFieldValues = null;
        if (((DexEncodedMethod)method.getDefinition()).isInitializer()) {
            if (((DexEncodedMethod)method.getDefinition()).isClassInitializer()) {
                staticFieldValues = StaticFieldValueAnalysis.run(this.appView, code, classInitializerDefaultsResult, feedback, timing);
            } else {
                instanceFieldInitializationInfos = InstanceFieldValueAnalysis.run(this.appView, code, classInitializerDefaultsResult, feedback, timing);
            }
        }
        this.enumUnboxer.recordEnumState(method.getHolder(), staticFieldValues);
        if (this.appView.options().protoShrinking().enableRemoveProtoEnumSwitchMap()) {
            this.appView.protoShrinker().protoEnumSwitchMapRemover.recordStaticValues(method.getHolder(), staticFieldValues);
        }
        this.methodOptimizationInfoCollector.collectMethodOptimizationInfo(method, code, feedback, this.dynamicTypeOptimization, instanceFieldInitializationInfos, methodProcessor, timing);
    }

    public void removeDeadCodeAndFinalizeIR(IRCode code, OptimizationFeedback feedback, Timing timing) {
        if (this.stringSwitchRemover != null) {
            this.stringSwitchRemover.run(code);
        }
        this.deadCodeRemover.run(code, timing);
        this.finalizeIR(code, feedback, BytecodeMetadataProvider.empty(), timing);
    }

    public void finalizeIR(IRCode code, OptimizationFeedback feedback, BytecodeMetadataProvider bytecodeMetadataProvider, Timing timing) {
        if (this.options.isGeneratingClassFiles()) {
            this.finalizeToCf(code, feedback, bytecodeMetadataProvider, timing);
        } else {
            assert (this.options.isGeneratingDex());
            this.finalizeToDex(code, feedback, bytecodeMetadataProvider, timing);
        }
    }

    public void markProcessed(IRCode code, OptimizationFeedback feedback) {
        ProgramMethod method = code.context();
        Inliner.ConstraintWithTarget state = this.shouldComputeInliningConstraint(method) ? this.inliner.computeInliningConstraint(code) : Inliner.ConstraintWithTarget.NEVER;
        feedback.markProcessed((DexEncodedMethod)method.getDefinition(), state);
    }

    public void printPhase(String phase) {
        if (!this.options.extensiveLoggingFilter.isEmpty()) {
            System.out.println("Entering phase: " + phase);
        }
    }

    public String printMethod(IRCode code, String title, String previous) {
        if (this.printer != null) {
            this.printer.resetUnusedValue();
            this.printer.begin("cfg");
            this.printer.print("name \"").append(title).append("\"\n");
            code.print(this.printer);
            this.printer.end("cfg");
        }
        if (this.options.extensiveLoggingFilter.size() > 0 && this.options.extensiveLoggingFilter.contains(((DexMethod)code.method().getReference()).toSourceString())) {
            String current = code.toString();
            System.out.println();
            System.out.println("-----------------------------------------------------------------------");
            System.out.println(title);
            System.out.println("-----------------------------------------------------------------------");
            if (previous != null && previous.equals(current)) {
                System.out.println("Unchanged");
            } else {
                System.out.println(current);
            }
            System.out.println("-----------------------------------------------------------------------");
            return current;
        }
        return previous;
    }

    public void onMethodPruned(ProgramMethod method) {
        assert (this.appView.enableWholeProgramOptimizations());
        assert (method.getHolder().lookupMethod((DexMethod)method.getReference()) == null);
        this.appView.withArgumentPropagator(argumentPropagator -> argumentPropagator.onMethodPruned(method));
        this.enumUnboxer.onMethodPruned(method);
        this.outliner.onMethodPruned(method);
        if (this.inliner != null) {
            this.inliner.onMethodPruned(method);
        }
        this.prunedMethodsInWave.add((DexMethod)method.getReference());
    }

    public void onMethodCodePruned(ProgramMethod method) {
        assert (this.appView.enableWholeProgramOptimizations());
        assert (method.getHolder().lookupMethod((DexMethod)method.getReference()) != null);
        this.appView.withArgumentPropagator(argumentPropagator -> argumentPropagator.onMethodCodePruned(method));
        this.enumUnboxer.onMethodCodePruned(method);
        this.outliner.onMethodCodePruned(method);
        if (this.inliner != null) {
            this.inliner.onMethodCodePruned(method);
        }
    }
}

