/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistryWithResult;

public class LibraryDesugaredChecker {
    private final AppView<?> appView;
    private final DexString jDollarDescriptorPrefix;

    LibraryDesugaredChecker(AppView<?> appView) {
        this.appView = appView;
        this.jDollarDescriptorPrefix = appView.dexItemFactory().createString("Lj$/");
    }

    public boolean isClassLibraryDesugared(DexProgramClass clazz) {
        IsLibraryDesugaredTracer tracer = new IsLibraryDesugaredTracer(this.appView, this.jDollarDescriptorPrefix, clazz);
        tracer.run();
        return tracer.isLibraryDesugared();
    }

    private static class IsLibraryDesugaredTracer {
        private final DexString jDollarDescriptorPrefix;
        private final AppView<?> appView;
        private final DexProgramClass clazz;
        private boolean isLibraryDesugared = false;

        public IsLibraryDesugaredTracer(AppView<?> appView, DexString jDollarDescriptorPrefix, DexProgramClass clazz) {
            this.jDollarDescriptorPrefix = jDollarDescriptorPrefix;
            this.appView = appView;
            this.clazz = clazz;
        }

        private void registerClass(DexProgramClass clazz) {
            if (clazz.superType != null) {
                this.registerType(clazz.superType);
            }
            for (DexType implementsType : clazz.interfaces.values) {
                this.registerType(implementsType);
            }
            if (this.isLibraryDesugared) {
                return;
            }
            for (DexEncodedMethod method : clazz.methods()) {
                this.registerMethod(new ProgramMethod(clazz, method));
                if (!this.isLibraryDesugared) continue;
                return;
            }
            clazz.forEachField(this::registerField);
        }

        private void registerType(DexType type) {
            this.isLibraryDesugared = this.isLibraryDesugared || type.descriptor.startsWith(this.jDollarDescriptorPrefix);
        }

        private void registerField(DexField field) {
            this.registerType(field.getHolderType());
            this.registerType(field.getType());
        }

        private void registerMethod(DexMethod method) {
            for (DexType type : method.getParameters()) {
                this.registerType(type);
            }
            this.registerType(method.getReturnType());
        }

        private void registerField(DexEncodedField field) {
            this.registerField((DexField)field.getReference());
        }

        private void registerMethod(ProgramMethod method) {
            this.registerMethod((DexMethod)method.getReference());
            for (DexAnnotation annotation : ((DexEncodedMethod)method.getDefinition()).annotations().annotations) {
                if (annotation.annotation.type != this.appView.dexItemFactory().annotationThrows) continue;
                DexValue.DexValueArray dexValues = annotation.annotation.elements[0].value.asDexValueArray();
                for (DexValue dexValType : dexValues.getValues()) {
                    this.registerType((DexType)dexValType.asDexValueType().value);
                }
            }
            if (!this.isLibraryDesugared) {
                this.isLibraryDesugared = method.registerCodeReferencesWithResult(new IsLibraryDesugaredUseRegistry(this.appView, method));
            }
        }

        public void run() {
            this.registerClass(this.clazz);
        }

        public boolean isLibraryDesugared() {
            return this.isLibraryDesugared;
        }

        private class IsLibraryDesugaredUseRegistry
        extends UseRegistryWithResult<Boolean, ProgramMethod> {
            public IsLibraryDesugaredUseRegistry(AppView<?> appView, ProgramMethod context) {
                super(appView, context, false);
            }

            private boolean registerField(DexField field) {
                return this.registerType(field.getHolderType()) || this.registerType(field.getType());
            }

            private boolean registerMethod(DexMethod method) {
                return this.registerType(method.getReturnType()) || Iterables.any(method.getParameters(), this::registerType);
            }

            private boolean registerType(DexType type) {
                if (type.descriptor.startsWith(IsLibraryDesugaredTracer.this.jDollarDescriptorPrefix)) {
                    this.setResult(true);
                    return true;
                }
                return false;
            }

            @Override
            public void registerInitClass(DexType type) {
                this.registerType(type);
            }

            @Override
            public void registerInvokeVirtual(DexMethod method) {
                this.registerMethod(method);
            }

            @Override
            public void registerInvokeDirect(DexMethod method) {
                this.registerMethod(method);
            }

            @Override
            public void registerInvokeStatic(DexMethod method) {
                this.registerMethod(method);
            }

            @Override
            public void registerInvokeInterface(DexMethod method) {
                this.registerMethod(method);
            }

            @Override
            public void registerInvokeStatic(DexMethod method, boolean itf) {
                this.registerMethod(method);
            }

            @Override
            public void registerInvokeSuper(DexMethod method) {
                this.registerMethod(method);
            }

            @Override
            public void registerInstanceFieldRead(DexField field) {
                this.registerField(field);
            }

            @Override
            public void registerInstanceFieldWrite(DexField field) {
                this.registerField(field);
            }

            @Override
            public void registerNewInstance(DexType type) {
                this.registerType(type);
            }

            @Override
            public void registerStaticFieldRead(DexField field) {
                this.registerField(field);
            }

            @Override
            public void registerStaticFieldWrite(DexField field) {
                this.registerField(field);
            }

            @Override
            public void registerTypeReference(DexType type) {
                this.registerType(type);
            }

            @Override
            public void registerInstanceOf(DexType type) {
                this.registerType(type);
            }
        }
    }
}

