/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.utils.InternalOptions;

public abstract class MethodConversionOptions {
    public abstract boolean isGeneratingClassFiles();

    public final boolean isGeneratingDex() {
        return !this.isGeneratingClassFiles();
    }

    public abstract boolean isPeepholeOptimizationsEnabled();

    public static class ThrowingMethodConversionOptions
    extends MutableMethodConversionOptions {
        public ThrowingMethodConversionOptions(InternalOptions options) {
            super(options);
        }

        @Override
        public boolean isGeneratingClassFiles() {
            throw new Unreachable();
        }

        @Override
        public boolean isPeepholeOptimizationsEnabled() {
            throw new Unreachable();
        }
    }

    public static class MutableMethodConversionOptions
    extends MethodConversionOptions {
        private boolean enablePeepholeOptimizations = true;
        private boolean isGeneratingClassFiles;

        public MutableMethodConversionOptions(InternalOptions options) {
            this.isGeneratingClassFiles = options.isGeneratingClassFiles();
        }

        public void disablePeepholeOptimizations(MethodProcessor methodProcessor) {
            assert (methodProcessor.isPrimaryMethodProcessor());
            this.enablePeepholeOptimizations = false;
        }

        public MutableMethodConversionOptions setIsGeneratingClassFiles(boolean isGeneratingClassFiles) {
            this.isGeneratingClassFiles = isGeneratingClassFiles;
            return this;
        }

        @Override
        public boolean isGeneratingClassFiles() {
            return this.isGeneratingClassFiles;
        }

        @Override
        public boolean isPeepholeOptimizationsEnabled() {
            return this.enablePeepholeOptimizations;
        }
    }
}

