/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.MethodProcessorWithWave;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class OneTimeMethodProcessor
extends MethodProcessorWithWave {
    private final CompilationContext.ProcessorContext processorContext;

    private OneTimeMethodProcessor(CompilationContext.ProcessorContext processorContext, ProgramMethodSet wave) {
        this.processorContext = processorContext;
        this.wave = wave;
    }

    public static Builder builder(CompilationContext.ProcessorContext processorContext) {
        return new Builder(processorContext);
    }

    public static OneTimeMethodProcessor create(ProgramMethod methodToProcess, AppView<?> appView) {
        return OneTimeMethodProcessor.create(ProgramMethodSet.create(methodToProcess), appView);
    }

    public static OneTimeMethodProcessor create(ProgramMethod methodToProcess, CompilationContext.ProcessorContext processorContext) {
        return OneTimeMethodProcessor.create(ProgramMethodSet.create(methodToProcess), processorContext);
    }

    public static OneTimeMethodProcessor create(ProgramMethodSet methodsToProcess, AppView<?> appView) {
        return OneTimeMethodProcessor.create(methodsToProcess, appView.createProcessorContext());
    }

    public static OneTimeMethodProcessor create(ProgramMethodSet methodsToProcess, CompilationContext.ProcessorContext processorContext) {
        return new OneTimeMethodProcessor(processorContext, methodsToProcess);
    }

    @Override
    public CompilationContext.MethodProcessingContext createMethodProcessingContext(ProgramMethod method) {
        return this.processorContext.createMethodProcessingContext(method);
    }

    @Override
    public boolean shouldApplyCodeRewritings(ProgramMethod method) {
        return true;
    }

    public <E extends Exception> void forEachWaveWithExtension(MethodAction<E> consumer) throws E {
        while (!this.wave.isEmpty()) {
            for (ProgramMethod method : this.wave) {
                consumer.accept(method, this.processorContext.createMethodProcessingContext(method));
            }
            this.prepareForWaveExtensionProcessing();
        }
    }

    public <E extends Exception> void forEachWaveWithExtension(MethodAction<E> consumer, ExecutorService executorService) throws ExecutionException {
        while (!this.wave.isEmpty()) {
            ThreadUtils.processItems(this.wave, method -> consumer.accept((ProgramMethod)method, this.processorContext.createMethodProcessingContext((ProgramMethod)method)), executorService);
            this.prepareForWaveExtensionProcessing();
        }
    }

    public static class Builder {
        private final ProgramMethodSet methodsToProcess = ProgramMethodSet.create();
        private final CompilationContext.ProcessorContext processorContext;

        Builder(CompilationContext.ProcessorContext processorContext) {
            this.processorContext = processorContext;
        }

        public Builder add(ProgramMethod methodToProcess) {
            this.methodsToProcess.add(methodToProcess);
            return this;
        }

        public OneTimeMethodProcessor build() {
            return OneTimeMethodProcessor.create(this.methodsToProcess, this.processorContext);
        }
    }

    @FunctionalInterface
    public static interface MethodAction<E extends Exception> {
        public void accept(ProgramMethod var1, CompilationContext.MethodProcessingContext var2) throws E;
    }
}

