/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.PrimitiveTypeElement;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.IntSwitch;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.StringSwitch;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceRBTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import com.android.tools.r8.naming.IdentifierNameStringMarker;
import com.android.tools.r8.naming.IdentifierNameStringUtils;
import com.android.tools.r8.utils.ArrayUtils;
import com.android.tools.r8.utils.SetUtils;
import java.io.UTFDataFormatException;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class StringSwitchRemover {
    private final AppView<?> appView;
    private final IdentifierNameStringMarker identifierNameStringMarker;
    private final ClassTypeElement stringType;

    public StringSwitchRemover(AppView<?> appView) {
        this(appView, null);
    }

    StringSwitchRemover(AppView<?> appView, IdentifierNameStringMarker identifierNameStringMarker) {
        this.appView = appView;
        this.identifierNameStringMarker = identifierNameStringMarker;
        this.stringType = TypeElement.stringClassType(appView, Nullability.definitelyNotNull());
    }

    private boolean hashCodeOfKeysMayChangeAfterMinification(StringSwitch theSwitch) {
        return this.appView.options().isMinifying() && IdentifierNameStringUtils.isClassNameValue(theSwitch.value(), this.appView.dexItemFactory());
    }

    private boolean prepareForStringSwitchRemoval(IRCode code) {
        boolean hasStringSwitch = false;
        BasicBlockIterator blockIterator = code.listIterator();
        block0: while (blockIterator.hasNext()) {
            BasicBlock block = (BasicBlock)blockIterator.next();
            for (BasicBlock predecessor : block.getNormalPredecessors()) {
                StringSwitch exit = predecessor.exit().asStringSwitch();
                if (exit == null) continue;
                hasStringSwitch = true;
                if (block != exit.fallthroughBlock()) continue;
                BasicBlock hashSwitchFallthroughBlock = block;
                BasicBlock idSwitchBlock = hashSwitchFallthroughBlock.listIterator(code).split(code, blockIterator);
                BasicBlock idSwitchFallthroughBlock = idSwitchBlock.listIterator(code).split(code, blockIterator);
                continue block0;
            }
        }
        return hasStringSwitch;
    }

    public void run(IRCode code) {
        if (!code.metadata().mayHaveStringSwitch()) {
            assert (Streams.stream(code.instructions()).noneMatch(Instruction::isStringSwitch));
            return;
        }
        if (!this.prepareForStringSwitchRemoval(code)) {
            return;
        }
        Set<BasicBlock> newBlocksWithStrings = Sets.newIdentityHashSet();
        BasicBlockIterator blockIterator = code.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = (BasicBlock)blockIterator.next();
            StringSwitch theSwitch = block.exit().asStringSwitch();
            if (theSwitch == null) continue;
            try {
                SingleStringSwitchRemover remover = theSwitch.numberOfKeys() < this.appView.options().minimumStringSwitchSize || this.hashCodeOfKeysMayChangeAfterMinification(theSwitch) ? new SingleEqualityBasedStringSwitchRemover(code, blockIterator, block, theSwitch, newBlocksWithStrings) : new SingleHashBasedStringSwitchRemover(code, blockIterator, block, theSwitch, newBlocksWithStrings);
                ((SingleStringSwitchRemover)remover).removeStringSwitch();
            }
            catch (UTFDataFormatException e) {
                throw new Unreachable();
            }
        }
        if (this.identifierNameStringMarker != null) {
            this.identifierNameStringMarker.decoupleIdentifierNameStringsInBlocks(code, newBlocksWithStrings);
        }
        assert (code.isConsistentSSA(this.appView));
    }

    private class SingleHashBasedStringSwitchRemover
    extends SingleStringSwitchRemover {
        private final BasicBlock hashSwitchBlock;
        private final BasicBlock hashSwitchFallthroughBlock;
        private final BasicBlock idSwitchBlock;
        private final BasicBlock idSwitchFallthroughBlock;
        Int2ReferenceMap<Map<DexString, BasicBlock>> structure;
        private int nextStringId;

        private SingleHashBasedStringSwitchRemover(IRCode code, ListIterator<BasicBlock> blockIterator, BasicBlock hashSwitchBlock, StringSwitch theSwitch, Set<BasicBlock> newBlocksWithStrings) throws UTFDataFormatException {
            super(code, blockIterator, theSwitch, newBlocksWithStrings);
            this.hashSwitchBlock = hashSwitchBlock;
            this.hashSwitchFallthroughBlock = theSwitch.fallthroughBlock();
            this.idSwitchBlock = theSwitch.fallthroughBlock().getUniqueNormalSuccessor();
            this.idSwitchFallthroughBlock = this.idSwitchBlock.getUniqueNormalSuccessor();
            this.structure = this.createStructure(theSwitch);
        }

        private int getAndIncrementNextBlockNumber() {
            return this.code.getNextBlockNumber();
        }

        private Int2ReferenceMap<Map<DexString, BasicBlock>> createStructure(StringSwitch theSwitch) throws UTFDataFormatException {
            Int2ReferenceRBTreeMap<Map<DexString, BasicBlock>> result = new Int2ReferenceRBTreeMap<Map<DexString, BasicBlock>>();
            theSwitch.forEachCase((key, target) -> {
                int hashCode = key.decodedHashCode();
                if (result.containsKey(hashCode)) {
                    ((Map)result.get(hashCode)).put(key, target);
                } else {
                    LinkedHashMap<DexString, BasicBlock> cases = new LinkedHashMap<DexString, BasicBlock>();
                    cases.put((DexString)key, (BasicBlock)target);
                    result.put(hashCode, (Map<DexString, BasicBlock>)cases);
                }
            });
            return result;
        }

        private IntSwitch createHashSwitch(Value hashValue) {
            int[] hashSwitchKeys = this.structure.keySet().toArray(new int[0]);
            int[] hashSwitchTargetIndices = new int[hashSwitchKeys.length];
            int offset = this.hashSwitchBlock.numberOfExceptionalSuccessors();
            for (int i = 0; i < hashSwitchTargetIndices.length; ++i) {
                hashSwitchTargetIndices[i] = i + offset;
            }
            int hashSwitchFallthroughIndex = this.hashSwitchBlock.getSuccessors().size() - 1;
            return new IntSwitch(hashValue, hashSwitchKeys, hashSwitchTargetIndices, hashSwitchFallthroughIndex);
        }

        private void createHashSwitchTargets(Phi idPhi, Value notFoundIdValue) {
            for (Map map : this.structure.values()) {
                BasicBlock hashBlock = BasicBlock.createGotoBlock(this.getAndIncrementNextBlockNumber(), this.position, this.code.metadata());
                this.blockIterator.add(hashBlock);
                this.hashSwitchBlock.link(hashBlock);
                BasicBlock previous = (BasicBlock)this.blockIterator.previous();
                assert (previous == hashBlock);
                this.blockIterator.next();
                BasicBlock current = hashBlock;
                for (Map.Entry entry : map.entrySet()) {
                    current.getMutableSuccessors().clear();
                    InstructionListIterator instructionIterator = current.listIterator(this.code);
                    Value keyValue = instructionIterator.insertConstStringInstruction(StringSwitchRemover.this.appView, this.code, (DexString)entry.getKey());
                    this.newBlocksWithStrings.add(current);
                    InvokeVirtual equalsInvoke = new InvokeVirtual(((StringSwitchRemover)StringSwitchRemover.this).appView.dexItemFactory().stringMembers.equals, this.code.createValue(TypeElement.getInt()), ImmutableList.of(this.stringValue, keyValue));
                    equalsInvoke.setPosition(this.position);
                    instructionIterator.add(equalsInvoke);
                    BasicBlock equalsKeyBlock = BasicBlock.createGotoBlock(this.getAndIncrementNextBlockNumber(), this.position, this.code.metadata(), this.idSwitchBlock);
                    this.idSwitchBlock.getMutablePredecessors().add(equalsKeyBlock);
                    this.blockIterator.add(equalsKeyBlock);
                    current.link(equalsKeyBlock);
                    Value idValue = equalsKeyBlock.listIterator(this.code).insertConstIntInstruction(this.code, StringSwitchRemover.this.appView.options(), this.nextStringId++);
                    idPhi.appendOperand(idValue);
                    BasicBlock continuationBlock = BasicBlock.createGotoBlock(this.getAndIncrementNextBlockNumber(), this.position, this.code.metadata(), this.idSwitchBlock);
                    this.blockIterator.add(continuationBlock);
                    current.link(continuationBlock);
                    instructionIterator.next();
                    instructionIterator.replaceCurrentInstruction(new If(If.Type.NE, equalsInvoke.outValue()));
                    current = continuationBlock;
                }
                idPhi.appendOperand(notFoundIdValue);
                this.idSwitchBlock.getMutablePredecessors().add(current);
            }
        }

        private IntSwitch createIdSwitch(Phi idPhi, Reference2IntMap<BasicBlock> targetBlockIndices) {
            int numberOfCases = this.nextStringId;
            int[] keys2 = ArrayUtils.createIdentityArray(numberOfCases);
            int[] targetIndices = new int[numberOfCases];
            int i = 0;
            for (Map map : this.structure.values()) {
                for (Map.Entry entry : map.entrySet()) {
                    targetIndices[i++] = targetBlockIndices.getInt(entry.getValue());
                }
            }
            int fallthroughIndex = targetBlockIndices.size();
            return new IntSwitch(idPhi, keys2, targetIndices, fallthroughIndex);
        }

        @Override
        void removeStringSwitch() {
            for (BasicBlock successor : this.hashSwitchBlock.getNormalSuccessors()) {
                successor.removePredecessor(this.hashSwitchBlock, null);
            }
            this.hashSwitchBlock.removeAllNormalSuccessors();
            InstructionListIterator instructionIterator = this.hashSwitchBlock.listIterator(this.code, this.hashSwitchBlock.size());
            instructionIterator.previous();
            Phi idPhi = this.code.createPhi(this.idSwitchBlock, TypeElement.getInt());
            Value notFoundIdValue = instructionIterator.insertConstIntInstruction(this.code, StringSwitchRemover.this.appView.options(), -1);
            idPhi.appendOperand(notFoundIdValue);
            InvokeVirtual hashInvoke = new InvokeVirtual(((StringSwitchRemover)StringSwitchRemover.this).appView.dexItemFactory().stringMembers.hashCode, this.code.createValue(TypeElement.getInt()), ImmutableList.of(this.stringValue));
            hashInvoke.setPosition(this.position);
            instructionIterator.add(hashInvoke);
            this.createHashSwitchTargets(idPhi, notFoundIdValue);
            this.hashSwitchBlock.link(this.hashSwitchFallthroughBlock);
            IntSwitch hashSwitch = this.createHashSwitch(hashInvoke.outValue());
            instructionIterator.next();
            instructionIterator.replaceCurrentInstruction(hashSwitch);
            Reference2IntOpenHashMap<BasicBlock> targetBlockIndices = new Reference2IntOpenHashMap<BasicBlock>();
            targetBlockIndices.defaultReturnValue(-1);
            this.idSwitchBlock.getMutableSuccessors().clear();
            for (Map map : this.structure.values()) {
                for (BasicBlock target : map.values()) {
                    int targetIndex = targetBlockIndices.getInt(target);
                    if (targetIndex != -1) continue;
                    targetBlockIndices.put(target, this.idSwitchBlock.getSuccessors().size());
                    this.idSwitchBlock.link(target);
                }
            }
            this.idSwitchBlock.getMutableSuccessors().add(this.idSwitchFallthroughBlock);
            IntSwitch idSwitch = this.createIdSwitch(idPhi, targetBlockIndices);
            InstructionListIterator instructionListIterator = this.idSwitchBlock.listIterator(this.code);
            instructionListIterator.next();
            instructionListIterator.replaceCurrentInstruction(idSwitch);
        }
    }

    private class SingleEqualityBasedStringSwitchRemover
    extends SingleStringSwitchRemover {
        private final BasicBlock block;
        private final BasicBlock fallthroughBlock;
        private final Map<DexString, BasicBlock> structure;

        private SingleEqualityBasedStringSwitchRemover(IRCode code, ListIterator<BasicBlock> blockIterator, BasicBlock block, StringSwitch theSwitch, Set<BasicBlock> newBlocksWithStrings) {
            super(code, blockIterator, theSwitch, newBlocksWithStrings);
            this.block = block;
            this.fallthroughBlock = theSwitch.fallthroughBlock();
            this.structure = this.createStructure(theSwitch);
        }

        private Map<DexString, BasicBlock> createStructure(StringSwitch theSwitch) {
            LinkedHashMap<DexString, BasicBlock> result = new LinkedHashMap<DexString, BasicBlock>();
            theSwitch.forEachCase(result::put);
            return result;
        }

        @Override
        void removeStringSwitch() {
            for (BasicBlock successor : this.block.getNormalSuccessors()) {
                successor.removePredecessor(this.block, null);
            }
            this.block.removeAllNormalSuccessors();
            Set<BasicBlock> blocksTargetedByMultipleSwitchCases = Sets.newIdentityHashSet();
            Set seenBefore = SetUtils.newIdentityHashSet(this.structure.size());
            for (BasicBlock basicBlock : this.structure.values()) {
                if (seenBefore.add(basicBlock)) continue;
                blocksTargetedByMultipleSwitchCases.add(basicBlock);
            }
            BasicBlock previous = null;
            for (Map.Entry entry : this.structure.entrySet()) {
                ConstString constStringInstruction = new ConstString(this.code.createValue(StringSwitchRemover.this.stringType), (DexString)entry.getKey());
                constStringInstruction.setPosition(this.position);
                InvokeVirtual invokeInstruction = new InvokeVirtual(((StringSwitchRemover)StringSwitchRemover.this).appView.dexItemFactory().stringMembers.equals, this.code.createValue(PrimitiveTypeElement.getInt()), ImmutableList.of(this.stringValue, constStringInstruction.outValue()));
                invokeInstruction.setPosition(this.position);
                If ifInstruction = new If(If.Type.NE, invokeInstruction.outValue());
                ifInstruction.setPosition(Position.none());
                BasicBlock targetBlock = (BasicBlock)entry.getValue();
                if (blocksTargetedByMultipleSwitchCases.contains(targetBlock)) {
                    BasicBlock intermediateBlock = BasicBlock.createGotoBlock(this.code.getNextBlockNumber(), Position.none(), this.code.metadata());
                    intermediateBlock.link(targetBlock);
                    this.blockIterator.add(intermediateBlock);
                    this.newBlocksWithStrings.add(intermediateBlock);
                    targetBlock = intermediateBlock;
                }
                BasicBlock newBlock = BasicBlock.createIfBlock(this.code.getNextBlockNumber(), ifInstruction, this.code.metadata(), constStringInstruction, invokeInstruction);
                newBlock.link(targetBlock);
                this.blockIterator.add(newBlock);
                this.newBlocksWithStrings.add(newBlock);
                if (previous == null) {
                    this.block.exit().replace(new Goto(newBlock), this.code);
                    this.block.link(newBlock);
                } else {
                    previous.link(newBlock);
                }
                previous = newBlock;
            }
            assert (previous != null);
            previous.link(this.fallthroughBlock);
        }
    }

    private static abstract class SingleStringSwitchRemover {
        final IRCode code;
        final ListIterator<BasicBlock> blockIterator;
        final Set<BasicBlock> newBlocksWithStrings;
        final Position position;
        final Value stringValue;

        private SingleStringSwitchRemover(IRCode code, ListIterator<BasicBlock> blockIterator, StringSwitch theSwitch, Set<BasicBlock> newBlocksWithStrings) {
            this.code = code;
            this.blockIterator = blockIterator;
            this.newBlocksWithStrings = newBlocksWithStrings;
            this.position = theSwitch.getPosition();
            this.stringValue = theSwitch.value();
        }

        abstract void removeStringSwitch();
    }
}

