/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.ir.analysis.type.ArrayTypeElement;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.ImpreciseMemberTypeInstruction;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueTypeConstraint;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.position.MethodPosition;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class TypeConstraintResolver {
    private final AppView<?> appView;
    private final IRBuilder builder;
    private final Map<Value, Value> unificationParents = new HashMap<Value, Value>();

    public TypeConstraintResolver(AppView<?> appView, IRBuilder builder) {
        this.appView = appView;
        this.builder = builder;
    }

    public static ValueTypeConstraint constraintForType(TypeElement type) {
        return type.isBottom() ? ValueTypeConstraint.OBJECT : ValueTypeConstraint.fromTypeLattice(type);
    }

    public static TypeElement typeForConstraint(ValueTypeConstraint constraint) {
        switch (constraint) {
            case INT_OR_FLOAT_OR_OBJECT: {
                return TypeElement.getTop();
            }
            case OBJECT: {
                return TypeElement.getBottom();
            }
            case INT: {
                return TypeElement.getInt();
            }
            case FLOAT: {
                return TypeElement.getFloat();
            }
            case INT_OR_FLOAT: {
                return TypeElement.getSingle();
            }
            case LONG: {
                return TypeElement.getLong();
            }
            case DOUBLE: {
                return TypeElement.getDouble();
            }
            case LONG_OR_DOUBLE: {
                return TypeElement.getWide();
            }
        }
        throw new Unreachable("Unexpected constraint type: " + (Object)((Object)constraint));
    }

    private List<Value> resolveRoundOne(IRCode code) {
        ArrayList<Value> impreciseValues = new ArrayList<Value>();
        for (BasicBlock block : code.blocks) {
            for (Phi phi : block.getPhis()) {
                if (!phi.getType().isPreciseType()) {
                    impreciseValues.add(phi);
                }
                for (Value value : phi.getOperands()) {
                    this.merge(phi, value);
                }
            }
            for (Instruction instruction : block.getInstructions()) {
                if (instruction.outValue() != null && !instruction.getOutType().isPreciseType()) {
                    impreciseValues.add(instruction.outValue());
                }
                if (!instruction.isIf() || instruction.inValues().size() != 2) continue;
                If ifInstruction = instruction.asIf();
                assert (!ifInstruction.isZeroTest());
                If.Type type = ifInstruction.getType();
                if (type != If.Type.EQ && type != If.Type.NE) continue;
                this.merge(ifInstruction.inValues().get(0), ifInstruction.inValues().get(1));
            }
        }
        return this.constrainValues(false, impreciseValues);
    }

    private void resolveRoundTwo(IRCode code, List<ImpreciseMemberTypeInstruction> impreciseInstructions, List<Value> remainingImpreciseValues) {
        ArrayList<Value> stillImprecise;
        if (impreciseInstructions != null) {
            for (ImpreciseMemberTypeInstruction impreciseInstruction : impreciseInstructions) {
                impreciseInstruction.constrainType(this);
            }
        }
        if (!(stillImprecise = this.constrainValues(true, remainingImpreciseValues)).isEmpty()) {
            throw this.appView.options().reporter.fatalError(new StringDiagnostic("Cannot determine precise type for value: " + stillImprecise.get(0) + ", its imprecise type is: " + stillImprecise.get(0).getType(), code.origin, new MethodPosition(((DexMethod)code.method().getReference()).asMethodReference())));
        }
    }

    private ArrayList<Value> constrainValues(boolean finished, List<Value> impreciseValues) {
        ArrayList<Value> stillImprecise = new ArrayList<Value>(impreciseValues.size());
        for (Value value : impreciseValues) {
            this.builder.constrainType(value, this.getCanonicalTypeConstraint(value, finished));
            if (value.getType().isPreciseType()) continue;
            stillImprecise.add(value);
        }
        return stillImprecise;
    }

    private void merge(Value value1, Value value2) {
        this.link(this.canonical(value1), this.canonical(value2));
    }

    private ValueTypeConstraint getCanonicalTypeConstraint(Value value, boolean finished) {
        ValueTypeConstraint type = TypeConstraintResolver.constraintForType(this.canonical(value).getType());
        switch (type) {
            case INT_OR_FLOAT_OR_OBJECT: {
                assert (!finished);
                return ValueTypeConstraint.INT_OR_FLOAT;
            }
            case INT_OR_FLOAT: {
                assert (!finished || TypeConstraintResolver.verifyNoConstrainedUses(value));
                return finished ? ValueTypeConstraint.INT : type;
            }
            case LONG_OR_DOUBLE: {
                assert (!finished || TypeConstraintResolver.verifyNoConstrainedUses(value));
                return finished ? ValueTypeConstraint.LONG : type;
            }
        }
        return type;
    }

    private static boolean verifyNoConstrainedUses(Value value) {
        return TypeConstraintResolver.verifyNoConstrainedUses(value, ImmutableSet.of());
    }

    private static boolean verifyNoConstrainedUses(Value value, Set<Value> assumeNoConstrainedUses) {
        for (Instruction user : value.uniqueUsers()) {
            if (user.isIf()) {
                Value other;
                If ifInstruction = user.asIf();
                if (!ifInstruction.isZeroTest() && !assumeNoConstrainedUses.contains(other = ifInstruction.inValues().get(1 - ifInstruction.inValues().indexOf(value)))) assert (TypeConstraintResolver.verifyNoConstrainedUses(other, (Set<Value>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(assumeNoConstrainedUses)).add(value)).build())));
                continue;
            }
            if (user.isArrayPut()) {
                ArrayPut put = user.asArrayPut();
                assert (value == put.value());
                assert (!put.getMemberType().isPrecise());
                assert (put.array().getType().isDefinitelyNull());
                continue;
            }
            assert (false);
        }
        return true;
    }

    private void link(Value canonical1, Value canonical2) {
        if (canonical1 == canonical2) {
            return;
        }
        TypeElement type1 = canonical1.getType();
        TypeElement type2 = canonical2.getType();
        if (type1.isPreciseType() && type2.isPreciseType()) {
            if (type1 != type2 && TypeConstraintResolver.constraintForType(type1) != TypeConstraintResolver.constraintForType(type2)) {
                throw new CompilationError("Cannot unify types for values " + canonical1 + ":" + type1 + " and " + canonical2 + ":" + type2);
            }
            return;
        }
        if (type1.isPreciseType()) {
            this.unificationParents.put(canonical2, canonical1);
        } else {
            this.unificationParents.put(canonical1, canonical2);
        }
    }

    private Value canonical(Value value) {
        Value parent = value;
        while (parent != null) {
            Value grandparent = this.unificationParents.get(parent);
            if (grandparent != null) {
                this.unificationParents.put(value, grandparent);
            }
            value = parent;
            parent = grandparent;
        }
        return value;
    }

    public void resolve(List<ImpreciseMemberTypeInstruction> impreciseInstructions, IRCode code) {
        List<Value> remainingImpreciseValues = this.resolveRoundOne(code);
        new TypeAnalysis(this.appView, true).widening(code);
        this.resolveRoundTwo(code, impreciseInstructions, remainingImpreciseValues);
    }

    public void constrainArrayMemberType(MemberType type, Value value, Value array, Consumer<MemberType> setter) {
        ValueTypeConstraint constraint;
        assert (!type.isPrecise());
        Value canonical = this.canonical(value);
        if (array.getType().isArrayType()) {
            ArrayTypeElement arrayType = array.getType().asArrayType();
            constraint = ValueTypeConstraint.fromTypeLattice(arrayType.getMemberTypeAsValueType());
        } else {
            constraint = this.getCanonicalTypeConstraint(canonical, true);
        }
        this.builder.constrainType(canonical, constraint);
        setter.accept(MemberType.constrainedType(type, constraint));
    }
}

