/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion.callgraph;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.ImmediateProgramSubtypingInfo;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.callgraph.CallGraph;
import com.android.tools.r8.ir.conversion.callgraph.Node;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.KeepMethodInfo;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.classhierarchy.MethodOverridesCollector;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.Set;

public abstract class CallSiteInformation {
    public static CallSiteInformation empty() {
        return EmptyCallSiteInformation.EMPTY_INFO;
    }

    public abstract boolean hasSingleCallSite(ProgramMethod var1);

    public abstract boolean isMultiCallerInlineCandidate(ProgramMethod var1);

    public abstract void unsetCallSiteInformation(ProgramMethod var1);

    static class CallGraphBasedCallSiteInformation
    extends CallSiteInformation {
        private final Set<DexMethod> singleCallerMethods = Sets.newIdentityHashSet();
        private final Set<DexMethod> multiCallerInlineCandidates = Sets.newIdentityHashSet();

        CallGraphBasedCallSiteInformation(AppView<AppInfoWithLiveness> appView, CallGraph graph) {
            InternalOptions options = appView.options();
            ProgramMethodSet pinned = MethodOverridesCollector.findAllMethodsAndOverridesThatMatches(appView, ImmediateProgramSubtypingInfo.create(appView), appView.appInfo().classes(), method -> {
                KeepMethodInfo keepInfo = appView.getKeepInfo((ProgramMethod)method);
                return !keepInfo.isClosedWorldReasoningAllowed(options) || keepInfo.isPinned(options);
            });
            for (Node node : graph.getNodes()) {
                ProgramMethod method2 = node.getProgramMethod();
                DexMethod reference = (DexMethod)method2.getReference();
                if (pinned.contains(method2) || appView.options().inlinerOptions().disableInliningOfLibraryMethodOverrides && ((DexEncodedMethod)method2.getDefinition()).isLibraryMethodOverride().isTrue() || ((DexEncodedMethod)method2.getDefinition()).isDefaultInitializer() && appView.hasProguardCompatibilityActions() && appView.getProguardCompatibilityActions().isCompatInstantiated(method2.getHolder())) continue;
                int numberOfCallSites = node.getNumberOfCallSites();
                if (numberOfCallSites == 1) {
                    this.singleCallerMethods.add(reference);
                    continue;
                }
                if (numberOfCallSites <= 1) continue;
                this.multiCallerInlineCandidates.add(reference);
            }
        }

        @Override
        public boolean hasSingleCallSite(ProgramMethod method) {
            return this.singleCallerMethods.contains(method.getReference());
        }

        @Override
        public boolean isMultiCallerInlineCandidate(ProgramMethod method) {
            return this.multiCallerInlineCandidates.contains(method.getReference());
        }

        @Override
        public void unsetCallSiteInformation(ProgramMethod method) {
            this.singleCallerMethods.remove(method.getReference());
            this.multiCallerInlineCandidates.remove(method.getReference());
        }
    }

    private static class EmptyCallSiteInformation
    extends CallSiteInformation {
        private static final EmptyCallSiteInformation EMPTY_INFO = new EmptyCallSiteInformation();

        private EmptyCallSiteInformation() {
        }

        @Override
        public boolean hasSingleCallSite(ProgramMethod method) {
            return false;
        }

        @Override
        public boolean isMultiCallerInlineCandidate(ProgramMethod method) {
            return false;
        }

        @Override
        public void unsetCallSiteInformation(ProgramMethod method) {
        }
    }
}

